#ifndef _KVI_ASYNCMESSAGEBOX_H_INCLUDED_
#define _KVI_ASYNCMESSAGEBOX_H_INCLUDED_

// =============================================================================
//
//      --- kvi_asyncmessagebox.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_asyncdialog.h"
#include "kvi_messagebox.h"

class KviUserParser;
class KviWindow;

class KviAsyncMessageBox : public KviMessageBox, public KviAsyncDialog
{
	Q_OBJECT
public:
	KviAsyncMessageBox(KviUserParser *parser, KviWindow *pWnd, const char *caption,
		const char *text, const char *icon, const char *btn1);
	KviAsyncMessageBox(KviUserParser *parser, KviWindow *pWnd, const char *caption,
		const char *text, const char *icon, const char *btn1, const char *btn2);
	KviAsyncMessageBox(KviUserParser *parser, KviWindow *pWnd, const char *caption,
		const char *text, const char *icon, const char *btn1, const char *btn2, const char *btn3);
	~KviAsyncMessageBox();
	virtual void done(int);
	void doSetIcon(const char *iconDescription);
};

#endif // _KVI_ASYNCMESSAGEBOX_H_INCLUDED_
