/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "addnetworkroutedialog.h"
#include <klocale.h>
#include <klistview.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <qcheckbox.h>
#include "addnetworkroutedialog.moc"

AddNetworkRouteDialog::AddNetworkRouteDialog(QWidget *parent, const QString& caption) : KDialogBase( parent, "Add_new_network_route", false, caption,
		KDialogBase::Ok|KDialogBase::Cancel,KDialogBase::Ok, true )
{
	main = new AddNetworkRouteDialogBase (this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());
	connect(main->UseGatewayCheckBox,SIGNAL(toggled(bool)),this, SLOT(useGatewayToggled(bool)));
	Network="";
	Netmask="";
	Gateway="";
	useGateway=false;
}


AddNetworkRouteDialog::~AddNetworkRouteDialog()
{}

void AddNetworkRouteDialog::accept()
{
	Network = main->RemoteNetAddrLineEdit->text();
	Netmask = main->RemoteNetMaskComboBox->currentText();
	Gateway = main->RemoteGatewayAddrLineEdit->text();
	useGateway = main->UseGatewayCheckBox->isChecked();
	QDialog::accept();
}

QString AddNetworkRouteDialog::getNetwork()
{
	return Network;
}

QString AddNetworkRouteDialog::getNetmask()
{
	return Netmask;
}

QString AddNetworkRouteDialog::getGateway()
{
	return Gateway;
}

bool AddNetworkRouteDialog::getUseGateway()
{
	return useGateway;
}

void AddNetworkRouteDialog::useGatewayToggled(bool)
{
	if (main->UseGatewayCheckBox->isChecked())
		main->RemoteGatewayAddrLineEdit->setEnabled(true);
	else
		main->RemoteGatewayAddrLineEdit->setEnabled(false);
}

