/***************************************************************************
*  Copyright (C) 2005 by hal9000 <hal9000@evilscientists.de>               *
 *  Copyright (C) 2005 by Maurice Massar <vpnc@unix-ag.uni-kl.de>               *
 *  Copyright (C) 2005 by Christoph Thielecke <crissi99@gmx.de>               *
*                                     *
*  This program is free software; you can redistribute it and/or modify *
*  it under the terms of the GNU General Public License as published by *
*  the Free Software Foundation; either version 2 of the License, or   *
*  (at your option) any later version.                  *
*                                     *
*  This program is distributed in the hope that it will be useful,    *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of    *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the     *
*  GNU General Public License for more details.             *
*                                     *
*  You should have received a copy of the GNU General Public License   *
*  along with this program; if not, write to the             *
*  Free Software Foundation, Inc.,                    *
*  59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.       *
***************************************************************************/
#pragma once

#include <iostream>
#include <string>
#include <fstream>
#include <qstring.h>

#include <stdio.h>
#include <stdlib.h>
#include <gcrypt.h>
#include <errno.h>

using namespace std;

class CiscoPasswdDecoder
{
public:
	CiscoPasswdDecoder(const string& profileFile);
	~CiscoPasswdDecoder();
	bool decodePasswords(QString& userPasswd, QString& groupPasswd);

private:
	void readProfileData(const string& profile, string& userData, string& groupData);
	string profile;

	int hex2bin_c(unsigned int c);
	int hex2bin(const char *str, char **bin, int *len);
	int c_decrypt(char *ct, int len, char **resp, char *reslenp);
	void cleanupStr(const string& str, string& cleanStr);

};
