/***************************************************************************
 *   Copyright (C) 2005 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "debugoutputtextedit.h"

#include <klocale.h>
#include <iostream>
#include <qwidget.h>
#include "debugoutputtextedit.moc"

DebugOutputTextEdit::DebugOutputTextEdit( QWidget* parent, const char* name)
    : QTextEdit( parent, name)
{


}

QPopupMenu* DebugOutputTextEdit::createPopupMenu(const QPoint &)
{
	popup = new QPopupMenu(this);
	popup->insertItem(i18n("Cut Content"), this, SLOT(cut() ) );
	popup->insertSeparator();
	popup->insertItem(i18n("Clear Log Window"), this, SLOT(clear() ) );
  popup->insertSeparator();

	return popup;
}

void DebugOutputTextEdit::append ( const QString & text )
{
	QTextEdit::append(text);
}


