/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN INCLUDES
#include "preferencesdialog.h"
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <qcheckbox.h>
#include <kmessagebox.h>
#include <qspinbox.h>
#include <qpixmap.h>
#include <kurlrequester.h>
#include <kcolordialog.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kinputdialog.h>
#include <knuminput.h>
#include <klistview.h>
#include <ktextedit.h>
#include <qlayout.h>
#include "networkinterface.h"
#include "utils.h"
#include "importcertificatedialog.h"
#include "newprofiledialog.h"

#include <iostream>
//END INCLUDES

PreferencesDialog::PreferencesDialog( QWidget *parent, QApplication *app,QTextEdit *LogOutput, KVpncConfig *GlobalConfig,bool showOnlyProfiles ) : KDialogBase ( KDialogBase::TreeList, i18n("Preferences..."),
		        KDialogBase::Ok | KDialogBase::Apply|KDialogBase::Cancel | KDialogBase::Help,KDialogBase::Ok,
		        parent,"configdialog" )
{
	//main = new PreferencesDialogBase(this);

	//setMainWidget(main);

	//main->setMinimumSize(main->sizeHint())

	this->AccountList = GlobalConfig->AccountList;
	this->LogOutput = LogOutput;
	this->currentProfile = GlobalConfig->currentProfile;
	this->KvpncDebugLevel = GlobalConfig->KvpncDebugLevel;
	this->app = app;
	this->GlobalConfig = GlobalConfig;

	lastProfileName="";

	this->showOnlyProfiles=showOnlyProfiles;
	if (showOnlyProfiles)
	{
		setCaption(i18n("Manage Profiles"));
	}
	setupGui();

	// 	DaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
	// 	programsInPathToggled(GlobalConfig->programsInPath);
	//
	unfoldTreeList ();
	if (!showOnlyProfiles)
	{
		DaemonOptionsWidget->RacoonDebugLevelComboBox->clear();
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "notify" );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug" );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug2" );
		DaemonOptionsWidget->PppdPathInput->setURL( GlobalConfig->pathToPppd );
		DaemonOptionsWidget->VpncPathInput->setURL( GlobalConfig->pathToVpnc );
		DaemonOptionsWidget->RacoonPathInput->setURL( GlobalConfig->pathToRacoon );
		DaemonOptionsWidget->SetkeyPathInput->setURL( GlobalConfig->pathToSetkey );
		DaemonOptionsWidget->FreeswanPathInput->setURL( GlobalConfig->pathToFreeswan );
		DaemonOptionsWidget->OpenvpnPathInput->setURL( GlobalConfig->pathToOpenvpn );

		HelperProgramOptionsWidget->IptablesPathInput->setURL( GlobalConfig->pathToIptables );
		HelperProgramOptionsWidget->OpenSSLPathInput->setURL( GlobalConfig->pathToOpenssl );
		HelperProgramOptionsWidget->KillPathInput->setURL( GlobalConfig->pathToKill );
		HelperProgramOptionsWidget->KillallPathInput->setURL( GlobalConfig->pathToKillall );
		HelperProgramOptionsWidget->PingPathInput->setURL( GlobalConfig->pathToPing );
		HelperProgramOptionsWidget->IpPathInput->setURL( GlobalConfig->pathToIp );
		HelperProgramOptionsWidget->IfconfigPathInput->setURL( GlobalConfig->pathToIfconfig );
		HelperProgramOptionsWidget->RoutePathInput->setURL( GlobalConfig->pathToRoute );


		ToolInfo *Openssl = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"openssl");
		ToolInfo *Iptables = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"iptables");
		ToolInfo *Kill = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"kill");
		ToolInfo *Killall = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"killall");
		ToolInfo *Ping = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"ping");
		ToolInfo *Ip = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"ip");
		ToolInfo *Ifconfig = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"ifconfig");
		ToolInfo *Route = Utils( GlobalConfig ).getToolInfo(GlobalConfig,"route");

		HelperProgramOptionsWidget->OpensslVersionLineEdit->setText( Openssl->Version );
		HelperProgramOptionsWidget->IptablesVersionLineEdit->setText( Iptables->Version );
		HelperProgramOptionsWidget->KillVersionLineEdit->setText( Kill->Version );
		HelperProgramOptionsWidget->KillallVersionLineEdit->setText( Killall->Version );
		HelperProgramOptionsWidget->PingVersionLineEdit->setText( Ping->Version );
		HelperProgramOptionsWidget->IpVersionLineEdit->setText( Ip->Version );
		HelperProgramOptionsWidget->IfconfigVersionLineEdit->setText( Ifconfig->Version );
		HelperProgramOptionsWidget->RouteVersionLineEdit->setText( Route->Version );

		QPixmap ok_icon = KGlobal::iconLoader()->loadIcon( "button_ok", KIcon::NoGroup, 16 );
		QPixmap wrong_icon = KGlobal::iconLoader()->loadIcon( "button_cancel", KIcon::NoGroup, 16 );

		if ( !Openssl->PathToExec.isEmpty())
			HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap( wrong_icon );
		if ( !Iptables->PathToExec.isEmpty())
			HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap( wrong_icon );
		if ( !Kill->PathToExec.isEmpty())
			HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap( wrong_icon );
		if ( !Killall->PathToExec.isEmpty())
			HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap( wrong_icon );
		if ( !Ping->PathToExec.isEmpty())
			HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap( wrong_icon );
		if ( !Ip->PathToExec.isEmpty())
			HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap( wrong_icon );
		if ( !Ifconfig->PathToExec.isEmpty())
			HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap( wrong_icon );
		if ( !Route->PathToExec.isEmpty())
			HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap( wrong_icon );

		ConnectOptionsWidget->checkMinimizeAfterConnectCheck->setChecked( GlobalConfig->minimizeAfterConnect );
		DebugOptionsWidget->showDebugCheck->setChecked( GlobalConfig->showDebugConsole );
		DebugOptionsWidget->WriteLogCheck->setChecked( GlobalConfig->writeLogFile );
		DebugOptionsWidget->spinKvpncDebugLevel->setValue ( GlobalConfig->KvpncDebugLevel );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->setCurrentText ( GlobalConfig->RacoonDebugLevel );
		DaemonOptionsWidget->spinVpncDebugLevel->setValue ( GlobalConfig->VpncDebugLevel );
		DaemonOptionsWidget->spinOpenvpnDebugLevel->setValue ( GlobalConfig->OpenvpnDebugLevel );
		DaemonOptionsWidget->DebugPppdcheckBox->setChecked(GlobalConfig->enableDebugPppd);
		ConnectOptionsWidget->spinTryConnectTimeout->setValue( GlobalConfig->tryConnectTimeout );
		ConnectOptionsWidget->SilentQuitcheckBox->setChecked( GlobalConfig->useSilentQuit );
		GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->setChecked( GlobalConfig->dontQuitOnCloseEvent );
		GeneralOptionsWidget->useKwalletCheckBox->setChecked( GlobalConfig->useKwallet );
		DaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
		DebugOptionsWidget->KeepConnectionFilesCheckBox->setChecked(GlobalConfig->holdGeneratedScripts);
		LogOptionsWidget->InfoLogLabel->setPaletteBackgroundColor (GlobalConfig->InfoLogColor);
		LogOptionsWidget->RemoteLogLabel->setPaletteBackgroundColor (GlobalConfig->RemoteLogColor);
		LogOptionsWidget->ErrorLogLabel->setPaletteBackgroundColor (GlobalConfig->ErrorLogColor);
		LogOptionsWidget->SuccessLogLabel->setPaletteBackgroundColor (GlobalConfig->SuccessLogColor);
		LogOptionsWidget->DebugLogLabel->setPaletteBackgroundColor (GlobalConfig->DebugLogColor);
		LogOptionsWidget->UseColorizedLogOutputcheckBox->setChecked(GlobalConfig->useColorizedLogOutput);
		DaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->setChecked(GlobalConfig->showInterfaceIPinTooltip);
		ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked(GlobalConfig->doAutoConnectAtStartup);
		LogOptionsWidget->LogFontSizeSpinBox->setValue(GlobalConfig->LogViewerFontSize);

		bool profileInList=false;
		for (uint i=0; i < GlobalConfig->AccountList->count();i++)
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem(GlobalConfig->AccountList->at(i)->getName());
			if ( GlobalConfig->AccountList->at(i)->getName() == GlobalConfig->AutoConnectProfile)
			{
				profileInList=true;
			}
		}

		if (profileInList)
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->setCurrentText(GlobalConfig->AutoConnectProfile);
		}
		else
		{
			GlobalConfig->doAutoConnectAtStartup=false;
			ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked(GlobalConfig->doAutoConnectAtStartup);
		}
	}
	KDialogBase::adjustSize();

	// TODO read types from list
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "Cisco (vpnc)" ), VpnAccountData::cisco );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (racoon)" ), VpnAccountData::racoon );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (FreeSWAN)" ), VpnAccountData::freeswan );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "PPTP" ), VpnAccountData::pptp );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "OpenVPN" ), VpnAccountData::openvpn );
	//ConnectionTypeComboBox->insertItem( "-", 5 );

	ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->insertItem( "tun" );
	ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->insertItem( "tap" );

	profileAddedOrDeleted = false;
	NewProfileName="";

	// profile data
	VpnAccountData * it;
	if ( !GlobalConfig->AccountList->isEmpty() )
	{
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if (it != 0 )
			{
				if (GlobalConfig->KvpncDebugLevel > 1 )
					GlobalConfig->appendLogEntry("item found: "+it->getName(), KVpncConfig::debug);

				ProfileGeneralOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileNetworkRouteOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileNetworkNatOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileCertPskOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileUserOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileOpenvpnOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfilePptpOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileRacoonOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileCiscoOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
				ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->insertItem(it->getName() );
			}
		}


		if ( GlobalConfig->currentProfile != 0 )
		{
			ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
		}
		else
		{
			ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );

		}
	}
	else
	{
		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
	}


	NetworkInterface iface(GlobalConfig,GlobalConfig->appPointer);
	QStringList list = iface.getAllNetworkInterfaces();
	ProfileGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( "default" );
	if ( GlobalConfig->currentProfile != 0 )
	{
		for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
		{
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( QString( *it ) );
		}
		ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
		ProfileGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );

		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "X.509 certificate" ) );

		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentText( i18n( "Pre shared key" ) );

		if (GlobalConfig->currentProfile->getConnectionType() != VpnAccountData::ConnectionType(VpnAccountData::openvpn))
			ProfileCertPskOptionsWidget->PSKLineEdit->setText( GlobalConfig->currentProfile->getPreSharedKey() );
		else
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setURL(GlobalConfig->currentProfile->getPreSharedKeyFile());

		if ( GlobalConfig->currentProfile->getDoPingIP() )
			ProfileGeneralOptionsWidget->PingIPLineEdit->setEnabled( true );
		else
			ProfileGeneralOptionsWidget->PingIPLineEdit->setEnabled( false );

		ProfileGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->setChecked( GlobalConfig->currentProfile->getUseConnectionStatusCheck() );
		ProfileGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusCheckSuccessCount());
		ProfileGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusInterval());
		ProfileGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->setChecked(GlobalConfig->currentProfile->getDoReconnectAfterConnectionLost());

		ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( false );

		ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->setChecked(GlobalConfig->currentProfile->getUseAdditionalNetworkRoutes());

		ProfileNetworkRouteOptionsWidget->NetworkListView->clear();
		QStringList AdditionalNetworkRoutes = GlobalConfig->currentProfile->getAdditionalNetworkRoutes();

		for (QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			QString networkstring = *it2;
			QString Network = networkstring.section('#',0,0).section('/',0,0);
			QString Netmask = networkstring.section('#',0,0).section('/',1,1);
			QString Gateway = networkstring.section('#',1,1).section('/',0,0);

			ProfileNetworkRouteOptionsWidget->NetworkListView->insertItem(new QListViewItem(ProfileNetworkRouteOptionsWidget->NetworkListView,Network,Netmask,Gateway));

		}

		ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( GlobalConfig->currentProfile->getUseSpecialServerCertificate() );

		if ( GlobalConfig->currentProfile != 0 )
		{
			if (  GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
				ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
			else
				ProfileNetworkVirtualIpOptionsWidget->setEnabled(false);

			if ( GlobalConfig->currentProfile->getUseSpecialServerCertificate())
				ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setURL(GlobalConfig->currentProfile->getSpecialServerCertificate());
		}
		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		authTypeChanged( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() );

		// FIXME
		profileChanged( ProfileGeneralOptionsWidget->ProfileComboBox->currentText() );

	}

	// 	// pppd settings
	ProfilePptpOptionsWidget->DnsServerLineedit->setEnabled( false );
	ProfilePptpOptionsWidget->MtuSpinbox->setEnabled( false );


	ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);
	ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled(true);
	ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled(true);
	ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setEnabled(true);
	ProfileNetworkVirtualIpOptionsWidget->LabelLocalVirtualIp->setEnabled(true);




	if ( GlobalConfig->currentProfile != 0 )
	{
		if ( GlobalConfig->currentProfile->getUseUserdefinedPort() )
		{
			ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(true);
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(true);
		}
		else
		{
			ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(false);
		}

		if ( GlobalConfig->currentProfile->getUseNsCertType())
		{
			ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(true);
			ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(true);
		}
		else
		{
			ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(false);
			ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(false);
		}

		if ( GlobalConfig->currentProfile->getDisableLzoCompression())
		{
			ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(false);
		}
		else
		{
			ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(true);
		}

		ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());
		if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword())
			ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked (true);
		else
			ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked (false);

		if ( GlobalConfig->currentProfile->getAllowEmptyGroupPassword())
			ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->setChecked(true);
		else
			ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->setChecked(false);


	}
	KDialogBase::adjustSize();
}

void PreferencesDialog::setupGui()
{

	setShowIconsInTreeList(true);

	QStringList path;
	path.clear();
	path << i18n("KVpnc");
	setFolderIcon (path, SmallIcon("kvpnc-application", KIcon::SizeSmall));

	path.clear();

	QVBoxLayout *lo;

	if (!showOnlyProfiles)
	{
		/* called as preferences dialog */

		// General page
		path << i18n("Application") << i18n("General");
		QFrame* GeneralFrame = addPage(path, i18n("General"), BarIcon("application", KIcon::SizeSmall));
		lo = new QVBoxLayout( GeneralFrame );
		lo->setSpacing(KDialog::spacingHint());
		GeneralOptionsWidget = new ConfigGeneralOptions(GeneralFrame);
		lo->addWidget(GeneralOptionsWidget);

		// Debug
		path.clear();
		path << i18n("Application") << i18n("Debug");
		QFrame* DebugFrame = addPage(path, i18n("Debug"), BarIcon("bug", KIcon::SizeSmall));
		lo = new QVBoxLayout( DebugFrame );
		lo->setSpacing(KDialog::spacingHint());
		DebugOptionsWidget = new ConfigDebugOptions(DebugFrame);
		lo->addWidget(DebugOptionsWidget);

		path.clear();
		path << i18n("Application") << i18n("Connect");
		QFrame* ConnectFrame = addPage(path, i18n("Connect"), BarIcon("kvpnc-connecting", KIcon::SizeSmall));
		lo = new QVBoxLayout( ConnectFrame );
		lo->setSpacing(KDialog::spacingHint());
		ConnectOptionsWidget = new ConfigConnectOptions(ConnectFrame);
		lo->addWidget(ConnectOptionsWidget);

		path.clear();
		path << i18n("Application") << i18n("Log");
		QFrame* LogFrame = addPage(path, i18n("Log"), BarIcon("text_center", KIcon::SizeSmall));
		lo = new QVBoxLayout( LogFrame );
		lo->setSpacing(KDialog::spacingHint());
		LogOptionsWidget = new ConfigLogOptions(LogFrame);
		lo->addWidget(LogOptionsWidget);

		path << i18n("Programs");
		setFolderIcon (path, SmallIcon("kvpnc", KIcon::SizeSmall));

		path.clear();
		path << i18n("Programs") << i18n("Daemons");
		QFrame* DaemonFrame = addPage(path, i18n("Daemons"), BarIcon("fork", KIcon::SizeSmall));
		lo = new QVBoxLayout( DaemonFrame );
		lo->setSpacing(KDialog::spacingHint());
		DaemonOptionsWidget = new ConfigDaemonOptions(DaemonFrame);
		lo->addWidget(DaemonOptionsWidget);

		path.clear();
		path << i18n("Programs") << i18n("Helper Programs");
		QFrame* HelperProgramFrame = addPage(path, i18n("Helper Programs"), BarIcon("tool", KIcon::SizeSmall));
		lo = new QVBoxLayout( HelperProgramFrame );
		lo->setSpacing(KDialog::spacingHint());
		HelperProgramOptionsWidget = new ConfigHelperProgramOptions(HelperProgramFrame);
		lo->addWidget(HelperProgramOptionsWidget);
	}
	// Profile page
	path.clear();
	path << i18n("Profile");
	setFolderIcon (path, SmallIcon("view_icon", KIcon::SizeSmall));

	path.clear();
	path << i18n("Profile") << i18n("General");
	QFrame* ProfileGeneralOptionsFrame = addPage(path, i18n("General"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileGeneralOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileGeneralOptionsWidget = new ProfileGeneralOptions(ProfileGeneralOptionsFrame, GlobalConfig);
	lo->addWidget(ProfileGeneralOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Authenticate") << i18n("User data");
	QFrame* ProfileUserOptionsFrame = addPage(path, i18n("User Data"), BarIcon("kvpnc-user", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileUserOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileUserOptionsWidget = new ProfileUserOptions(ProfileUserOptionsFrame);
	lo->addWidget(ProfileUserOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Authenticate") << i18n("Certificate/PSK");
	QFrame* ProfileCertPskOptionsFrame = addPage(path, i18n("Certificate/PSK"), BarIcon("kvpnc-certimport", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCertPskOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCertPskOptionsWidget = new ProfileCertPskOptions(ProfileCertPskOptionsFrame);
	lo->addWidget(ProfileCertPskOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Network") << i18n("Routes");
	QFrame* ProfileNetworkRouteOptionsFrame = addPage(path, i18n("Routes"), BarIcon("kvpnc-route", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileNetworkRouteOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileNetworkRouteOptionsWidget = new ProfileNetworkRouteOptions(ProfileNetworkRouteOptionsFrame);
	lo->addWidget(ProfileNetworkRouteOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Network") << i18n("NAT");
	QFrame* ProfileNetworkNatOptionsFrame = addPage(path, i18n("NAT"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileNetworkNatOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileNetworkNatOptionsWidget = new ProfileNetworkNatOptions(ProfileNetworkNatOptionsFrame);
	lo->addWidget(ProfileNetworkNatOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Network")  << i18n("Virtual IP");
	QFrame* ProfileNetworkVirtualIpOptionsFrame = addPage(path, i18n("Virtual IP"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileNetworkVirtualIpOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileNetworkVirtualIpOptionsWidget = new ProfileNetworkVirtualIpOptions(ProfileNetworkVirtualIpOptionsFrame);
	lo->addWidget(ProfileNetworkVirtualIpOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Connection specific") << i18n("Cisco");
	QFrame* ProfileCiscoOptionsFrame = addPage(path, i18n("Cisco"), BarIcon("kvpnc-cisco", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCiscoOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCiscoOptionsWidget = new ProfileCiscoOptions(ProfileCiscoOptionsFrame);
	lo->addWidget(ProfileCiscoOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Connection specific") << i18n("Racoon");
	QFrame* ProfileRacoonOptionsFrame = addPage(path, i18n("Racoon"), BarIcon("kvpnc-kame", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileRacoonOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileRacoonOptionsWidget = new ProfileRacoonOptions(ProfileRacoonOptionsFrame);
	lo->addWidget(ProfileRacoonOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Connection specific") << i18n("OpenVPN");
	QFrame* ProfileOpenvpnOptionsFrame = addPage(path, i18n("OpenVPN"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileOpenvpnOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileOpenvpnOptionsWidget = new ProfileOpenvpnOptions(ProfileOpenvpnOptionsFrame);
	lo->addWidget(ProfileOpenvpnOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Connection specific") << i18n("PPTP");
	QFrame* ProfilePptpOptionsFrame = addPage(path, i18n("PPTP"), BarIcon("application", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfilePptpOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfilePptpOptionsWidget = new ProfilePptpOptions(ProfilePptpOptionsFrame);
	lo->addWidget(ProfilePptpOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Command Execution") << i18n("Before Connect");
	QFrame* ProfileCmdExecBeforeConnectOptionsFrame = addPage(path, i18n("Before Connect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecBeforeConnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecBeforeConnectOptionsWidget = new ProfileCmdExecBeforeConnectOptions(ProfileCmdExecBeforeConnectOptionsFrame);
	lo->addWidget(ProfileCmdExecBeforeConnectOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Command Execution") << i18n("After Connect");
	QFrame* ProfileCmdExecAfterConnectOptionsFrame = addPage(path, i18n("After Connect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecAfterConnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecAfterConnectOptionsWidget = new ProfileCmdExecAfterConnectOptions(ProfileCmdExecAfterConnectOptionsFrame);
	lo->addWidget(ProfileCmdExecAfterConnectOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Command Execution") << i18n("Before Disconnect");
	QFrame* ProfileCmdExecBeforeDisconnectOptionsFrame = addPage(path, i18n("Before Disconnect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecBeforeDisconnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecBeforeDisconnectOptionsWidget = new ProfileCmdExecBeforeDisconnectOptions(ProfileCmdExecBeforeDisconnectOptionsFrame);
	lo->addWidget(ProfileCmdExecBeforeDisconnectOptionsWidget);

	path.clear();
	path << i18n("Profile") << i18n("Command Execution") << i18n("After Disconnect");
	QFrame* ProfileCmdExecAfterDisconnectOptionsFrame = addPage(path, i18n("Command Execute After Disconnect"), BarIcon("exec", KIcon::SizeSmall));
	lo = new QVBoxLayout( ProfileCmdExecAfterDisconnectOptionsFrame );
	lo->setSpacing(KDialog::spacingHint());
	ProfileCmdExecAfterDisconnectOptionsWidget = new ProfileCmdExecAfterDisconnectOptions(ProfileCmdExecAfterDisconnectOptionsFrame);
	lo->addWidget(ProfileCmdExecAfterDisconnectOptionsWidget);

	adjustSize();

	/* connect profile combobox of each profile widget */
	connect( ProfileGeneralOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkRouteOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkNatOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCertPskOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileUserOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileOpenvpnOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfilePptpOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileRacoonOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCiscoOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );

	connect( ProfileCertPskOptionsWidget->AuthTypeComboBox, SIGNAL( activated ( int ) ), this, SLOT( authTypeChanged( int ) ) );

	connect ( ProfileGeneralOptionsWidget->NewSessionPushButton , SIGNAL(clicked ()), this, SLOT(newSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->SaveSessionPushButton, SIGNAL(clicked ()), this, SLOT(saveSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->RenameSessionPushButton, SIGNAL(clicked ()), this, SLOT(renameSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->DeleteSessionPushButton, SIGNAL(clicked ()), this, SLOT(deleteSessionClicked()));
	connect ( ProfileGeneralOptionsWidget->ImportCertificatePushButton, SIGNAL(clicked ()), this, SLOT(importCertificate()));

	connect ( this, SIGNAL(aboutToShowPage(QWidget *)), this, SLOT(pageChanged(QWidget *)));

	connect ( this, SIGNAL(applyClicked ()), this, SLOT(saveSessionClicked()));

}

void PreferencesDialog::accept()
{
	//MyprofileWidget->saveSessionClicked();
	if (!showOnlyProfiles)
	{
		GlobalConfig->pathToVpnc = DaemonOptionsWidget->VpncPathInput->url();
		GlobalConfig->pathToSetkey = DaemonOptionsWidget->SetkeyPathInput->url();
		GlobalConfig->pathToRacoon = DaemonOptionsWidget->RacoonPathInput->url();
		GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url();
		GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url();
		GlobalConfig->pathToPppd = DaemonOptionsWidget->PppdPathInput->url();
		GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url();
		GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url();
		GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url();
		GlobalConfig->pathToOpenvpn = DaemonOptionsWidget->OpenvpnPathInput->url();
		GlobalConfig->pathToFreeswan = DaemonOptionsWidget->FreeswanPathInput->url();
		GlobalConfig->pathToIp = HelperProgramOptionsWidget->IpPathInput->url();
		GlobalConfig->pathToIfconfig = HelperProgramOptionsWidget->IfconfigPathInput->url();
		GlobalConfig->pathToRoute = HelperProgramOptionsWidget->RoutePathInput->url();
		GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
		GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
		GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
		GlobalConfig->dontQuitOnCloseEvent = GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
		GlobalConfig->useKwallet = GeneralOptionsWidget->useKwalletCheckBox->isChecked();
		GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
		GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value();
		GlobalConfig->RacoonDebugLevel = DaemonOptionsWidget->RacoonDebugLevelComboBox->currentText();
		GlobalConfig->VpncDebugLevel = DaemonOptionsWidget->spinVpncDebugLevel->value();
		GlobalConfig->OpenvpnDebugLevel = DaemonOptionsWidget->spinOpenvpnDebugLevel->value();
		GlobalConfig->enableDebugPppd = DaemonOptionsWidget->DebugPppdcheckBox->isChecked();
		GlobalConfig->tryConnectTimeout = ConnectOptionsWidget->spinTryConnectTimeout->value();
		GlobalConfig->programsInPath = DaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
		GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();
		GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->paletteBackgroundColor ();
		GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->paletteBackgroundColor();
		GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->paletteBackgroundColor ();
		GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->paletteBackgroundColor ();
		GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
		GlobalConfig->showInterfaceIPinTooltip = DaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
		GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
		GlobalConfig->AutoConnectProfile = ConnectOptionsWidget->AutoConnectProfileComboBox->currentText();
		GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
	}
	if (GlobalConfig->currentProfile != 0 && !GlobalConfig->AccountList->isEmpty() )
		saveSessionClicked();

	QDialog::accept();
}

void PreferencesDialog::connectionTypeChanged( int )
{

	if ( GlobalConfig->KvpncDebugLevel > 0 )
		GlobalConfig->appendLogEntry( "connectionTypeChanged()", GlobalConfig->debug );

	if (GlobalConfig->currentProfile == 0)
		return;

	ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );

	// First we should set a type
	// 	parent->buttonCancel->setEnabled( FALSE );
	// 	parent->buttonOk->setEnabled( FALSE );
	ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );

	if ( GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::cisco )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: cisco",GlobalConfig->debug );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( true );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

		ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
		ProfileGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);
		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // vpnc

	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan )
	{

		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon )
		{

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg("racoon"), GlobalConfig->debug );

			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );
		}
		else
		{

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg("freeswan"), GlobalConfig->debug );

			if (GlobalConfig->currentProfile != 0)
			{
				ProfileCertPskOptionsWidget->privkeypathURLRequester->setURL( GlobalConfig->currentProfile->getPrivateKey() );
				ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->setText( GlobalConfig->currentProfile->getPrivateKeyPass() );
			}
			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		}
		ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled ( true );
		ProfileGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );
		if ( ProfileCertPskOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() )
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( true );
		else
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // racoon/freeswan

	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: pptp", GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

		authTypeChanged(VpnAccountData::pptp);
	} // pptp
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: %1" ).arg("openvpn"),GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
		ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );
		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // openvpn

	// other
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::other )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: none specified" ),GlobalConfig->debug );
	}
	else
	{
		GlobalConfig->appendLogEntry( i18n( "unknown type" ),GlobalConfig->debug );
	}

}

void PreferencesDialog::authTypeChanged( int authtype )
{
	if (GlobalConfig->currentProfile ==0)
		return;

	ProfileCertPskOptionsWidget->PskInFileCheckBox->setEnabled(true);

	if (GlobalConfig->KvpncDebugLevel > 0)
	{

		QString type;
		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			type = "cert";
		else if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			type = "psk";


		GlobalConfig->appendLogEntry( i18n( "New authtype: \"%1\"." ).arg( type ) ,GlobalConfig->debug);
	}

	ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( false );
	ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( false );
	ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( false );
	ProfileCertPskOptionsWidget->LabelAuthType->setEnabled( false );
	ProfileCertPskOptionsWidget->CaCertpathURLRequester->setEnabled( false );
	ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setEnabled( false );

	int connectiontype = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem();


	if (connectiontype == VpnAccountData::cisco || connectiontype == VpnAccountData::pptp )
	{
		if (connectiontype == VpnAccountData::cisco)
		{
			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( true );
			ProfileCertPskOptionsWidget->PskInFileCheckBox->setChecked(false);
			ProfileCertPskOptionsWidget->PskInFileCheckBox->setEnabled(false);
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setEnabled(false);
			ProfileCertPskOptionsWidget->LabelPskFile->setEnabled(false);
		}

	}

	// racoon or freeswan
	else if ( connectiontype == VpnAccountData::freeswan || connectiontype == VpnAccountData::racoon )
	{

		ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertPskOptionsWidget->LabelAuthType->setEnabled( true );

		// cert
		if ( authtype == VpnAccountData::cert )
		{
			// certificate
			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( true );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( true );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( false );

		}

		// psk
		if ( authtype == VpnAccountData::psk )
		{
			// psk
			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( false );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( false );

		}
	}
	else if (connectiontype == VpnAccountData::openvpn)
	{

		ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertPskOptionsWidget->LabelAuthType->setEnabled( true );
		// cert
		if ( authtype  == VpnAccountData::cert )
		{
			// certificate
			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->CaCertpathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( true );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( true );
			ProfileCertPskOptionsWidget->privkeypathURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPrivateKeyPath->setEnabled( true );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
		}

		// psk
		if ( authtype == VpnAccountData::psk)
		{
			// psk
			ProfileCertPskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKFileURLRequester->setEnabled( true );
			ProfileCertPskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfileCertPskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertPskOptionsWidget->CertificateGroupBox->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
			ProfileCertPskOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertPskOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertPskOptionsWidget->LabelCertificatePath->setEnabled( false );
			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( false );
		}

	}
}


void PreferencesDialog::profileChanged( const QString& itemtext )
{

	if (!GlobalConfig->AccountList->isEmpty() && GlobalConfig->currentProfile != 0)
	{

		QString Name = itemtext;
		lastProfileName = Name;
		ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );
		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( lastProfileName );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New profile: %1" ).arg( Name ),GlobalConfig->debug );

		//	KMessageBox::information(0,"item clicked",Name);
		// profile data
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{
				GlobalConfig->currentProfile = it;
				break;
			}
		}

		ProfileCertPskOptionsWidget->x509certURLRequester->clear();
		ProfileCertPskOptionsWidget->certpathURLRequester->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfileCertPskOptionsWidget->PSKLineEdit->clear();
		ProfileCertPskOptionsWidget->RemoteIDLineEdit->clear();
		ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->clear();
		ProfileGeneralOptionsWidget->gatewayLineEdit->clear();
		ProfileNetworkRouteOptionsWidget->NetworkListView->clear();
		ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->clear();

		ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( false );
		ProfileUserOptionsWidget->CheckUserPass->setChecked( false );
		ProfileCiscoOptionsWidget->IDLineEdit->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfileUserOptionsWidget->PasswordEdit->clear();
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled(false);
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled(false);
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled(false);
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled(false);
		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked(false);
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked(false);
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked(false);
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked(false);
		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(false);
		ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked(false);

		ProfilePptpOptionsWidget->RefuseEapCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked(false );
		ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerLineedit->clear();
		ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->ReplaceDefaultRouteCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->SetDefaultRouteCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->MtuSpinbox->setValue( 1500 );
		ProfilePptpOptionsWidget->MtuCheckbox->setChecked( false );

		ProfileNetworkVirtualIpOptionsWidget->setEnabled(false);


		if ( it == 0 )
		{
			ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
			return;
		}
		else
		{
			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( true );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( true );
		}

		ProfileCertPskOptionsWidget->RemoteIDLineEdit->clear();
		ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText("24");
		ProfileGeneralOptionsWidget->DescriptionLineEdit->setText( it->getDescription() );
		ProfileGeneralOptionsWidget->gatewayLineEdit->setText(it->getGateway());

		// 	AdvancedSettingsPushButton->setEnabled( false );
		if ( ( it->getNetworkDevice() ).isEmpty() )
		{
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( "default" );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": no network device defined, using \"default\"." ).arg( it->getName() ), GlobalConfig->debug );
		}
		else
		{
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( it->getNetworkDevice() );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": network device defined, using \"%2\"." ).arg( it->getName() ).arg( it->getNetworkDevice() ), GlobalConfig->debug );
		}

		// global
		if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::cisco ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 0 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 1 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::freeswan ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 2 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::pptp ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 3 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn ))
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( 4 );
		else
			ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( VpnAccountData::other ); // must be last item -> other

		ProfileGeneralOptionsWidget->gatewayLineEdit->setText( it->getGateway() );

		ProfileCertPskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );

		/* connection specific */
		if ( it->getConnectionType() == VpnAccountData::cisco )
		{
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileCiscoOptionsWidget->IDLineEdit->setText( it->getID() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileCertPskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

			ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem(1); // PSK
			ProfileCertPskOptionsWidget->AuthTypeComboBox->setEnabled( false );

			ProfileCertPskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( true );
			ProfileCiscoOptionsWidget->KeepDefaultRouteCheckBox->setChecked( it->getKeepDefaultRoute());
			ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->setChecked ( it->getAllowEmptyGroupPassword());

			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
			ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled(false);
			ProfileOpenvpnOptionsWidget->setEnabled(false);
			ProfileCiscoOptionsWidget->setEnabled(true);
			ProfileRacoonOptionsWidget->setEnabled(false);

		} // vpnc

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon) || it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::freeswan ))
		{
			QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
			QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( RemoteNetAddr );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
			}


			ProfileCertPskOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertPskOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertPskOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
			ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass());
			ProfileCertPskOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );

			ProfileGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );
			ProfileCertPskOptionsWidget->RemoteIDLineEdit->setText( it->getSpecialRemoteID() );
			ProfileCertPskOptionsWidget->UseSpecialRemoteIDcheckBox->setChecked( it->getUseSpecialRemoteID() );
			ProfileCertPskOptionsWidget->PSKLineEdit->setText(it->getPreSharedKey());
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked(it->getSavePsk());

			// TODO made it useable for freeswan
			if (it->getConnectionType() == VpnAccountData::freeswan)
			{
				ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setEnabled(false);
				ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( 	it->getUseSpecialServerCertificate() );
				if ( it->getUseSpecialServerCertificate())
					ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->setURL(it->getSpecialServerCertificate());
			}

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( it->getUseVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);

			ProfileUserOptionsWidget->setEnabled(false);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
			ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );

			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			if (it->getConnectionType() == VpnAccountData::racoon)
				ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfilePptpOptionsWidget->setEnabled(false);
			ProfileOpenvpnOptionsWidget->setEnabled(false);
			ProfileCiscoOptionsWidget->setEnabled(false);
			ProfileRacoonOptionsWidget->setEnabled( true );

			if (it->getHashAlgo() == "sha1")
				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText("SHA1");
			if (it->getHashAlgo() == "md5")
				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText("MD5");

		} // racoon or freeswan

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::pptp ))
		{
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );
			ProfileGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			if (!it->getRemoteNet().isEmpty())
			{
				QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
				QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
				ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( RemoteNetAddr );
				ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			}

			ProfilePptpOptionsWidget->RefuseEapCheckbox->setChecked(it->getRefuseEap());
			ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked(it->getRequireMppe());
			ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked(it->getRefuse128BitEncryption());
			ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked(it->getRefuse40BitEncryption());
			ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked(it->getDisableMPPEComp());
			ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->setChecked(it->getUseGetDnsFromPeer());
			ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked(it->getUseDnsServer());
			ProfilePptpOptionsWidget->DnsServerLineedit->setText(it->getDnsServer());
			ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked(it->getUseNoBsdComp());
			ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked(it->getUseNoDeflate());
			ProfilePptpOptionsWidget->SetDefaultRouteCheckbox->setChecked(it->getSetDefaultRoute());
			ProfilePptpOptionsWidget->ReplaceDefaultRouteCheckbox->setChecked(it->getReplaceDefaultRoute());
			ProfilePptpOptionsWidget->MtuCheckbox->setChecked(it->getUseMtu());
			ProfilePptpOptionsWidget->MtuSpinbox->setValue(it->getMtu());
			ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked(it->getAllowStatefulMode());
			ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->setChecked(it->getUseNoIpDefault());

			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
			ProfileGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(true );
			ProfileGeneralOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled(true);
			ProfileOpenvpnOptionsWidget->setEnabled(false);
			ProfileCiscoOptionsWidget->setEnabled(false);
			ProfileRacoonOptionsWidget->setEnabled(false);

		} // pptp

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn ))
		{

			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
			}

			ProfileCertPskOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertPskOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertPskOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
			ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass());
			ProfileCertPskOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );
			ProfileCertPskOptionsWidget->PSKLineEdit->setText(it->getPreSharedKey());
			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked(it->getSavePsk());
			ProfileGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			ProfileGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->setChecked( GlobalConfig->currentProfile->getUseConnectionStatusCheck());
			ProfileGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusCheckSuccessCount());
			ProfileGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->setValue(GlobalConfig->currentProfile->getConnectionStatusInterval());
			ProfileGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->setChecked(GlobalConfig->currentProfile->getDoReconnectAfterConnectionLost());

			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP());
			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP());

			// 			if (!it->getRemoteNet().isEmpty())
			// 			{
			// 				QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
			// 				QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
			// 				ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( RemoteNetAddr );
			// 				ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			// 			}
			// 			ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled(true);
			// 			ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled(true);


			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(true);
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled(false);

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled(false);
			ProfileOpenvpnOptionsWidget->setEnabled(true);
			ProfileCiscoOptionsWidget->setEnabled(false);
			ProfileRacoonOptionsWidget->setEnabled(false);

			if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword() )
				ProfileUserOptionsWidget->setEnabled(true);
			else
				ProfileUserOptionsWidget->setEnabled(false);

			ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->setCurrentText(it->getTunnelDeviceType());

			if ( GlobalConfig->currentProfile->getUseUserdefinedPort() )
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(true);
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(true);
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled(false);
			}

			if (it->getAuthType() == VpnAccountData::cert)
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled(true);
			else
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled(false);


			if ( GlobalConfig->currentProfile->getUseNsCertType())
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(true);
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(true);

				if (GlobalConfig->currentProfile->getNsCertType() == "client")
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem(0);
				else
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem(1);
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked(false);
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled(false);
			}
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());

			if (GlobalConfig->currentProfile->getDisableLzoCompression())
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(false);
			else
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked(true);

			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());
			if (GlobalConfig->currentProfile->getAuthWithUsernameAndPassword())
				ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked (true);
			else
				ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked (false);

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled(true);

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked(GlobalConfig->currentProfile->getUseVirtualIP());

			if (  GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
				ProfileNetworkVirtualIpOptionsWidget->setEnabled(true);
			else
			{
				ProfileNetworkVirtualIpOptionsWidget->setEnabled(false);

				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText(GlobalConfig->currentProfile->getRemoteVirtualIP());
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText(GlobalConfig->currentProfile->getLocalVirtualIP());
			}

			ProfileCertPskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );

		} // openvpn

		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked(it->getExecuteCmdBeforeConnect());
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked(it->getExecuteCmdAfterConnect());
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked(it->getExecuteCmdBeforeDisconnect());
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked(it->getExecuteCmdAfterDisconnect());
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setText(it->getCommandBeforeConnect());
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setText(it->getCommandAfterConnect());
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setText (it->getCommandBeforeDisconnect());
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setText (it->getCommandAfterDisconnect());
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled(it->getExecuteCmdBeforeConnect());
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled(it->getExecuteCmdAfterConnect());
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled(it->getExecuteCmdBeforeDisconnect());
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled(it->getExecuteCmdAfterDisconnect());

		ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->setChecked(it->getUseAdditionalNetworkRoutes());

		QStringList AdditionalNetworkRoutes = it->getAdditionalNetworkRoutes();
		// example entry:
		// <network>/<netmask>#<gateway>

		for (QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			QString networkstring = *it2;
			QString Network = networkstring.section('#',0,0).section('/',0,0);
			QString Netmask = networkstring.section('#',0,0).section('/',1,1);
			QString Gateway = networkstring.section('#',1,1).section('/',0,0);

			ProfileNetworkRouteOptionsWidget->NetworkListView->insertItem(new QListViewItem(ProfileNetworkRouteOptionsWidget->NetworkListView,Network,Netmask,Gateway));

		}

		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		ProfileCertPskOptionsWidget->AuthTypeComboBox->setCurrentItem(it->getAuthType());
		ProfileCertPskOptionsWidget->x509certURLRequester->setFilter( "*.pem" );
		ProfileCertPskOptionsWidget->certpathURLRequester->setMode( KFile::Directory );
	}
}

void PreferencesDialog::saveSessionClicked()
{
	if ( GlobalConfig->currentProfile== 0 )
		return;

	VpnAccountData *profile = GlobalConfig->currentProfile;
	//QString itemString=ConnectionTypeComboBox->currentText();
	int item = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem();

	profile->setDescription( ProfileGeneralOptionsWidget->DescriptionLineEdit->text() );

	// cisco
	if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::cisco )
	{
		profile->setConnectionType( VpnAccountData::cisco );
		if (ProfileUserOptionsWidget->CheckUserPass->isChecked() && ! ProfileUserOptionsWidget->UsernameLineEdit->text().isEmpty())
		{
			profile->setSaveUserPassword(true);
			profile->setUserPassword(ProfileUserOptionsWidget->UsernameLineEdit->text());
		}
		else
		{
			profile->setSaveUserPassword(false);
		}

		if (ProfileCertPskOptionsWidget->CheckSavePsk->isChecked() && !ProfileCertPskOptionsWidget->PSKLineEdit->text().isEmpty() )
		{
			profile->setSavePsk(true);
			profile->setPreSharedKey(ProfileCertPskOptionsWidget->PSKLineEdit->text());
		}
		else
		{
			profile->setSavePsk(false);
		}
		profile->setKeepDefaultRoute(ProfileCiscoOptionsWidget->KeepDefaultRouteCheckBox->isChecked());
		profile->setAllowEmptyGroupPassword(ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->isChecked());
	}

	else if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon || ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::freeswan )
	{
		profile->setSpecialRemoteID( ProfileCertPskOptionsWidget->RemoteIDLineEdit->text() );
		profile->setUseSpecialRemoteID( ProfileCertPskOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() );

		if ( item == VpnAccountData::racoon )
			profile->setConnectionType( VpnAccountData::racoon );
		else
			profile->setConnectionType( VpnAccountData::freeswan );

		profile->setPrivateKey( ProfileCertPskOptionsWidget->privkeypathURLRequester->url() );
		profile->setPrivateKeyPass( ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->text() );


		bool validAddr = true;
		if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
		{
			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
			GlobalConfig->appendLogEntry(i18n( "No IP address entered!" ) ,GlobalConfig->error);
			validAddr = false;
		}
		else
		{
			QString addr = ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
			int part0 = addr.section( '.', 0, 0 ).toInt();
			int part1 = addr.section( '.', 1, 1 ).toInt();
			int part2 = addr.section( '.', 2, 2 ).toInt();
			int part3 = addr.section( '.', 3, 3 ).toInt();

			/*
						LogOutput->append ("part0: "+QString().setNum(part0));
						LogOutput->append ("part1: "+QString().setNum(part1));
						LogOutput->append ("part2: "+QString().setNum(part2));
						LogOutput->append ("part3: "+QString().setNum(part3));
			*/
			if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
			{
				KMessageBox::error ( this, i18n( "IP address (remote net) is not valid!" ), i18n( "Invalid IP Address" ) );
				GlobalConfig->appendLogEntry( i18n( "IP address (remote net) is not valid!" ) ,GlobalConfig->error);

				validAddr = false;
			}
			if ( validAddr == true )
			{
				profile->setRemoteNet( addr + "/" + ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
			}

		}

		if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		else
			profile->setAuthType( VpnAccountData::psk );

		profile->setX509Certificate( ProfileCertPskOptionsWidget->x509certURLRequester->url() );
		profile->setCertPath( ProfileCertPskOptionsWidget->certpathURLRequester->url() );

		profile->setPreSharedKey( ProfileCertPskOptionsWidget->PSKLineEdit->text());

		if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon )
		{
			if (ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText() =="SHA1")
			{
				profile->setHashAlgo("sha1");
			}
			if (ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText() =="MD5")
			{
				profile->setHashAlgo("md5");
			}
		}
	}

	else if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::pptp )
	{
		profile->setConnectionType( VpnAccountData::pptp );


		bool validAddr = true;
		if (ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && !ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().isEmpty())
		{
			if ( ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
			{
				//KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
				validAddr = false;
			}
			else
			{
				QString addr = ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
				int part0 = addr.section( '.', 0, 0 ).toInt();
				int part1 = addr.section( '.', 1, 1 ).toInt();
				int part2 = addr.section( '.', 2, 2 ).toInt();
				int part3 = addr.section( '.', 3, 3 ).toInt();

				/*
							LogOutput->append ("part0: "+QString().setNum(part0));
							LogOutput->append ("part1: "+QString().setNum(part1));
							LogOutput->append ("part2: "+QString().setNum(part2));
							LogOutput->append ("part3: "+QString().setNum(part3));
				*/

				if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
				{
					KMessageBox::error ( this, i18n( "Invalid values in IP address (remote net)!" ), i18n( "Invalid Values in IP Address" ) );
					GlobalConfig->appendLogEntry(i18n( "Invalid values in IP address (remote net)!" ) ,GlobalConfig->error);
					validAddr = false;
				}


				if ( validAddr == true )
				{
					profile->setRemoteNet( addr + "/" + ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
				}

			}
		}
		else
		{
			profile->setRemoteNet("");
		}

	}

	else if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::openvpn)
	{
		profile->setConnectionType( VpnAccountData::openvpn );

		// 		bool validAddr = true;
		// 		if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
		// 		{
		// 			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
		// 			GlobalConfig->appendLogEntry(i18n( "No IP address entered!" ) ,GlobalConfig->error);
		// 			validAddr = false;
		// 		}
		// 		else
		// 		{
		// 			QString addr = ProfileGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
		// 			int part0 = addr.section( '.', 0, 0 ).toInt();
		// 			int part1 = addr.section( '.', 1, 1 ).toInt();
		// 			int part2 = addr.section( '.', 2, 2 ).toInt();
		// 			int part3 = addr.section( '.', 3, 3 ).toInt();
		//
		// 			/*
		// 						LogOutput->append ("part0: "+QString().setNum(part0));
		// 						LogOutput->append ("part1: "+QString().setNum(part1));
		// 						LogOutput->append ("part2: "+QString().setNum(part2));
		// 						LogOutput->append ("part3: "+QString().setNum(part3));
		// 			*/
		// 			if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
		// 			{
		// 				KMessageBox::error ( this, i18n( "IP address (remote net) is invalid!" ), i18n( "Invalid IP Address" ) );
		// 				GlobalConfig->appendLogEntry(i18n( "IP address (remote net) is invalid!" ) ,GlobalConfig->error);
		// 				validAddr = false;
		// 			}
		// 			if ( validAddr == true )
		// 			{
		// 				profile->setRemoteNet( addr + "/" + ProfileGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
		// 			}
		//
		// 		}

		// 		QString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
		// 		if (Utils( GlobalConfig ).isValidIPv4Adress(LocalVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
		// 		else
		// 		{
		// 			profile->setLocalVirtualIP( LocalVirtualIp);
		// 		}
		//
		// 		QString RemoteVirtualIp = RemoteVirtualIpLineEdit->text();
		// 		if (Utils( GlobalConfig ).isValidIPv4Adress(RemoteVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
		// 		else
		// 		{
		// 			profile->setRemoteVirtualIP( RemoteVirtualIp);
		// 		}


		if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		else
			profile->setAuthType( VpnAccountData::psk );


		profile->setPreSharedKeyFile(ProfileCertPskOptionsWidget->PSKFileURLRequester->url());
		profile->setX509Certificate( ProfileCertPskOptionsWidget->x509certURLRequester->url() );
		profile->setCaCertificate( ProfileCertPskOptionsWidget->CaCertpathURLRequester->url() );
		profile->setCertPath( ProfileCertPskOptionsWidget->certpathURLRequester->url() );
		profile->setPrivateKey ( ProfileCertPskOptionsWidget->privkeypathURLRequester->url());
		profile->setPrivateKeyPass ( ProfileCertPskOptionsWidget->PrivkeyPasswordEdit->text());
		profile->setTunnelDeviceType( ProfileOpenvpnOptionsWidget->TunnelDeviceTypeComboBox->currentText() );

		profile->setUserdefinedPort( ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value());
		profile->setUseUserdefinedPort( ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->isChecked());
		profile->setDisableLzoCompression (!ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->isChecked());

		profile->setUserdefinedPort(ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value());

		profile->setAuthWithUsernameAndPassword(ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->isChecked ());

	} // openvpn

	else
		profile->setConnectionType( VpnAccountData::other );

	if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && !ProfileGeneralOptionsWidget->PingIPLineEdit->text().isEmpty() )
	{
		// do check for vailid IP
		if (!Utils( GlobalConfig ).isValidIPv4Adress(ProfileGeneralOptionsWidget->PingIPLineEdit->text()))
		{
			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
			GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) ,GlobalConfig->error);
		}
		else
		{
			profile->setPingHostIP( ProfileGeneralOptionsWidget->PingIPLineEdit->text() );
			profile->setDoPingIP( ProfileGeneralOptionsWidget->PingCheckBox->isChecked());
		}
	}
	else
	{
		if ( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileGeneralOptionsWidget->PingIPLineEdit->text() == QString( "" ) )
		{
			KMessageBox::error ( this, i18n( "No IP address (ping host) entered!" ), i18n( "No IP Address" ) );
			GlobalConfig->appendLogEntry(i18n( "No IP address (ping host) entered!" ) ,GlobalConfig->error);
		}
		else
			profile->setPingHostIP( "" );
	}

	profile->setUseConnectionStatusCheck( ProfileGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->isChecked());
	profile->setConnectionStatusCheckSuccessCount( ProfileGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->value());
	profile->setConnectionStatusInterval( ProfileGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->value());
	profile->setDoReconnectAfterConnectionLost(ProfileGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->isChecked());

	if ( item == VpnAccountData::ConnectionType(VpnAccountData::freeswan) ||
	        item == VpnAccountData::ConnectionType(VpnAccountData::racoon) )
	{

		if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() && !ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() )
		{
			// do check for vailid IP
			if (!Utils( GlobalConfig ).isValidIPv4Adress(ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text()))
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) ,GlobalConfig->error);
			}
			else
			{
				profile->setVirtualIP( ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text() );
				profile->setUseVirtualIP( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked());
			}
		}
		else
		{
			if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() && ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "No IP address (virtual IP) entered!" ), i18n( "No IP Address" ) );
				GlobalConfig->appendLogEntry(i18n( "No IP address (virtual IP) entered!" ) ,GlobalConfig->error);
			}
			else
			{
				profile->setVirtualIP( "" );
				profile->setUseVirtualIP(false);
			}
		}
	}



	profile->setSavePsk( ProfileCertPskOptionsWidget->CheckSavePsk->isChecked() );
	profile->setSaveUserPassword( ProfileUserOptionsWidget->CheckUserPass->isChecked () );
	profile->setID( ProfileCiscoOptionsWidget->IDLineEdit->text() );
	profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text () );

	if (ProfileUserOptionsWidget->CheckUserPass->isChecked())
		profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text ( ) );
	else
		profile->setUserPassword( "" );

	if (ProfileCertPskOptionsWidget->CheckSavePsk->isChecked())
		profile->setPreSharedKey( ProfileCertPskOptionsWidget->PSKLineEdit->text( ) );
	else
		profile->setPreSharedKey( "" );

	profile->setGateway( ProfileGeneralOptionsWidget->gatewayLineEdit->text() );
	profile->setPreSharedKey( ProfileCertPskOptionsWidget->PSKLineEdit->text() );
	profile->setX509Certificate( ProfileCertPskOptionsWidget->x509certURLRequester->url() );
	profile->setCertPath( ProfileCertPskOptionsWidget->certpathURLRequester->url() );
	profile->setNetworkDevice( ProfileGeneralOptionsWidget->NetworkDeviceComboBox->currentText() );

	profile->setDoPingIP( ProfileGeneralOptionsWidget->PingCheckBox->isChecked() );

	if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
		profile->setAuthType( VpnAccountData::cert );
	if ( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
		profile->setAuthType( VpnAccountData::psk );

	if (ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked())
		profile->setUseUdp(true);
	else
		profile->setUseUdp(false);

	if (ProfileNetworkNatOptionsWidget->UdpPortCheckbox->isChecked())
	{
		profile->setUdpPort(ProfileNetworkNatOptionsWidget->UdpPortSpinbox->value());
		profile->setUseUdpPort(true);
	}
	else
	{
		profile->setUdpPort(0);
		profile->setUseUdpPort(false);
	}



	profile->setExecuteCmdBeforeConnect( (ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->isChecked()));
	profile->setExecuteCmdAfterConnect( (ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->isChecked()));
	profile->setExecuteCmdBeforeDisconnect( (ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->isChecked()));
	profile->setExecuteCmdAfterDisconnect( (ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->isChecked()));

	profile->setCommandBeforeConnect(ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->text());
	profile->setCommandAfterConnect(ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->text());
	profile->setCommandBeforeDisconnect(ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->text());
	profile->setCommandAfterDisconnect(ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->text());

	profile->setUseAdditionalNetworkRoutes(ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked());

	if (ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked() && ProfileNetworkRouteOptionsWidget->NetworkListView->childCount() > 0)
	{
		QStringList AdditionalNetworkRoutes;
		QListViewItemIterator it( ProfileNetworkRouteOptionsWidget->NetworkListView );
		for ( ; it.current(); ++it )
		{
			// example entry:
			// <network>/<netmask>#<gateway>
			QString network = QString(it.current()->text(0)+"/"+it.current()->text(1));
			network.append("#");
			network.append(it.current()->text(2));
			AdditionalNetworkRoutes.append(network);
		}
		profile->setAdditionalNetworkRoutes(AdditionalNetworkRoutes);
	}

	profile->setUseSpecialServerCertificate(ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked());
	if ( ProfileCertPskOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked())
	{
		if (!ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->url().isEmpty())
			profile->setSpecialServerCertificate(ProfileCertPskOptionsWidget->SpecialServerCertificateURLRequester->url());
		else
		{
			KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No Server Certificate" ) );
			GlobalConfig->appendLogEntry( i18n( "Special server certificate can't be empty!" ) ,GlobalConfig->error);
		}
	}

	profile->setUseNsCertType(ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->isChecked());

	if (ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->currentText() == "client")
		profile->setNsCertType("client");
	else
		profile->setNsCertType("server");

	profile->setRefuseEap(ProfilePptpOptionsWidget->RefuseEapCheckbox->isChecked() );
	profile->setRequireMppe(ProfilePptpOptionsWidget->RequireMppeCheckbox->isChecked()  );
	profile->setRefuse128BitEncryption(ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->isChecked() );
	profile->setRefuse40BitEncryption(ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->isChecked() );
	profile->setDisableMPPEComp(ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked() );
	profile->setUseGetDnsFromPeer(ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->isChecked());
	profile->setUseDnsServer(ProfilePptpOptionsWidget->DnsServerCheckbox->isChecked() );
	profile->setDnsServer(ProfilePptpOptionsWidget->DnsServerLineedit->text() );
	profile->setUseNoBsdComp(ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->isChecked());
	profile->setUseNoDeflate(ProfilePptpOptionsWidget->UseNoDeflateCheckbox->isChecked());
	profile->setSetDefaultRoute(ProfilePptpOptionsWidget->SetDefaultRouteCheckbox->isChecked());
	profile->setReplaceDefaultRoute(ProfilePptpOptionsWidget->ReplaceDefaultRouteCheckbox->isChecked());
	profile->setUseMtu(ProfilePptpOptionsWidget->MtuCheckbox->isChecked());
	profile->setMtu(ProfilePptpOptionsWidget->MtuSpinbox->value());
	profile->setAllowStatefulMode(ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->isChecked());
	profile->setUseNoIpDefault(ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->isChecked());
	profile->setDisableMPPEComp(ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked());

	//GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" saved." ).arg( newName ),GlobalConfig->debug);
}

void PreferencesDialog::deleteSessionClicked()
{
	QString Name = ProfileGeneralOptionsWidget->ProfileComboBox->currentText();
	if ( !ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
	{
		int result = KMessageBox::questionYesNo ( this, i18n( "Really delete \"%1\"?" ).arg( Name ), i18n( "Delete?" ), KStdGuiItem::del(), KStdGuiItem::cancel() );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3) // Yes
		{
			VpnAccountData * it;
			if (!GlobalConfig->AccountList->isEmpty())
			{
				for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
				{
					if ( ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
					{
						// 					this->deleteSessionAction->setEnabled ( FALSE );
						//			this->advancedSessionAction->setEnabled ( FALSE );
						// 					this->saveSessionAction->setEnabled ( FALSE );
					}
					else
					{
						if ( it->getName() == Name )
						{
							GlobalConfig->removeEntry(GlobalConfig->currentProfile->getName());
							GlobalConfig->currentProfile=0L;
							ProfileGeneralOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileNetworkRouteOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileNetworkNatOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCertPskOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileUserOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileOpenvpnOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfilePptpOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileRacoonOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCiscoOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->removeItem( ProfileGeneralOptionsWidget->ProfileComboBox->currentItem() );
							break;
						}
					}
				}
			}

			if ( !GlobalConfig->AccountList->isEmpty() )
			{
				GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
				ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText(GlobalConfig->AccountList->first()->getName());
				//ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setSelected(0, true);
				profileChanged ( GlobalConfig->AccountList->first()->getName());
				connectionTypeChanged( GlobalConfig->AccountList->first()->getConnectionType() );
				authTypeChanged( GlobalConfig->AccountList->first()->getAuthType() );
				// 				buttonCancel->setEnabled( true );
				// 				buttonOk->setEnabled( true );
			}
			else
			{
				ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
				GlobalConfig->lastProfile="";
				// 				CiscoPptpGroupBox->setEnabled( false );
				//				FreeswanRacoonGroupBox->setEnabled( false );
				// 				OpenvpnGroupBox->setEnabled( false );
				// 				GeneralGroupbox->setEnabled( false );
				//				CommandExecutionGroupBox->setEnabled( false );
			}

			//		slotStatusMsg ( i18n( "Profile \"%1\" deleted." ).arg( Name ), ID_FLASH_MSG );

			GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" deleted." ).arg( Name ),GlobalConfig->debug );

			profileAddedOrDeleted=true;
			//saveOptions(); // TODO save, currently after closing dialog
			//			sessionToggled();
			//if ( ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
			//	ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setEnabled ( FALSE );
		}
	}

}

void PreferencesDialog::newSessionClicked()
{

	// call new profile dialog...
	NewProfileDialog newdlg( GlobalConfig->appPointer,this, i18n("New profile"),GlobalConfig);
	newdlg.exec();
	if ( newdlg.newProfileCreated )
	{
		QString Name = newdlg.profileData->getName();
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{

				ProfileGeneralOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileNetworkRouteOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileNetworkNatOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCertPskOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileUserOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileOpenvpnOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfilePptpOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileRacoonOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCiscoOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->insertItem( Name );
				ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->insertItem( Name );

				ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileUserOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfilePptpOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );
				ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentItem ( Name );

				GlobalConfig->currentProfile = it;
				break;
			}
		}

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );

		// 		CiscoPptpGroupBox->setEnabled( true );
		// 		//		FreeswanRacoonGroupBox->setEnabled( true );
		// 		OpenvpnGroupBox->setEnabled( true );
		// 		GeneralGroupbox->setEnabled( true );
		// 		CommandExecutionGroupBox->setEnabled( true );

		KMessageBox::information ( this, i18n( "Profile \"%1\" added.\nNow set the right type,\n fill in the fields\nand press \"Save\" to complete the profile." ).arg( Name ), i18n( "Complete Profile" ) );
		//slotStatusMsg ( i18n( "Profile \"%1\" added." ).arg( Name ), ID_FLASH_MSG );

		GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" added." ).arg( Name ),GlobalConfig->debug );
		profileAddedOrDeleted=true;
		NewProfileName=Name;
		profileChanged ( Name );
		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		authTypeChanged( ProfileCertPskOptionsWidget->AuthTypeComboBox->currentItem() );
		saveSessionClicked();
	}
	else
	{

		GlobalConfig->appendLogEntry ( i18n( "Creation of the new profile canceled." ),GlobalConfig->debug );
	}

}


void PreferencesDialog::renameSessionClicked()
{
	bool ok=false;
	QString oldName= GlobalConfig->currentProfile->getName();
	QString newName = KInputDialog::getText ( i18n("New Name"),i18n("Enter new name for profile:"), oldName, &ok,this);

	if (newName.contains(' '))
	{
		KMessageBox::error ( this, i18n( "Blanks are not allowed in profile names!" ), i18n( "Illegal Character in Name" ) );
		GlobalConfig->appendLogEntry(i18n( "Blanks are not allowed in profile names!" ) ,GlobalConfig->error);
		ok = false;
	}

	if (ok)
	{
		GlobalConfig->currentProfile->setName(newName);
		ProfileGeneralOptionsWidget->ProfileComboBox->clear();
		ProfileNetworkRouteOptionsWidget->ProfileComboBox->clear();
		ProfileNetworkNatOptionsWidget->ProfileComboBox->clear();
		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->clear();
		ProfileCertPskOptionsWidget->ProfileComboBox->clear();
		ProfileUserOptionsWidget->ProfileComboBox->clear();
		ProfileOpenvpnOptionsWidget->ProfileComboBox->clear();
		ProfilePptpOptionsWidget->ProfileComboBox->clear();
		ProfileRacoonOptionsWidget->ProfileComboBox->clear();
		ProfileCiscoOptionsWidget->ProfileComboBox->clear();
		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->clear();
		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->clear();
		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->clear();
		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->clear();

		if ( !GlobalConfig->AccountList->isEmpty() )
		{
			VpnAccountData * it;
			for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
			{
				if (it != 0 )
				{
					ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( newName );
					ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( newName );
				}
			}
		}

		if (!showOnlyProfiles)
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->clear();
			for (uint i=1; i < GlobalConfig->AccountList->count();i++)
				ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem(GlobalConfig->AccountList->at(i)->getName());
		}
		profileAddedOrDeleted=true;
		GlobalConfig->removeEntry(GlobalConfig->currentProfile->getName());
		saveSessionClicked();
		GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" renamed to \"%2\"." ).arg(oldName).arg( GlobalConfig->currentProfile->getName() ),GlobalConfig->debug );
	}

}

void PreferencesDialog::importCertificate()
{
	ImportCertificateDialog dlg( this, i18n("Import certificate...").ascii(),GlobalConfig );
	//int result =
	dlg.exec();
}

void PreferencesDialog::pageChanged(QWidget*)
{
	//std::cout << "page changed, new profile: "<< lastProfileName << std::endl;
	profileChanged(lastProfileName);
}

#include "preferencesdialog.moc"
