/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilecertpskoptions.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <qlabel.h>
#include <klocale.h>
#include <kcombobox.h>

ProfileCertPskOptions::ProfileCertPskOptions(QWidget *parent)
		: ProfileCertPskOptionsBase(parent)
{
}


ProfileCertPskOptions::~ProfileCertPskOptions()
{}

void ProfileCertPskOptions::useSpecialRemoteIDToggled(bool)
{
	if ( UseSpecialRemoteIDcheckBox->isChecked() )
		RemoteIDLineEdit->setEnabled( true );
	else
		RemoteIDLineEdit->setEnabled( false );
}


void ProfileCertPskOptions::useSpecialServerCertificateToggled(bool)
{
	if (UseSpecialServerCertificateCheckBox->isChecked())
	{
		SpecialServerCertificateURLRequester->setEnabled(TRUE);
	}
	else
	{
		SpecialServerCertificateURLRequester->setEnabled(FALSE);
	}
}

void ProfileCertPskOptions::pskIsInFileToggled(bool)
{
	if (PskInFileCheckBox->isChecked())
	{
		LabelPskFile->setEnabled(TRUE);
		PSKFileURLRequester->setEnabled(TRUE);
		LabelPsk->setEnabled(FALSE);
		PSKLineEdit->setEnabled(FALSE);
	}
	else
	{
		LabelPskFile->setEnabled(FALSE);
		PSKFileURLRequester->setEnabled(FALSE);
		LabelPsk->setEnabled(TRUE);
		PSKLineEdit->setEnabled(TRUE);

	}
}





