/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//BEGIN INCLUDES
#ifndef NEWPROFILEWIZARD_H
#define NEWPROFILEWIZARD_H

#include <qwizard.h>
#include <qwidget.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qstring.h>
#include <qobject.h>
#include <qpixmap.h>


#include "kvpncconfig.h"

#include "newprofilewizardtypeselection.h"
#include "newprofilewizardgeneral.h"
#include "newprofilewizardciscoselection.h"
#include "newprofilewizardciscomanually.h"
#include "importprofiledialog.h" // PCF import
#include "importopenvpnprofiledialog.h" //< OpenVPN import
#include "newprofilewizardracoon.h"
#include "newprofilewizardfreeswan.h"
#include "newprofilewizardopenvpn.h"
#include "newprofilewizardopenvpnauth.h"
#include "newprofilewizardopenvpnselection.h"
#include "newprofilewizardpptp.h"
#include "newprofilewizardauthselection.h"
#include "newprofilewizardpsk.h"
#include "newprofilewizardcert.h"
#include "newprofilewizardstart.h"
#include "newprofilewizarduser.h"
#include "newprofilewizardnetwork.h"
#include "newprofilewizardnat.h"
#include "newprofilewizardp12certselection.h"
#include "importcertificatedialog.h"
#include "newprofilewizardconnectoptions.h"
#include "newprofilewizardconnectionstatuscheck.h"

//END INCLUDES

/**
Provides a wizard for creating a new profile

@author Christoph Thielecke
*/
class NewProfileWizard : public QWizard
{
Q_OBJECT
public:
	NewProfileWizard(KVpncConfig* GlobalConfig);

	void dataChanged( const QString & );
	QString getName();
	QString getProfile();
	bool getFinished();
	bool newProfileCreated;
	bool daemonavailable; //< true if required is found, used for connecting after creating
	bool connectaftercreating; //< connect if successful created
	VpnAccountData *profileData;

public slots:
	void showPage( QWidget* page );
	void next ();
	void back();
	void accept();
	void reject();
	void userdefinedOpenvpnPortToggeled(bool);
	void nsCertTypeOpenvpnToggled(bool);
	void pskIsInFileToggled(bool);
	void useUdpToggled(bool);
	void udpPortToggled(bool);
	void pingIpAfterConnectToggled(bool);
	void useUserdefiniedCipherToggled(bool);
	void useHttpProxyToggeled(bool);
	void useTlsAuthToggled(bool);
	void useTlsRemoteHostToggled(bool);
	void connectionStatusCheckToggled(bool);
	void authenticateWithUsernameAndPasswordToggled(bool);
	void pskInputToggled(const QString& str);
	void userpassToggled(const QString& str);
	void usernameToggled(const QString& str);
	void useNtDomainNameToggled(bool);
	//void reject();

protected:
	QString ConnectionType;
	QString Gateway;
	QString ID;
	QString Username;
	QString UserPassword;
	QString PreSharedKey;
	QString ApplicationVersion;
	QString NtDomainName;
	QString PerfectForwardSecrecy;
	QString IkeGroup;
	QString DnsServer; //< userdefined DNS server for pptp
	QString Name;
	QString Description;
	bool saveUserPassword;
	bool savePsk;
	bool useApplicationVersion;
	bool useGlobalIpsecSecret;
	bool useIkeGroup;
	bool useLocalPort;
	bool useNtDomainName;
	bool useSingleDes;
	bool useAdvancedSettings;
	bool usePerfectSecrecy;
	bool useUdp; //< True if NAT-T should be used
	bool useUdpPort; //< True if userdefined UDP port should be used
	bool useDnsServer; //< True if userdefined DNS server should be used
	bool useGetDnsFromPeer; //< True if DNS servers should be retrieved from peer (pptp)bool
	bool refuse40BitEncryption; //< True if 40 bit encryption is refused (pptp)
	bool refuse128BitEncryption; //< True if 128 bit encryption is refused (pptp)
	bool allowStatefulMode;
	bool useNoBsdComp;
	bool useNoDeflate;
	bool requireMppe; //< True if MPPE is required (pptp)
	bool refuseEap; //< True if EAP is refused (pptp)
	int Port;
	int UdpPort; //< Port number of UDP port

private:
	void setupPages();
	bool importProfile(VpnAccountData::ConnectionType ConnType);
	bool importP12Certificate();
	QHBox *page1;
	QHBox *newprofilewizardtypeselectionpage;
	QHBox *newprofilewizardgeneralpage;
	QHBox *newprofilewizardciscoselectionpage;
	QHBox *newprofilewizardciscomanuallypage;
	QHBox *newprofilewizardracoonpage;
	QHBox *newprofilewizardfreeswanpage;
	QHBox *newprofilewizardopenvpnpage;
	QHBox *newprofilewizardopenvpnselectionpage;
	QHBox *newprofilewizardopenvpnauthpage;
	QHBox *newprofilewizardpptppage;
	QHBox *newprofilewizardauthselectionpage;
	QHBox *newprofilewizardpskpage;
	QHBox *newprofilewizardcertpage;
	QHBox *newprofilewizardp12certselectionpage;
	QHBox *newprofilewizarduserpage;
	QHBox *newprofilewizardnetworkpage;
	QHBox *newprofilewizardnatpage;
	QHBox *newprofilewizardconnectionstatuscheckpage;
	QHBox *newprofilewizardconnectoptionspage;
	QHBox *endpage;
	NewProfileWizardTypeSelection *newprofilewizardtypeselectionpagecontent;
	NewProfileWizardGeneral *newprofilewizardgeneralpagecontent;
	NewProfileWizardCiscoSelection *newprofilewizardciscoselectionpagecontent;
	NewProfileWizardCiscoManually *newprofilewizardciscomanuallypagecontent;
	NewProfileWizardRacoon *newprofilewizardracoonpagecontent;
	NewProfileWizardFreeswan *newprofilewizardfreeswanpagecontent;
	NewProfileWizardOpenvpn *newprofilewizardopenvpnpagecontent;
	NewProfileWizardOpenvpnAuth *newprofilewizardopenvpnauthpagecontent;
	NewProfileWizardOpenvpnSelection *newprofilewizardopenvpnselectionpagecontent;
	NewProfileWizardPptp *newprofilewizardpptppagecontent;
	NewProfileWizardAuthSelection *newprofilewizardauthselectioncontent;
	NewProfileWizardPsk *newprofilewizardpskcontent;
	NewProfileWizardCert *newprofilewizardcertcontent;
	NewProfileWizardStart *newprofilewizardstartcontent;
	NewProfileWizardP12CertSelection *newprofilewizardp12certselectioncontent;
	NewProfileWizardUser *newprofilewizarduserpagecontent;
	NewProfileWizardNetwork *newprofilewizardnetworkcontent;
	NewProfileWizardNat *newprofilewizardnatcontent;
	NewProfileWizardConnectionStatusCheck *newprofilewizardconnectionstatuscheckcontent;
	NewProfileWizardConnectOptions *newprofilewizardconnectoptionscontent;
	KVpncConfig* GlobalConfig; //< pointer to global config class
	QWidget* currentpage; // pointer to current page
	QWidget* previouspage; //< pointer to previous page
	bool finished;
	bool enterdatamanually; //< enter data manually
	bool useCert; //< use certificate for authentication
	bool importOK; //< import was successful
	QPixmap *SetupPixmap;

};

#endif
