/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ADDNETWORKROUTEDIALOG_H
#define ADDNETWORKROUTEDIALOG_H

#include "addnetworkroutedialogbase.h"
#include <kdialogbase.h>
#include <qstring.h>

/**
@author Christoph Thielecke
*/
class AddNetworkRouteDialog : public KDialogBase
{
	Q_OBJECT
public:
	AddNetworkRouteDialog(QWidget *parent, const QString& caption);

	~AddNetworkRouteDialog();
	QString getNetwork();
	QString getNetmask();
	QString getGateway();
	QString getInterface();
	bool getUseGateway();
	bool getUseInterface();
	AddNetworkRouteDialogBase *main;

public slots:
	void accept();
	void useGatewayToggled(bool);
	void useInterfaceToggled(bool);

private:
	QString Network;
	QString Netmask;
	QString Gateway;
	QString Interface;
	bool useGateway;
	bool useInterface;
};

#endif
