/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/ 
//BEGIN INCLUDES

#include <klocale.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <klineedit.h>
#include <qlineedit.h>
#include <kmessagebox.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include <knuminput.h>
#include <kpassdlg.h>
#include <qspinbox.h>
#include <qcursor.h>
#include <qbuttongroup.h>
#include <iostream>

#include <kstddirs.h>
#include <kinputdialog.h>

#include "kvpncconfig.h"
#include "networkinterface.h"
#include "newprofilewizard.h"
#include "addnetworkroutedialog.h"
#include "utils.h" 
//END INCLUDES

NewProfileWizard::NewProfileWizard( KVpncConfig* GlobalConfig )
{
	this->GlobalConfig = GlobalConfig;

	newProfileCreated = false;
	setCaption( i18n( "Add new profile..." ) );
	//setMinimumSize( 400,300);

	SetupPixmap = new QPixmap( locate( "data", "kvpnc/newprofilewizard.png" ) );

	// currently static for new profile
	VpnAccountData::ConnectionType ConnType = VpnAccountData::ConnectionType( VpnAccountData::other );
	Port = 500;
	Gateway = "";
	ID = "";
	Username = "";
	UserPassword = "";
	PreSharedKey = "";
	ApplicationVersion = "";
	NtDomainName = "";
	PerfectForwardSecrecy = "";
	IkeGroup = "";
	Description = "";
	Name = "None";
	useApplicationVersion = false;
	useGlobalIpsecSecret = false;
	useIkeGroup = false;
	useLocalPort = false;
	useNtDomainName = false;
	useSingleDes = false;
	useAdvancedSettings = false;
	usePerfectSecrecy = false;
	saveUserPassword = false;
	savePsk = false;
	useUdp = false;
	useUdpPort = false;
	useDnsServer = false;
	DnsServer = "";
	useGetDnsFromPeer = true;
	refuse40BitEncryption = true;
	refuse128BitEncryption = false;
	allowStatefulMode = false;
	requireMppe = true;
	refuseEap = false;
	useNoBsdComp = true;
	useNoDeflate = true;
	savePsk = false;
	connectaftercreating = true;
	daemonavailable = false;
	enterdatamanually = false;
	importOK = false;

	currentpage = 0;
	previouspage = 0;

	profileData = new VpnAccountData( ConnType, Name );
	profileData->setGateway ( Gateway );
	profileData->setID( ID );
	profileData->setPreSharedKey( PreSharedKey );
	profileData->setSavePsk( savePsk );
	profileData->setUserName( Username );
	profileData->setUserPassword( UserPassword );
	profileData->setSaveUserPassword( saveUserPassword );
	profileData->setSavePsk( savePsk );
	profileData->setApplicationVersion( ApplicationVersion );
	profileData->setUseLocalPort( useLocalPort );
	profileData->setLocalPort( Port );
	profileData->setUseSingleDes ( useSingleDes );
	profileData->setPerfectForwardSecrety ( PerfectForwardSecrecy );
	profileData->setIkeGroup( IkeGroup );
	profileData->setUseGlobalIpsecSecret ( useGlobalIpsecSecret );
	profileData->setUseIkeGroup ( useIkeGroup );
	profileData->setNtDomainName ( NtDomainName );
	profileData->setUseAdvancedSettings ( useAdvancedSettings );
	profileData->setUsePerfectForwardSecrety ( usePerfectSecrecy );
	profileData->setUseTlsAuth ( false );

	setupPages();

	// 	// tmp
	// 	newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setEnabled(false);
	// 	newprofilewizardtypeselectionpagecontent->RacoonRadioButton->setEnabled(false);
}

void NewProfileWizard::accept()
{

	if ( !enterdatamanually )
	{
		if ( profileData->getConnectionType() == VpnAccountData::cisco )
		{
// 			importProfile( VpnAccountData::cisco );
// 			if ( importOK )
// 				newProfileCreated = true;
// 			else
// 				newProfileCreated = false;
		}
	}
	else
	{
		newProfileCreated = true;
	}
	finished = true;

	if ( newProfileCreated && profileData->getAuthType() == VpnAccountData::cert )
	{}

	QWizard::accept();
}

void NewProfileWizard::reject()
{
	finished = false;
	QWizard::reject();
}

void NewProfileWizard::setupPages()
{

	// setup start page
	page1 = new QHBox( 0 );
	// 	page1->setSpacing(8);
	QLabel *setupPixmapContent1 = new QLabel( page1 );
	setupPixmapContent1->setPixmap( *SetupPixmap );
	setupPixmapContent1->resize( setupPixmapContent1->sizeHint() );
	newprofilewizardstartcontent = new NewProfileWizardStart ( page1 );
	newprofilewizardstartcontent->resize( newprofilewizardstartcontent->sizeHint() );
	page1->sizeHint();
	addPage( page1, "<b>" + i18n( "Welcome" ) + "</b>" );

	// type selection
	newprofilewizardtypeselectionpage = new QHBox( 0 );
	// 	newprofilewizardtypeselectionpage->setSpacing(8);
	QLabel *setupPixmapContent2 = new QLabel( newprofilewizardtypeselectionpage );
	setupPixmapContent2->setPixmap( *SetupPixmap );
	setupPixmapContent2->resize( setupPixmapContent2->sizeHint() );
	newprofilewizardtypeselectionpagecontent = new NewProfileWizardTypeSelection( newprofilewizardtypeselectionpage );
	newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setText(i18n("IPSec (%1)").arg("FreeS/WAN/Openswan/strongSwan"));
	newprofilewizardtypeselectionpagecontent->L2tpFreeswanRadioButton->setText(i18n("L2TP over IPSec (%1)").arg("FreeS/WAN/Openswan/strongSwan"));
	newprofilewizardtypeselectionpage->sizeHint();
	addPage( newprofilewizardtypeselectionpage, "<b>" + i18n( "Type selection" ) + "</b>" );

	// cisco
	newprofilewizardciscoselectionpage = new QHBox( 0 );
	// 	newprofilewizardciscoselectionpage->setSpacing(8);
	QLabel *setupPixmapContent3 = new QLabel( newprofilewizardciscoselectionpage );
	setupPixmapContent3->setPixmap( *SetupPixmap );
	setupPixmapContent3->resize( setupPixmapContent3->sizeHint() );
	newprofilewizardciscoselectionpagecontent = new NewProfileWizardCiscoSelection( newprofilewizardciscoselectionpage );
	newprofilewizardciscoselectionpage->sizeHint();

	newprofilewizardciscomanuallypage = new QHBox( 0 );
	// 	newprofilewizardciscomanuallypage->setSpacing(8);
	QLabel *setupPixmapContent4 = new QLabel( newprofilewizardciscomanuallypage );
	setupPixmapContent4->setPixmap( *SetupPixmap );
	setupPixmapContent4->resize( setupPixmapContent4->sizeHint() );
	newprofilewizardciscomanuallypagecontent = new NewProfileWizardCiscoManually( newprofilewizardciscomanuallypage );
	newprofilewizardciscomanuallypage->sizeHint();

	// racoon
	newprofilewizardracoonpage = new QHBox( 0 );
	// 	newprofilewizardracoonpage->setSpacing(8);
	QLabel *setupPixmapContent5 = new QLabel( newprofilewizardracoonpage );
	setupPixmapContent5->setPixmap( *SetupPixmap );
	setupPixmapContent5->resize( setupPixmapContent5->sizeHint() );
	newprofilewizardracoonpagecontent = new NewProfileWizardRacoon( newprofilewizardracoonpage );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem( "main", 0 );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem( "aggressive", 1 );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem( "base", 2 );
	newprofilewizardracoonpagecontent->ExchangeModeComboBox->setCurrentItem( 0 ); // main

	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "SHA1" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->insertItem( "MD5" );
	newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentItem( 0 ); //SHA1

	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp768" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp1024" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "ec2n155" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "ec2n185" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp1536" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp2048" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp3072" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp4096" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp6144" );
	newprofilewizardracoonpagecontent->DHGroupComboBox->insertItem( "modp8192" );

	QStringList KernelCrypto = Utils( GlobalConfig ).getKernelCrypto();

	//FIXME why this is not in kernel crypto list???
	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem( "3des" );

	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des_iv64" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("des_iv32" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("rc5" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("rc4" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("idea" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("3idea" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("cast128" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("blowfish" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("null_enc" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("twofish" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("rijndael" );
	// 	newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem("aes" );

	for ( QStringList::Iterator it = KernelCrypto.begin(); it != KernelCrypto.end(); ++it )
	{
		newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->insertItem( *it );
	}


	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "des" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "3des" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "des_iv64" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "des_iv32" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "hmac_md5" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha1" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha256" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha384" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha512" );
	newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->insertItem( "non_auth" );

	newprofilewizardracoonpage->sizeHint();

	//freeswan
	newprofilewizardfreeswanpage = new QHBox( 0 );
	// 	newprofilewizardfreeswanpage->setSpacing(8);
	QLabel *setupPixmapContent6 = new QLabel( newprofilewizardfreeswanpage );
	setupPixmapContent6->setPixmap( *SetupPixmap );
	setupPixmapContent6->resize( setupPixmapContent6->sizeHint() );
	newprofilewizardfreeswanpagecontent = new NewProfileWizardFreeswan( newprofilewizardfreeswanpage );
	newprofilewizardfreeswanpage->sizeHint();

	// openvpn
	newprofilewizardopenvpnselectionpage = new QHBox( 0 );
	// 	newprofilewizardopenvpnselectionpage->setSpacing(8);
	QLabel *setupPixmapContent7 = new QLabel( newprofilewizardopenvpnselectionpage );
	setupPixmapContent7->setPixmap( *SetupPixmap );
	setupPixmapContent7->resize( setupPixmapContent7->sizeHint() );
	newprofilewizardopenvpnselectionpagecontent = new NewProfileWizardOpenvpnSelection( newprofilewizardopenvpnselectionpage );
	newprofilewizardopenvpnselectionpage->sizeHint();

	newprofilewizardopenvpnauthpage = new QHBox( 0 );
	// 	newprofilewizardopenvpnauthpage->setSpacing(8);
	QLabel *setupPixmapContent71 = new QLabel( newprofilewizardopenvpnauthpage );
	setupPixmapContent71->setPixmap( *SetupPixmap );
	setupPixmapContent71->resize( setupPixmapContent71->sizeHint() );
	newprofilewizardopenvpnauthpagecontent = new NewProfileWizardOpenvpnAuth( newprofilewizardopenvpnauthpage );
	newprofilewizardopenvpnauthpage->sizeHint();
	connect ( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( authenticateWithUsernameAndPasswordToggled( bool ) ) );

	newprofilewizardopenvpnpage = new QHBox( 0 );
	// 	newprofilewizardopenvpnpage->setSpacing(8);
	QLabel *setupPixmapContent8 = new QLabel( newprofilewizardopenvpnpage );
	setupPixmapContent8->setPixmap( *SetupPixmap );
	setupPixmapContent8->resize( setupPixmapContent8->sizeHint() );
	newprofilewizardopenvpnpagecontent = new NewProfileWizardOpenvpn( newprofilewizardopenvpnpage );
	newprofilewizardopenvpnpage->sizeHint();
	newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->insertItem( "tun" );
	newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->insertItem( "tap" );
	newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->insertItem( "client" );
	newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->insertItem( "server" );
	newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled ( false );
	newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled ( false );

	newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->setChecked( false );
	newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox->setChecked( false );
	newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->setChecked( false );
	newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setChecked( false );
	newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->setChecked( false );
	newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->setChecked( false );

	connect( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox , SIGNAL( toggled ( bool ) ), this, SLOT( userdefinedOpenvpnPortToggeled( bool ) ) );
	connect( newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox , SIGNAL( toggled ( bool ) ), this, SLOT( nsCertTypeOpenvpnToggled( bool ) ) );
	connect( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( userdefinedOpenvpnPortToggeled( bool ) ) );
	connect( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( useTlsAuthToggled( bool ) ) );
	connect( newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( useTlsRemoteHostToggled( bool ) ) );
	connect( newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( useUserdefiniedCipherToggled( bool ) ) );
	connect( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( useHttpProxyToggeled( bool ) ) );

	QStringList ciphers = Utils( GlobalConfig ).getOpenvpnCiphers();
	QStringList digests = Utils( GlobalConfig ).getOpenvpnDigests();

	for ( QStringList::Iterator it = ciphers.begin(); it != ciphers.end(); ++it )
	{
		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->insertItem( *it );
	}

	for ( QStringList::Iterator it = digests.begin(); it != digests.end(); ++it )
	{
		newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->insertItem( *it );
	}

	// pptp
	newprofilewizardpptppage = new QHBox( 0 );
	// 	newprofilewizardpptppage->setSpacing(8);
	QLabel *setupPixmapContent9 = new QLabel( newprofilewizardpptppage );
	setupPixmapContent9->setPixmap( *SetupPixmap );
	setupPixmapContent9->resize( setupPixmapContent9->sizeHint() );
	newprofilewizardpptppagecontent = new NewProfileWizardPptp( newprofilewizardpptppage );
	newprofilewizardpptppage->sizeHint();
	newprofilewizardpptppagecontent->DnsServerLineedit->setEnabled( false );
	newprofilewizardpptppagecontent->Refuse40BitEncryptionCheckbox->setChecked ( profileData->getRefuse40BitEncryption() );
	newprofilewizardpptppagecontent->Refuse40BitEncryptionCheckbox->setChecked( profileData->getRefuse128BitEncryption() );
	newprofilewizardpptppagecontent->RequireMppeCheckbox->setChecked( profileData->getRequireMppe() );
	newprofilewizardpptppagecontent->AllowStatefulModeCheckbox->setChecked( profileData->getAllowStatefulMode() );
	newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->setChecked( profileData->getDisableMPPEComp() );
	newprofilewizardpptppagecontent->UseNoDeflateCheckbox->setChecked( profileData->getUseNoDeflate() );

	newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem( "chap" );
	newprofilewizardpptppagecontent->AuthMethodComboBox->insertItem( "pap" );

	newprofilewizardauthselectionpage = new QHBox( 0 );
	// 	newprofilewizardauthselectionpage->setSpacing(8);
	QLabel *setupPixmapContent81 = new QLabel( newprofilewizardauthselectionpage );
	setupPixmapContent81->setPixmap( *SetupPixmap );
	setupPixmapContent81->resize( setupPixmapContent81->sizeHint() );
	newprofilewizardauthselectioncontent = new NewProfileWizardAuthSelection( newprofilewizardauthselectionpage );
	newprofilewizardauthselectionpage->sizeHint();
	newprofilewizardauthselectioncontent->CertificateRadioButton->setChecked( true );

	// psk
	newprofilewizardpskpage = new QHBox( 0 );
	// 	newprofilewizardpskpage->setSpacing(8);
	QLabel *setupPixmapContent72 = new QLabel( newprofilewizardpskpage );
	setupPixmapContent72->setPixmap( *SetupPixmap );
	setupPixmapContent72->resize( setupPixmapContent72->sizeHint() );
	newprofilewizardpskcontent = new NewProfileWizardPsk( newprofilewizardpskpage );
	newprofilewizardpskpage->sizeHint();

	connect ( newprofilewizardpskcontent->PskInFileCheckBox , SIGNAL( toggled ( bool ) ), this, SLOT( pskIsInFileToggled( bool ) ) );
	connect ( newprofilewizardpskcontent->PSKLineEdit , SIGNAL( textChanged ( const QString & ) ), this, SLOT( pskInputToggled( const QString& ) ) );

	newprofilewizardp12certselectionpage = new QHBox( 0 );
	// 	newprofilewizardp12certselectionpage->setSpacing(8);
	QLabel *setupPixmapContent74 = new QLabel( newprofilewizardp12certselectionpage );
	setupPixmapContent74->setPixmap( *SetupPixmap );
	setupPixmapContent74->resize( setupPixmapContent74->sizeHint() );
	newprofilewizardp12certselectioncontent = new NewProfileWizardP12CertSelection( newprofilewizardp12certselectionpage );
	newprofilewizardp12certselectionpage->sizeHint();
	connect ( newprofilewizardp12certselectioncontent->UseSmartcardCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( useSmartcardOnCertFormateToggled( bool ) ) );

	// cert
	newprofilewizardcertpage = new QHBox( 0 );
	// 	newprofilewizardcertpage->setSpacing(8);
	QLabel *setupPixmapContent73 = new QLabel( newprofilewizardcertpage );
	setupPixmapContent73->setPixmap( *SetupPixmap );
	setupPixmapContent73->resize( setupPixmapContent73->sizeHint() );
	newprofilewizardcertcontent = new NewProfileWizardCert( newprofilewizardcertpage );
	newprofilewizardcertpage->sizeHint();
	connect ( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox , SIGNAL( toggled( bool ) ), this, SLOT( useSpecialServerCertificateToggled( bool ) ) );
	connect ( newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox , SIGNAL( toggled( bool ) ), this, SLOT( useSpecialRemoteIDToggled( bool ) ) );
	connect ( newprofilewizardcertcontent->UseSmartcardCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( useSmartcardToggled( bool ) ) );
	connect ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( usePkcs11ProvidersToggled( bool ) ) );
	connect ( newprofilewizardcertcontent->DetectPkcs11SlotsPushButton, SIGNAL( clicked() ), this, SLOT( detectPkcs11Slots() ) );
	connect ( newprofilewizardcertcontent->DetectPkcs11IdPushButton, SIGNAL( clicked() ), this, SLOT( detectPkcs11Ids() ) );
	newprofilewizardcertcontent->Pkcs11SlotTypeComboBox->setEnabled(false);
	newprofilewizardcertcontent->Pkcs11SlotTypeLabel->setEnabled(false);
	newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setURL(QString("/usr/local/lib/libetpkcs11.so"));


	// user
	newprofilewizarduserpage = new QHBox( 0 );
	// 	newprofilewizarduserpage->setSpacing(8);
	QLabel *setupPixmapContent75 = new QLabel( newprofilewizarduserpage );
	setupPixmapContent75->setPixmap( *SetupPixmap );
	setupPixmapContent75->resize( setupPixmapContent75->sizeHint() );
	newprofilewizarduserpagecontent = new NewProfileWizardUser( newprofilewizarduserpage );
	newprofilewizarduserpage->sizeHint();

	connect ( newprofilewizarduserpagecontent->PasswordEdit , SIGNAL( textChanged( const QString& ) ), this, SLOT( userpassToggled( const QString& ) ) );
	connect ( newprofilewizarduserpagecontent->UsernameLineEdit , SIGNAL( textChanged( const QString& ) ), this, SLOT( usernameToggled( const QString& ) ) );
	connect( newprofilewizarduserpagecontent->NtDomainNameCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( domainNameToggled( bool ) ) );
	newprofilewizarduserpagecontent ->NtDomainNameCheckbox->setEnabled( true );
	newprofilewizarduserpagecontent ->NtDomainNameCheckbox->hide();
	newprofilewizarduserpagecontent ->NtDomainNameLineedit->hide();


	// network
	newprofilewizardnetworkpage = new QHBox( 0 );
	// 	newprofilewizardnetworkpage->setSpacing(8);
	QLabel *setupPixmapContent76 = new QLabel( newprofilewizardnetworkpage );
	setupPixmapContent76->setPixmap( *SetupPixmap );
	setupPixmapContent76->resize( setupPixmapContent76->sizeHint() );
	newprofilewizardnetworkcontent = new NewProfileWizardNetwork( newprofilewizardnetworkpage );
	newprofilewizardnetworkpage->sizeHint();
	newprofilewizardnetworkcontent->NetworkDeviceComboBox->insertItem( "default" );

	NetworkInterface iface( GlobalConfig, GlobalConfig->appPointer );
	QStringList list = iface.getAllNetworkInterfaces();
	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
		newprofilewizardnetworkcontent->NetworkDeviceComboBox->insertItem( QString( *it ) );


	newprofilewizardnetworkroutepage = new QHBox( 0 );
	// 	newprofilewizardnetworkroutepage->setSpacing(8);
	QLabel *setupPixmapContent761 = new QLabel( newprofilewizardnetworkroutepage );
	setupPixmapContent761->setPixmap( *SetupPixmap );
	setupPixmapContent761->resize( setupPixmapContent761->sizeHint() );
	newprofilewizardnetworkroutecontent = new NewProfileWizardNetworkRoute( newprofilewizardnetworkroutepage );
	newprofilewizardnetworkroutepage->sizeHint();
	insertPage( newprofilewizardnetworkroutepage, "<b>" + i18n( "Network route options" ) + "</b>", -1 );
	connect( newprofilewizardnetworkroutecontent->AddRoutePushButton, SIGNAL( clicked() ), this, SLOT( addNetworkRouteClicked() ) );
	connect( newprofilewizardnetworkroutecontent->DeleteNetworkRoutePushButton, SIGNAL( clicked() ), this, SLOT( delNetworkRouteClicked() ) );
	connect( newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( additionalNetworkRoutesToggled( bool ) ) );

	// nat
	newprofilewizardnatpage = new QHBox( 0 );
	// 	newprofilewizardnatpage->setSpacing(8);
	QLabel *setupPixmapContent77 = new QLabel( newprofilewizardnatpage );
	setupPixmapContent77->setPixmap( *SetupPixmap );
	setupPixmapContent77->resize( setupPixmapContent77->sizeHint() );
	newprofilewizardnatcontent = new NewProfileWizardNat( newprofilewizardnatpage );
	newprofilewizardnatpage->sizeHint();
	newprofilewizardnatcontent->UseUdpCheckbox->setChecked( true );
	connect( newprofilewizardnatcontent->UseUdpCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( useUdpToggled( bool ) ) );
	connect( newprofilewizardnatcontent->UdpPortCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( udpPortToggled( bool ) ) );


	// connectionstatuscheck
	newprofilewizardconnectionstatuscheckpage = new QHBox( 0 );
	// 	newprofilewizardconnectionstatuscheckpage->setSpacing(8);
	QLabel *setupPixmapContent79 = new QLabel( newprofilewizardconnectionstatuscheckpage );
	setupPixmapContent79->setPixmap( *SetupPixmap );
	setupPixmapContent79->resize( setupPixmapContent79->sizeHint() );
	newprofilewizardconnectionstatuscheckcontent = new NewProfileWizardConnectionStatusCheck( newprofilewizardconnectionstatuscheckpage );
	newprofilewizardconnectionstatuscheckpage->sizeHint();
	insertPage( newprofilewizardconnectionstatuscheckpage, "<b>" + i18n( "Connection status check" ) + "</b>", -1 );
	connect( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( pingIpAfterConnectToggled( bool ) ) );
	connect( newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( connectionStatusCheckToggled( bool ) ) );

	// connectoptions
	newprofilewizardconnectoptionspage = new QHBox( 0 );
	// 	newprofilewizardconnectoptionspage->setSpacing(8);
	QLabel *setupPixmapContent80 = new QLabel( newprofilewizardconnectoptionspage );
	setupPixmapContent80->setPixmap( *SetupPixmap );
	setupPixmapContent80->resize( setupPixmapContent80->sizeHint() );
	newprofilewizardconnectoptionscontent = new NewProfileWizardConnectOptions( newprofilewizardconnectoptionspage );
	newprofilewizardconnectoptionspage->sizeHint();
	newprofilewizardconnectoptionscontent->DoAutoConnectCheckBox->hide(); //TODO later
	newprofilewizardconnectoptionscontent->AutoConnectProfileComboBox->hide(); //TODO_ later
	insertPage( newprofilewizardconnectoptionspage, "<b>" + i18n( "Connect options" ) + "</b>", -1 );

	// general
	newprofilewizardgeneralpage = new QHBox( 0 );
	// 	newprofilewizardgeneralpage->setSpacing(8);
	QLabel *setupPixmapContent78 = new QLabel( newprofilewizardgeneralpage );
	setupPixmapContent78->setPixmap( *SetupPixmap );
	setupPixmapContent78->resize( setupPixmapContent78->sizeHint() );
	newprofilewizardgeneralpagecontent = new NewProfileWizardGeneral( newprofilewizardgeneralpage );
	newprofilewizardgeneralpage->sizeHint();
	insertPage( newprofilewizardgeneralpage, "<b>" + i18n( "General settings" ) + "</b>", -1 );

	// setup end page
	endpage = new QHBox( 0 );
	// 	endpage->setSpacing(8);
	QLabel *setupPixmapContent11 = new QLabel( endpage );
	setupPixmapContent11->setPixmap( *SetupPixmap );
	setupPixmapContent11->resize( setupPixmapContent11->sizeHint() );
	QLabel *endpagecontent = new QLabel( endpage );
	endpagecontent->setMargin( 11 );
	endpagecontent->setText( i18n( "Now you have completed all steps for creating a new profile.\nClick \"Finish\" to continue." ) );
	endpagecontent->setMaximumSize ( endpagecontent->sizeHint() );
	endpage->sizeHint();
	insertPage( endpage, "<b>" + i18n( "Finish" ) + "</b>", -1 ); // last page
}

void NewProfileWizard::next ()
{
	// called at each finish of a page
	bool ok = true;
	QString msg = i18n( "Please fill in all fields!" );

	if ( currentpage == page1 )
	{
		// nothing here
	}
	else if ( currentpage == newprofilewizardgeneralpage )
	{
		msg = i18n( "These fields must be filled in:\n" );
		if ( newprofilewizardgeneralpagecontent->NameLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n( "Name" ) + "\n";
			GlobalConfig->appendLogEntry( i18n( "Name is empty!" ), GlobalConfig->error );
		}
		else
		{
			QString Name = newprofilewizardgeneralpagecontent->NameLineEdit->text();


			bool nameOk = true;
			if ( Name.contains( ' ' ) )
			{
				KMessageBox::error ( this, i18n( "Profile name can not contain spaces!" ), i18n( "Spaces Not Allowed" ) );
				GlobalConfig->appendLogEntry( i18n( "Profile name can not contain spaces!" ) , GlobalConfig->error );

				nameOk = FALSE;
			}

			if ( Name.isEmpty() )
			{
				KMessageBox::error ( this, i18n( "Profile name can not be empty!" ), i18n( "No Name Entered" ) );
				GlobalConfig->appendLogEntry( i18n( "Profile name can not be empty!" ) , GlobalConfig->error );

				nameOk = FALSE;
			}

			VpnAccountData * it;

			while ( nameOk == false )
			{
				for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
				{
					if ( it->getName() == Name )
					{
						//account->setName( QString( account->getName() + "_2" ) );
						// 				KMessageBox::information ( this, i18n( "Profile name exists!\n It will be renamed to \"%1\"." ).arg( account->getName() ), i18n( "Name exist, renamed" ) );
						KMessageBox::error ( this, i18n( "Profile name exists!" ), i18n( "Name Exists" ) );

						QString newName = KInputDialog::getText ( i18n( "New Name" ), i18n( "New name for profile:" ), QString( Name += "_2" ), &ok );

						if ( !Name.isEmpty() )
						{
							nameOk = true;
							break;
						}
					}
					nameOk = true;
				}
				nameOk = true;
			}

			if ( nameOk )
			{
				profileData->setName( Name );

				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry( i18n( "Profile name: %1" ).arg( profileData->getName() ), KVpncConfig::debug );

				newProfileCreated = TRUE;
			}
			else
			{
				return ;
			}
		}

		if ( newprofilewizardgeneralpagecontent->gatewayLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n( "Gateway" ) + "\n";
			GlobalConfig->appendLogEntry( i18n( "Gateway is empty!" ), GlobalConfig->error );
		}
		else
		{
			profileData->setGateway( newprofilewizardgeneralpagecontent->gatewayLineEdit->text() );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Gateway: %1" ).arg( newprofilewizardgeneralpagecontent->gatewayLineEdit->text() ), KVpncConfig::debug );
		}
		profileData->setDescription( newprofilewizardgeneralpagecontent->DescriptionLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Description: %1" ).arg( newprofilewizardgeneralpagecontent->DescriptionLineEdit->text() ), KVpncConfig::debug );
	}
	else if ( currentpage == newprofilewizardtypeselectionpage )
	{
		if ( newprofilewizardtypeselectionpagecontent->CiscoRadioButton->isChecked() )
		{
			profileData->setConnectionType( VpnAccountData::cisco );
			removePage( newprofilewizardcertpage );
			removePage( newprofilewizardpskpage );
			removePage( newprofilewizardp12certselectionpage );
			removePage( newprofilewizardfreeswanpage );
			removePage( newprofilewizardracoonpage );
			removePage( newprofilewizardopenvpnpage );
			removePage( newprofilewizardopenvpnselectionpage );
			removePage( newprofilewizardpptppage );
			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();

			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();

			insertPage( newprofilewizardciscoselectionpage, "<b>" + i18n( "Cisco selection" ) + "</b>", indexOf( currentpage ) + 1 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Selected type: %1" ).arg( "Cisco" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->isChecked() )
		{
			profileData->setConnectionType( VpnAccountData::freeswan );
			removePage( newprofilewizardciscoselectionpage );
			removePage( newprofilewizardciscomanuallypage );
			removePage( newprofilewizardopenvpnpage );
			removePage( newprofilewizardopenvpnselectionpage );
			removePage( newprofilewizardpptppage );

			insertPage( newprofilewizardracoonpage, "<b>" + i18n( "FreeSWAN/OpenSWAN settings" ) + "</b>", indexOf( currentpage ) + 1 );

			newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem( "main", 0 );
			newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem( "aggressive", 1 );
			newprofilewizardracoonpagecontent->ExchangeModeComboBox->setCurrentItem( 0 ); // main
			newprofilewizardracoonpagecontent->ExchangeModeComboBox->setEnabled( true );

			newprofilewizardracoonpagecontent->HashAlgoComboBox->hide();
			newprofilewizardracoonpagecontent->HashAlgoTextLabel->hide();
			newprofilewizardracoonpagecontent->UseModeConfigCheckBox->hide();
			newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->hide();
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->hide();
			newprofilewizardracoonpagecontent->DHGroupComboBox->hide();
			newprofilewizardracoonpagecontent->DisablePfsCheckBox->setEnabled( true );
			newprofilewizardracoonpagecontent->DisablePfsCheckBox->setChecked( true );

			newprofilewizardcertcontent->certpathURLRequester->setURL("/etc/ipsec.d/cacerts");
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled(false);
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setCurrentText(i18n("ID"));

			profileData->setIkeGroup( "modp2048" ); // default for windows?!
			profileData->setAuthenticationAlgorithm( "hmac_md5" ); // default for windows?!
			profileData->setHashAlgo( "sha1" ); // default for windows?!


			newprofilewizardracoonpagecontent->InfoLabel->setText( i18n( "Please enter %1 specific settings:" ).arg( "FreeS/WAN/Openswan/strongSwan" ) );

			insertPage( newprofilewizardauthselectionpage, i18n( "Authentication settings" ), indexOf( currentpage ) + 1 );
			insertPage( newprofilewizardnetworkpage, "<b>" + i18n( "Network settings" ) + "</b>", indexOf( currentpage ) + 2 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Selected type: %1" ).arg( "FreeS/WAN/Openswan/strongSwan" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->RacoonRadioButton->isChecked() )
		{
			profileData->setConnectionType( VpnAccountData::racoon );
			removePage( newprofilewizardciscoselectionpage );
			removePage( newprofilewizardciscomanuallypage );
			removePage( newprofilewizardopenvpnpage );
			removePage( newprofilewizardopenvpnselectionpage );
			removePage( newprofilewizardpptppage );

			newprofilewizardracoonpagecontent->FreeswanGroupBox->hide();
			newprofilewizardracoonpagecontent->DisablePfsCheckBox->setEnabled( false );

			profileData->setIkeGroup( "modp2048" ); // default for windows?!
			profileData->setHashAlgo( "sha1" ); // default for windows?!
			profileData->setAuthenticationAlgorithm( "hmac_md5" );

			profileData->setUseMailAddressAsIdentifier( false );

			newprofilewizardracoonpagecontent->DHGroupComboBox->setCurrentText( profileData->getIkeGroup() );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->setCurrentText( profileData->getAuthenticationAlgorithm() );
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->setCurrentText( profileData->getEncryptionAlgorithm() );

			newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->SmartcardGroupBox->hide();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();

			insertPage( newprofilewizardracoonpage, "<b>" + i18n( "Racoon settings" ) + "</b>", indexOf( currentpage ) + 1 );
			insertPage( newprofilewizardauthselectionpage, i18n( "Authentication settings" ), indexOf( currentpage ) + 2 );
			insertPage( newprofilewizardnetworkpage, "<b>" + i18n( "Network settings" ) + "</b>", indexOf( currentpage ) + 3 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Selected type: %1" ).arg( "Racoon" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->L2tpRacoonRadioButton->isChecked() )
		{
			profileData->setConnectionType( VpnAccountData::l2tpd_racoon );
			removePage( newprofilewizardciscoselectionpage );
			removePage( newprofilewizardciscomanuallypage );
			removePage( newprofilewizardopenvpnpage );
			removePage( newprofilewizardopenvpnselectionpage );
			removePage( newprofilewizardpptppage );
			removePage( newprofilewizardnetworkpage );

			profileData->setUseMailAddressAsIdentifier( false );

			profileData->setIkeGroup( "modp2048" ); // default for windows?!
			profileData->setHashAlgo( "sha1" ); // default for windows?!
			profileData->setAuthenticationAlgorithm( "hmac_md5" ); // default for windows?!

			newprofilewizardracoonpagecontent->DHGroupComboBox->setCurrentText( profileData->getIkeGroup() );
			newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->setCurrentText( profileData->getAuthenticationAlgorithm() );
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->setCurrentText( profileData->getEncryptionAlgorithm() );

			insertPage( newprofilewizardracoonpage, "<b>" + i18n( "Racoon settings" ) + "</b>", indexOf( currentpage ) + 1 );
			insertPage( newprofilewizardauthselectionpage, i18n( "Authentication settings" ), indexOf( currentpage ) + 2 );
			insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 3 );

			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();
			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
			newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->SmartcardGroupBox->hide();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->certpathURLRequester->setURL("/etc/racoon/");

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Selected type: %1" ).arg( "L2TP (racoon)" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->L2tpFreeswanRadioButton->isChecked() )
		{
			profileData->setConnectionType( VpnAccountData::l2tpd_freeswan );
			removePage( newprofilewizardciscoselectionpage );
			removePage( newprofilewizardciscomanuallypage );
			removePage( newprofilewizardopenvpnpage );
			removePage( newprofilewizardopenvpnselectionpage );
			removePage( newprofilewizardpptppage );
			removePage( newprofilewizardnetworkpage );

			profileData->setUseMailAddressAsIdentifier( false );

			profileData->setIkeGroup( "modp2048" ); // default for windows?!
			profileData->setHashAlgo( "sha1" ); // default for windows?!
			profileData->setAuthenticationAlgorithm( "hmac_md5" ); // default for windows?!
			profileData->setPkcs11IdType("id"); // Why it must be id???

			insertPage( newprofilewizardracoonpage, "<b>" + i18n( "%1 settings" ).arg("FreeSWAN/Openswan/strongSwan") + "</b>", indexOf( currentpage ) + 1 );
			insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 1 );

			newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem( "main", 0 );
			newprofilewizardracoonpagecontent->ExchangeModeComboBox->insertItem( "aggressive", 1 );
			newprofilewizardracoonpagecontent->ExchangeModeComboBox->setCurrentItem( 0 ); // main
			newprofilewizardracoonpagecontent->ExchangeModeComboBox->setEnabled( true );

			newprofilewizardracoonpagecontent->HashAlgoComboBox->hide();
			newprofilewizardracoonpagecontent->HashAlgoTextLabel->hide();
			newprofilewizardracoonpagecontent->UseModeConfigCheckBox->hide();
			newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->hide();
			newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->hide();
			newprofilewizardracoonpagecontent->DHGroupComboBox->hide();
			newprofilewizardracoonpagecontent->DisablePfsCheckBox->setEnabled( true );
			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setEnabled(false);
			newprofilewizardcertcontent->Pkcs11IdTypeComboBox->setCurrentText(i18n("ID"));
			newprofilewizardauthselectioncontent->CertificateRadioButton->setText (i18n("&Certificate/Smartcard"));
			newprofilewizardcertcontent->certpathURLRequester->setURL("/etc/ipsec.d/cacerts");

			profileData->setIkeGroup( "modp2048" ); // default for windows?!
			profileData->setAuthenticationAlgorithm( "hmac_md5" ); // default for windows?!
			profileData->setHashAlgo( "sha1" ); // default for windows?!


			newprofilewizardracoonpagecontent->InfoLabel->setText( i18n( "Please enter %1 specific settings:" ).arg( "FreeS/WAN/Openswan/strongSwan" ) );

			insertPage( newprofilewizardauthselectionpage, i18n( "Authentication settings" ), indexOf( currentpage ) + 1 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Selected type: %1" ).arg( "L2TP (OpenS/WAN)" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->OpenvpnRadioButton->isChecked() )
		{
			profileData->setConnectionType( VpnAccountData::openvpn );
			profileData->setLocalPort( 1194 );
			profileData->setRemotePort( 1194 );
			profileData->setUserdefinedPort( 1194 );
			profileData->setUseSmartcard( false );
			profileData->setCertPath( "/etc/openvpn" );
			profileData->setHashAlgo("SHA1");
			profileData->setAuthenticationAlgorithm("MD5");
			removePage( newprofilewizardciscoselectionpage );
			removePage( newprofilewizardciscomanuallypage );
			removePage( newprofilewizardracoonpage );
			removePage( newprofilewizardpptppage );
			newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
			newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
			newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
			newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();

			newprofilewizardcertcontent->UseSmartcardCheckBox->show();
			newprofilewizardcertcontent->SmartcardGroupBox->show();
			newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->show();
			newprofilewizardauthselectioncontent->CertificateRadioButton->setText (i18n("&Certificate/Smartcard"));
			newprofilewizardcertcontent->certpathURLRequester->setURL("/etc/openvpn");

			insertPage( newprofilewizardopenvpnauthpage, "<b>" + i18n( "OpenVPN authentication settings" ) + "</b>", indexOf( currentpage ) + 1 );

			connect( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( authenticateWithUsernameAndPasswordToggled( bool ) ) );
			newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->setCurrentText( "SHA1" );
			insertPage ( newprofilewizardopenvpnselectionpage, "<b>" + i18n( "OpenVPN selection" ) + "</b>", indexOf( currentpage ) + 1 );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Selected type: %1" ).arg( "OpenVPN" ), KVpncConfig::debug );
		}
		else if ( newprofilewizardtypeselectionpagecontent->PptpRadioButton->isChecked() )
		{
			profileData->setConnectionType( VpnAccountData::pptp );
			profileData->setUseMtu( true );
			profileData->setUseMru( true );
			profileData->setMtu( 1000 );
			profileData->setMru( 1000 );
			removePage( newprofilewizardciscoselectionpage );
			removePage( newprofilewizardciscomanuallypage );
			removePage( newprofilewizardcertpage );
			removePage( newprofilewizardpskpage );
			removePage( newprofilewizardp12certselectionpage );
			removePage( newprofilewizardfreeswanpage );
			removePage( newprofilewizardracoonpage );
			removePage( newprofilewizardopenvpnpage );
			removePage( newprofilewizardopenvpnselectionpage );
			insertPage( newprofilewizardpptppage, "<b>" + i18n( "PPTP settings" ) + "</b>", indexOf( currentpage ) + 1 );
			insertPage( newprofilewizardnetworkpage, "<b>" + i18n( "Network settings" ) + "</b>", indexOf( currentpage ) + 2 );

			newprofilewizarduserpagecontent ->NtDomainNameCheckbox->show();
			newprofilewizarduserpagecontent ->NtDomainNameLineedit->show();
			newprofilewizardcertcontent->UseSmartcardCheckBox->hide();
			newprofilewizardcertcontent->SmartcardGroupBox->hide();

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Selected type: %1" ).arg( "PPTP" ), KVpncConfig::debug );
		}

		QString type = ""; // visible name
		QString bin = "";  // executable name
		if ( profileData->getConnectionType() == VpnAccountData::cisco )
		{
			type = "vpnc";
			bin = "vpnc";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::freeswan )
		{
			type = "freeswan";
			bin = "ipsec";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::racoon )
		{
			type = "racoon";
			bin = "racoon";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
		{
			type = "L2TP (racoon)";
			bin = "racoon";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
		{
			type = "L2TP (OpenSWAN)";
			bin = "ipsec";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::pptp )
		{
			type = "pptp";
			bin = "pppd pptp";
		}
		else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
		{
			type = "openvpn";
			bin = "openvpn";
		}
		else
		{
			type = "other";
			bin = "";
		}

		ToolInfo *it = 0;
		//std::cout << "Tool (bin): " << bin << std::endl;

		if ( !GlobalConfig->ToolList->isEmpty() )
		{
			if ( type != "pptp" )
			{
				it = Utils( GlobalConfig ).getToolInfo( GlobalConfig, bin );
				if ( it != 0 )
				{
					if ( it->PathToExec.section( '/', -1 ) == bin )
					{
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry( i18n( "The required daemon (%1) is available, you will be able to use this connection." ).arg( bin ), KVpncConfig::info );
						daemonavailable = true;
					}
					else
					{
						KMessageBox::information ( this, i18n( "The required daemon (%1) isn't available, you will not be able to use this connection until the daemon is not installed." ).arg( bin ) );
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry( i18n( "The required daemon (%1) isn't available, you will not be able to use this connection until the daemon is not installed." ).arg( bin ), KVpncConfig::error );
						daemonavailable = false;
						removePage( newprofilewizardconnectoptionspage );
					}
				}
				if ( type == "ipsec" )
				{

					QString realversion = it->Version.section( ' ', 1, 1 ).section( '/', 0, 0 ).right( it->Version.section( ' ', 1, 1 ).section( '/', 0, 0 ).length() - 1 );
					QString realtype = it->Version.section( ' ', 0, 0 ).lower();

					if ( realversion.find( "1.", 0, -1 ) > -1 )
					{
						KMessageBox::information ( this, i18n( "The required version (%1) of FreeSWAN/OpenSWAN was not found. You will not be able to use the Agressive Mode. It will be used the Main Mode." ).arg( "2" ) );
						if ( GlobalConfig->KvpncDebugLevel > 0 )
							GlobalConfig->appendLogEntry( i18n( "The required version (%1) of FreeSWAN/OpenSWAN was not found. You will not be able to use the Agressive Mode. It will be used the Main Mode." ).arg( "2" ).arg( bin ), KVpncConfig::error );
					}
				}
			}
			else
			{
				bool pppd_and_pptp_available = false;
				it = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "pppd" );
				if ( it->PathToExec.section( '/', -1 ) == "pppd" )
				{
					it = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "pptp" );
					if ( it->PathToExec.section( '/', -1 ) == "pptp" )
						pppd_and_pptp_available = true;
				}
				if ( pppd_and_pptp_available )
				{
					// programs are installed
					daemonavailable = true;
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry( i18n( "The required daemons (%1 and %2) are available." ).arg( "pppd" ).arg( "pptp" ), KVpncConfig::info );
				}
				else
				{
					KMessageBox::information ( this, i18n( "The required daemons (%1 and %2) aren't available, you will not be able to use this connection until the daemons are not installed." ).arg( "pppd" ).arg( "pptpd" ) );
					GlobalConfig->appendLogEntry( i18n( "The required daemons (%1 and %2) are not available, connect will be disabled." ).arg( "pppd" ).arg( "pptpd" ), KVpncConfig::error );
					daemonavailable = false;
					removePage( newprofilewizardconnectoptionspage );
				}
			}

		}

	}
	else if ( currentpage == newprofilewizardciscoselectionpage )
	{
		if ( newprofilewizardciscoselectionpagecontent->PcfImportRadioButton->isChecked() )
		{
			enterdatamanually = false;
			removePage( newprofilewizardciscomanuallypage );
			removePage ( newprofilewizardgeneralpage );
			insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 1 );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Cisco selection: import PCF file" ), KVpncConfig::debug );

			importProfile( VpnAccountData::cisco );
			if ( importOK )
				newProfileCreated = true;
			else
				newProfileCreated = false;

		}
		else
		{
			enterdatamanually = true;
			insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 1 );
			insertPage( newprofilewizardciscomanuallypage, "<b>" + i18n( "Cisco settings" ) + "</b>", indexOf( currentpage ) + 2 );
			insertPage( newprofilewizardnetworkpage, "<b>" + i18n( "Network settings" ) + "</b>", indexOf( currentpage ) + 3 );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Cisco selection: enter data manually" ), KVpncConfig::debug );
		}
	}
	else if ( currentpage == newprofilewizardciscomanuallypage )
	{
		msg = i18n( "These fields must be filled in:\n" );
		if ( newprofilewizardciscomanuallypagecontent->IDLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n( "Cisco IPSec ID" ) + "\n";
			GlobalConfig->appendLogEntry( i18n( "Cisco IPSec ID is empty!" ), GlobalConfig->error );
		}
		profileData->setGateway( newprofilewizardciscomanuallypagecontent->IDLineEdit->text() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Cisco IPSec ID: %1" ).arg( newprofilewizardciscomanuallypagecontent->IDLineEdit->text() ), KVpncConfig::debug );

		profileData->setAllowEmptyGroupPassword( newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			if ( newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() )
				GlobalConfig->appendLogEntry( i18n( "Allow empty group password: true" ), KVpncConfig::debug );
			else
				GlobalConfig->appendLogEntry( i18n( "Allow empty group password: false" ), KVpncConfig::debug );
		}

		if ( !newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() && newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n( "Group password" ) + "\n";
			GlobalConfig->appendLogEntry( i18n( "Group password  is empty but you dont have checked to allow that!" ), GlobalConfig->error );
		}
		else
			profileData->setPreSharedKey( newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->text() );

		profileData->setID( newprofilewizardciscomanuallypagecontent->IDLineEdit->text() );
		profileData->setAllowEmptyGroupPassword( newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->isChecked() );

		insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 1 );
		insertPage( newprofilewizardnatpage, "<b>" + i18n( "NAT settings" ) + "</b>", indexOf( currentpage ) + 2 );

	}
	else if ( currentpage == newprofilewizardfreeswanpage )
	{}
	else if ( currentpage == newprofilewizardracoonpage )
	{
		if ( newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() == "SHA1" )
		{
			profileData->setHashAlgo( "sha1" );
		}
		if ( newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() == "MD5" )
		{
			profileData->setHashAlgo( "md5" );
		}

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Hash algorithm (%1): %2" ).arg( "racoon" ).arg( profileData->getHashAlgo() ), KVpncConfig::debug );

		if ( newprofilewizardtypeselectionpagecontent->RacoonRadioButton->isChecked() )
		{
			profileData->setUseModeConfig( newprofilewizardracoonpagecontent->UseModeConfigCheckBox->isChecked() );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
			{
				if ( newprofilewizardracoonpagecontent->UseModeConfigCheckBox->isChecked() )
					GlobalConfig->appendLogEntry( i18n( "Use Mode Config: %1" ).arg( i18n( "yes" ) ), KVpncConfig::debug );
				else
					GlobalConfig->appendLogEntry( i18n( "Use Mode Config: %1" ).arg( i18n( "no" ) ), KVpncConfig::debug );
			}
		}

		profileData->setExchangeMode( newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Exchange mode (%1): %2" ).arg( "racoon" ).arg( newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText() ), KVpncConfig::debug );

		profileData->setIkeGroup( newprofilewizardracoonpagecontent->DHGroupComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "DH group (%1): %2" ).arg( "racoon" ).arg( newprofilewizardracoonpagecontent->DHGroupComboBox->currentText() ), KVpncConfig::debug );

		profileData->setExchangeMode( newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Authentication algorithm (%1): %2" ).arg( "racoon" ).arg( newprofilewizardracoonpagecontent->AuthenticationAlgorithmComboBox->currentText() ), KVpncConfig::debug );

		profileData->setExchangeMode( newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Encryption algorithm (%1): %2" ).arg( "racoon" ).arg( newprofilewizardracoonpagecontent->EncryptionAlgorithmComboBox->currentText() ), KVpncConfig::debug );

		if ( newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->isChecked() )
		{
			profileData->setLeftNextHop( newprofilewizardracoonpagecontent->LeftNextHopLineEdit->text() ); //TODO check valid IP
			profileData->setRightNextHop( newprofilewizardracoonpagecontent->RightNextHopLineEdit->text( ) ); //TODO check valid IP
			profileData->setDisableOpportunisticEncryption( newprofilewizardracoonpagecontent->DisableOpportunisticEncryptionCheckBox->isChecked( ) );
			if ( newprofilewizardracoonpagecontent->DisablePfsCheckBox->isChecked() )
				profileData->setPerfectForwardSecrety( "false" );
			else
				profileData->setPerfectForwardSecrety( "true" );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
			{
				if ( newprofilewizardracoonpagecontent->DisableOpportunisticEncryptionCheckBox->isChecked() )
					GlobalConfig->appendLogEntry( i18n( "Disable opportunistic encryption: %1" ).arg( i18n( "yes" ) ).arg( newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() ), KVpncConfig::debug );
				else
					GlobalConfig->appendLogEntry( i18n( "Disable opportunistic encryption: %1" ).arg( i18n( "no" ) ).arg( newprofilewizardracoonpagecontent->HashAlgoComboBox->currentText() ), KVpncConfig::debug );
				GlobalConfig->appendLogEntry( i18n( "Right next hop: %1" ).arg( newprofilewizardracoonpagecontent->RightNextHopLineEdit->text() ), KVpncConfig::debug );
				GlobalConfig->appendLogEntry( i18n( "Left next hop: %1" ).arg( newprofilewizardracoonpagecontent->LeftNextHopLineEdit->text() ), KVpncConfig::debug );
				GlobalConfig->appendLogEntry( i18n( "Disable PFS: %1" ).arg( profileData->getPerfectForwardSecrety() ), KVpncConfig::debug );
			}
		}

		profileData->setExchangeMode( newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText() );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Exchange Mode: %1" ).arg( newprofilewizardracoonpagecontent->ExchangeModeComboBox->currentText() ), KVpncConfig::debug );

		insertPage( newprofilewizardnatpage, "<b>" + i18n( "NAT settings" ) + "</b>", indexOf( currentpage ) + 1 );
	}
	else if ( currentpage == newprofilewizardopenvpnpage )
	{
		msg = i18n( "These fields must be filled in:\n" );
		profileData->setTunnelDeviceType( newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "Tunnel device type (%1): %2" ).arg( "OpenVPN" ).arg( newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText() ), KVpncConfig::debug );

		if ( newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->currentText() == "client" )
			profileData->setNsCertType( "client" );
		else
			profileData->setNsCertType( "server" );

		profileData->setTunnelDeviceType( newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->currentText() );

		insertPage( newprofilewizardauthselectionpage, "<b>" + i18n( "Authentication settings" ) + "</b>", indexOf( currentpage ) + 1 );
		insertPage( newprofilewizardnetworkpage, "<b>" + i18n( "Network settings" ) + "</b>", indexOf( currentpage ) + 2 );
		insertPage( newprofilewizardnatpage, "<b>" + i18n( "NAT settings" ) + "</b>", indexOf( currentpage ) + 3 );

		profileData->setUserdefiniedCipher( newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->currentText() );
		profileData->setUseUserdefiniedCipher( newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->isChecked() );

		profileData->setUserdefinedPort( newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->value() );
		profileData->setUseUserdefinedPort( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->isChecked() );

		if ( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked() )
		{
			if ( newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->url().isEmpty() )
			{
				ok = false;
				msg += i18n( "TLS auth file" ) + "\n";
			}
			else
			{
				profileData->setUseTlsAuth( true );
				profileData->setTlsAuthFile( newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->url() );
			}
		}

		if ( newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->isChecked() )
		{
			if ( newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text().isEmpty() )
			{
				ok = false;
				msg += i18n( "TLS remote host" ) + "\n";
			}
			else
			{
				profileData->setUseTlsRemoteHost( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked() );
				profileData->setTlsRemoteHost( newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text() );
			}
		}

		profileData->setDisableLzoCompression( newprofilewizardopenvpnpagecontent->DisableLzoCompressionCheckBox->isChecked() );

		if ( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() )
		{
			if ( newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text().isEmpty() )
			{
				ok = false;
				msg += i18n( "HTTP proxy host" ) + "\n";
			}
			else
			{
				profileData->setUseHttpProxy( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() );
				profileData->setHttpProxy( newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text( ) );
			}
		}

		if ( newprofilewizardopenvpnpagecontent->AllowIpAddressChangeOfPeerCheckBox->isChecked())
			profileData->setAllowIpAddressChangeOfPeer(true);
		else
			profileData->setAllowIpAddressChangeOfPeer(false);

		profileData->setHttpProxyPort( newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->value( ) );
		profileData->setHttpProxyTimeout( newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->value() );

	}
	else if ( currentpage == newprofilewizardauthselectionpage )
	{
		if ( newprofilewizardauthselectioncontent->PskRadioButton->isChecked() )
		{
			useCert = false;

			profileData->setAuthType( VpnAccountData::psk );
			insertPage( newprofilewizardpskpage, "<b>" + i18n( "PSK settings" ) + "</b>", indexOf( currentpage ) + 1 );

			// racoon or freeswan
			if ( profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
			        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
			{
				newprofilewizardpskcontent->PSKLineEdit->setEnabled( true );
			}

			else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			{
				newprofilewizardpskcontent->PSKLineEdit->setEnabled( true );
				newprofilewizardpskcontent->LabelPsk->setEnabled( true );
			}
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Auth selection: use PSK" ), KVpncConfig::debug );
		}
		else
		{
			useCert = true;
			profileData->setAuthType( VpnAccountData::cert );
			insertPage( newprofilewizardp12certselectionpage, "<b>" + i18n( "Certificate format" ) + "</b>", indexOf( currentpage ) + 1 );
			// racoon or freeswan
			if ( profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
			        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
			{
				newprofilewizardcertcontent->x509certURLRequester->setEnabled( true );
				newprofilewizardcertcontent->LabelCertificate->setEnabled( true );
				newprofilewizardcertcontent->certpathURLRequester->setEnabled( true );
				newprofilewizardcertcontent->LabelCertificatePath->setEnabled( true );
			}

			else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			{
				newprofilewizardcertcontent->CaCertpathURLRequester->setEnabled( true );
				newprofilewizardcertcontent->certpathURLRequester->setEnabled( true );
				newprofilewizardcertcontent->LabelCertificatePath->setEnabled( true );


				if ( profileData->getUseOnlyCaCertAndUserAuth() )
				{
					newprofilewizardcertcontent->x509certURLRequester->setEnabled( false );
					newprofilewizardcertcontent->privkeypathURLRequester->setEnabled( false );
					newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled( false );
					newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled( false );
					newprofilewizardcertcontent->LabelCertificate->setEnabled( false );
					newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled( false );

				}
				else
				{
					newprofilewizardcertcontent->x509certURLRequester->setEnabled( true );
					newprofilewizardcertcontent->privkeypathURLRequester->setEnabled( true );
					newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled( true );
					newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled( true );
					newprofilewizardcertcontent->LabelCertificate->setEnabled( true );
					newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled( true );
				}
			}
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Auth selection: use certificate" ), KVpncConfig::debug );
		}
	}
	else if ( currentpage == newprofilewizardp12certselectionpage )
	{
		insertPage( newprofilewizardcertpage, "<b>" + i18n( "Certificate settings" ) + "</b>", indexOf( currentpage ) + 1 );

		if ( newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->isChecked())
		{
			profileData->setUseSmartcard(true);
			newprofilewizardcertcontent->UseSmartcardCheckBox->setChecked(true);
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "P12 cert selection: use smartcard" ), KVpncConfig::debug );
		}
		else
		{
			if ( newprofilewizardp12certselectioncontent->P12CertYesRadioButton->isChecked() )
			{
				// yes we have p12 cert
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry( i18n( "P12 cert selection: cert type is PKCS12" ), KVpncConfig::debug );
	
				if ( importP12Certificate() )
				{
					// success :)
				}
				else
				{
					newProfileCreated = false;
				}
			}
			else
			{
	
				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry( i18n( "P12 cert selection: cert type is other" ), KVpncConfig::debug );
			}
		}
	}
	else if ( currentpage == newprofilewizardopenvpnselectionpage )
	{
		if ( newprofilewizardopenvpnselectionpagecontent->OpenvpnImportRadioButton->isChecked() )
		{
			enterdatamanually = false;
			removePage( newprofilewizardopenvpnpage );
			removePage( newprofilewizardopenvpnauthpage );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "OpenVPN selection: import profile file" ), KVpncConfig::debug );

			// 			removePage ( newprofilewizardgeneralpage );

			if ( importProfile( VpnAccountData::openvpn ) == true )
			{
				newProfileCreated = true;
				newprofilewizardgeneralpagecontent->NameLineEdit->setText( profileData->getName() );
				newprofilewizardgeneralpagecontent->gatewayLineEdit->setText( profileData->getGateway() );
				newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText( profileData->getDescription() );

				if (profileData->getAuthWithUsernameAndPassword() )
				{
					if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry( i18n( "OpenVPN auth: authenticate with username and password" ), KVpncConfig::debug );
					insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 1 );
				}
			}
			else
			{
				newProfileCreated = false;
				ok = false;
			}
		}
		else
		{
			enterdatamanually = true;
			insertPage( newprofilewizardopenvpnpage, "<b>" + i18n( "OpenVPN settings" ) + "</b>", indexOf( currentpage ) + 1 );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "OpenVPN selection: enter data manually" ), KVpncConfig::debug );
		}

	}
	else if ( currentpage == newprofilewizardopenvpnauthpage )
	{
		if ( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox->isChecked() )
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "OpenVPN auth: authenticate with username and password" ), KVpncConfig::debug );
			insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 1 );

			profileData->setAuthWithUsernameAndPassword( true );

			if ( newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->isChecked() )
			{
				profileData->setUseOnlyCaCertAndUserAuth( true );

				if ( GlobalConfig->KvpncDebugLevel > 0 )
					GlobalConfig->appendLogEntry( i18n( "OpenVPN auth: use only CA cert authenticate with username and password" ), KVpncConfig::debug );
			}
			else
			{
				profileData->setUseOnlyCaCertAndUserAuth( false );

			}
		}
		else
		{
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "OpenVPN auth: dont authenticate with username and password" ), KVpncConfig::debug );

			profileData->setAuthWithUsernameAndPassword( false );
			profileData->setUseOnlyCaCertAndUserAuth( false );
		}

		profileData->setAuthenticationAlgorithm( newprofilewizardopenvpnauthpagecontent->UserdefiniedDigestComboBox->currentText() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "OpenVPN auth: use authentication method: %1" ).arg( profileData->getAuthenticationAlgorithm() ), KVpncConfig::debug );


	}
	else if ( currentpage == newprofilewizardpptppage )
	{

		msg = i18n( "These fields must be filled in:\n" );

		profileData->setRefuseEap( newprofilewizardpptppagecontent->RefuseEapCheckbox->isChecked() );
		profileData->setRequireMppe( newprofilewizardpptppagecontent->RequireMppeCheckbox->isChecked() );
		profileData->setRefuse128BitEncryption( newprofilewizardpptppagecontent->Refuse128BitEncryptionCheckbox->isChecked() );
		profileData->setRefuse40BitEncryption( newprofilewizardpptppagecontent->Refuse40BitEncryptionCheckbox->isChecked() );
		profileData->setDisableMPPEComp( newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->isChecked() );
		profileData->setUseGetDnsFromPeer( newprofilewizardpptppagecontent->GetDnsFromPeerCheckbox->isChecked() );
		profileData->setUseDnsServer( newprofilewizardpptppagecontent->DnsServerCheckbox->isChecked() );
		profileData->setDnsServer( newprofilewizardpptppagecontent->DnsServerLineedit->text() );
		profileData->setUseNoBsdComp( newprofilewizardpptppagecontent->UseNoBsdCompCheckbox->isChecked() );
		profileData->setUseNoDeflate( newprofilewizardpptppagecontent->UseNoDeflateCheckbox->isChecked() );

		profileData->setAllowStatefulMode( newprofilewizardpptppagecontent->AllowStatefulModeCheckbox->isChecked() );
		profileData->setUseNoIpDefault( newprofilewizardpptppagecontent->UseNoIpDefaultCheckbox->isChecked() );
		profileData->setDisableMPPEComp( newprofilewizardpptppagecontent->UseNoMPPECompressionCheckbox->isChecked() );

		if (newprofilewizardpptppagecontent->AuthMethodComboBox->currentItem() == 0)
			profileData->setAuthMethod("chap");
		else
			profileData->setAuthMethod("pap");

		newprofilewizardnetworkcontent->LabelRemoteNetwork->hide();
		newprofilewizardnetworkcontent->RemoteNetMaskComboBox->hide();
		newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->hide();
		newprofilewizardnetworkcontent->RemoteNetDividetextLabel->hide();

		insertPage( newprofilewizarduserpage, "<b>" + i18n( "User settings" ) + "</b>", indexOf( currentpage ) + 1 );

	}
	else if ( currentpage == newprofilewizardpskpage )
	{
		msg = i18n( "These fields must be filled in:\n" );
		if ( newprofilewizardpskcontent->CheckSavePsk->isChecked() )
		{
			if ( !newprofilewizardpskcontent->PskInFileCheckBox->isChecked() )
			{
				profileData->setSavePsk( true );
				profileData->setPskIsInFile( false );
				if ( !newprofilewizardpskcontent->PSKLineEdit->text().isEmpty() )
				{
					profileData->setPreSharedKey( newprofilewizardpskcontent->PSKLineEdit->text() );
				}
				else
				{
					msg += "- " + i18n( "Pre shared key" ) + "\n";
					ok = false;
				}
			}
			else
			{
				profileData->setSavePsk( true );
				profileData->setPskIsInFile( true );
				if ( !newprofilewizardpskcontent->PSKFileURLRequester->url().isEmpty() )
				{
					profileData->setPreSharedKey( newprofilewizardpskcontent->PSKLineEdit->text() );
				}
				else
				{
					ok = false;
					msg += "- " + i18n( "Pre shared key file" ) + "\n";
				}
			}

		}
		else
		{
			profileData->setSavePsk( false );
		}

		if ( newprofilewizardpskcontent->PskInFileCheckBox->isChecked() )
		{
			profileData->setSavePsk( newprofilewizardpskcontent->CheckSavePsk->isChecked() );
			if ( !newprofilewizardpskcontent->PSKFileURLRequester->url().isEmpty() )
			{
				profileData->setPreSharedKeyFile( newprofilewizardpskcontent->PSKFileURLRequester->url() );
			}
			else
			{
				ok = false;
				msg += "- " + i18n( "Pre shared key file" ) + "\n";
			}
		}
		if ( newprofilewizardpskcontent->CheckSavePsk->isChecked() )
			profileData->setPreSharedKey( newprofilewizardpskcontent->PSKLineEdit->text( ) );
		else
			profileData->setPreSharedKey( "" );

		profileData->setPreSharedKey( newprofilewizardpskcontent->PSKLineEdit->text() );

	}
	else if ( currentpage == newprofilewizardcertpage )
	{
		profileData->setSpecialRemoteID( newprofilewizardcertcontent->RemoteIDLineEdit->text() );
		profileData->setUseSpecialRemoteID( newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->isChecked() );
		profileData->setX509Certificate( newprofilewizardcertcontent->x509certURLRequester->url() );
		profileData->setCaCertificate( newprofilewizardcertcontent->CaCertpathURLRequester->url() );
		profileData->setCertPath( newprofilewizardcertcontent->certpathURLRequester->url() );
		profileData->setPrivateKey ( newprofilewizardcertcontent->privkeypathURLRequester->url() );
		profileData->setPrivateKeyPass ( newprofilewizardcertcontent->PrivkeyPasswordEdit->text() );
		profileData->setX509Certificate( newprofilewizardcertcontent->x509certURLRequester->url() );
		profileData->setCertPath( newprofilewizardcertcontent->certpathURLRequester->url() );
		profileData->setUseSpecialServerCertificate( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked() );
		profileData->setSpecialServerCertificate( newprofilewizardcertcontent->SpecialServerCertificateURLRequester->url() );

		if ( !newprofilewizardcertcontent->PrivkeyPasswordEdit->text().isEmpty() )
			profileData->setSavePrivateKeyPassword( true );
		else
			profileData->setSavePrivateKeyPassword( false );

		msg = i18n( "These fields must be filled in:\n" );

		if ( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked() )
		{
			if ( newprofilewizardcertcontent->SpecialServerCertificateURLRequester->url().isEmpty() )
			{
				ok = false;
				msg += "- " + i18n( "Special server certificate" ) + "\n";
				// 				KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No Server Certificate" ) );
				GlobalConfig->appendLogEntry( i18n( "Special server certificate can't be empty!" ) , GlobalConfig->error );
			}
		}

		if ( !newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked() )
		{
			if ( !profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->x509certURLRequester->url().isEmpty() )
			{
				ok = false;
				msg += "- " + i18n( "Certificate" ) + "\n";
				GlobalConfig->appendLogEntry( i18n( "Certificate can't be empty!" ) , GlobalConfig->error );
			}
		}
		if ( newprofilewizardcertcontent->CaCertpathURLRequester->url().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n( "CA certificate" ) + "\n";
			GlobalConfig->appendLogEntry( i18n( "CA Certificate can't be empty!" ) , GlobalConfig->error );
		}
		if ( !newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked() )
		{
			if ( !profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->privkeypathURLRequester->url().isEmpty() )
			{
				ok = false;
				msg += "- " + i18n( "Path to private key" ) + "\n";
				GlobalConfig->appendLogEntry( i18n( "Path to private key can't be empty!" ) , GlobalConfig->error );
			}
			if ( !( profileData->getConnectionType() == VpnAccountData::racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ) && !profileData->getUseOnlyCaCertAndUserAuth() && newprofilewizardcertcontent->PrivkeyPasswordEdit->text().isEmpty() )
			{
				if ( Utils(GlobalConfig).getNeedsPassphrase( newprofilewizardcertcontent->privkeypathURLRequester->url()))
				{
					ok = false;
					msg += "- " + i18n( "Private key password, private key needs passphrase" ) + "\n";
					GlobalConfig->appendLogEntry( i18n( "Private key password can't be empty  because private key is protected with a passphrase." ) , GlobalConfig->error );
				}
			}
		}
		if ( newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->isChecked() )
		{
			if ( newprofilewizardcertcontent->RemoteIDLineEdit->text().isEmpty() )
			{
				ok = false;
				msg += "- " + i18n( "Special remote ID" ) + "\n";
				// 				KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No Server Certificate" ) );
				GlobalConfig->appendLogEntry( i18n( "Special remote ID can't be empty!" ) , GlobalConfig->error );
			}
		}


		if ( newprofilewizardcertcontent->UseSmartcardCheckBox->isEnabled() && newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked() )
		{
			if ( !newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().isEmpty() )
				profileData->setPkcs11Slot( newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText() );
			else
			{
				KMessageBox::error ( this, i18n( "Slot at smartcard can't be empty!" ), i18n( "No smartcard slot" ) );
				// 			GlobalConfig->appendLogEntry( i18n( "Slot at smartcard can't be empty!" ) ,GlobalConfig->error);
				ok = false;
			}
			if ( !newprofilewizardcertcontent->Pkcs11IdComboBox->currentText().isEmpty() )
				profileData->setPkcs11Id( newprofilewizardcertcontent->Pkcs11IdComboBox->currentText() );
			else
			{
				KMessageBox::error ( this, i18n( "ID for certificate at smartcard can't be empty!" ), i18n( "No certificate ID" ) );
				// 			GlobalConfig->appendLogEntry( i18n( "ID for certificate at smartcard can't be empty!" ) ,GlobalConfig->error);
				ok = false;
			}
			QString Pkcs11SlotType = newprofilewizardcertcontent->Pkcs11SlotTypeComboBox->currentText();
			if ( Pkcs11SlotType == i18n( "ID" ) )
				profileData->setPkcs11SlotType( "id" );
			else if ( Pkcs11SlotType == i18n( "Name" ) )
				profileData->setPkcs11SlotType( "name" );
			else
				profileData->setPkcs11SlotType( "label" );

			QString Pkcs11IdType = newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentText();
			if ( Pkcs11IdType == i18n( "ID" ) )
				profileData->setPkcs11IdType( "id" );
			else if ( Pkcs11IdType == i18n( "Label" ) )
				profileData->setPkcs11IdType( "label" );
			else
				profileData->setPkcs11IdType( "subject" );

			QString Pkcs11SignMode = newprofilewizardcertcontent->Pkcs11SignModeComboBox->currentText();
			if ( Pkcs11SignMode == i18n( "auto" ) )
				profileData->setPkcs11SignMode( "auto" );
			else if ( Pkcs11SignMode == i18n( "sign" ) )
				profileData->setPkcs11SignMode( "sign" );
			else if ( Pkcs11SignMode == i18n( "recover" ) )
				profileData->setPkcs11SignMode( "recover" );
			else
				profileData->setPkcs11SignMode( "any" );

			if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() )
			{
				if ( !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().isEmpty() )
					profileData->setPkcs11Providers( newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url() );
				else
				{
					KMessageBox::error ( this, i18n( "Library path to lib for use with smartcard can't be empty!" ), i18n( "No providers lib" ) );
					// 			GlobalConfig->appendLogEntry( i18n( "Library path to lib for use with smartcard can't be empty!" ) ,GlobalConfig->error);
					ok = false;
				}
			}
			profileData->setUsePkcs11Providers ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() );
		}

	}
	else if ( currentpage == newprofilewizarduserpage )
	{
		msg = i18n( "These fields must be filled in:\n" );
		if ( newprofilewizarduserpagecontent->UsernameLineEdit->text().isEmpty() )
		{
			ok = false;
			msg += "- " + i18n( "Username" ) + "\n";
			GlobalConfig->appendLogEntry( i18n( "Username  is empty!" ), GlobalConfig->error );
		}
		else
		{
			profileData->setUserName( newprofilewizarduserpagecontent->UsernameLineEdit->text() );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "User options: username: %1" ).arg( profileData->getUserName() ), KVpncConfig::debug );
		}

		if ( !newprofilewizarduserpagecontent->PasswordEdit->text().isEmpty() )
		{
			profileData->setUserPassword( newprofilewizarduserpagecontent->PasswordEdit->text() );

		}
		else
		{
			if ( newprofilewizarduserpagecontent->CheckUserPass->isChecked() )
			{
				ok = false;
				msg += "- " + i18n( "Password" ) + "\n";
				GlobalConfig->appendLogEntry( i18n( "Password  is empty but you have checked to store it!" ), GlobalConfig->error );
			}
		}
		profileData->setUserPassword( newprofilewizarduserpagecontent->PasswordEdit->text() );
		profileData->setSaveUserPassword( newprofilewizarduserpagecontent->CheckUserPass->isChecked() );

		profileData->setNtDomainName( newprofilewizarduserpagecontent->NtDomainNameLineedit->text() );


		if ( profileData->getConnectionType () == VpnAccountData::cisco || profileData->getConnectionType() == VpnAccountData::pptp ||
		        profileData->getConnectionType () == VpnAccountData::l2tpd_racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan
		   )
		{
			if ( newprofilewizarduserpagecontent->NtDomainNameCheckbox->isChecked() )
			{
				if ( newprofilewizarduserpagecontent->NtDomainNameLineedit->text().isEmpty() )
				{
					ok = false;
					msg += "- " + i18n( "NT domain name" ) + "\n";
					GlobalConfig->appendLogEntry( i18n( "NT domain name  is empty but you have checked to specifiy one!" ), GlobalConfig->error );
				}
				else
				{
					profileData->setNtDomainName( newprofilewizarduserpagecontent->NtDomainNameLineedit->text() );
					profileData->setUseNtDomainName( true );
					if ( GlobalConfig->KvpncDebugLevel > 0 )
						GlobalConfig->appendLogEntry( i18n( "User options: NT domain name: %1" ).arg( profileData->getNtDomainName() ), KVpncConfig::debug );
				}
			}
			else
			{
				profileData->setUseNtDomainName( false );
			}
		}
	}
	else if ( currentpage == newprofilewizardnetworkpage )
	{
		msg = i18n( "These fields must be filled in:\n" );
		bool validAddr = true;
		if ( ( profileData->getConnectionType() == VpnAccountData::freeswan || profileData->getConnectionType() == VpnAccountData::racoon ||
		        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ) )
		{
			if ( !newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text().isEmpty() )
			{
				if ( newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
				{
					KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
					validAddr = false;
					return ;
				}
				else
				{
					QString addr = newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->text();
					int part0 = addr.section( '.', 0, 0 ).toInt();
					int part1 = addr.section( '.', 1, 1 ).toInt();
					int part2 = addr.section( '.', 2, 2 ).toInt();
					int part3 = addr.section( '.', 3, 3 ).toInt();

					/*
								LogOutput->append ("part0: "+QString().setNum(part0));
								LogOutput->append ("part1: "+QString().setNum(part1));
								LogOutput->append ("part2: "+QString().setNum(part2));
								LogOutput->append ("part3: "+QString().setNum(part3));
					*/

					if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
					{
						KMessageBox::error ( this, i18n( "Invalid values in IP address (remote net)!" ), i18n( "Invalid Values in IP Address" ) );
						GlobalConfig->appendLogEntry( i18n( "Invalid values in IP address (remote net)!" ) , GlobalConfig->error );
						validAddr = false;
						return ;
					}

					if ( validAddr == true )
					{
						profileData->setRemoteNetAddr( addr );
						profileData->setRemoteNetMask ( newprofilewizardnetworkcontent->RemoteNetMaskComboBox->currentText() );
					}

				}
			}


			else
			{
				ok = false;
				msg += "- " + i18n( "Remote network" ) + "\n";
				GlobalConfig->appendLogEntry( i18n( "Remote network  is empty!" ), GlobalConfig->error );
			}
		}
		profileData->setNetworkDevice( newprofilewizardnetworkcontent->NetworkDeviceComboBox->currentText() );

	}
	else if ( currentpage == newprofilewizardnetworkroutepage )
	{
		msg = i18n( "These fields must be filled in:\n" );

		if ( newprofilewizardnetworkroutecontent->DefaultRouteComboBox->currentItem() == 1 )
		{
			profileData->setSetDefaultRoute( true );
			profileData->setReplaceDefaultRoute( true );
			profileData->setKeepDefaultRoute( false );

			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n( "Network route options: replace default route" ).arg( profileData->getName() ) , GlobalConfig->debug );
		}
		else
		{
			profileData->setSetDefaultRoute( false );
			profileData->setReplaceDefaultRoute( false );
			profileData->setKeepDefaultRoute( true );
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n( "Network route options: dont replace default route" ).arg( profileData->getName() ) , GlobalConfig->debug );
		}

		profileData->setUseAdditionalNetworkRoutes( newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked() );

		if ( newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked() && newprofilewizardnetworkroutecontent->NetworkListView->childCount() > 0 )
		{
			if ( GlobalConfig->KvpncDebugLevel > 1 )
				GlobalConfig->appendLogEntry ( i18n( "Network route options: use additional network routes" ).arg( profileData->getName() ) , GlobalConfig->debug );

			QStringList AdditionalNetworkRoutes;
			QListViewItemIterator it( newprofilewizardnetworkroutecontent->NetworkListView );
			for ( ; it.current(); ++it )
			{
				// example entry:
				// <network>/<netmask>#<gateway>
				QString network = QString( it.current() ->text( 0 ) + "/" + it.current() ->text( 1 ) );
				network.append( "#" );
				network.append( it.current() ->text( 2 ) ); // gateway
				network.append( "#" );
				network.append( it.current() ->text( 3 ) ); // interface
				AdditionalNetworkRoutes.append( network );

				if ( GlobalConfig->KvpncDebugLevel > 1 )
					GlobalConfig->appendLogEntry ( i18n( "Network route options: additional network: %1/%2 gw %3 %4" ).arg( it.current() ->text( 0 ) ).arg( it.current() ->text( 1 ) ).arg( it.current() ->text( 2 ) ).arg( it.current() ->text( 3 ) ) , GlobalConfig->debug );
			}
			profileData->setAdditionalNetworkRoutes( AdditionalNetworkRoutes );
		}

	}
	else if ( currentpage == newprofilewizardnatpage )
	{
		profileData->setUseUdp( newprofilewizardnatcontent->UseUdpCheckbox->isChecked() );
		profileData->setUseUdpPort ( newprofilewizardnatcontent->UdpPortCheckbox->isChecked() );
		profileData->setUdpPort( newprofilewizardnatcontent->UdpPortSpinbox->value() );
		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			if ( profileData->getUseUdp() )
				GlobalConfig->appendLogEntry( i18n( "NAT settings: use NAT" ), KVpncConfig::debug );
			else
				GlobalConfig->appendLogEntry( i18n( "NAT settings: use no NAT" ), KVpncConfig::debug );

			if ( profileData->getUseUdpPort() )
				GlobalConfig->appendLogEntry( i18n( "NAT settings: use userdefinied Port: %1" ).arg( QString().setNum( profileData->getUdpPort() ) ), KVpncConfig::debug );
		}


	}
	else if ( currentpage == newprofilewizardconnectoptionspage )
	{
		connectaftercreating = newprofilewizardconnectoptionscontent->ConnectAfterCreatingProfileCheckBox->isChecked();

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			if ( connectaftercreating )
				GlobalConfig->appendLogEntry ( i18n( "Connect options: connecting to profile \"%1\" after creating it." ).arg( profileData->getName() ) , GlobalConfig->debug );

	}
	else if ( currentpage == newprofilewizardconnectionstatuscheckpage )
	{
		msg = i18n( "These fields must be filled in:\n" );
		if ( newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked() )
		{
			profileData->setUseConnectionStatusCheck( true );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Connection status check: use connection status check" ), KVpncConfig::debug );
		}
		else
		{
			profileData->setUseConnectionStatusCheck( false );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Connection status check: dont use connection status check" ), KVpncConfig::debug );
		}

		if ( newprofilewizardconnectionstatuscheckcontent->DoReconnectAfterConnectionLostCheckBox->isChecked() )
		{
			profileData->setDoReconnectAfterConnectionLost( true );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Connection status check: do reconnect after connection lost" ), KVpncConfig::debug );
		}
		else
		{
			profileData->setDoReconnectAfterConnectionLost( false );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Connection status check: dont reconnect after connection lost" ), KVpncConfig::debug );
		}

		if ( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked() )
		{
			profileData->setDoPingIP( true );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Connection status check: ping userdefinied IP address" ), KVpncConfig::debug );
		}
		else
		{
			profileData->setDoPingIP( false );
			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "Connection status check: dont ping userdefinied IP address" ), KVpncConfig::debug );
		}

		profileData->setConnectionStatusInterval( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->value() );
		profileData->setConnectionStatusCheckSuccessCount( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->value() );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
		{
			GlobalConfig->appendLogEntry( i18n( "Connection status check: use connection interval: %1" ).arg( QString().setNum( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->value() ) ), KVpncConfig::debug );
			GlobalConfig->appendLogEntry( i18n( "Connection status check: success count: %1" ).arg( QString().setNum( newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->value() ) ), KVpncConfig::debug );
		}

		if ( newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked() )
		{
			if ( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked() )
			{
				if ( !newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text().isEmpty() )
				{
					if ( Utils( GlobalConfig ).isValidIPv4Address( newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text() ) )
						profileData->setPingHostIP( newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->text() );
					else
					{
						ok = false;
						msg = i18n( "The value of userdefinied IP address is not a valid IP address!" );
					}
				}
				else
				{
					ok = false;
					msg += i18n( "Userdefinied IP for ping" ) + "\n";
				}
			}
		}
	}
	else if ( currentpage == endpage )
	{}
	if ( ok )
	{
		previouspage = currentpage;
		QWizard::next();
	}
	else
	{
		KMessageBox::error( this, msg );
	}
}

void NewProfileWizard::back()
{
	/*
	currentpage=previouspage;
	// 	showPage(previouspage);

	if ( currentpage == page1 )
	{
		// nothing here
	}
	else if ( currentpage == newprofilewizardgeneralpage )
	{
		newprofilewizardgeneralpagecontent->NameLineEdit->setText(profileData->getName());
		newprofilewizardgeneralpagecontent->gatewayLineEdit->setText(profileData->getGateway());
		newprofilewizardgeneralpagecontent->DescriptionLineEdit->setText(profileData->getDescription());
	}
	else if ( currentpage == newprofilewizardtypeselectionpage )
	{
		if ( profileData->getConnectionType() == VpnAccountData::cisco )
			newprofilewizardtypeselectionpagecontent->CiscoRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::freeswan  || 
					profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
			newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::racoon  || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon)
			newprofilewizardtypeselectionpagecontent->FreeswanRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::pptp )
			newprofilewizardtypeselectionpagecontent->PptpRadioButton->setChecked(true);
		else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			newprofilewizardtypeselectionpagecontent->OpenvpnRadioButton->setChecked(true);
	}
	else if ( currentpage == newprofilewizardciscoselectionpage )
	{}
	else if ( currentpage == newprofilewizardciscomanuallypage )
	{
		newprofilewizardciscomanuallypagecontent->IDLineEdit->setText(profileData->getGateway());
		newprofilewizardciscomanuallypagecontent->AllowEmptyGroupPasswordCheckBox->setChecked(profileData->getAllowEmptyGroupPassword());
		newprofilewizardciscomanuallypagecontent->GroupPasswordLineEdit->setText(profileData->getPreSharedKey());
		profileData->setID(newprofilewizardciscomanuallypagecontent->IDLineEdit->text());

		insertPage ( newprofilewizardciscoselectionpage, "<b>"+ i18n("Cisco selection")+"</b>", 2 );

	}
	else if ( currentpage == newprofilewizardracoonpage )
	{
		newprofilewizardracoonpagecontent->HashAlgoComboBox->setCurrentText(profileData->getHashAlgo());

		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" ,  2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("FreeS/WAN settings")  , 4 );
		insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("OpenVPN settings")+"</b>"  , 5 );
		insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  6 );
	}
	else if ( currentpage == newprofilewizardfreeswanpage )
	{
		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" ,  2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  , 4 );
		insertPage ( newprofilewizardopenvpnselectionpage, "<b>"+ i18n("FreeS/WAN settings")  , 4 );
		insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  5 );
	}
	else if ( currentpage == newprofilewizardopenvpnpage )
	{
		newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->setCurrentText(profileData->getTunnelDeviceType() );
		newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setCurrentText(profileData->getNsCertType());
		newprofilewizardopenvpnpagecontent->TunnelDeviceTypeComboBox->setCurrentText(profileData->getTunnelDeviceType() );
		newprofilewizardopenvpnpagecontent->UseRedirectGatewayCheckBox->setChecked(profileData->getUseRedirectGateway() );

		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setCurrentText(profileData->getUserdefiniedCipher());
		newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->setChecked(profileData->getUseUserdefiniedCipher());
		newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->setChecked(profileData->getUseTlsAuth());
		newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setURL(profileData->getTlsAuthFile());

		profileData->setUseTlsRemoteHost( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox->isChecked());
		profileData->setTlsRemoteHost( newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->text());

		profileData->setUseHttpProxy( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() );
		profileData->setHttpProxy( newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->text( ) );
		profileData->setHttpProxyPort( newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->value( ) );
		profileData->setHttpProxyTimeout( newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->value() );

		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" , 2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardfreeswanpage, "<b>"+ i18n("FreeS/WAN settings")  ,  4 );
		insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  ,  5 );
		insertPage ( newprofilewizardpptppage,  "<b>"+ i18n("PPTP settings")+"</b>",  6 );
	}
	else if ( currentpage == newprofilewizardpptppage )
	{
		insertPage ( newprofilewizardciscoselectionpage,"<b>"+ i18n("Cisco selection")+"</b>" , 2 );
		insertPage ( newprofilewizardciscomanuallypage, "<b>"+ i18n("Cisco settings")+"</b>",  3 );
		insertPage ( newprofilewizardfreeswanpage, "<b>"+ i18n("FreeS/WAN settings")  ,  4 );
		insertPage ( newprofilewizardracoonpage, "<b>"+ i18n("Racoon settings")+"</b>"  ,  5 );
		insertPage ( newprofilewizardopenvpnpage,   "<b>"+i18n("OpenVPN settings")+"</b>", 6 );
	}
	else if ( currentpage == newprofilewizarduserpage )
	{
		newprofilewizarduserpagecontent->UsernameLineEdit->setText(profileData->getUserName());
		newprofilewizarduserpagecontent->PasswordEdit->setText(profileData->getUserPassword() );
		newprofilewizarduserpagecontent->CheckUserPass->setChecked(profileData->getSaveUserPassword());
	}
	else if ( currentpage == newprofilewizardnetworkpage )
	{
		newprofilewizardnetworkcontent->RemoteNetAddrLineEdit->setText(profileData->getRemoteNetAddr() );
		newprofilewizardnetworkcontent->RemoteNetMaskComboBox->setCurrentText(profileData->getRemoteNetMask());
		newprofilewizardnetworkcontent->NetworkDeviceComboBox->setCurrentText(profileData->getNetworkDevice());
	}
	else if ( currentpage == newprofilewizardnatpage )
	{
		newprofilewizardnatcontent->UseUdpCheckbox->setChecked(profileData->getUseUdp());
		newprofilewizardnatcontent->UdpPortCheckbox->setChecked(profileData->getUseUdpPort ());
		newprofilewizardnatcontent->UdpPortSpinbox->setValue(profileData->getUdpPort());
	}
	*/
	QWizard::back();
}

QString NewProfileWizard::getName()
{
	return profileData->getName();
}

bool NewProfileWizard::getFinished()
{
	return finished;
}

// void NewProfileDialog::reject()
// {
//
// }

void NewProfileWizard::showPage( QWidget* page )
{
	currentpage = page;
	QWizard::showPage( page );

	// FIXME set currentpage at back()
	//backButton()->setEnabled(false);

	helpButton() ->setEnabled( false );

	if ( page == endpage )
	{
		finishButton() ->setEnabled( TRUE );
		finishButton() ->setFocus();
	}
}

void NewProfileWizard::dataChanged( const QString & )
{
	//     if ( !firstName->text().isEmpty() &&
	//          !lastName->text().isEmpty() &&
	//          !email->text().isEmpty() )
	//         nextButton()->setEnabled( TRUE );
	//     else
	//         nextButton()->setEnabled( FALSE );
}

void NewProfileWizard::userdefinedOpenvpnPortToggeled( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseUserdefinedPortCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled( true );
	else
		newprofilewizardopenvpnpagecontent->UserdefinedPortSpinBox->setEnabled( false );
}

void NewProfileWizard::nsCertTypeOpenvpnToggled( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseNsCertTypeCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled( true );
	else
		newprofilewizardopenvpnpagecontent->NsCertTypeComboBox->setEnabled( false );
}

void NewProfileWizard::pskIsInFileToggled( bool )
{
	if ( newprofilewizardpskcontent->PskInFileCheckBox->isChecked() )
	{
		newprofilewizardpskcontent->LabelPskFile->setEnabled( TRUE );
		newprofilewizardpskcontent->PSKFileURLRequester->setEnabled( TRUE );
		newprofilewizardpskcontent->LabelPsk->setEnabled( FALSE );
		newprofilewizardpskcontent->PSKLineEdit->setEnabled( FALSE );
	}
	else
	{
		newprofilewizardpskcontent->LabelPskFile->setEnabled( FALSE );
		newprofilewizardpskcontent->PSKFileURLRequester->setEnabled( FALSE );
		newprofilewizardpskcontent->LabelPsk->setEnabled( TRUE );
		newprofilewizardpskcontent->PSKLineEdit->setEnabled( TRUE );
	}
}

void NewProfileWizard::useUdpToggled( bool )
{
	if ( newprofilewizardnatcontent->UseUdpCheckbox->isChecked() )
	{
		newprofilewizardnatcontent->UdpPortCheckbox->setEnabled( TRUE );
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled( FALSE );
	}
	else
	{
		newprofilewizardnatcontent->UdpPortCheckbox->setEnabled( FALSE );
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled( FALSE );
	}
}

void NewProfileWizard::udpPortToggled( bool )
{
	if ( newprofilewizardnatcontent->UdpPortCheckbox->isChecked() )
	{
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled( TRUE );
	}
	else
	{
		newprofilewizardnatcontent->UdpPortSpinbox->setEnabled( FALSE );
	}
}

void NewProfileWizard::pingIpAfterConnectToggled( bool )
{
	if ( newprofilewizardconnectionstatuscheckcontent->PingUserdefiniedAddressCheckBox->isChecked() )
		newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->setEnabled( true );
	else
		newprofilewizardconnectionstatuscheckcontent->UserdefiniedPingIPLineEdit->setEnabled( false );
}

void NewProfileWizard::useUserdefiniedCipherToggled( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseUserdefiniedCipherCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setEnabled( true );
	else
		newprofilewizardopenvpnpagecontent->UserdefiniedCipherComboBox->setEnabled( false );
}

void NewProfileWizard::useSpecialRemoteIDToggled( bool )
{
	if ( newprofilewizardcertcontent->UseSpecialRemoteIDcheckBox->isChecked() )
		newprofilewizardcertcontent->RemoteIDLineEdit->setEnabled( true );
	else
		newprofilewizardcertcontent->RemoteIDLineEdit->setEnabled( false );
}

void NewProfileWizard::useSpecialServerCertificateToggled( bool )
{
	if ( newprofilewizardcertcontent->UseSpecialServerCertificateCheckBox->isChecked() )
	{
		newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled( TRUE );
	}
	else
	{
		newprofilewizardcertcontent->SpecialServerCertificateURLRequester->setEnabled( FALSE );
	}
}

void NewProfileWizard::useTlsAuthToggled( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseTlsAuthCheckBox ->isChecked() )
	{
		newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setEnabled( true );
		newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setEnabled( true );
	}
	else
	{
		newprofilewizardopenvpnpagecontent->TlsAuthURLRequester->setEnabled( false );
		newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->setEnabled( false );
	}
}

void NewProfileWizard::useHttpProxyToggeled( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseHttpProxyCheckBox->isChecked() )
	{
		newprofilewizardopenvpnpagecontent->HostTextLabel->setEnabled( true );
		newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->setEnabled( true );
		newprofilewizardopenvpnpagecontent->TimeoutTextLabel->setEnabled( true );
		newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->setEnabled( true );
		newprofilewizardopenvpnpagecontent->PortTextextLabel->setEnabled( true );
		newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->setEnabled( true );
	}
	else
	{
		newprofilewizardopenvpnpagecontent->HostTextLabel->setEnabled( false );
		newprofilewizardopenvpnpagecontent->HttpProxyLineEdit->setEnabled( false );
		newprofilewizardopenvpnpagecontent->TimeoutTextLabel->setEnabled( false );
		newprofilewizardopenvpnpagecontent->HttpProxyTimeoutIntSpinBox->setEnabled( false );
		newprofilewizardopenvpnpagecontent->PortTextextLabel->setEnabled( false );
		newprofilewizardopenvpnpagecontent->HttpProxyPortIntNumInput->setEnabled( false );
	}
}

void NewProfileWizard::useTlsRemoteHostToggled( bool )
{
	if ( newprofilewizardopenvpnpagecontent->UseTlsRemoteHostCheckBox->isChecked() )
		newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->setEnabled( true );
	else
		newprofilewizardopenvpnpagecontent->TlsRemoteHostLineEdit->setEnabled( false );
}

void NewProfileWizard::connectionStatusCheckToggled( bool )
{
	if ( !newprofilewizardconnectionstatuscheckcontent->UseConnectionStatusCheckCheckBox->isChecked() )
	{
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->setEnabled( false );
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->setEnabled( false );
	}
	else
	{
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusCheckIntervalNumInput->setEnabled( true );
		newprofilewizardconnectionstatuscheckcontent->ConnectionStatusSuccessCountNumInput->setEnabled( true );
	}
}

bool NewProfileWizard::importProfile( VpnAccountData::ConnectionType ConnType )
{
	// FIXME make dlg dynamiclly

	bool success = true;

	if ( ConnType == VpnAccountData::cisco )
	{
		ImportProfileDialog dlg( GlobalConfig, this, i18n( "Import Cisco PCF profile" ), "" );
		dlg.exec();
		importOK = dlg.importOk;
		if ( importOK )
		{
			profileData = dlg.acc;
			KMessageBox::information( 0, i18n( "Import of \"%1\" was successful." ).arg( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n( "Import of \"%1\" (%2) was successful." ).arg( profileData->getName() ).arg( "PCF" ), GlobalConfig->info );
		}
		else
		{
			KMessageBox::sorry( 0, i18n( "Import of \"%1\" has been failed." ).arg( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n( "Import of \"%1\" (%2) has been failed." ).arg( profileData->getName() ).arg( "PCF" ), GlobalConfig->error );
			success = false;
		}
	}
	if ( ConnType == VpnAccountData::openvpn )
	{
		ImportOpenvpnProfileDialog dlg( GlobalConfig, this, i18n( "Import OpenVPN profile" ), "" );
		dlg.exec();
		importOK = dlg.importOk;
		if ( importOK )
		{
			profileData = dlg.acc;
			KMessageBox::information( 0, i18n( "Import of \"%1\" was successful." ).arg( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n( "Import of \"%1\" (%2) was successful." ).arg( profileData->getName() ).arg( "OpenVPN" ), GlobalConfig->info );
		}
		else
		{
			KMessageBox::sorry( 0, i18n( "Import of \"%1\" has been failed." ).arg( profileData->getName() ) );
			GlobalConfig->appendLogEntry ( i18n( "Import of \"%1\" (%2) has been failed." ).arg( profileData->getName() ).arg( "OpenVPN" ), GlobalConfig->error );
			success = false;
		}
	}
	return success;

}

bool NewProfileWizard::importP12Certificate()
{
	bool success = true;

	newprofilewizardcertcontent->CaCertpathURLRequester->clear();
	newprofilewizardcertcontent->certpathURLRequester->clear();
	newprofilewizardcertcontent->PrivkeyPasswordEdit->clear();
	ImportCertificateDialog dlg( this, i18n( "Import Certificate..." ).ascii(), GlobalConfig );

	if ( profileData->getConnectionType() == VpnAccountData::freeswan ||
	        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
	{
		dlg.main->ImporttypeComboBox->setCurrentItem( ImportCertificateDialog::pkcs12_freeswan );
		dlg.typeToggeled( ImportCertificateDialog::pkcs12_freeswan );
	}
	else if ( profileData->getConnectionType() == VpnAccountData::racoon || profileData->getConnectionType() == VpnAccountData::l2tpd_racoon )
	{
		dlg.main->ImporttypeComboBox->setCurrentItem( ImportCertificateDialog::pkcs12_racoon );
		dlg.main->FreeswanGroupBox->setEnabled( false );
		dlg.typeToggeled( ImportCertificateDialog::pkcs12_racoon );
	}
	else if ( profileData->getConnectionType() == VpnAccountData::openvpn )
	{
		dlg.main->ImporttypeComboBox->setCurrentItem( ImportCertificateDialog::pkcs12_openvpn );
		dlg.typeToggeled( ImportCertificateDialog::pkcs12_openvpn );
		dlg.main->RacoonCertificatePathUrlrequester->setEnabled( true );
		dlg.main->RacoonCertificatePathUrlrequester->setURL( profileData->getCertPath() );
		dlg.main->FreeswanGroupBox->setEnabled( true );
		dlg.main->PrivateKeyPasswordEdit->setEnabled( true );
		dlg.main->PrivateKeyAgainPasswordEdit->setEnabled( true );
	}

	

	dlg.exec();
	importOK = dlg.importOk;
	QString filename = dlg.filename;
	if ( importOK )
	{
		QString certpath = dlg.certpath;
		QString CertFullPath = dlg.CertFullPath;
		QString CaCertFullPath = dlg.CaCertFullPath;
		QString importpassword = dlg.main->ImportPasswordEdit->text();
		QString privatekeypassword = dlg.main->PrivateKeyPasswordEdit->password();
		QString certificate = QString( "mykeys_" + dlg.certName + ".pem" );
		QString privatekey = QString( dlg.certName + ".pem" );

		QString certpostfix = "";
		QString privatepostfix = "";
		if ( profileData->getConnectionType() == VpnAccountData::freeswan ||
		        profileData->getConnectionType() == VpnAccountData::l2tpd_freeswan )
		{
			certpostfix = "certs/";
			privatepostfix = "private/";
		}

		newprofilewizardcertcontent->CaCertpathURLRequester->setURL ( CaCertFullPath );


		if ( profileData->getConnectionType() == VpnAccountData::openvpn )
			newprofilewizardcertcontent->PrivkeyPasswordEdit->setText( importpassword );
		else
			newprofilewizardcertcontent->PrivkeyPasswordEdit->setText( privatekeypassword );

		if ( profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ||
		        profileData->getConnectionType() == VpnAccountData::racoon )
			newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled( false );


		newprofilewizardcertcontent->certpathURLRequester->setURL( certpath );

		if ( profileData->getConnectionType() == VpnAccountData::l2tpd_racoon ||
		        profileData->getConnectionType() == VpnAccountData::racoon )
		{
			newprofilewizardcertcontent->privkeypathURLRequester->setURL ( certpath + "/" + certpostfix + certificate );
			newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled( false );
		}
		else
			newprofilewizardcertcontent->privkeypathURLRequester->setURL ( certpath + "/" + privatepostfix + privatekey );
		newprofilewizardcertcontent->x509certURLRequester->setURL( certpath + "/" + certpostfix + certificate );

		KMessageBox::information( 0, i18n( "Import of \"%1\" was successful." ).arg( filename ) );
		GlobalConfig->appendLogEntry ( i18n( "Import of \"%1\" (%2) was successful." ).arg( filename ).arg( "P12 certificate" ), GlobalConfig->info );
	}
	else
	{
		GlobalConfig->appendLogEntry ( i18n( "Import of \"%1\" (%2) has been failed." ).arg( filename ).arg( "P12 certificate" ), GlobalConfig->info );
		success = false;
	}
	return success;
}

void NewProfileWizard::authenticateWithUsernameAndPasswordToggled( bool )
{
	if ( newprofilewizardopenvpnauthpagecontent->AuthWithUsernameAndPasswordCheckBox->isChecked() )
		newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->setEnabled( true );
	else
		newprofilewizardopenvpnauthpagecontent->UseOnlyCaCertAndUserAuthCheckBox->setEnabled( false );
}

void NewProfileWizard::pskInputToggled( const QString& )
{
	if ( !newprofilewizardpskcontent->PSKLineEdit->text().isEmpty() )
		newprofilewizardpskcontent->CheckSavePsk->setChecked( true );
	else
		newprofilewizardpskcontent->CheckSavePsk->setChecked( false );
}

void NewProfileWizard::userpassToggled( const QString& )
{
	if ( !newprofilewizarduserpagecontent->PasswordEdit->text().isEmpty() )
		newprofilewizarduserpagecontent->CheckUserPass->setChecked( true );
	else
		newprofilewizarduserpagecontent->CheckUserPass->setChecked( false );
}

void NewProfileWizard::usernameToggled( const QString& )
{
	// 	if (newprofilewizarduserpagecontent->UsernameLineEdit->text().isEmpty())
	// 		newprofilewizarduserpagecontent->DontSaveUsernameCheckBox->setChecked(true);
	// 	else
	// 		newprofilewizarduserpagecontent->DontSaveUsernameCheckBox->setChecked(false);
}

void NewProfileWizard::useRightNextHopToggled( bool )
{
	if ( newprofilewizardracoonpagecontent->UseRightNextHopCheckBox->isChecked() )
		newprofilewizardracoonpagecontent->RightNextHopLineEdit->setEnabled( true );
	else
		newprofilewizardracoonpagecontent->RightNextHopLineEdit->setEnabled( false );
}

void NewProfileWizard::useLeftNextHopToggled( bool )
{
	if ( newprofilewizardracoonpagecontent->UseLeftNextHopCheckBox->isChecked() )
		newprofilewizardracoonpagecontent->LeftNextHopLineEdit->setEnabled( true );
	else
		newprofilewizardracoonpagecontent->LeftNextHopLineEdit->setEnabled( false );
}

void NewProfileWizard::additionalNetworkRoutesToggled( bool )
{
	if ( newprofilewizardnetworkroutecontent->UseExtraNetworkRoutesCheckbox->isChecked() )
	{
		newprofilewizardnetworkroutecontent->NetworkListView->setEnabled( TRUE );
		newprofilewizardnetworkroutecontent->DeleteNetworkRoutePushButton->setEnabled( TRUE );
		newprofilewizardnetworkroutecontent->AddRoutePushButton->setEnabled( TRUE );
	}
	else
	{
		newprofilewizardnetworkroutecontent->NetworkListView->setEnabled( FALSE );
		newprofilewizardnetworkroutecontent->DeleteNetworkRoutePushButton->setEnabled( FALSE );
		newprofilewizardnetworkroutecontent->AddRoutePushButton->setEnabled( FALSE );
	}
}

void NewProfileWizard::delNetworkRouteClicked()
{
	if ( newprofilewizardnetworkroutecontent->NetworkListView->childCount() > 0 && newprofilewizardnetworkroutecontent->NetworkListView->currentItem() != 0 )
	{
		QListViewItem * item = newprofilewizardnetworkroutecontent->NetworkListView->currentItem();
		QString Network = item->text( 0 );
		QString Netmask = item->text( 1 );
		int result = KMessageBox::questionYesNo ( this, i18n( "Do you really want to delete the network \"%1/%2\"?" ).arg( Network ).arg( Netmask ), i18n( "Delete?" ) );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3 )  // Yes
		{
			newprofilewizardnetworkroutecontent->NetworkListView->removeItem( item );
		}
	}
}

void NewProfileWizard::addNetworkRouteClicked()
{
	AddNetworkRouteDialog dlg( this, i18n( "Add Network Route..." ) );


	dlg.main->InterfaceComboBox->insertItem( "default" ); // interface where default route points

	//FIXME
	dlg.main->InterfaceComboBox->insertItem( "eth0" );
	dlg.main->InterfaceComboBox->insertItem( "eth1" );
	dlg.main->InterfaceComboBox->insertItem( "eth2" );
	dlg.main->InterfaceComboBox->insertItem( "ipsec0" );
	dlg.main->InterfaceComboBox->insertItem( "tun0" );
	dlg.main->InterfaceComboBox->insertItem( "ppp0" );

	if ( dlg.exec() )
	{
		QString gateway = dlg.getGateway();
		QString interface = dlg.getInterface();
		if ( !dlg.getUseGateway() )
			gateway = "-";
		if ( !dlg.getUseInterface() )
			interface = "-";
		newprofilewizardnetworkroutecontent->NetworkListView->insertItem( new QListViewItem( newprofilewizardnetworkroutecontent->NetworkListView, dlg.getNetwork(), dlg.getNetmask(), gateway, interface ) );
	}
}

void NewProfileWizard::domainNameToggled( bool )
{
	if ( newprofilewizarduserpagecontent->NtDomainNameCheckbox->isChecked() )
		newprofilewizarduserpagecontent->NtDomainNameLineedit->setEnabled( true );
	else
		newprofilewizarduserpagecontent->NtDomainNameLineedit->setEnabled( false );
}

void NewProfileWizard::useSmartcardToggled( bool )
{
	if ( newprofilewizardcertcontent->UseSmartcardCheckBox->isChecked() )
	{
		newprofilewizardcertcontent->SmartcardGroupBox->setEnabled( true );
		newprofilewizardcertcontent->x509certURLRequester->setEnabled( false );
		newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled( false );
		newprofilewizardcertcontent->privkeypathURLRequester->setEnabled( false );
		newprofilewizardcertcontent->LabelCertificate->setEnabled( false );
		newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled( false );
		newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled( false );


// 		if ( profileData->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
// 		{
// 			ToolInfo IpsecToolInfo( GlobalConfig->programsInPath , "ipsec" );
// 			if ( GlobalConfig->programsInPath )
// 			{
// 				IpsecToolInfo.addSearchPath( "/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/sbin" );
// 				IpsecToolInfo.addSearchPath( "/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/bin" );
// 			}
// 			IpsecToolInfo.collectToolInfo();
// 			if (IpsecToolInfo.Version.contains("Openswan") || IpsecToolInfo.Version.contains("Free"))
// 				KMessageBox::information(0,i18n("%1 (IPSec) currently has no working smartcard support (pkcs11). Please use strongSwan instead with enabled smartcard support.").arg(IpsecToolInfo.Version.section(' ',0,0)),i18n("Unsupported IPSec version"));
// 		}

	}
	else
	{
		newprofilewizardcertcontent->SmartcardGroupBox->setEnabled( false );
		newprofilewizardcertcontent->x509certURLRequester->setEnabled( true );
		newprofilewizardcertcontent->PrivkeyPasswordEdit->setEnabled( true );
		newprofilewizardcertcontent->privkeypathURLRequester->setEnabled( true );
		newprofilewizardcertcontent->LabelCertificate->setEnabled( true );
		newprofilewizardcertcontent->LabelPrivateKeyPath->setEnabled( true );
		newprofilewizardcertcontent->LabelPrivateKeyPassword->setEnabled( true );
	}
}

void NewProfileWizard::useSmartcardOnCertFormateToggled(bool)
{
	if ( newprofilewizardp12certselectioncontent->UseSmartcardCheckBox->isChecked() )
	{
		newprofilewizardp12certselectioncontent->P12Group->setEnabled( false );
// 		if ( profileData->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
// 		{
// 			ToolInfo IpsecToolInfo( GlobalConfig->programsInPath , "ipsec" );
// 			if ( GlobalConfig->programsInPath )
// 			{
// 				IpsecToolInfo.addSearchPath( "/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/sbin" );
// 				IpsecToolInfo.addSearchPath( "/usr/sbin" );
// 				IpsecToolInfo.addSearchPath( "/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/local/bin" );
// 				IpsecToolInfo.addSearchPath( "/usr/bin" );
// 			}
// 			IpsecToolInfo.collectToolInfo();
// 			if (IpsecToolInfo.Version.contains("Openswan") || IpsecToolInfo.Version.contains("Free"))
// 				KMessageBox::information(0,i18n("%1 (IPSec) currently has no working smartcard support (pkcs11). Please use strongSwan instead with enabled smartcard support.").arg(IpsecToolInfo.Version.section(' ',0,0)),i18n("Unsupported IPSec version"));
// 		}
	}
	else
	{
		newprofilewizardp12certselectioncontent->P12Group->setEnabled( true );
	}
}

void NewProfileWizard::usePkcs11ProvidersToggled( bool )
{
	if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() )
		newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setEnabled( true );
	else
		newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->setEnabled( false );
}

void NewProfileWizard::idTypeToggled()
{
	// 	if (newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentItem() == 0)
	// 		newprofilewizardcertcontent->IdLabel->setText(i18n("ID"));
	// 	else if (newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentItem() == 1)
	// 		newprofilewizardcertcontent->IdLabel->setText(i18n("Label"));
	// 	else
	// 		newprofilewizardcertcontent->IdLabel->setText(i18n("Description"));
}

void NewProfileWizard::detectPkcs11Ids()
{
	GlobalConfig->appPointer->setOverrideCursor( QCursor( Qt::WaitCursor ) );
	newprofilewizardcertcontent->Pkcs11IdComboBox->clear();

	int Pkcs11IdType = newprofilewizardcertcontent->Pkcs11IdTypeComboBox->currentItem();
	QString Pkcs11IdTypeTmp;
	if ( Pkcs11IdType == 0 )
	{
		Pkcs11IdTypeTmp = "id";

		if ( GlobalConfig->KvpncDebugLevel > 1 )
			GlobalConfig->appendLogEntry( i18n( "Pkcs11IdType: %1" ).arg( Pkcs11IdTypeTmp ), KVpncConfig::debug );
	}
	else if ( Pkcs11IdType == 1 )
	{
		Pkcs11IdTypeTmp = "label";
		if ( GlobalConfig->KvpncDebugLevel > 1 )
			GlobalConfig->appendLogEntry( i18n( "Pkcs11IdType: %1" ).arg( Pkcs11IdTypeTmp ), KVpncConfig::debug );
	}
	else
	{
		Pkcs11IdTypeTmp = "subject";
		if ( GlobalConfig->KvpncDebugLevel > 1 )
			GlobalConfig->appendLogEntry( i18n( "Pkcs11IdType: %1" ).arg( Pkcs11IdTypeTmp ), KVpncConfig::debug );
	}

	QString ProviderLib = "";
	if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() && !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().isEmpty() )
		ProviderLib = newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url();

	// we have to split slot id and name ("0 : foobar") => 0
	QString Pkcs11Slot = newprofilewizardcertcontent->Pkcs11SlotComboBox->currentText().section( ':', 0, 0 ).stripWhiteSpace();

	QStringList Pkcs11Ids = Utils( GlobalConfig ).getSmartcardCertsFromSlot( Pkcs11Slot, Pkcs11IdTypeTmp, ProviderLib );
	for ( QStringList::Iterator it = Pkcs11Ids.begin(); it != Pkcs11Ids.end(); ++it )
		newprofilewizardcertcontent->Pkcs11IdComboBox->insertItem( QString( *it ) );
	GlobalConfig->appPointer->restoreOverrideCursor();
}

void NewProfileWizard::detectPkcs11Slots()
{
	GlobalConfig->appPointer->setOverrideCursor( QCursor( Qt::WaitCursor ) );
	newprofilewizardcertcontent->Pkcs11SlotComboBox->clear();
	QString ProviderLib = "";
	if ( newprofilewizardcertcontent->UsePkcs11ProvidersCheckBox->isChecked() && !newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url().isEmpty() )
		ProviderLib = newprofilewizardcertcontent->Pkcs11ProvidersURLRequester->url();
	QStringList Pkcs11Slots = Utils( GlobalConfig ).getSmartcardSlots( ProviderLib );
	for ( QStringList::Iterator it = Pkcs11Slots.begin(); it != Pkcs11Slots.end(); ++it )
		newprofilewizardcertcontent->Pkcs11SlotComboBox->insertItem( QString( *it ) );
	GlobalConfig->appPointer->restoreOverrideCursor();
}







