/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "vpnaccountdata.h"

VpnAccountData::VpnAccountData( ConnectionType ConnType,const QString& Name)
{
	this->RemoteNetAddr = "";
	this->RemoteNetMask = "24";
	this->CertPath = "";
	this->doPingIP = false;
	this->pingHostIP = "";
	this->PrivateKeyPass="";
	this->PrivateKey="";
	this->NetworkDevice="";
	this->connectiontype = ConnType;
	this->Name = Name;

	Gateway="";
	ID="";
	Username="";
	UserPassword="";
	IkeGroup="modp2048";
	EncryptionAlgorithm="3des";
	AuthenticationAlgorithm="hmac_md5";
	PerfectForwardSecrecy="";
	NtDomainName="";
	ApplicationVersion="";
	RemoteNetAddr="";
	RemoteNetMask="";
	PreSharedKey="";
	x509Certificate="";
	CaCertificate="";
	NetworkDevice="";
	PrivateKeyPass="";
	PrivateKey="";
	CertPath="";
	AuthType="";
	pingHostIP="";
	SpecialRemoteID="";
	LocalVirtualIP="";
	RemoteVirtualIP="";
	PreSharedKeyFile="";
	HashAlgo="md5";
	Description="";
	HttpProxyAuthType="";
	HttpProxyUser="";
	HttpProxyPass="";
	RightNextHop="";
	LeftNextHop="";
	AuthMethod="chap";
	TunnelDeviceType="tun";
	saveUserPassword=false;
	savePsk=false;
	useAdvancedSettings=false;
	useIkeGroup=false;
	usePerfectForwardSecrety=false;
	useNtDomainName=false;
	useApplicationVersion=false;
	useSingleDes=false;
	useGlobalIpsecSecret=false;
	doPingIP=false;
	useSpecialRemoteID=false;
	useUdp=true;
	useUdpPort=false;
	useDnsServer=false;
	DnsServer="";
	useGetDnsFromPeer=true;
	refuse40BitEncryption=false;
	refuse128BitEncryption=false;
	allowStatefulMode=false;
	requireMppe=true;
	refuseEap=false;
	useNoIpDefault=false;
	disableMPPEComp=false;
	executeCmdBeforeConnect=false;
	executeCmdAfterConnect=false;
	executeCmdBeforeDisconnect=false;
	executeCmdAfterDisconnect=false;
	CommandBeforeConnect="";
	CommandAfterConnect="";
	CommandBeforeDisconnect="";
	CommandAfterDisconnect="";
	useNoBsdComp=true;
	useNoDeflate=true;
	setDefaultRoute=false;
	replaceDefaultRoute=false;
	useMtu=false;
	useMru=false;
	useVirtualIP=false;
	VirtualIP="";
	PskIsInFile=false;
	useAdditionalNetworkRoutes=false;
	useUserdefinedPort = false;
	SpecialServerCertificate="";
	useSpecialServerCertificate=false;
	TunnelDeviceType="tun";
	keepDefaultRoute = false;
	allowEmptyGroupPassword=false;
	useReconnectDelay=false;
	useHttpProxy=false;
	PskIsInFile=false;
	RemoteNetMask="24";
	RemoteNetAddr="";
	saveUserPassword=true;
	savePsk=true;
	useIkeGroup=false;
	usePerfectForwardSecrety=false;
	useNtDomainName=false;
	useApplicationVersion=false;
	useLocalPort=false;
	useRemotePort=false;
	useSingleDes=false;
	useGlobalIpsecSecret=false;
	doPingIP=false;
	useSpecialRemoteID=false;
	useUdp=false;
	useUdpPort=false;
	useDnsServer=false;
	useGetDnsFromPeer=true;
	refuse40BitEncryption=false;
	refuse128BitEncryption=false;
	allowStatefulMode=false;
	requireMppe=true;
	refuseEap=false;
	useNoIpDefault=false;
	disableMPPEComp=false;
	executeCmdBeforeConnect=false;
	executeCmdAfterConnect=false;
	executeCmdBeforeDisconnect=false;
	executeCmdAfterDisconnect=false;
	useNoBsdComp=false;
	useNoDeflate=false;
	setDefaultRoute=false;
	replaceDefaultRoute=false;
	useMtu=false;
	useMru=false;
	useVirtualIP=false;
	PskIsInFile=false;
	useAdditionalNetworkRoutes=false;
	useSpecialServerCertificate=false;
	useUserdefinedPort=false;
	keepDefaultRoute=false;
	useNsCertType=false;
	useConnectionStatusCheck=true;
	doReconnectAfterConnectionLost=true;
	disableLzoCompression=false;
	authWithUsernameAndPassword=false;
	allowEmptyGroupPassword=false;
	useUserdefiniedCipher=false;
	useRedirectGateway=false;
	useTlsAuth=false;
	useTlsRemoteHost=false;
	dontSaveUsername=false;
	disableLzoCompression=false;
	disableOpportunisticEncryption=true;
	useMssfix=false;
	useFragment=false;
	disableCcp=false;
	useXauthInteractive=false;
	savePrivateKeyPassword=false;
	useHttpProxyAuth=false;
	useOnlyCaCertAndUserAuth=false;
	useMailAddressAsIdentifier=false;
	useRightNextHop=false;
	useLeftNextHop=false;
	usePkcs11Providers=false;
	allowEmptyPrivateKeyPassword=false;
	useSmartcard=false;
	allowIpAddressChangeOfPeer=false;

	PeerTimeout=60;
	ReconnectDelay=5;
	connectionStatusInterval=20;
	Mtu=1492;
	Mru=1492;
	LocalPort=500;
	RemotePort=500;
	UserdefinedPort=10000;
	UdpPort=4500;
	HttpProxyPort=3128;
	HttpProxyTimeout=100;
	Mssfix=1300;
	Fragment=1300;
	CommandAfterConnectDelayTime=3;

}


VpnAccountData::~VpnAccountData()
{}

QString VpnAccountData::getName() const
{
	return Name;
}

VpnAccountData::ConnectionType VpnAccountData::getConnectionType() const
{
	return connectiontype;
}

QString VpnAccountData::getGateway() const
{
	return Gateway;
}

QString VpnAccountData::getID() const
{
	return ID;
}

QString VpnAccountData::getTunnelDeviceType() const
{
	return TunnelDeviceType;
}

QString VpnAccountData::getUserName() const
{
	return Username;
}

QString VpnAccountData::getUserPassword() const
{
	return UserPassword;
}

bool VpnAccountData::getSaveUserPassword() const
{
	return saveUserPassword;
}

bool VpnAccountData::getSavePsk() const
{
	return savePsk;
}

QString VpnAccountData::getIkeGroup() const
{
	return IkeGroup;
}

QString VpnAccountData::getEncryptionAlgorithm() const
{
	return EncryptionAlgorithm;
}

QString VpnAccountData::getAuthenticationAlgorithm() const
{
	return AuthenticationAlgorithm;
}

QString VpnAccountData::getPerfectForwardSecrety() const
{
	return PerfectForwardSecrecy;
}

QString VpnAccountData::getNtDomainName() const
{
	return NtDomainName;
}

QString VpnAccountData::getApplicationVersion() const
{
	return ApplicationVersion;
}

bool VpnAccountData::getUseSingleDes() const
{
	return useSingleDes;

}

bool VpnAccountData::getUseIkeGroup() const
{
	return useIkeGroup;
}

bool VpnAccountData::getUsePerfectForwardSecrety() const
{
	return usePerfectForwardSecrety;
}

bool VpnAccountData::getUseNtDomainName() const
{
	return useNtDomainName;
}

bool VpnAccountData::getUseApplicationVersion() const
{
	return useApplicationVersion;
}

bool VpnAccountData::getUseLocalPort() const
{
	return useLocalPort;
}

bool VpnAccountData::getUseRemotePort() const
{
	return useRemotePort;
}

bool VpnAccountData::getUseAdvancedSettings() const
{
	return useAdvancedSettings;
}

bool VpnAccountData::getUseGlobalIpsecSecret() const
{
	return useGlobalIpsecSecret;
}

int VpnAccountData::getLocalPort() const
{
	return LocalPort;
}

int VpnAccountData::getRemotePort() const
{
	return RemotePort;
}

QString VpnAccountData::getRemoteNetAddr() const
{
	return RemoteNetAddr;
}

QString VpnAccountData::getRemoteNetMask() const
{
	return RemoteNetMask;
}

QString VpnAccountData::getPreSharedKey() const
{
	return PreSharedKey;
}

QString VpnAccountData::getX509Certificate() const
{
	return x509Certificate;
}

QString VpnAccountData::getCaCertificate() const
{
	return CaCertificate;
}

QString VpnAccountData::getNetworkDevice() const
{
	if (NetworkDevice != QString::null)
		return NetworkDevice;
	else
		return "";
}

QString VpnAccountData::getCertPath() const
{
	return CertPath;
}

VpnAccountData::AuthenticationType VpnAccountData::getAuthType() const
{
	return authtype;
}

bool VpnAccountData::getDoPingIP() const
{
	return doPingIP;
}

QString VpnAccountData::getPingHostIP() const
{
	return pingHostIP;
}

QString VpnAccountData::getPrivateKeyPass() const
{
	return PrivateKeyPass;
}

QString VpnAccountData::getPrivateKey() const
{
	return PrivateKey;
}

bool VpnAccountData::getUseSpecialRemoteID() const
{
	return useSpecialRemoteID;
}

QString VpnAccountData::getSpecialRemoteID() const
{
	return SpecialRemoteID;
}

bool VpnAccountData::getUseUdp() const
{
	return useUdp;
}

bool VpnAccountData::getUseUdpPort() const
{
	return useUdpPort;
}

int VpnAccountData::getUdpPort() const
{
	return UdpPort;
}

bool VpnAccountData::getUseDnsServer() const
{
	return useDnsServer;
}

QString VpnAccountData::getDnsServer() const
{
	return DnsServer;
}

bool VpnAccountData::getUseGetDnsFromPeer() const
{
	return useGetDnsFromPeer;
}

bool VpnAccountData::getRefuse40BitEncryption() const
{
	return refuse40BitEncryption;
}

bool VpnAccountData::getRefuse128BitEncryption() const
{
	return refuse128BitEncryption;
}

bool VpnAccountData::getAllowStatefulMode() const
{
	return allowStatefulMode;
}

bool VpnAccountData::getRequireMppe() const
{
	return requireMppe;
}

bool VpnAccountData::getRefuseEap() const
{
	return refuseEap;
}

bool VpnAccountData::getUseNoIpDefault() const
{
	return useNoIpDefault;
}

bool VpnAccountData::getDisableMPPEComp() const
{
	return disableMPPEComp;
}

bool VpnAccountData::getUseSpecialServerCertificate() const
{
	return useSpecialServerCertificate;
}

QString VpnAccountData::getSpecialServerCertificate() const
{
	return SpecialServerCertificate;
}

QString VpnAccountData::getLocalVirtualIP() const
{
	return LocalVirtualIP;
}

QString VpnAccountData::getRemoteVirtualIP() const
{
	return RemoteVirtualIP;
}

QString VpnAccountData::getPreSharedKeyFile() const
{
	return PreSharedKeyFile;
}

bool VpnAccountData::getExecuteCmdBeforeConnect() const
{
	return executeCmdBeforeConnect;
}

bool VpnAccountData::getExecuteCmdAfterConnect() const
{
	return executeCmdAfterConnect;
}

bool VpnAccountData::getExecuteCmdBeforeDisconnect() const
{
	return executeCmdBeforeDisconnect;
}

bool VpnAccountData::getExecuteCmdAfterDisconnect() const
{
	return executeCmdAfterDisconnect;
}

QString VpnAccountData::getCommandBeforeConnect() const
{
	return CommandBeforeConnect;
}

QString VpnAccountData::getCommandAfterConnect() const
{
	return CommandAfterConnect;
}

QString VpnAccountData::getCommandBeforeDisconnect() const
{
	return CommandBeforeDisconnect;
}

QString VpnAccountData::getCommandAfterDisconnect() const
{
	return CommandAfterDisconnect;
}

bool VpnAccountData::getUseNoBsdComp() const
{
	return useNoBsdComp;
}

bool VpnAccountData::getUseNoDeflate() const
{
	return useNoDeflate;
}

bool VpnAccountData::getSetDefaultRoute() const
{
	return setDefaultRoute;
}

bool VpnAccountData::getReplaceDefaultRoute() const
{
	return replaceDefaultRoute;
}

bool VpnAccountData::getUseMtu() const
{
	return useMtu;
}

int VpnAccountData::getMtu() const
{
	return Mtu;
}

bool VpnAccountData::getUseMru() const
{
	return useMru;
}

int VpnAccountData::getMru() const
{
	return Mru;
}

bool VpnAccountData::getUseVirtualIP() const
{
	return useVirtualIP;
}

QString VpnAccountData::getVirtualIP() const
{
	return VirtualIP;
}

bool VpnAccountData::getPskIsInFile() const
{
	return PskIsInFile;
}

bool VpnAccountData::getUseAdditionalNetworkRoutes() const
{
	return useAdditionalNetworkRoutes;
}

QStringList VpnAccountData::getAdditionalNetworkRoutes() const
{
	return AdditionalNetworkRoutes;
}

QString VpnAccountData::getHashAlgo() const
{
	return HashAlgo;
}

bool VpnAccountData::getUseUserdefinedPort() const
{
	return useUserdefinedPort;
}

int VpnAccountData::getUserdefinedPort() const
{
	return UserdefinedPort;
}

bool VpnAccountData::getKeepDefaultRoute() const
{
	return keepDefaultRoute;
}

QString VpnAccountData::getDescription() const
{
	return Description;
}

QString VpnAccountData::getNsCertType() const
{
	return NsCertType;
}

bool VpnAccountData::getUseNsCertType() const
{
	return useNsCertType;
}

bool VpnAccountData::getUseConnectionStatusCheck() const
{
	return useConnectionStatusCheck;
}

int VpnAccountData::getConnectionStatusCheckSuccessCount() const
{
	return connectionStatusCheckSuccessCount;
}

int VpnAccountData::getConnectionStatusInterval() const
{
	return connectionStatusInterval;
}

bool VpnAccountData::getDoReconnectAfterConnectionLost() const
{
	return doReconnectAfterConnectionLost;
}

bool VpnAccountData::getDisableLzoCompression() const
{
	return disableLzoCompression;
}

bool VpnAccountData::getAuthWithUsernameAndPassword() const
{
		return authWithUsernameAndPassword;
}

bool VpnAccountData::getAllowEmptyGroupPassword() const
{
	return allowEmptyGroupPassword;
}

bool VpnAccountData::getUseUserdefiniedCipher() const
{
	return useUserdefiniedCipher;
}

QString VpnAccountData::getUserdefiniedCipher() const
{
	return UserdefiniedCipher;
}

bool VpnAccountData::getUseRedirectGateway() const
{
	return useRedirectGateway;
}

bool VpnAccountData::getUseTlsAuth() const
{
	return useTlsAuth;
}

QString VpnAccountData::getTlsAuthFile() const
{
	return TlsAuthFile;
}

QString VpnAccountData::getHttpProxy() const
{
	return HttpProxy;
}

bool VpnAccountData::getUseHttpProxy() const
{
	return useHttpProxy;
}

int VpnAccountData::getHttpProxyPort() const
{
	return HttpProxyPort;
}

int VpnAccountData::getHttpProxyTimeout() const
{
	return HttpProxyTimeout;
}

bool VpnAccountData::getDontSaveUsername() const
{
	return dontSaveUsername;
}

bool VpnAccountData::getUseModeConfig() const
{
	return useModeConfig;
}

QString VpnAccountData::getExchangeMode() const
{
	return ExchangeMode;
}

bool VpnAccountData::getUseReconnectDelay() const
{
	return useReconnectDelay;
}

int VpnAccountData::getReconnectDelay() const
{
	return ReconnectDelay;
}

bool VpnAccountData::getUseTlsRemoteHost() const
{
	return useTlsRemoteHost;
}

QString VpnAccountData::getTlsRemoteHost() const
{
	return TlsRemoteHost;
}

QString VpnAccountData::getRightNextHop() const
{
	return RightNextHop;
}

QString VpnAccountData::getLeftNextHop() const
{
	return LeftNextHop;
}

bool VpnAccountData::getDisableOpportunisticEncryption() const
{
	return disableOpportunisticEncryption;
}

bool VpnAccountData::getUseMssfix() const
{
	return useMssfix;
}

bool VpnAccountData::getUseFragment() const
{
	return useFragment;
}

int VpnAccountData::getMssfix() const
{
	return Mssfix;
}

int VpnAccountData::getFragment() const
{
	return Fragment;
}

int VpnAccountData::getPeerTimeout() const
{
	return PeerTimeout;
}

bool VpnAccountData::getDisableCcp() const
{
	return disableCcp;
}

bool VpnAccountData::getUseSmartcard() const
{
	return useSmartcard;
}

bool VpnAccountData::getUseXauthInteractive() const
{
	return useXauthInteractive;
}

bool VpnAccountData::getSavePrivateKeyPassword() const
{
	return savePrivateKeyPassword;
}

bool VpnAccountData::getUseHttpProxyAuth() const
{
	return useHttpProxyAuth;
}

QString VpnAccountData::getHttpProxyAuthType() const
{
	return HttpProxyAuthType;
}

QString VpnAccountData::getHttpProxyUser() const
{
	return HttpProxyUser;
}

QString VpnAccountData::getHttpProxyPass() const
{
	return HttpProxyPass;
}

bool VpnAccountData::getUseOnlyCaCertAndUserAuth() const
{
	return useOnlyCaCertAndUserAuth;
}

bool VpnAccountData::getUseMailAddressAsIdentifier() const
{
	return useMailAddressAsIdentifier;
}

bool VpnAccountData::getUseRightNextHop() const
{
	return useRightNextHop;
}

bool VpnAccountData::getUseLeftNextHop() const
{
	return useLeftNextHop;
}

QString VpnAccountData::getPkcs11Providers() const
{
	return Pkcs11Providers;
}

QString VpnAccountData::getPkcs11SlotType() const
{
	return Pkcs11SlotType;
}

QString VpnAccountData::getPkcs11Slot() const
{
	return Pkcs11Slot;
}

QString VpnAccountData::getPkcs11IdType() const
{
	return Pkcs11IdType;
}

QString VpnAccountData::getPkcs11Id() const
{
	return Pkcs11Id;
}

QString VpnAccountData::getPkcs11SignMode() const
{
	return Pkcs11SignMode;
}

bool VpnAccountData::getUsePkcs11Providers() const
{
	return usePkcs11Providers;
}

bool VpnAccountData::getAllowEmptyPrivateKeyPassword() const
{
	return allowEmptyPrivateKeyPassword;
}

bool VpnAccountData::getAllowIpAddressChangeOfPeer() const
{
	return allowIpAddressChangeOfPeer;
}

QString VpnAccountData::getAuthMethod() const
{
	return AuthMethod;
}

int VpnAccountData::getCommandAfterConnectDelayTime() const
{
	return CommandAfterConnectDelayTime;
}

/* set methods */
void VpnAccountData::setConnectionType( ConnectionType type )
{
	this->connectiontype = type;
}

void VpnAccountData::setName( const QString &Name )
{
	this->Name = Name;
}

void VpnAccountData::setGateway( const QString &Gateway )
{
	this->Gateway = Gateway;
}

void VpnAccountData::setID( const QString &ID )
{
	this->ID = ID;
}

void VpnAccountData::setUserName( const QString &Username )
{
	this->Username = Username;
}

void VpnAccountData::setUserPassword( const QString& UserPassword )
{
	this->UserPassword = UserPassword;
}

void VpnAccountData::setSaveUserPassword( bool saveUserPassword )
{
	this->saveUserPassword = saveUserPassword;
}

void VpnAccountData::setSavePsk( bool savePsk )
{
	this->savePsk = savePsk;
}

void VpnAccountData::setIkeGroup( const QString &IkeGroup )
{
	this->IkeGroup = IkeGroup;
}

void VpnAccountData::setEncryptionAlgorithm( const QString &EncryptionAlgorithm )
{
	this->EncryptionAlgorithm = EncryptionAlgorithm;
}

void VpnAccountData::setAuthenticationAlgorithm( const QString &AuthenticationAlgorithm)
{
	this->AuthenticationAlgorithm= AuthenticationAlgorithm;
}

void VpnAccountData::setPerfectForwardSecrety( const QString &PerfectForwardSecrecy )
{
	this->PerfectForwardSecrecy = PerfectForwardSecrecy;
}

void VpnAccountData::setNtDomainName( const QString& Name )
{
	this->NtDomainName = Name;
}

void VpnAccountData::setApplicationVersion( const QString& version )
{
	this->ApplicationVersion = version;
}

void VpnAccountData::setUseSingleDes( bool useSingleDes )
{
	this->useSingleDes = useSingleDes;
}

void VpnAccountData::setUseIkeGroup( bool useIkeGroup )
{
	this->useIkeGroup = useIkeGroup;
}

void VpnAccountData::setUsePerfectForwardSecrety( bool usePerfectForwardSecrety )
{
	this->usePerfectForwardSecrety = usePerfectForwardSecrety;
}

void VpnAccountData::setUseNtDomainName( bool useNtDomainName )
{
	this->useNtDomainName = useNtDomainName;
}

void VpnAccountData::setUseApplicationVersion( bool useApplicationVersion )
{
	this->useApplicationVersion = useApplicationVersion;
}

void VpnAccountData::setUseLocalPort( bool useLocalPort )
{
	this->useLocalPort = useLocalPort;
}

void VpnAccountData::setUseRemotePort( bool useRemotePort )
{
	this->useRemotePort = useRemotePort;
}

void VpnAccountData::setUseAdvancedSettings( bool useAdvancedSettings )
{
	this->useAdvancedSettings = useAdvancedSettings;
}

void VpnAccountData::setUseGlobalIpsecSecret( bool useGlobalIpsecSecret )
{
	this->useGlobalIpsecSecret = useGlobalIpsecSecret;
}

void VpnAccountData::setLocalPort( int port )
{
	this->LocalPort = port;
}

void VpnAccountData::setRemotePort( int port )
{
	this->RemotePort = port;
}

void VpnAccountData::setRemoteNetAddr( const QString& RemoteNetAddr )
{
	this->RemoteNetAddr = RemoteNetAddr;
}

void VpnAccountData::setRemoteNetMask( const QString& RemoteNetMask )
{
	this->RemoteNetMask = RemoteNetMask;
}

void VpnAccountData::setPreSharedKey( const QString& PreSharedKey )
{
	this->PreSharedKey = PreSharedKey;
}

void VpnAccountData::setX509Certificate( const QString& x509Certificate )
{
	this->x509Certificate = x509Certificate;
}

void VpnAccountData::setCaCertificate( const QString& CaCertificate )
{
	this->CaCertificate = CaCertificate;
}

void VpnAccountData::setNetworkDevice( const QString& NetworkDevice )
{
	this->NetworkDevice = NetworkDevice;
}

void VpnAccountData::setCertPath( const QString& CertPath )
{
	this->CertPath = CertPath;
}

void VpnAccountData::setAuthType( VpnAccountData::AuthenticationType authtype )
{
	this->authtype = authtype;
}

void VpnAccountData::setDoPingIP(bool doPingIP)
{
	this->doPingIP=doPingIP;
}

void VpnAccountData::setPingHostIP(const QString& pingHostIP)
{
	this->pingHostIP = pingHostIP;
}

void VpnAccountData::setPrivateKeyPass(const QString& PrivateKeyPass)
{
	this->PrivateKeyPass = PrivateKeyPass;
}

void VpnAccountData::setPrivateKey(const QString& PrivateKey)
{
	this->PrivateKey = PrivateKey;
}

void VpnAccountData::setUseSpecialRemoteID(bool useSpecialRemoteID)
{
	this->useSpecialRemoteID = useSpecialRemoteID;
}

void VpnAccountData::setSpecialRemoteID(const QString& SpecialRemoteID)
{
	this->SpecialRemoteID = SpecialRemoteID;
}

void VpnAccountData::setUseUdp(bool useUdp)
{
	this->useUdp = useUdp;
}

void VpnAccountData::setUseUdpPort(bool useUdpPort)
{
	this->useUdpPort = useUdpPort;
}

void VpnAccountData::setUdpPort(int UdpPort)
{
	this->UdpPort = UdpPort;
}

void VpnAccountData::setUseDnsServer(bool useDnsServer )
{
	this->useDnsServer = useDnsServer;
}

void VpnAccountData::setDnsServer(const QString& DnsServer )
{
	this->DnsServer = DnsServer;
}

void VpnAccountData::setUseGetDnsFromPeer(bool useGetDnsFromPeer )
{
	this->useGetDnsFromPeer = useGetDnsFromPeer;
}

void VpnAccountData::setRefuse40BitEncryption(bool refuse40BitEncryption )
{
	this->refuse40BitEncryption = refuse40BitEncryption;
}

void VpnAccountData::setRefuse128BitEncryption(bool refuse128BitEncryption )
{
	this->refuse128BitEncryption = refuse128BitEncryption;
}

void VpnAccountData::setAllowStatefulMode(bool allowStatefulMode )
{
	this->allowStatefulMode = allowStatefulMode;
}

void VpnAccountData::setRequireMppe(bool requireMppe )
{
	this->requireMppe = requireMppe;
}

void VpnAccountData::setRefuseEap(bool refuseEap )
{
	this->refuseEap = refuseEap;
}

void VpnAccountData::setUseNoIpDefault(bool useNoIpDefault )
{
	this->useNoIpDefault = useNoIpDefault;
}

void VpnAccountData::setDisableMPPEComp(bool disableMPPEComp )
{
	this->disableMPPEComp = disableMPPEComp;
}

void VpnAccountData::setLocalVirtualIP( const QString& LocalVirtualIP )
{
	this->LocalVirtualIP = LocalVirtualIP;
}

void VpnAccountData::setRemoteVirtualIP( const QString& RemoteVirtualIP )
{
	this->RemoteVirtualIP = RemoteVirtualIP;
}

void VpnAccountData::setPreSharedKeyFile( const QString& PreSharedKeyFile)
{
	this->PreSharedKeyFile = PreSharedKeyFile;
}

void VpnAccountData::setExecuteCmdBeforeConnect(bool executeCmdBeforeConnect)
{
	this->executeCmdBeforeConnect = executeCmdBeforeConnect;
}

void VpnAccountData::setExecuteCmdAfterConnect(bool executeCmdAfterConnect)
{
	this->executeCmdAfterConnect = executeCmdAfterConnect;
}

void VpnAccountData::setExecuteCmdBeforeDisconnect( bool executeCmdBeforeDisconnect)
{
	this->executeCmdBeforeDisconnect = executeCmdBeforeDisconnect;
}

void VpnAccountData::setExecuteCmdAfterDisconnect( bool executeCmdAfterDisconnect)
{
	this->executeCmdAfterDisconnect = executeCmdAfterDisconnect;
}

void VpnAccountData::setCommandBeforeConnect(const QString& CommandBeforeConnect)
{
	this->CommandBeforeConnect = CommandBeforeConnect;
}

void VpnAccountData::setCommandAfterConnect(const QString& CommandAfterConnect)
{
	this->CommandAfterConnect = CommandAfterConnect;
}

void VpnAccountData::setCommandBeforeDisconnect(const QString& CommandBeforeDisconnect)
{
	this->CommandBeforeDisconnect = CommandBeforeDisconnect;
}

void VpnAccountData::setCommandAfterDisconnect(const QString& CommandAfterDisconnect)
{
	this->CommandAfterDisconnect = CommandAfterDisconnect;
}

void VpnAccountData::setUseNoBsdComp(bool useNoBsdComp)
{
	this->useNoBsdComp = useNoBsdComp;
}

void VpnAccountData::setUseNoDeflate(bool useNoDeflate)
{
	this->useNoDeflate = useNoDeflate;
}

void VpnAccountData::setSetDefaultRoute(bool setDefaultRoute)
{
	this->setDefaultRoute = setDefaultRoute;
}

void VpnAccountData::setReplaceDefaultRoute(bool replaceDefaultRoute)
{
	this->replaceDefaultRoute = replaceDefaultRoute;
}

void VpnAccountData::setUseMtu(bool useMtu)
{
	this->useMtu = useMtu;
}

void VpnAccountData::setMtu(int Mtu)
{
	this->Mtu = Mtu;
}

void VpnAccountData::setUseMru(bool useMru)
{
	this->useMru = useMru;
}

void VpnAccountData::setMru(int Mru)
{
	this->Mru = Mru;
}


void VpnAccountData::setUseVirtualIP(bool useVirtualIP )
{
	this->useVirtualIP = useVirtualIP;
}

void VpnAccountData::setVirtualIP(const QString& VirtualIP )
{
	this->VirtualIP = VirtualIP;
}

void VpnAccountData::setPskIsInFile(bool PskIsInFile)
{
	this->PskIsInFile = PskIsInFile;
}

void VpnAccountData::setUseAdditionalNetworkRoutes( bool useAdditionalNetworkRoutes )
{
	this->useAdditionalNetworkRoutes  = useAdditionalNetworkRoutes;
}

void VpnAccountData::setAdditionalNetworkRoutes( QStringList AdditionalNetworkRoutes )
{
	this->AdditionalNetworkRoutes = AdditionalNetworkRoutes;
}

void VpnAccountData::setUseSpecialServerCertificate(bool useSpecialServerCertificate)
{
	this->useSpecialServerCertificate = useSpecialServerCertificate;
}

void VpnAccountData::setSpecialServerCertificate(const QString& SpecialServerCertificate)
{
	this->SpecialServerCertificate = SpecialServerCertificate;
}

void VpnAccountData::setHashAlgo(const QString& HashAlgo)
{
	this->HashAlgo = HashAlgo;
}

void VpnAccountData::setTunnelDeviceType(const QString& TunnelDeviceType)
{
	this->TunnelDeviceType = TunnelDeviceType;
}

void VpnAccountData::setUseUserdefinedPort(bool useUserdefinedPort)
{
	this->useUserdefinedPort = useUserdefinedPort;
}

void VpnAccountData::setUserdefinedPort(int UserdefinedPort)
{
	this->UserdefinedPort = UserdefinedPort;
}

void VpnAccountData::setKeepDefaultRoute(bool keepDefaultRoute)
{
	this->keepDefaultRoute = keepDefaultRoute;
}

void VpnAccountData::setDescription(const QString& Description)
{
	this->Description = Description;
}

void VpnAccountData::setNsCertType(const QString& NsCertType)
{
	this->NsCertType = NsCertType;
}

void VpnAccountData::setUseNsCertType(bool useNsCertType)
{
	this->useNsCertType = useNsCertType;
}

void VpnAccountData::setUseConnectionStatusCheck(bool useConnectionStatusCheck)
{
	this->useConnectionStatusCheck=useConnectionStatusCheck;
}

void VpnAccountData::setConnectionStatusCheckSuccessCount(int connectionStatusCheckSuccessCount)
{
	this->connectionStatusCheckSuccessCount=connectionStatusCheckSuccessCount;
}

void VpnAccountData::setConnectionStatusInterval(int connectionStatusInterval)
{
	this->connectionStatusInterval=connectionStatusInterval;
}

void VpnAccountData::setDoReconnectAfterConnectionLost( bool doReconnectAfterConnectionLost )
{
	this->doReconnectAfterConnectionLost = doReconnectAfterConnectionLost;
}

void VpnAccountData::setDisableLzoCompression(bool disableLzoCompression )
{
	this->disableLzoCompression = disableLzoCompression;
}

void VpnAccountData::setAuthWithUsernameAndPassword(bool authWithUsernameAndPassword )
{
		this->authWithUsernameAndPassword = authWithUsernameAndPassword;
}

void VpnAccountData::setAllowEmptyGroupPassword( bool allowEmptyGroupPassword )
{
	this->allowEmptyGroupPassword = allowEmptyGroupPassword;
}

void VpnAccountData::setUseUserdefiniedCipher( bool useUserdefiniedCipher )
{
	this->useUserdefiniedCipher = useUserdefiniedCipher;
}

void VpnAccountData::setUserdefiniedCipher( QString UserdefiniedCipher )
{
	this->UserdefiniedCipher = UserdefiniedCipher;
}

void VpnAccountData::setUseRedirectGateway( bool useRedirectGateway )
{
	this->useRedirectGateway = useRedirectGateway;
}

void VpnAccountData::setUseTlsAuth( bool useTlsAuth )
{
	this->useTlsAuth = useTlsAuth;
}

void VpnAccountData::setTlsAuthFile( QString TlsAuthFile )
{
	this->TlsAuthFile = TlsAuthFile;
}

void VpnAccountData::setHttpProxy( QString HttpProxy )
{
	this->HttpProxy = HttpProxy;
}

void VpnAccountData::setUseHttpProxy( bool useHttpProxy )
{
	this->useHttpProxy = useHttpProxy;
}

void VpnAccountData::setHttpProxyPort( int HttpProxyPort )
{
	this->HttpProxyPort = HttpProxyPort;
}

void VpnAccountData::setHttpProxyTimeout( int HttpProxyTimeout )
{
	this->HttpProxyTimeout = HttpProxyTimeout;
}

void VpnAccountData::setDontSaveUsername( bool dontSaveUsername)
{
	this->dontSaveUsername = dontSaveUsername;
}

void VpnAccountData::setUseModeConfig( bool useModeConfig)
{
	this->useModeConfig = useModeConfig;
}

void VpnAccountData::setExchangeMode( QString ExchangeMode )
{
	this->ExchangeMode  = ExchangeMode;
}

void VpnAccountData::setUseReconnectDelay( bool useReconnectDelay )
{
	this->useReconnectDelay = useReconnectDelay;
}

void VpnAccountData::setReconnectDelay( int ReconnectDelay )
{
	this->ReconnectDelay = ReconnectDelay;
}

void VpnAccountData::setUseTlsRemoteHost( bool useTlsRemoteHost )
{
	this->useTlsRemoteHost = useTlsRemoteHost;
}

void VpnAccountData::setTlsRemoteHost( QString TlsRemoteHost )
{
	this->TlsRemoteHost = TlsRemoteHost;
}

void VpnAccountData::setRightNextHop( QString RightNextHop )
{
	this->RightNextHop = RightNextHop;
}

void VpnAccountData::setLeftNextHop( QString LeftNextHop )
{
	this->LeftNextHop = LeftNextHop;
}

 void VpnAccountData::setDisableOpportunisticEncryption( bool disableOpportunisticEncryption )
{
	this->disableOpportunisticEncryption = disableOpportunisticEncryption;
}

 void VpnAccountData::setUseMssfix( bool useMssfix )
{
	this->useMssfix = useMssfix;
}

 void VpnAccountData::setUseFragment(  bool useFragment)
{
	this->useFragment = useFragment;
}

 void VpnAccountData::setMssfix(  int Mssfix)
{
	this->Mssfix = Mssfix;
}

 void VpnAccountData::setFragment(  int Fragment)
{
	this->Fragment = Fragment;
}

void VpnAccountData::setPeerTimeout( int PeerTimeout )
{
	this->PeerTimeout = PeerTimeout;
}

void VpnAccountData::setDisableCcp( bool disableCcp )
{
	this->disableCcp = disableCcp;
}

void VpnAccountData::setUseSmartcard( bool useSmartcard)
{
	this->useSmartcard = useSmartcard;
}

void VpnAccountData::setUseXauthInteractive( bool useXauthInteractive)
{
	this->useXauthInteractive = useXauthInteractive;
}

void VpnAccountData::setSavePrivateKeyPassword( bool savePrivateKeyPassword)
{
	this->savePrivateKeyPassword = savePrivateKeyPassword;
}

void VpnAccountData::setUseHttpProxyAuth( bool useHttpProxyAuth )
{
	this->useHttpProxyAuth = useHttpProxyAuth;
}

void VpnAccountData::setHttpProxyAuthType(QString HttpProxyAuthType)
{
	this->HttpProxyAuthType = HttpProxyAuthType;
}

void VpnAccountData::setHttpProxyUser(QString HttpProxyUser)
{
	this->HttpProxyUser = HttpProxyUser;
}

void VpnAccountData::setHttpProxyPass( QString HttpProxyPass )
{
	this->HttpProxyPass = HttpProxyPass;
}

void VpnAccountData::setUseOnlyCaCertAndUserAuth(bool useOnlyCaCertAndUserAuth)
{
	this->useOnlyCaCertAndUserAuth = useOnlyCaCertAndUserAuth;
}

void VpnAccountData::setUseMailAddressAsIdentifier(bool useMailAddressAsIdentifier )
{
	this->useMailAddressAsIdentifier = useMailAddressAsIdentifier;
}

void VpnAccountData::setUseRightNextHop( bool useRightNextHop )
{
	this->useRightNextHop = useRightNextHop;
}

void VpnAccountData::setUseLeftNextHop( bool useLeftNextHop )
{
	this->useLeftNextHop = useLeftNextHop;
}

void VpnAccountData::setPkcs11Providers( QString Pkcs11Providers)
{
	this->Pkcs11Providers = Pkcs11Providers;
}

void VpnAccountData::setPkcs11SlotType(QString Pkcs11SlotType)
{
	this->Pkcs11SlotType = Pkcs11SlotType;
}

void VpnAccountData::setPkcs11Slot(QString Pkcs11Slot)
{
	this->Pkcs11Slot = Pkcs11Slot;
}

void VpnAccountData::setPkcs11IdType(QString Pkcs11IdType)
{
	this->Pkcs11IdType = Pkcs11IdType;
}

void VpnAccountData::setPkcs11Id(QString Pkcs11Id)
{
	this->Pkcs11Id = Pkcs11Id;
}

void VpnAccountData::setPkcs11SignMode(QString Pkcs11SignMode)
{
	this->Pkcs11SignMode = Pkcs11SignMode;
}

void VpnAccountData::setUsePkcs11Providers(bool usePkcs11Providers)
{
	this->usePkcs11Providers = usePkcs11Providers;
}

void VpnAccountData::setAllowEmptyPrivateKeyPassword( bool allowEmptyPrivateKeyPassword)
{
	this->allowEmptyPrivateKeyPassword = allowEmptyPrivateKeyPassword;
}

void VpnAccountData::setAllowIpAddressChangeOfPeer( bool allowIpAddressChangeOfPeer )
{
	this->allowIpAddressChangeOfPeer = allowIpAddressChangeOfPeer;
}

void VpnAccountData::setAuthMethod( QString AuthMethod )
{
	this->AuthMethod = AuthMethod;
}

void VpnAccountData::setCommandAfterConnectDelayTime( int CommandAfterConnectDelayTime)
{
	this->CommandAfterConnectDelayTime = CommandAfterConnectDelayTime;
}

