/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN INCLUDES
#include <kmessagebox.h>
#include <kio/netaccess.h>
#include <ktempfile.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <qfile.h>
#include <qurl.h>
#include <kurl.h>
#include <qtextstream.h>
#include <qcheckbox.h>

#include <iostream>

#include "importprofiledialog.h"
#include "utils.h"
//END INCLUDES

ImportProfileDialog::ImportProfileDialog(QWidget *parent, const QString& caption)
		: KDialogBase( parent, i18n("Import Cisco PCF profile:"), true, caption,
		               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{

	decodeEncPasswd = false;
	filename = "";
	importOk = false;

	main = new ImportProfileDialogBase(this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());

	main->FilenameUrlrequester->setFilter( "*.pcf" );

}


ImportProfileDialog::~ImportProfileDialog()
{}

void ImportProfileDialog::accept()
{

	//filename="/etc/CiscoSystemsVPNClient/Profiles/hs_harz.pcf";
	filename = main->FilenameUrlrequester->url();
	if ( !filename.isEmpty() )
		canAccept();

	else
	{
		KMessageBox::sorry( 0, i18n( "Filename can not be empty!" ), i18n( "Empty filename" ) );
	}
}


void ImportProfileDialog::canAccept()
{
	decodeEncPasswd = main->DecodePresharedSecretcheckbox->isChecked();



	QFile f( filename );
	if ( !f.exists() )
	{
		KMessageBox::information( 0, i18n( "File not found." ), i18n( "No file" ) );

		//		emit progress( 100 );
		return ;
	}

	KConfig config( filename, true, false );
	config.setGroup( "main" );

	// sample config

	/*
	[main]
	Description=
	Host=192.168.13.1
	AuthType=1 // nur auslesen 
	GroupName = hs_harz
	GroupPwd =
	Username = u15119
	SaveUserPassword = 0
	UserPassword =
	NTDomain =
	EnableBackup = 0
	BackupServer =
	EnableMSLogon = 1
	TunnelingMode = 0
	TcpTunnelingPort = 10000
	CertStore = 0
	CertName =
	CertPath =
	CertSubjectName =
	CertSerialHash = 00000000000000000000000000000000
	SendCertChain = 0
	VerifyCertDN =
	DHGroup = 2
	ForceKeepAlives = 0
	PeerTimeout = 90
	EnableLocalLAN = 1 // only reading because we dont want to do this
	EnableSplitDNS = 1

	// cert is not supported yet by vpnc: not action taken
	CertStore=1
	CertName=VPN Client
	VerifyCertDn=CN="vpn.uni-jena.de", OU="Computer Center", O="University Jena", C="DE"
	SendCertChain=1

	*/
	QString Description = config.readEntry( "Description", "" );
	QString Gateway = config.readEntry( "Host", "" );
	//	int AuthType = config.readNumEntry( "AuthType" , -1 );
	QString GroupName = config.readEntry( "GroupName" , "" );
	QString GroupPwd = config.readEntry( "GroupPwd" , "" );
	QString enc_GroupPwd = config.readEntry( "enc_GroupPwd", "" );
	QString Username = config.readEntry( "Username" , "" );
	bool saveUserPassword = config.readBoolEntry( "SaveUserPassword", FALSE );
	QString UserPassword = config.readEntry( "UserPassword", "" );
	QString NtDomain = config.readEntry( "NTDomain" );
	//	bool enableBackup = config.readBoolEntry( "EnableBackup" , FALSE );
	QString BackupServer = config.readEntry( "BackupServer", "" );
	bool enableMSLogon = config.readBoolEntry( "EnableMSLogon", FALSE );
	//	int TunnelingMode = config.readNumEntry( "TunnelingMode", -1 );
	int TunnelingPort = config.readNumEntry( "TcpTunnelingPort", -1 ); //std::cout << "tunneling port: " << TunnelingPort << std::endl;
	//	int CertStore = config.readNumEntry( "CertStore", -1 );
	QString CertName = config.readEntry( "CertName", "" );
	QString CertPath = config.readEntry( "CertPath", "" );
	QString CertSubjectName = config.readEntry( "CertSubjectName", "" );
	QString CertSerialHash = config.readEntry( "CertSerialHash", "" );
	//	bool SendCertChain = config.readBoolEntry( "SendCertChain" , "" );
	//	bool VerifyCertDN = config.readBoolEntry( "VerifyCertDN", FALSE );
	int DHGroup = config.readNumEntry( "DHGroup", -1 );
	//	bool ForceKeepAlives = config.readBoolEntry( "ForceKeepAlives", FALSE );
	//	int PeerTimeout = config.readNumEntry( "PeerTimeout", -1 );
	//	bool EnableLocalLAN = config.readBoolEntry( "EnableLocalLAN", FALSE ); // nur auslesen aber immer aus :)
	//	bool EnableSplitDNS = config.readBoolEntry( "EnableSplitDNS", FALSE );

	bool useUdp;
	if ( config.readNumEntry ("EnableNat",0) == 1)
		useUdp=true;
	else
		useUdp=false;
	bool saveGroupPwd = true;
	bool usePerfectSecrecy = false;
	bool useSingleDes = false;
	bool useLocalPort = false;

	bool useNtDomainName = false;
	if ( enableMSLogon && !NtDomain.isEmpty() )
		useNtDomainName = true;

	if ( TunnelingPort != -1 )
		useLocalPort = true;

	bool useIkeGroup = false;
	QString IkeGroup;
	if (DHGroup != -1 ) {
 		IkeGroup =  "dh" + QString().setNum( DHGroup ) ;
		useIkeGroup = true;
	}
	
	QString PerfectForwardSecrecy = ""; //QString("dh"+QString().setNum(DHGroup));
	//	bool usePerfectForwardSecrety = false;


	if ( decodeEncPasswd )
	{
		GroupPwd = downloadDecPasswd( enc_GroupPwd );
	}

	if ( GroupPwd.isEmpty() )
		saveGroupPwd = false;

	if ( Description.isEmpty() )
	{
		Description = ( QUrl( filename ).fileName() );
		Description = Utils().removeSpecialCharsForFilename( Description.left( Description.length() - 4 ));
	}

	bool useApplicationVersion = false;
	bool useGlobalIpsecSecret = false;

	VpnAccountData::ConnectionType ConnType = VpnAccountData::cisco;

	acc = new VpnAccountData ( ConnType, GroupName );
	acc->setDescription( Description );
	acc->setGateway( Gateway );
	acc->setID( GroupName );
	acc->setPreSharedKey( GroupPwd );
	acc->setUserName( Username );
	acc->setUserPassword( UserPassword );
	acc->setSaveUserPassword( saveUserPassword );
	acc->setSavePsk( saveGroupPwd );
	acc->setNtDomainName(	NtDomain );
	acc->setPerfectForwardSecrety( PerfectForwardSecrecy );
	acc->setIkeGroup( IkeGroup );
	acc->setUseApplicationVersion( useApplicationVersion );
	acc->setUseGlobalIpsecSecret( useGlobalIpsecSecret );
	acc->setUseIkeGroup( useIkeGroup );
	acc->setUseLocalPort( useLocalPort );
	acc->setNtDomainName( NtDomain );
	acc->setUseSingleDes( useSingleDes );
	//acc->setUseAdvancedSettings( useAdvancedSettings );
	acc->setUseAdvancedSettings( true );
	acc->setUsePerfectForwardSecrety( usePerfectSecrecy );
	acc->setUseUdp( useUdp );

	if (useLocalPort){
		acc->setLocalPort(TunnelingPort);
		acc->setUseLocalPort(true);
	}


	/*
	std::cout << Description
	std::cout << Gateway
	std::cout << AuthType
	std::cout << GroupName
	std::cout << GroupPwd
	std::cout << enc_GroupPwd
	std::cout << Username
	std::cout << saveUserPassword
	std::cout << UserPassword
	std::cout << NtDomain
	std::cout << bool enableBackup
	std::cout << BackupServer
	std::cout << bool enableMSLogon
	std::cout << TunnelingMode
	std::cout << TunnelingPort
	std::cout << CertStore
	std::cout << CertName
	std::cout << CertPath
	std::cout << CertSubjectName
	std::cout << CertSerialHash
	std::cout << SendCertChain
	std::cout << VerifyCertDN
	std::cout << DHGroup
	std::cout << ForceKeepAlives
	std::cout << PeerTimeout
	std::cout << EnableLocalLAN
	std::cout << EnableSplitDNS
	std::cout << saveGroupPwd
	std::cout << usePerfectSecrecy
	std::cout << useSingleDes
	std::cout << useLocalPort
	std::cout << useNtDomainName
	std::cout << useLocalPort
	std::cout << IkeGroup
	std::cout << PerfectForwardSecrecy
	std::cout << useAdvancedSettings
	*/
	/*
	acc.setName( Description );
	acc.setGateway( Gateway );
	acc.setID( GroupName );
	acc.setGroupPassword( GroupPwd );
	acc.setUserName( Username );
	acc.setUserPassword( UserPassword );
	acc.setSaveUserPassword( saveUserPassword );
	acc.setSaveGroupPassword( true );
	//acc.setIkeGroup( QString IkeGroup );
	acc.setPerfectForwardSecrety( QString PerfectForwardSecrecy );
	acc.setNtDomainName( QString Name );
	acc.setApplicationVersion( QString version );
	acc.setUseSingleDes( bool useSingleDes );
	acc.setLocalPort( int port );
	acc.setUseIkeGroup( bool useIkeGroup);
	acc.setUsePerfectForwardSecrety(bool usePerfectForwardSecrety);
	acc.setUseNtDomainName(bool useNtDomainName);
	acc.setUseApplicationVersion(bool useApplicationVersion);
	acc.setUseLocalPort(bool useLocalPort);
	acc.setUseAdvancedSettings(bool useAdvancedSettings);
	acc.setUseGlobalIpsecSecret(bool useGlobalIpsecSecret);
	*/
	importOk = true;
	//std::cout << "accept" << std::endl;
	QDialog::accept();
}

QString ImportProfileDialog::downloadDecPasswd( QString enc )
{
	QString msg = "enc: " + enc + ", dec: ";
	KURL url ( "http://www.unix-ag.uni-kl.de/~massar/bin/cisco-decode?enc=" + enc );
	QString dec = "";
	QString tmpFile = KTempFile().name();
	if ( KIO::NetAccess::download( url, tmpFile , NULL) )
	{
		QFile f;
		f.setName( tmpFile );
		if ( f.open( IO_ReadOnly ) )
		{
			QTextStream stream( &f );
			QString line = "";
			while ( !stream.atEnd() )
			{
				line = stream.readLine(); // line of text excluding '\n'
				if ( line.contains( "clear" ) )
				{
					dec = line.section( ':',1 ).right(line.section( ':',1 ).length()-1);
					int idx = dec.find( '<' );
					dec = dec.left( idx );
					msg += dec;
					//std::cout << msg << "\n";
					break;
				}
			}
			f.close();

			return Utils().decodeHtml(dec);
		}
		else
		{
			KMessageBox::sorry( 0, i18n("Read failed."), i18n("Reading downloaded file failed.") );
			return "";
		}
		KIO::NetAccess::removeTempFile( tmpFile );
	}
	else
	{
		KMessageBox::sorry( 0, i18n("Download failed."), i18n("Download failed.") );
		return "";
	}
}

