/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include <qtooltip.h>
#include <qimage.h>
#include <klocale.h>
#include <kiconloader.h>
#include "kvpnckicker.h"

KVpncKicker::KVpncKicker( QWidget* parent, const char *name )
		: KSystemTray( parent, name ) {
	this->parent = parent;
	this->initDockWindow();
		
	show();
}

KVpncKicker::~KVpncKicker() {}

void KVpncKicker::setStatus( int status ) {
	if ( status == connecting ) {
		setPixmap( connectingIcon );
	}
	else if (status ==  connected){
		setPixmap( connectedIcon );
	}
	else
		setPixmap( disconnectedIcon );
}

void KVpncKicker::initDockWindow() {
	disconnectedIcon = loadIcon( "kvpnc-disconnected");
	connectedIcon = loadIcon( "kvpnc-connected"  );
	connectingIcon = loadIcon( "kvpnc-connecting" );
	//setFixedSize( DOCK_WIDTH, DOCK_HEIGHT );
	setPixmap( disconnectedIcon );
	QToolTip::add(this, i18n("Disconnected"));
}

KPopupMenu* KVpncKicker::menu() {
	return contextMenu();
}

#include "kvpnckicker.moc"
