/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "logviewerdialog.h"
#include <klocale.h>
#include <klistview.h>
#include <qpixmap.h>
#include <kglobal.h>
#include <qstring.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <ktextbrowser.h>
#include <iostream>
#include <kvpnc.h>
#include <qfile.h>
#include <qtextstream.h>

LogViewerDialog::LogViewerDialog(QWidget *parent, const QString& caption) : KDialogBase( parent, i18n("Show log"), false, caption,
		KDialogBase::Ok|KDialogBase::Cancel,KDialogBase::Ok, true )
{
	main = new LogViewerDialogBase (this);
	setMainWidget(main);
//	main->setMinimumSize(main->sizeHint());
	main->setMinimumSize(400,300);

// 	QPixmap info_icon = KGlobal::iconLoader()->loadIcon( "button_ok", KIcon::NoGroup, 16 );
// 	QPixmap debug_icon = KGlobal::iconLoader()->loadIcon( "button_cancel", KIcon::NoGroup, 16 );
// 	QPixmap error_icon = KGlobal::iconLoader()->loadIcon( "button_ok", KIcon::NoGroup, 16 );
// 	QPixmap debug_icon = KGlobal::iconLoader()->loadIcon( "button_cancel", KIcon::NoGroup, 16 );

//	InfoListView->setSorting(1);
	KStandardDirs *dirs = KGlobal::dirs();
	QString logfileName = dirs->saveLocation( "data" );
	logfileName += "/kvpnc/kvpnc.log";
	QFile logfile;
	//std::cout << "file exists: " << logfile.exists() << std::endl;
	logfile.setName( logfileName );
	logfile.open(IO_ReadOnly );
	QString Log= QString(logfile.readAll());
	main->LogTextBrowser->setText( Log );
	logfile.close();
}


LogViewerDialog::~LogViewerDialog()
{}

void LogViewerDialog::accept()
{
	QDialog::accept();
}

