/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "networkinterface.h"
#include <iostream>
#include <qfile.h>
#include <qtextstream.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <qnetwork.h>
#include <qurloperator.h>

NetworkInterface::NetworkInterface( QApplication *app, QObject *parent, const char *name ) : QObject( parent, name )
{

	this->app = app;
	interfaceTest = false;
	retrieveAllNetworkInterfaces = false;
	retrieveInterfaceIP = false;
	retrieveInterfaceAddress = false;
	retrieveDefaultInterface = false;
	QPtrList<QString>*InterfaceList = new QPtrList<QString>();
	InterfaceList->setAutoDelete( TRUE ); // the list owns the objects
	QString InterfaceIP = "";
	QString InterfaceAddress = "";
	IPforInterface = "";
	tmpInterface = "";
	interfaceExists = false;
	ifconfigbin = "/sbin/ifconfig";
	routebin = "/sbin/route";
	defaultinterface="default";
	readOutput=false;
	env = new QStringList();
	*env << "LC_ALL=C" << "LANG=C";
}


NetworkInterface::~NetworkInterface()
{
	//delete proc;
	if (defaultinterface == "default")
		defaultinterface == "";
}

bool NetworkInterface::interfaceExist( QString Interface )
{
	if ( !Interface.isEmpty() )
	{

		proc = new QProcess (this);
		proc->addArgument( ifconfigbin );
		proc->addArgument( Interface );

		connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

		interfaceTest = true;

		if ( !proc->start() )
		{
			std::cerr << "unable to start proc(ifconfig)!" << std::endl;
		}
	}
	while ( interfaceTest == true && proc->isRunning() )
		app->processEvents();

	disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return interfaceExists;
}


QStringList NetworkInterface::getAllNetworkInterfaces()
{

	proc = new QProcess(this);
	proc->addArgument( ifconfigbin );

	retrieveAllNetworkInterfaces = true;

	connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

	if ( !proc->start() )
	{
		std::cerr << "unable to start proc(ifconfig)!" << std::endl;
	}

	while ( retrieveAllNetworkInterfaces && proc->isRunning() )
		app->processEvents();


	disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return InterfaceList;
}


QString NetworkInterface::getInterfaceIP( QString Interface )
{
	if ( !Interface.isEmpty() )
	{
		tmpfile = new KTempFile();

		QString tmpPath = locateLocal ( "data", "kvpnc/" );
		QString GetInterfaceIpScript = tmpPath + "get_interface_ip_"+Interface+".sh";

		QFile file ( GetInterfaceIpScript );
		QTextStream stream( &file );
		if ( file.open( IO_WriteOnly ) )
		{
			stream << "# generated by kvpnc. Do not edit it." << "\n";
			stream << "\n";
			stream << ifconfigbin +" | grep -A1 "+Interface+" | tail -n1| awk {'print $2'} | sed -e \"s/.*://\" > "+ tmpfile->name()+"\n";
			file.close();
		}


		proc = new QProcess(this);
		proc->addArgument( "/bin/sh" );
		proc->addArgument(GetInterfaceIpScript);

		retrieveInterfaceIP=true;
		readOutput=true;

		// 	connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		// 	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

		if ( !proc->start(env) )
		{
			std::cerr << "unable to start proc(ifconfig)!" << std::endl;
		}
	}
	while ( retrieveInterfaceIP && proc->isRunning() )
		app->processEvents();

	while ( readOutput)
		app->processEvents();

	// 	disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 	disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	//disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return InterfaceIP;
}


QString NetworkInterface::getInterfaceAddress( QString IPforInterface )
{
	// TODO fixme
	if ( !IPforInterface.isEmpty() )
	{
		this->IPforInterface = IPforInterface;
		QStringList devlist = getAllNetworkInterfaces();
		tmpfile = new KTempFile();
		QString tmpPath = locateLocal ( "data", "kvpnc/" );
		QString GetIpForInterfaceScript = tmpPath + "get_interface_for_ip_"+IPforInterface+".sh";

		QFile file ( GetIpForInterfaceScript );
		QTextStream stream( &file );
		if ( file.open( IO_WriteOnly ) )
		{
			stream << "# generated by kvpnc. Do not edit it." << "\n";
			stream << "\n";
			stream << ifconfigbin +" | grep -B1 "+IPforInterface+" | head -n1 |awk {'print $1'} > "+ tmpfile->name()+"\n";
			file.close();
		}


		proc = new QProcess(this);
		proc->addArgument( "/bin/sh" );
		proc->addArgument(GetIpForInterfaceScript);
		retrieveInterfaceAddress=true;
		readOutput=true;

		//connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		///	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );


		if ( !proc->start(env) )
		{
			std::cerr << "unable to start proc (ifconfig)!" << std::endl;
		}
	}
	while ( retrieveInterfaceAddress == true && proc->isRunning() )
		app->processEvents();

	while ( readOutput)
		app->processEvents();

	// 		disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 		disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return InterfaceAddress;

}


QString NetworkInterface::getDefaultInterface()
{
	tmpfile = new KTempFile();

	QString tmpPath = locateLocal ( "data", "kvpnc/" );
	QString GetDefaultInterfaceScript = tmpPath + "get_defaultinterface.sh";

	QFile file ( GetDefaultInterfaceScript );
	QTextStream stream( &file );
	if ( file.open( IO_WriteOnly ) )
	{
		stream << "# generated by kvpnc. Do not edit it." << "\n";
		stream << "\n";
		stream << routebin +" -n | grep UG | grep '0.0.0.0*.*.*.' | awk {'print $8'} > "+ tmpfile->name()+"\n";
		file.close();
	}


	proc = new QProcess(this);
	proc->addArgument( "/bin/sh" );
	proc->addArgument(GetDefaultInterfaceScript);


	// 	connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

	if ( !proc->start(env) )
	{
		std::cerr << "unable to start proc(route)!" << std::endl;
		KMessageBox::information( 0,i18n("unable to start process (%1)!").arg(QString("route "+i18n("defaultinterface")+")")),i18n("Start failed"));
		return "none";
	}
	else
	{
		//std::cout << "getDefaultInterface() started." << std::endl;
		retrieveDefaultInterface = true;
		readOutput=true;
		while ( proc->isRunning() || readOutput)
		{
			app->processEvents();
		}
		// 		disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		// 		disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		//		disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
		//		delete proc;

		return this->defaultinterface;
	}
}

QString  NetworkInterface::getExternalIpAddress()
{
	qInitNetworkProtocols();
	ExternalIpAddress="";
	getExternalIpAddressRunning=true;
	http = new QHttp();
	connect (http,SIGNAL(readyRead(const QHttpResponseHeader &)), this, SLOT(externalIpDataRecieved(const QHttpResponseHeader &)));
	http->setHost( "checkip.dyndns.org" );
	http->get( "/" );
	while ( getExternalIpAddressRunning )
		app->processEvents();
	return ExternalIpAddress;
}

void NetworkInterface::readFromStdout()
{
	while ( proc->canReadLineStdout() )
	{
		QString line = proc->readLineStdout() ;
		//		QString line = QString(proc->readStdout());


		/*
		example for one interface 
		 
		eth0      Protokoll:Ethernet  Hardware Adresse 00:10:4B:B2:19:00
		          inet Adresse:192.168.0.99  Bcast:192.168.0.255  Maske:255.255.255.0
		          inet6 Adresse: fe80::210:4bff:feb2:1900/64 Gltigkeitsbereich:Verbindung
		          UP BROADCAST NOTRAILERS RUNNING MULTICAST  MTU:1500  Metric:1
		          RX packets:31549 errors:0 dropped:0 overruns:0 frame:0
		          TX packets:34046 errors:0 dropped:0 overruns:0 carrier:0
		          Kollisionen:0 Sendewarteschlangenlnge:1000
		          RX bytes:11308743 (10.7 Mb)  TX bytes:3701511 (3.5 Mb)
		          Interrupt:10 Basisadresse:0xdc00
		*/

		if ( interfaceTest )
		{
			if ( line.find( "proto", 0 , FALSE ) != -1 )
			{
				interfaceExists = true;
				interfaceTest = false;
			}
		}

		if ( line.find( "proto", 0 , FALSE ) != -1 )
		{

			if ( retrieveAllNetworkInterfaces )
			{
				QString interface = line.simplifyWhiteSpace().section( ' ', 0, 0 ); // eth0
				InterfaceList.append( interface );
				//	std::cout << "dbg: found interface: " << interface << std::endl;
			}


		}

		// 		if ( retrieveInterfaceIP || retrieveInterfaceAddress )
		// 		{
		// 			if ( line.find( "inet a", 0 , FALSE ) != -1 )
		// 			{
		// 				QString interfaceIP = line.simplifyWhiteSpace().section( ' ', 1, 1 ).section( ':', 1, 1 ); // eth0
		// 				//std::cout << "dbg: found interface IP: " << interfaceIP << std::endl;
		// 				if ( retrieveInterfaceIP )
		// 				{
		// 					InterfaceIP = interfaceIP;
		// 					retrieveInterfaceIP = false;
		// 				}
		// 				if ( retrieveInterfaceAddress )
		// 				{
		// 					if ( line.find( "proto", 0 , FALSE ) != -1 )
		// 					{
		// 						if ( IPforInterface == interfaceIP )
		// 						{
		// 							InterfaceAddress = interfaceIP;
		// 							//		std::cout << "dbg: found interface address: " << interfaceIP << std::endl;
		// 							retrieveInterfaceAddress = false;
		// 						}
		// 					}
		// 				}
		// 			}
		// 		}
	}
}

void NetworkInterface::readFromStderr()
{
	//while ( proc->canReadLineStderr() ) {
	//	QString line = proc->readLineStderr() ;
	QString line = QString( proc->readStderr() );

	if ( interfaceTest )
	{
		interfaceExists = false;
		interfaceTest = false;
	}
	//std::cerr << "dbg err: " << line << std::endl;
	//}
}

void NetworkInterface::processHasFinished()
{


	//std::cout << "dbg: processHasFinished():" << proc->exitStatus() << std::endl;;
	if ( retrieveAllNetworkInterfaces )
		retrieveAllNetworkInterfaces = false;


	if ( retrieveInterfaceIP )
	{
		//std::cout << "tmp file: " << tmpfile->name() << std::endl;
		InterfaceIP = QString(tmpfile->file()->readAll()).stripWhiteSpace();
		//KMessageBox::information( 0,this->defaultinterface,"default if");
		//tmpfile->unlink();
	}

	if (retrieveDefaultInterface )
	{
		//std::cout << "tmp file: " << tmpfile->name() << std::endl;
		defaultinterface = QString(tmpfile->file()->readAll()).stripWhiteSpace() ;
		//KMessageBox::information( 0,this->defaultinterface,"default if");
		tmpfile->unlink();
	}
	if (retrieveInterfaceAddress )
	{
		//std::cout << "tmp file: " << tmpfile->name() << std::endl;
		InterfaceAddress = QString(tmpfile->file()->readAll()).stripWhiteSpace();
		//KMessageBox::information( 0,this->defaultinterface,"default if");
		tmpfile->unlink();

	}
	retrieveInterfaceAddress=false;
	readOutput=false;
}

void NetworkInterface::externalIpDataRecieved(const QHttpResponseHeader &)
{
	ExternalIpAddress=QString(http->readAll()).stripWhiteSpace().remove ("Current IP Address: ").stripWhiteSpace();
	getExternalIpAddressRunning=false;
}

#include "networkinterface.moc"
