/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

//BEGIN Includes
#include "profilewidget.h"
#include "importcertificatedialog.h"
#include <qlistview.h>
#include <klistview.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <kurlrequester.h>
#include <kmessagebox.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <klineeditdlg.h>
#include <klocale.h>
#include <knuminput.h>
#include <kinputdialog.h>
#include <ktextedit.h>
#include "networkinterface.h"
#include "advancedsettingsdialog.h"
#include "newprofiledialog.h"
#include "utils.h"
#include "addnetworkroutedialog.h"
#include "kdialogbase.h"
#include <klistview.h>
#include <qstringlist.h>
#include "kvpnc.h"
//END Includes

ProfileWidget::ProfileWidget(  KVpncConfig *GlobalConfig, QWidget * parent, const char * name, WFlags f ) : ProfileWidgetBase( parent, name, f)
{
	//resize(QSize(minimumSizeHint().width()+50, minimumSizeHint().height()+50));

	this->GlobalConfig = GlobalConfig;

	// TODO read types from list
	ConnectionTypeComboBox->insertItem( i18n( "Cisco (vpnc)" ), VpnAccountData::cisco );
	ConnectionTypeComboBox->insertItem( i18n( "IPSec (racoon)" ), VpnAccountData::racoon );
	ConnectionTypeComboBox->insertItem( i18n( "IPSec (FreeSWAN)" ), VpnAccountData::freeswan );
	ConnectionTypeComboBox->insertItem( i18n( "PPTP" ), VpnAccountData::pptp );
	ConnectionTypeComboBox->insertItem( i18n( "OpenVPN" ), VpnAccountData::openvpn );
	//ConnectionTypeComboBox->insertItem( "-", 5 );

	TunnelDeviceTypeComboBox->insertItem( "tun" );
	TunnelDeviceTypeComboBox->insertItem( "tap" );

	profileAddedOrDeleted = false;
	NewProfileName="";

	// profile data
	VpnAccountData * it;
	for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
	{
		//KMessageBox::information(0,"item found",it->getName());

		ProfileComboBox->insertItem( it->getName() );
	}

	connect( ProfileComboBox, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );

	connect( PingCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( pingIpToggled( bool ) ) );

	connect( UseUdpCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( useUdpToggled( bool ) ) );

	connect( UdpPortCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( udpPortToggled( bool ) ) );

	connect( UseSpecialServerCertificateCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( useSpecialServerCertificateToggled ( bool ) ) );

	connect (SetDefaultRouteCheckbox, SIGNAL(toggled(bool)),
	         this, SLOT(setDefaultRouteToggled(bool)));


	connect ( DnsServerCheckbox, SIGNAL(toggled(bool)),
	          this, SLOT(useDnsServerToggled(bool)));

	connect ( MtuCheckbox, SIGNAL(toggled(bool)),
	          this, SLOT(mtuToggled(bool)));

	connect ( this, SIGNAL(applyClicked ()),
	          this, SLOT(saveSessionClicked()));


	if ( !GlobalConfig->AccountList->isEmpty() )
	{
		if ( GlobalConfig->currentProfile != 0 )
			ProfileComboBox->setCurrentText( GlobalConfig->currentProfile->getName() );
		else
		{
			ProfileComboBox->setCurrentText( "" );

		}
	}
	else
	{
		AdvancedSettingsPushButton->setEnabled( false );
		RenameSessionPushButton->setEnabled( false );
		DeleteSessionPushButton->setEnabled( false );
		SaveSessionPushButton->setEnabled( false );
		CiscoPptpGroupBox->setEnabled( false );
		//		FreeswanRacoonGroupBox->setEnabled( false );
		OpenvpnGroupBox->setEnabled( false );
		GeneralGroupbox->setEnabled( false );
		CommandExecutionGroupBox->setEnabled( false );
		PppdGroupBox->setEnabled( false );
		RacoonGroupBox->setEnabled( false );
	}


	NetworkInterface iface(GlobalConfig->appPointer);
	QStringList list = iface.getAllNetworkInterfaces();
	NetworkDeviceComboBox->insertItem( "default" );
	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		NetworkDeviceComboBox->insertItem( QString( *it ) );
	}
	NetworkDeviceComboBox->setEnabled( true );
	LabelNetworkDevice->setEnabled( true );

	if ( GlobalConfig->currentProfile != 0 )
	{
		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			AuthTypeComboBox->setCurrentText( i18n( "X.509 certificate" ) );

		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			AuthTypeComboBox->setCurrentText( i18n( "Pre shared key" ) );

		if (GlobalConfig->currentProfile->getConnectionType() != VpnAccountData::ConnectionType(VpnAccountData::openvpn))
			PSKLineEdit->setText( GlobalConfig->currentProfile->getPreSharedKey() );
		else
			PSKFileURLRequester->setURL(GlobalConfig->currentProfile->getPreSharedKeyFile());

		if ( GlobalConfig->currentProfile->getDoPingIP() )
			PingIPLineEdit->setEnabled( true );
		else
			PingIPLineEdit->setEnabled( false );

		RemoteIDLineEdit->setEnabled( false );

		UseExtraNetworkRoutesCheckbox->setChecked(GlobalConfig->currentProfile->getUseAdditionalNetworkRoutes());

		NetworkListView->clear();
		QStringList AdditionalNetworkRoutes = GlobalConfig->currentProfile->getAdditionalNetworkRoutes();

		for (QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			QString networkstring = *it2;
			NetworkListView->insertItem(new QListViewItem(NetworkListView,networkstring.section('/',0,0),networkstring.section('/',1,1)));

		}

		UseSpecialServerCertificateCheckBox->setChecked( GlobalConfig->currentProfile->getUseSpecialServerCertificate() );
		if ( GlobalConfig->currentProfile->getUseSpecialServerCertificate())
			SpecialServerCertificateURLRequester->setURL(GlobalConfig->currentProfile->getSpecialServerCertificate());

		if ( GlobalConfig->currentProfile->getUseUserdefinedPort() ){
			UseUserdefinedPortCheckBox->setChecked(true);
			UserdefinedPortSpinBox->setEnabled(true);
		}
		else {
			UseUserdefinedPortCheckBox->setChecked(false);
			UserdefinedPortSpinBox->setEnabled(false);
		}

		UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());

		connectionTypeChanged( ConnectionTypeComboBox->currentItem() );
		authTypeChanged( AuthTypeComboBox->currentItem() );
		profileChanged( ProfileComboBox->currentText() );

	}

	// 	// pppd settings
	// 	RefuseEapCheckbox->setEnabled( false );
	// 	RequireMppeCheckbox->setEnabled( false );
	// 	Refuse128BitEncryptionCheckbox->setEnabled(false );
	// 	Refuse40BitEncryptionCheckbox->setEnabled( false );
	// 	DnsServerCheckbox->setEnabled( false );
	DnsServerLineedit->setEnabled( false );
	// 	AllowStatefulModeCheckbox->setEnabled( false );
	// 	GetDnsFromPeerCheckbox->setEnabled( false );
	// 	UseNoBsdCompCheckbox->setEnabled( false );
	// 	UseNoDeflateCheckbox->setEnabled( false );
	// 	ReplaceDefaultRouteCheckbox->setEnabled( false );
	// 	SetDefaultRouteCheckbox->setEnabled( false );
	MtuSpinbox->setEnabled( false );
	// 	MtuCheckbox->setEnabled( false );

	//FIXME -> not virtual IP's yet
	UseVirtualIPCheckBox->setChecked(false);
	UseVirtualIPCheckBox->setEnabled(false);
	RemoteVirtualIpLineEdit->setEnabled(false);
	LocalVirtualIpEdit->setEnabled(false);
	LabelRemoteVirtualIp->setEnabled(false);
	LabelLocalVirtualIp->setEnabled(false);

}


ProfileWidget::~ProfileWidget()
{}


void ProfileWidget::importCertificate()
{
	//FIXME make path dynamiclly
	ImportCertificateDialog dlg( this, i18n("Import certificate..."),GlobalConfig );
	//int result =
	dlg.exec();
}

void ProfileWidget::profileChanged( const QString& itemtext )
{

	if (!GlobalConfig->AccountList->isEmpty() && GlobalConfig->currentProfile != 0)
	{

		QString Name = itemtext;

if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New profile: %1" ).arg( Name ),GlobalConfig->debug );

		//	KMessageBox::information(0,"item clicked",Name);
		// profile data
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{
				GlobalConfig->currentProfile = it;
				break;
			}
		}

		x509certURLRequester->clear();
		certpathURLRequester->clear();
		UsernameLineEdit->clear();
		PSKLineEdit->clear();
		RemoteIDLineEdit->clear();
		RemoteNetAddrLineEdit->clear();
		gatewayLineEdit->clear();
		NetworkListView->clear();
		SpecialServerCertificateURLRequester->clear();

		CheckSavePsk->setChecked( false );
		CheckUserPass->setChecked( false );
		IDLineEdit->clear();
		UsernameLineEdit->clear();
		PasswordEdit->clear();
		CmdBeforeConnectTextEdit->setEnabled(false);
		CmdAfterConnectTextEdit->setEnabled(false);
		CmdBeforeDisconnectTextEdit->setEnabled(false);
		CmdAfterDisconnectTextEdit->setEnabled(false);
		ExcuteCmdBeforeConnectCheckBox->setChecked(false);
		ExcuteCmdAfterConnectCheckBox->setChecked(false);
		ExcuteCmdBeforeDisconnectCheckBox->setChecked(false);
		ExcuteCmdAfterDisconnectCheckBox->setChecked(false);
		UseVirtualIPCheckBox->setChecked(false);
		UseSpecialServerCertificateCheckBox->setChecked(false);

		RefuseEapCheckbox->setChecked( false );
		RequireMppeCheckbox->setChecked( false );
		Refuse128BitEncryptionCheckbox->setChecked(false );
		Refuse40BitEncryptionCheckbox->setChecked( false );
		UseNoMPPECompressionCheckbox->setChecked( false );
		DnsServerCheckbox->setChecked( false );
		DnsServerLineedit->clear();
		AllowStatefulModeCheckbox->setChecked( false );
		GetDnsFromPeerCheckbox->setChecked( false );
		UseNoBsdCompCheckbox->setChecked( false );
		UseNoDeflateCheckbox->setChecked( false );
		ReplaceDefaultRouteCheckbox->setChecked( false );
		SetDefaultRouteCheckbox->setChecked( false );
		MtuSpinbox->setValue( 1500 );
		MtuCheckbox->setChecked( false );
		UseUserdefinedPortCheckBox->setChecked(false);
		UserdefinedPortSpinBox->setValue(1194);

		if ( it == 0 )
		{
			RenameSessionPushButton->setEnabled( false );
			DeleteSessionPushButton->setEnabled( false );
			SaveSessionPushButton->setEnabled( false );
			return;
		}
		else
		{
			AdvancedSettingsPushButton->setEnabled( true );
			DeleteSessionPushButton->setEnabled( true );
			SaveSessionPushButton->setEnabled( true );
		}

		RemoteIDLineEdit->clear();
		RemoteNetMaskComboBox->setCurrentText("24");

		gatewayLineEdit->setText(it->getGateway());

		// 	AdvancedSettingsPushButton->setEnabled( false );
		if ( ( it->getNetworkDevice() ).isEmpty() )
		{
			NetworkDeviceComboBox->setCurrentText( "default" );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": no network device defined, using \"default\"." ).arg( it->getName() ), GlobalConfig->debug );
		}
		else
		{
			NetworkDeviceComboBox->setCurrentText( it->getNetworkDevice() );

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": network device defined, using \"%2\"." ).arg( it->getName() ).arg( it->getNetworkDevice() ), GlobalConfig->debug );
		}

		// global
		if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::cisco ))
			ConnectionTypeComboBox->setCurrentItem( 0 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon ))
			ConnectionTypeComboBox->setCurrentItem( 1 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::freeswan ))
			ConnectionTypeComboBox->setCurrentItem( 2 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::pptp ))
			ConnectionTypeComboBox->setCurrentItem( 3 );
		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn ))
			ConnectionTypeComboBox->setCurrentItem( 4 );
		else
			ConnectionTypeComboBox->setCurrentItem( VpnAccountData::other ); // must be last item -> other

		gatewayLineEdit->setText( it->getGateway() );

		PSKLineEdit->setText( it->getPreSharedKey() );

		/* connection specific */
		if ( it->getConnectionType() == VpnAccountData::cisco )
		{
			CheckSavePsk->setChecked( it->getSavePsk() );
			CheckUserPass->setChecked ( it->getSaveUserPassword() );
			IDLineEdit->setText( it->getID() );
			UsernameLineEdit->setText ( it->getUserName() );
			PSKLineEdit->setText( it->getPreSharedKey() );
			PasswordEdit->setText ( it->getUserPassword() );

			UseUdpCheckbox->setChecked(it->getUseUdp());
			UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				UdpPortCheckbox->setChecked(true);
			else
				UdpPortCheckbox->setChecked(false);

			UseUdpCheckbox->setEnabled( true );
			UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				UdpPortCheckbox->setEnabled(true);
			else
				UdpPortCheckbox->setEnabled(false);

			AuthTypeComboBox->setCurrentItem(1); // PSK
			AuthTypeComboBox->setEnabled( false );

			PSKLineEdit->setText( it->getPreSharedKey() );
			CheckSavePsk->setChecked( it->getSavePsk() );

			IDLineEdit->setEnabled( true );
			LabelID->setEnabled( true );
			AdvancedSettingsPushButton->setEnabled( true );

			RemoteNetAddrLineEdit->setEnabled( false );
			LabelRemoteNetwork->setEnabled( false );
			RemoteNetMaskComboBox->setEnabled( false );
			RemoteIDLineEdit->setEnabled( false );

			PppdGroupBox->setEnabled(false);
			OpenvpnGroupBox->setEnabled(false);
			CiscoPptpGroupBox->setEnabled(true);
			RacoonGroupBox->setEnabled(false);

		} // vpnc

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::racoon) || it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::freeswan ))
		{
			QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
			QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
			RemoteNetAddrLineEdit->setText( RemoteNetAddr );
			RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			if ( it->getAuthType() == VpnAccountData::cert )
			{
				AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				AuthTypeComboBox->setCurrentItem( 1 );
			}


			x509certURLRequester->setURL( it->getX509Certificate() );
			CaCertpathURLRequester->setURL( it->getCaCertificate() );
			certpathURLRequester->setURL( it->getCertPath() );
			PrivkeyPasswordEdit->setText( it->getPrivateKeyPass());
			privkeypathURLRequester->setURL( it->getPrivateKey() );

			PingCheckBox->setChecked( it->getDoPingIP() );
			PingIPLineEdit->setText( it->getPingHostIP() );
			RemoteIDLineEdit->setText( it->getSpecialRemoteID() );
			UseSpecialRemoteIDcheckBox->setChecked( it->getUseSpecialRemoteID() );
			PSKLineEdit->setText(it->getPreSharedKey());
			CheckSavePsk->setChecked(it->getSavePsk());

			// TODO made it useable for freeswan
			if (it->getConnectionType() == VpnAccountData::freeswan)
			{
				SpecialServerCertificateURLRequester->setEnabled(false);
				UseSpecialServerCertificateCheckBox->setChecked( 	it->getUseSpecialServerCertificate() );
				if ( it->getUseSpecialServerCertificate())
					SpecialServerCertificateURLRequester->setURL(it->getSpecialServerCertificate());
			}

			UseVirtualIPCheckBox->setChecked( it->getUseVirtualIP() );
			UseVirtualIPCheckBox->setEnabled( true);

			UseUdpCheckbox->setChecked(it->getUseUdp());
			UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				UdpPortCheckbox->setChecked(true);
			else
				UdpPortCheckbox->setChecked(false);

			UseUdpCheckbox->setEnabled( true );
			UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				UdpPortCheckbox->setEnabled(true);
			else
				UdpPortCheckbox->setEnabled(false);

			RemoteNetAddrLineEdit->setEnabled( true );
			LabelRemoteNetwork->setEnabled( true );
			RemoteNetMaskComboBox->setEnabled( true );

			ImportCertificatePushButton->setEnabled( true );

			IDLineEdit->setEnabled( false );
			LabelID->setEnabled( false );

			if (it->getConnectionType() == VpnAccountData::racoon)
				AdvancedSettingsPushButton->setEnabled( true );

			PppdGroupBox->setEnabled(false);
			OpenvpnGroupBox->setEnabled(false);
			CiscoPptpGroupBox->setEnabled(false);
			RacoonGroupBox->setEnabled( true );

			if (it->getHashAlgo() == "sha1")
				HashAlgoComboBox->setCurrentText("SHA1");
			if (it->getHashAlgo() == "md5")
				HashAlgoComboBox->setCurrentText("MD5");

		} // racoon or freeswan

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::pptp ))
		{
			CheckSavePsk->setChecked( it->getSavePsk() );
			CheckUserPass->setChecked ( it->getSaveUserPassword() );
			UsernameLineEdit->setText ( it->getUserName() );
			PasswordEdit->setText ( it->getUserPassword() );
			PingCheckBox->setChecked( it->getDoPingIP() );
			PingIPLineEdit->setText( it->getPingHostIP() );

			if (!it->getRemoteNet().isEmpty())
			{
				QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
				QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
				RemoteNetAddrLineEdit->setText( RemoteNetAddr );
				RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			}

			RefuseEapCheckbox->setChecked(it->getRefuseEap());
			RequireMppeCheckbox->setChecked(it->getRequireMppe());
			Refuse128BitEncryptionCheckbox->setChecked(it->getRefuse128BitEncryption());
			Refuse40BitEncryptionCheckbox->setChecked(it->getRefuse40BitEncryption());
			UseNoMPPECompressionCheckbox->setChecked(it->getDisableMPPEComp());
			GetDnsFromPeerCheckbox->setChecked(it->getUseGetDnsFromPeer());
			DnsServerCheckbox->setChecked(it->getUseDnsServer());
			DnsServerLineedit->setText(it->getDnsServer());
			UseNoBsdCompCheckbox->setChecked(it->getUseNoBsdComp());
			UseNoDeflateCheckbox->setChecked(it->getUseNoDeflate());
			SetDefaultRouteCheckbox->setChecked(it->getSetDefaultRoute());
			ReplaceDefaultRouteCheckbox->setChecked(it->getReplaceDefaultRoute());
			MtuCheckbox->setChecked(it->getUseMtu());
			MtuSpinbox->setValue(it->getMtu());
			AllowStatefulModeCheckbox->setChecked(it->getAllowStatefulMode());
			UseNoIpDefaultCheckbox->setChecked(it->getAllowStatefulMode());

			AdvancedSettingsPushButton->setEnabled( true );

			IDLineEdit->setEnabled( false );
			LabelID->setEnabled( false );

			RemoteNetAddrLineEdit->setEnabled( true );
			LabelRemoteNetwork->setEnabled( true );
			RemoteNetMaskComboBox->setEnabled(true );
			ImportCertificatePushButton->setEnabled( false );
			NetworkDeviceComboBox->setEnabled( false );

			PppdGroupBox->setEnabled(true);
			OpenvpnGroupBox->setEnabled(false);
			CiscoPptpGroupBox->setEnabled(false); //FIXME remove pptp in name
			RacoonGroupBox->setEnabled(false);

		} // pptp

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType(VpnAccountData::openvpn ))
		{

			if ( it->getAuthType() == VpnAccountData::cert )
			{
				AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				AuthTypeComboBox->setCurrentItem( 1 );
			}

			x509certURLRequester->setURL( it->getX509Certificate() );
			CaCertpathURLRequester->setURL( it->getCaCertificate() );
			certpathURLRequester->setURL( it->getCertPath() );
			PrivkeyPasswordEdit->setText( it->getPrivateKeyPass());
			privkeypathURLRequester->setURL( it->getPrivateKey() );
			PSKLineEdit->setText(it->getPreSharedKey());
			CheckSavePsk->setChecked(it->getSavePsk());
			PingCheckBox->setChecked( it->getDoPingIP() );
			PingIPLineEdit->setText( it->getPingHostIP() );

			LocalVirtualIpEdit->setText( it->getLocalVirtualIP());
			RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP());

			if (!it->getRemoteNet().isEmpty())
			{
				QString RemoteNetAddr = it->getRemoteNet().section( '/', 0, 0 );
				QString RemoteNetMask = it->getRemoteNet().section( '/', 1, 1 );
				RemoteNetAddrLineEdit->setText( RemoteNetAddr );
				RemoteNetMaskComboBox->setCurrentText( RemoteNetMask );
			}
			RemoteNetMaskComboBox->setEnabled(true);
			RemoteNetAddrLineEdit->setEnabled(true);


			UseUdpCheckbox->setChecked(it->getUseUdp());
			UdpPortSpinbox->setValue(it->getUdpPort());
			if (it->getUseUdpPort() )
				UdpPortCheckbox->setChecked(true);
			else
				UdpPortCheckbox->setChecked(false);

			UseUdpCheckbox->setEnabled( true );
			UdpPortCheckbox->setEnabled( true );
			if (it->getUseUdp())
				UdpPortCheckbox->setEnabled(true);
			else
				UdpPortCheckbox->setEnabled(false);

			IDLineEdit->setEnabled( false );
			LabelID->setEnabled( false );

			PppdGroupBox->setEnabled(false);
			OpenvpnGroupBox->setEnabled(true);
			CiscoPptpGroupBox->setEnabled(false);
			RacoonGroupBox->setEnabled(false);

			TunnelDeviceTypeComboBox->setCurrentText(it->getTunnelDeviceType());
		if ( GlobalConfig->currentProfile->getUseUserdefinedPort() ){
			UseUserdefinedPortCheckBox->setChecked(true);
			UserdefinedPortSpinBox->setEnabled(true);
		}
		else {
			UseUserdefinedPortCheckBox->setChecked(false);
			UserdefinedPortSpinBox->setEnabled(false);
		}

		UserdefinedPortSpinBox->setValue(GlobalConfig->currentProfile->getUserdefinedPort());

		} // openvpn

		ExcuteCmdBeforeConnectCheckBox->setChecked(it->getExecuteCmdBeforeConnect());
		ExcuteCmdAfterConnectCheckBox->setChecked(it->getExecuteCmdAfterConnect());
		ExcuteCmdBeforeDisconnectCheckBox->setChecked(it->getExecuteCmdBeforeDisconnect());
		ExcuteCmdAfterDisconnectCheckBox->setChecked(it->getExecuteCmdAfterDisconnect());
		CmdBeforeConnectTextEdit->setText(it->getCommandBeforeConnect());
		CmdAfterConnectTextEdit->setText(it->getCommandAfterConnect());
		CmdBeforeDisconnectTextEdit->setText (it->getCommandBeforeDisconnect());
		CmdAfterDisconnectTextEdit->setText (it->getCommandAfterDisconnect());
		CmdBeforeConnectTextEdit->setEnabled(it->getExecuteCmdBeforeConnect());
		CmdAfterConnectTextEdit->setEnabled(it->getExecuteCmdAfterConnect());
		CmdBeforeDisconnectTextEdit->setEnabled(it->getExecuteCmdBeforeDisconnect());
		CmdAfterDisconnectTextEdit->setEnabled(it->getExecuteCmdAfterDisconnect());

		UseExtraNetworkRoutesCheckbox->setChecked(it->getUseAdditionalNetworkRoutes());

		QStringList AdditionalNetworkRoutes = it->getAdditionalNetworkRoutes();

		for (QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			QString networkstring = *it2;
			NetworkListView->insertItem(new QListViewItem(NetworkListView,networkstring.section('/',0,0),networkstring.section('/',1,1)));

		}

		connectionTypeChanged( ConnectionTypeComboBox->currentItem() );
		AuthTypeComboBox->setCurrentItem(it->getAuthType());
		x509certURLRequester->setFilter( "*.pem" );
		certpathURLRequester->setMode( KFile::Directory );
	}
}

void ProfileWidget::connectionTypeChanged( int )
{

	if ( GlobalConfig->KvpncDebugLevel > 0 )
		GlobalConfig->appendLogEntry( "connectionTypeChanged()", GlobalConfig->debug );

	if (GlobalConfig->currentProfile == 0)
		return;

	DeleteSessionPushButton->setEnabled ( TRUE );
	NewSessionPushButton->setEnabled ( TRUE );
	SaveSessionPushButton->setEnabled ( TRUE );

	// First we should set a type
	// 	parent->buttonCancel->setEnabled( FALSE );
	// 	parent->buttonOk->setEnabled( FALSE );
	AdvancedSettingsPushButton->setEnabled( false );

	if ( GlobalConfig->currentProfile->getConnectionType() ==  VpnAccountData::cisco )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: cisco",GlobalConfig->debug );

		IDLineEdit->setEnabled( true );
		LabelID->setEnabled( true );

		AdvancedSettingsPushButton->setEnabled( true );

		NetworkDeviceComboBox->setEnabled( true );
		LabelNetworkDevice->setEnabled( true );
		RemoteNetAddrLineEdit->setEnabled( false );
		RemoteNetMaskComboBox->setEnabled( false );

		UseUdpCheckbox->setEnabled( true );
		UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			UdpPortCheckbox->setEnabled(true);
		else
			UdpPortCheckbox->setEnabled(false);
		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // vpnc

	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan )
	{

		if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon )
		{

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg("racoon"), GlobalConfig->debug );

			AdvancedSettingsPushButton->setEnabled( true );
		}
		else
		{

			if ( GlobalConfig->KvpncDebugLevel > 0 )
				GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg("freeswan"), GlobalConfig->debug );

			if (GlobalConfig->currentProfile != 0)
			{
				privkeypathURLRequester->setURL( GlobalConfig->currentProfile->getPrivateKey() );
				PrivkeyPasswordEdit->setText( GlobalConfig->currentProfile->getPrivateKeyPass() );
			}
			AdvancedSettingsPushButton->setEnabled( false );
		}
		NetworkDeviceComboBox->setEnabled ( true );
		LabelNetworkDevice->setEnabled( true );
		RemoteNetAddrLineEdit->setEnabled( true );
		RemoteNetMaskComboBox->setEnabled( true );
		IDLineEdit->setEnabled( false );
		LabelID->setEnabled( false );
		OpenvpnGroupBox->setEnabled( false );

		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );
		if ( UseSpecialRemoteIDcheckBox->isChecked() )
			RemoteIDLineEdit->setEnabled( true );
		else
			RemoteIDLineEdit->setEnabled( false );

		UseUdpCheckbox->setEnabled( true );
		UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			UdpPortCheckbox->setEnabled(true);
		else
			UdpPortCheckbox->setEnabled(false);

		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // racoon/freeswan

	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: pptp", GlobalConfig->debug );

		AdvancedSettingsPushButton->setEnabled( true );
		OpenvpnGroupBox->setEnabled( false );

		authTypeChanged(VpnAccountData::pptp);
	} // pptp
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: %1" ).arg("openvpn"),GlobalConfig->debug );

		AdvancedSettingsPushButton->setEnabled( false );
		RemoteNetAddrLineEdit->setEnabled( true );
		LabelRemoteNetwork->setEnabled( true );
		RemoteNetMaskComboBox->setEnabled( true );
		IDLineEdit->setEnabled( false );
		LabelID->setEnabled( false );
		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );

		OpenvpnGroupBox->setEnabled( true );
		UseUdpCheckbox->setEnabled( true );
		UdpPortCheckbox->setEnabled( true );
		if (GlobalConfig->currentProfile->getUseUdp())
			UdpPortCheckbox->setEnabled(true);
		else
			UdpPortCheckbox->setEnabled(false);

		emit authTypeChanged(GlobalConfig->currentProfile->getAuthType());
	} // openvpn

	// other
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::other )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: none specified" ),GlobalConfig->debug );
	}
	else
	{

		GlobalConfig->appendLogEntry( i18n( "unknown type" ),GlobalConfig->debug );
		OpenvpnGroupBox->setEnabled( false );
	}

}

void ProfileWidget::authTypeChanged( int authtype )
{
	if (GlobalConfig->currentProfile ==0)
		return;

	PskInFileCheckBox->setEnabled(true);

	if (GlobalConfig->KvpncDebugLevel > 0)
	{

		QString type;
		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			type = "cert";
		else if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			type = "psk";


		GlobalConfig->appendLogEntry( i18n( "New authtype: \"%1\"." ).arg( type ) ,GlobalConfig->debug);
	}

	PasswordGroupBox->setEnabled(false);
	CertificateGroupBox->setEnabled( false );
	PskGroupBox->setEnabled( false );
	AuthTypeComboBox->setEnabled( false );
	LabelAuthType->setEnabled( false );
	PasswordGroupBox->setEnabled( false );
	CaCertpathURLRequester->setEnabled( false );
	SpecialServerCertificateURLRequester->setEnabled( false );

	int connectiontype = ConnectionTypeComboBox->currentItem();


	if (connectiontype == VpnAccountData::cisco || connectiontype == VpnAccountData::pptp )
	{
		PasswordGroupBox->setEnabled(true);
		if (connectiontype == VpnAccountData::cisco)
		{
			PskGroupBox->setEnabled( true );
			PSKLineEdit->setEnabled( true );
			LabelPsk->setEnabled( true );
			PskInFileCheckBox->setChecked(false);
			PskInFileCheckBox->setEnabled(false);
			PSKFileURLRequester->setEnabled(false);
			LabelPskFile->setEnabled(false);
		}

	}

	// racoon or freeswan
	else if ( connectiontype == VpnAccountData::freeswan || connectiontype == VpnAccountData::racoon )
	{

		AuthTypeComboBox->setEnabled( true );
		LabelAuthType->setEnabled( true );

		// cert
		if ( authtype == VpnAccountData::cert )
		{
			// certificate
			CertificateGroupBox->setEnabled( true );
			x509certURLRequester->setEnabled( true );
			LabelCertificate->setEnabled( true );

			certpathURLRequester->setEnabled( true );
			LabelCertificatePath->setEnabled( true );

			ImportCertificatePushButton->setEnabled( true );

			PskGroupBox->setEnabled( false );
			PSKLineEdit->setEnabled( false );
			LabelPsk->setEnabled( false );

		}

		// psk
		if ( authtype == VpnAccountData::psk )
		{
			// psk
			PskGroupBox->setEnabled( true );
			PSKLineEdit->setEnabled( true );
			LabelPsk->setEnabled( true );

			CertificateGroupBox->setEnabled( false );
			x509certURLRequester->setEnabled( false );
			LabelCertificate->setEnabled( false );

			certpathURLRequester->setEnabled( false );
			LabelCertificatePath->setEnabled( false );

			ImportCertificatePushButton->setEnabled( false );

		}
	}
	else if (connectiontype == VpnAccountData::openvpn)
	{

		AuthTypeComboBox->setEnabled( true );
		LabelAuthType->setEnabled( true );
		// cert
		if ( authtype  == VpnAccountData::cert )
		{
			// certificate
			CertificateGroupBox->setEnabled( true );
			x509certURLRequester->setEnabled( true );
			CaCertpathURLRequester->setEnabled( true );
			LabelCertificate->setEnabled( true );

			certpathURLRequester->setEnabled( true );
			LabelCertificatePath->setEnabled( true );
			privkeypathURLRequester->setEnabled( true );
			LabelPrivateKeyPath->setEnabled( true );

			ImportCertificatePushButton->setEnabled( true );

			PskGroupBox->setEnabled( false );
			PSKFileURLRequester->setEnabled( false );
			LabelPrivateKeyPath->setEnabled( true );
		}

		// psk
		if ( authtype == VpnAccountData::psk)
		{
			// psk
			PskGroupBox->setEnabled( true );
			PSKFileURLRequester->setEnabled( true );
			PSKLineEdit->setEnabled( true );
			LabelPsk->setEnabled( true );

			CertificateGroupBox->setEnabled( false );
			LabelPrivateKeyPath->setEnabled( false );
			x509certURLRequester->setEnabled( false );
			LabelCertificate->setEnabled( false );

			certpathURLRequester->setEnabled( false );
			LabelCertificatePath->setEnabled( false );
			ImportCertificatePushButton->setEnabled( false );
		}

	}
}

void ProfileWidget::newSessionClicked()
{

	// call new profile dialog...
 	NewProfileDialog newdlg( GlobalConfig->appPointer,this, i18n("New profile"),GlobalConfig);
	newdlg.exec();
	if ( newdlg.newProfileCreated )
	{
		QString Name = newdlg.profileData->getName();
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{
				ProfileComboBox->insertItem( Name );
				ProfileComboBox->setCurrentItem ( Name );
				GlobalConfig->currentProfile = it;
				break;
			}
		}

		AdvancedSettingsPushButton->setEnabled( TRUE );
		RenameSessionPushButton->setEnabled( TRUE );
		DeleteSessionPushButton->setEnabled( TRUE );
		SaveSessionPushButton->setEnabled ( TRUE );

		CiscoPptpGroupBox->setEnabled( true );
		//		FreeswanRacoonGroupBox->setEnabled( true );
		OpenvpnGroupBox->setEnabled( true );
		GeneralGroupbox->setEnabled( true );
		CommandExecutionGroupBox->setEnabled( true );

		KMessageBox::information ( this, i18n( "Profile \"%1\" added.\nNow set the right type,\n fill in the fields\nand press \"Save\" to complete the profile." ).arg( Name ), i18n( "Complete profile" ) );
		//slotStatusMsg ( i18n( "Profile \"%1\" added." ).arg( Name ), ID_FLASH_MSG );

		GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" added." ).arg( Name ),GlobalConfig->debug );
		profileAddedOrDeleted=true;
		NewProfileName=Name;
		ProfileComboBox->setCurrentText(Name);
		profileChanged ( ProfileComboBox->currentText ());
		connectionTypeChanged( ConnectionTypeComboBox->currentItem() );
		authTypeChanged( AuthTypeComboBox->currentItem() );
		saveSessionClicked();
	}
	else
	{

		GlobalConfig->appendLogEntry ( i18n( "Creation of the new profile canceled." ),GlobalConfig->debug );
	}

}


void ProfileWidget::saveSessionClicked()
{
	if ( GlobalConfig->currentProfile== 0 )
		return;
	//QString itemString=ConnectionTypeComboBox->currentText();
	int item = ConnectionTypeComboBox->currentItem();

	// cisco
	if ( ConnectionTypeComboBox->currentItem() == VpnAccountData::cisco )
	{
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::cisco );
		if (CheckUserPass->isChecked())
		{
			GlobalConfig->currentProfile->setSaveUserPassword(true);
			GlobalConfig->currentProfile->setUserPassword(UsernameLineEdit->text());
		}
		else
		{
			GlobalConfig->currentProfile->setSaveUserPassword(false);
		}

		if (CheckSavePsk->isChecked())
		{
			GlobalConfig->currentProfile->setSavePsk(true);
			GlobalConfig->currentProfile->setPreSharedKey(PSKLineEdit->text());
		}
		else
		{
			GlobalConfig->currentProfile->setSavePsk(false);
		}
	}

	else if ( ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon || ConnectionTypeComboBox->currentItem() == VpnAccountData::freeswan )
	{
		GlobalConfig->currentProfile->setSpecialRemoteID( RemoteIDLineEdit->text() );
		GlobalConfig->currentProfile->setUseSpecialRemoteID( UseSpecialRemoteIDcheckBox->isChecked() );

		if ( item == VpnAccountData::racoon )
			GlobalConfig->currentProfile->setConnectionType( VpnAccountData::racoon );
		else
			GlobalConfig->currentProfile->setConnectionType( VpnAccountData::freeswan );

		GlobalConfig->currentProfile->setPrivateKey( privkeypathURLRequester->url() );
		GlobalConfig->currentProfile->setPrivateKeyPass( PrivkeyPasswordEdit->text() );


		bool validAddr = true;
		if ( PingCheckBox->isChecked() && RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
		{
			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP address" ) );
			GlobalConfig->appendLogEntry(i18n( "No IP address entered!" ) ,GlobalConfig->error);
			validAddr = false;
		}
		else
		{
			QString addr = RemoteNetAddrLineEdit->text();
			int part0 = addr.section( '.', 0, 0 ).toInt();
			int part1 = addr.section( '.', 1, 1 ).toInt();
			int part2 = addr.section( '.', 2, 2 ).toInt();
			int part3 = addr.section( '.', 3, 3 ).toInt();

			/*
						LogOutput->append ("part0: "+QString().setNum(part0));
						LogOutput->append ("part1: "+QString().setNum(part1));
						LogOutput->append ("part2: "+QString().setNum(part2));
						LogOutput->append ("part3: "+QString().setNum(part3));
			*/
			if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
			{
				KMessageBox::error ( this, i18n( "IP address (remote net) is not valid!" ), i18n( "Invalid IP address" ) );
				GlobalConfig->appendLogEntry( i18n( "IP address (remote net) is not valid!" ) ,GlobalConfig->error);

				validAddr = false;
			}
			if ( validAddr == true )
			{
				GlobalConfig->currentProfile->setRemoteNet( addr + "/" + RemoteNetMaskComboBox->currentText() );
			}

		}

		if ( AuthTypeComboBox->currentItem() == 0 )
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::cert );
		else
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::psk );

		GlobalConfig->currentProfile->setX509Certificate( x509certURLRequester->url() );
		GlobalConfig->currentProfile->setCertPath( certpathURLRequester->url() );

		GlobalConfig->currentProfile->setPreSharedKey( PSKLineEdit->text());

		if ( ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon )
		{
			if (HashAlgoComboBox->currentText() =="SHA1")
			{
				GlobalConfig->currentProfile->setHashAlgo("sha1");
			}
			if (HashAlgoComboBox->currentText() =="MD5")
			{
				GlobalConfig->currentProfile->setHashAlgo("md5");
			}
		}
	}

	else if ( ConnectionTypeComboBox->currentItem() == VpnAccountData::pptp )
	{
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::pptp );


		bool validAddr = true;
		if (PingCheckBox->isChecked() && !RemoteNetAddrLineEdit->text().isEmpty())
		{
			if ( RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
			{
				//KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP address" ) );
				validAddr = false;
			}
			else
			{
				QString addr = RemoteNetAddrLineEdit->text();
				int part0 = addr.section( '.', 0, 0 ).toInt();
				int part1 = addr.section( '.', 1, 1 ).toInt();
				int part2 = addr.section( '.', 2, 2 ).toInt();
				int part3 = addr.section( '.', 3, 3 ).toInt();

				/*
							LogOutput->append ("part0: "+QString().setNum(part0));
							LogOutput->append ("part1: "+QString().setNum(part1));
							LogOutput->append ("part2: "+QString().setNum(part2));
							LogOutput->append ("part3: "+QString().setNum(part3));
				*/

				if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
				{
					KMessageBox::error ( this, i18n( "Invalid values in IP address (remote net)!" ), i18n( "Invalid values in IP address" ) );
					GlobalConfig->appendLogEntry(i18n( "Invalid values in IP address (remote net)!" ) ,GlobalConfig->error);
					validAddr = false;
				}


				if ( validAddr == true )
				{
					GlobalConfig->currentProfile->setRemoteNet( addr + "/" + RemoteNetMaskComboBox->currentText() );
				}

			}
		}
		else
		{
			GlobalConfig->currentProfile->setRemoteNet("");
		}

	}

	else if ( ConnectionTypeComboBox->currentItem() == VpnAccountData::openvpn)
	{
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::openvpn );

		bool validAddr = true;
		if ( PingCheckBox->isChecked() && RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
		{
			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP address" ) );
			GlobalConfig->appendLogEntry(i18n( "No IP address entered!" ) ,GlobalConfig->error);
			validAddr = false;
		}
		else
		{
			QString addr = RemoteNetAddrLineEdit->text();
			int part0 = addr.section( '.', 0, 0 ).toInt();
			int part1 = addr.section( '.', 1, 1 ).toInt();
			int part2 = addr.section( '.', 2, 2 ).toInt();
			int part3 = addr.section( '.', 3, 3 ).toInt();

			/*
						LogOutput->append ("part0: "+QString().setNum(part0));
						LogOutput->append ("part1: "+QString().setNum(part1));
						LogOutput->append ("part2: "+QString().setNum(part2));
						LogOutput->append ("part3: "+QString().setNum(part3));
			*/
			if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
			{
				KMessageBox::error ( this, i18n( "IP address (remote net) is invalid!" ), i18n( "Invalid IP address" ) );
				GlobalConfig->appendLogEntry(i18n( "IP address (remote net) is invalid!" ) ,GlobalConfig->error);
				validAddr = false;
			}
			if ( validAddr == true )
			{
				GlobalConfig->currentProfile->setRemoteNet( addr + "/" + RemoteNetMaskComboBox->currentText() );
			}

		}

		// 		QString LocalVirtualIp = LocalVirtualIpEdit->text();
		// 		if (Utils().isValidIPv4Adress(LocalVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
		// 		else
		// 		{
		// 			GlobalConfig->currentProfile->setLocalVirtualIP( LocalVirtualIp);
		// 		}
		//
		// 		QString RemoteVirtualIp = RemoteVirtualIpLineEdit->text();
		// 		if (Utils().isValidIPv4Adress(RemoteVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
		// 		else
		// 		{
		// 			GlobalConfig->currentProfile->setRemoteVirtualIP( RemoteVirtualIp);
		// 		}


		if ( AuthTypeComboBox->currentItem() == 0 )
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::cert );
		else
			GlobalConfig->currentProfile->setAuthType( VpnAccountData::psk );


		GlobalConfig->currentProfile->setPreSharedKeyFile(PSKFileURLRequester->url());
		GlobalConfig->currentProfile->setX509Certificate( x509certURLRequester->url() );
		GlobalConfig->currentProfile->setCaCertificate( CaCertpathURLRequester->url() );
		GlobalConfig->currentProfile->setCertPath( certpathURLRequester->url() );
		GlobalConfig->currentProfile->setPrivateKey ( privkeypathURLRequester->url());
		GlobalConfig->currentProfile->setPrivateKeyPass ( PrivkeyPasswordEdit->text());
		GlobalConfig->currentProfile->setTunnelDeviceType( TunnelDeviceTypeComboBox->currentText() );

		GlobalConfig->currentProfile->setUserdefinedPort( UserdefinedPortSpinBox->value());
		GlobalConfig->currentProfile->setUseUserdefinedPort( UseUserdefinedPortCheckBox->isChecked());

	} // openvpn

	else
		GlobalConfig->currentProfile->setConnectionType( VpnAccountData::other );

	if ( PingCheckBox->isChecked() && !PingIPLineEdit->text().isEmpty() )
	{
		// do check for vailid IP
		if (!Utils().isValidIPv4Adress(PingIPLineEdit->text())) {
			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
			GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) ,GlobalConfig->error);
		}
		else
		{
			GlobalConfig->currentProfile->setPingHostIP( PingIPLineEdit->text() );
			GlobalConfig->currentProfile->setDoPingIP( PingCheckBox->isChecked());
		}
	}
	else
	{
		if ( PingCheckBox->isChecked() && PingIPLineEdit->text() == QString( "" ) ) {
			KMessageBox::error ( this, i18n( "No IP address (ping host) entered!" ), i18n( "No IP address" ) );
			GlobalConfig->appendLogEntry(i18n( "No IP address (ping host) entered!" ) ,GlobalConfig->error);
		}
		else
			GlobalConfig->currentProfile->setPingHostIP( "" );
	}

	if ( item == VpnAccountData::ConnectionType(VpnAccountData::freeswan) ||
	        item == VpnAccountData::ConnectionType(VpnAccountData::racoon) )
	{

		if ( UseVirtualIPCheckBox->isChecked() && !LocalVirtualIpEdit->text().isEmpty() )
		{
			// do check for vailid IP
			if (!Utils().isValidIPv4Adress(LocalVirtualIpEdit->text())) {
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No valid IP address" ) );
				GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) ,GlobalConfig->error);
			}
			else
			{
				GlobalConfig->currentProfile->setVirtualIP( LocalVirtualIpEdit->text() );
				GlobalConfig->currentProfile->setUseVirtualIP( UseVirtualIPCheckBox->isChecked());
			}
		}
		else
		{
			if ( UseVirtualIPCheckBox->isChecked() && LocalVirtualIpEdit->text().isEmpty() ) {
				KMessageBox::error ( this, i18n( "No IP address (virtual IP) entered!" ), i18n( "No IP address" ) );
				GlobalConfig->appendLogEntry(i18n( "No IP address (virtual IP) entered!" ) ,GlobalConfig->error);
			}
			else
			{
				GlobalConfig->currentProfile->setVirtualIP( "" );
				GlobalConfig->currentProfile->setUseVirtualIP(false);
			}
		}
	}



	GlobalConfig->currentProfile->setSavePsk( CheckSavePsk->isChecked() );
	GlobalConfig->currentProfile->setSaveUserPassword( CheckUserPass->isChecked () );
	GlobalConfig->currentProfile->setID( IDLineEdit->text() );
	GlobalConfig->currentProfile->setUserName( UsernameLineEdit->text () );

	if (CheckSavePsk->isChecked())
		GlobalConfig->currentProfile->setPreSharedKey( PSKLineEdit->text( ) );
	else
		GlobalConfig->currentProfile->setPreSharedKey( "" );

	if (CheckUserPass->isChecked())
		GlobalConfig->currentProfile->setUserPassword( PasswordEdit->text ( ) );
	else
		GlobalConfig->currentProfile->setUserPassword( "" );

	GlobalConfig->currentProfile->setGateway( gatewayLineEdit->text() );
	GlobalConfig->currentProfile->setPreSharedKey( PSKLineEdit->text() );
	GlobalConfig->currentProfile->setX509Certificate( x509certURLRequester->url() );
	GlobalConfig->currentProfile->setCertPath( certpathURLRequester->url() );
	GlobalConfig->currentProfile->setNetworkDevice( NetworkDeviceComboBox->currentText() );

	GlobalConfig->currentProfile->setDoPingIP( PingCheckBox->isChecked() );

	if ( AuthTypeComboBox->currentItem() == 0 )
		GlobalConfig->currentProfile->setAuthType( VpnAccountData::cert );
	if ( AuthTypeComboBox->currentItem() == 1 )
		GlobalConfig->currentProfile->setAuthType( VpnAccountData::psk );

	if (UseUdpCheckbox->isChecked())
		GlobalConfig->currentProfile->setUseUdp(true);
	else
		GlobalConfig->currentProfile->setUseUdp(false);

	if (UdpPortCheckbox->isChecked())
	{
		GlobalConfig->currentProfile->setUdpPort(UdpPortSpinbox->value());
		GlobalConfig->currentProfile->setUseUdpPort(true);
	}
	else
	{
		GlobalConfig->currentProfile->setUdpPort(0);
		GlobalConfig->currentProfile->setUseUdpPort(false);
	}



	GlobalConfig->currentProfile->setExecuteCmdBeforeConnect( (ExcuteCmdBeforeConnectCheckBox->isChecked()));
	GlobalConfig->currentProfile->setExecuteCmdAfterConnect( (ExcuteCmdAfterConnectCheckBox->isChecked()));
	GlobalConfig->currentProfile->setExecuteCmdBeforeDisconnect( (ExcuteCmdBeforeDisconnectCheckBox->isChecked()));
	GlobalConfig->currentProfile->setExecuteCmdAfterDisconnect( (ExcuteCmdAfterDisconnectCheckBox->isChecked()));

	GlobalConfig->currentProfile->setCommandBeforeConnect(CmdBeforeConnectTextEdit->text());
	GlobalConfig->currentProfile->setCommandAfterConnect(CmdAfterConnectTextEdit->text());
	GlobalConfig->currentProfile->setCommandBeforeDisconnect(CmdBeforeDisconnectTextEdit->text());
	GlobalConfig->currentProfile->setCommandAfterDisconnect(CmdAfterDisconnectTextEdit->text());

	GlobalConfig->currentProfile->setUseAdditionalNetworkRoutes(UseExtraNetworkRoutesCheckbox->isChecked());

	if (UseExtraNetworkRoutesCheckbox->isChecked() && NetworkListView->childCount() > 0)
	{
		QStringList AdditionalNetworkRoutes;
		QListViewItemIterator it( NetworkListView );
		for ( ; it.current(); ++it )
		{
			QString network = QString(it.current()->text(0)+"/"+it.current()->text(1));
			AdditionalNetworkRoutes.append(network);
		}
		GlobalConfig->currentProfile->setAdditionalNetworkRoutes(AdditionalNetworkRoutes);
	}

	GlobalConfig->currentProfile->setUseSpecialServerCertificate(UseSpecialServerCertificateCheckBox->isChecked());
	if ( UseSpecialServerCertificateCheckBox->isChecked())
	{
		if (!SpecialServerCertificateURLRequester->url().isEmpty())
			GlobalConfig->currentProfile->setSpecialServerCertificate(SpecialServerCertificateURLRequester->url());
		else {
			KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No server certificate" ) );
			GlobalConfig->appendLogEntry( i18n( "Special server certificate can't be empty!" ) ,GlobalConfig->error);
		}
	}

	GlobalConfig->currentProfile->setRefuseEap(RefuseEapCheckbox->isChecked() );
	GlobalConfig->currentProfile->setRequireMppe(RequireMppeCheckbox->isChecked()  );
	GlobalConfig->currentProfile->setRefuse128BitEncryption(Refuse128BitEncryptionCheckbox->isChecked() );
	GlobalConfig->currentProfile->setRefuse40BitEncryption(Refuse40BitEncryptionCheckbox->isChecked() );
	GlobalConfig->currentProfile->setDisableMPPEComp(UseNoMPPECompressionCheckbox->isChecked() );
	GlobalConfig->currentProfile->setUseGetDnsFromPeer(GetDnsFromPeerCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseDnsServer(DnsServerCheckbox->isChecked() );
	GlobalConfig->currentProfile->setDnsServer(DnsServerLineedit->text() );
	GlobalConfig->currentProfile->setUseNoBsdComp(UseNoBsdCompCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseNoDeflate(UseNoDeflateCheckbox->isChecked());
	GlobalConfig->currentProfile->setSetDefaultRoute(SetDefaultRouteCheckbox->isChecked());
	GlobalConfig->currentProfile->setReplaceDefaultRoute(ReplaceDefaultRouteCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseMtu(MtuCheckbox->isChecked());
	GlobalConfig->currentProfile->setMtu(MtuSpinbox->value());
	GlobalConfig->currentProfile->setAllowStatefulMode(AllowStatefulModeCheckbox->isChecked());
	GlobalConfig->currentProfile->setUseNoIpDefault(UseNoIpDefaultCheckbox->isChecked());
	GlobalConfig->currentProfile->setDisableMPPEComp(UseNoMPPECompressionCheckbox->isChecked());



	GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" saved." ).arg( GlobalConfig->currentProfile->getName() ) ,GlobalConfig->debug);
}


void ProfileWidget::deleteSessionClicked()
{
	QString Name = ProfileComboBox->currentText();
	if ( !ProfileComboBox->currentText().isEmpty() )
	{
		int result = KMessageBox::questionYesNo ( this, i18n( "Really delete \"%1\"?" ).arg( Name ), i18n( "Delete?" ) );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3) // Yes
		{


			VpnAccountData * it;
			if (!GlobalConfig->AccountList->isEmpty())
			{
				for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
				{
					if ( ProfileComboBox->currentText().isEmpty() )
					{
						// 					this->deleteSessionAction->setEnabled ( FALSE );
						//			this->advancedSessionAction->setEnabled ( FALSE );
						// 					this->saveSessionAction->setEnabled ( FALSE );
					}
					else
					{
						if ( it->getName() == Name )
						{
							GlobalConfig->currentProfile=0L;
							GlobalConfig->AccountList->remove
							( it );
							ProfileComboBox->removeItem( ProfileComboBox->currentItem() );
							break;
						}
					}
				}
			}

			if ( !GlobalConfig->AccountList->isEmpty() )
			{
				GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
				ProfileComboBox->setCurrentText(GlobalConfig->AccountList->first()->getName());
				//ProfileComboBox->setSelected(0, true);
				profileChanged ( GlobalConfig->AccountList->first()->getName());
				connectionTypeChanged( GlobalConfig->AccountList->first()->getConnectionType() );
				authTypeChanged( GlobalConfig->AccountList->first()->getAuthType() );
				// 				buttonCancel->setEnabled( true );
				// 				buttonOk->setEnabled( true );
			}
			else
			{
				this->DeleteSessionPushButton->setEnabled ( FALSE );
				this->RenameSessionPushButton->setEnabled ( FALSE );
				this->SaveSessionPushButton->setEnabled ( FALSE );
				AdvancedSettingsPushButton->setEnabled( false );
				CiscoPptpGroupBox->setEnabled( false );
				//				FreeswanRacoonGroupBox->setEnabled( false );
				OpenvpnGroupBox->setEnabled( false );
				GeneralGroupbox->setEnabled( false );
				CommandExecutionGroupBox->setEnabled( false );
			}

			//		slotStatusMsg ( i18n( "Profile \"%1\" deleted." ).arg( Name ), ID_FLASH_MSG );

			GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" deleted." ).arg( Name ),GlobalConfig->debug );
			saveSessionClicked();

			profileAddedOrDeleted=true;
			//saveOptions(); // TODO save, currently after closing dialog
			//			sessionToggled();
			//if ( ProfileComboBox->currentText().isEmpty() )
			//	ProfileComboBox->setEnabled ( FALSE );
		}
	}

}

void ProfileWidget::slotCancelClicked()
{
	cancelClicked = true;
}

void ProfileWidget::advancedSettingsClicked()
{
	if (GlobalConfig->currentProfile ==0)
		return;

	AdvancedSettingsDialog d1(this, i18n("Advanced settings..."),GlobalConfig->currentProfile,GlobalConfig->currentProfile->getConnectionType(), GlobalConfig);

	d1.main->LocalPortCheckbox->setEnabled( false );
	d1.main->IkeGroupCheckbox->setEnabled( false );
	d1.main->PerfectForwardSecrecyCombobox->setEnabled( false );
	d1.main->SingleDesCheckbox->setEnabled( false );
	d1.main->NtDomainNameCheckbox->setEnabled( false );
	d1.main->LocalPortSpinbox->setEnabled( false );
	d1.main->ApplicationVersionLineedit->setEnabled( false );
	d1.main->NtDomainNameLineedit->setEnabled( false );
	d1.main->PerfectForwardSecurityCheckbox->setEnabled( false );
	d1.main->IkeGroupCombobox->setEnabled( false );
	d1.main->ApplicationVersionCheckbox->setEnabled( false );
	d1.main->UseGlobalIpsecSecretCheckbox->setEnabled( false );
	d1.main->IkeGroupCheckbox->setEnabled( false );



	d1.main->UseGlobalIpsecSecretCheckbox->setChecked ( GlobalConfig->currentProfile->getUseGlobalIpsecSecret() );
	d1.main->SingleDesCheckbox->setChecked( GlobalConfig->currentProfile->getUseSpecialRemoteID() );
	d1.main->IkeGroupCheckbox->setChecked ( GlobalConfig->currentProfile->getUseIkeGroup() );

	d1.main->PerfectForwardSecurityCheckbox->setChecked( GlobalConfig->currentProfile->getUsePerfectForwardSecrety() );
	d1.main->NtDomainNameCheckbox->setEnabled ( GlobalConfig->currentProfile->getUseNtDomainName() );
	d1.main->ApplicationVersionCheckbox->setEnabled ( GlobalConfig->currentProfile->getUseApplicationVersion() );
	d1.main->UseGlobalIpsecSecretCheckbox->setEnabled ( GlobalConfig->currentProfile->getUseGlobalIpsecSecret() );

	d1.main->LocalPortSpinbox->setValue( GlobalConfig->currentProfile->getLocalPort() );
	if (!GlobalConfig->currentProfile->getIkeGroup().isEmpty())
		d1.main->IkeGroupCombobox->setCurrentText( GlobalConfig->currentProfile->getIkeGroup() );
	if (!GlobalConfig->currentProfile->getPerfectForwardSecrety().isEmpty())
		d1.main->PerfectForwardSecrecyCombobox->setCurrentText( GlobalConfig->currentProfile->getPerfectForwardSecrety() );
	d1.main->NtDomainNameLineedit->setText( GlobalConfig->currentProfile->getNtDomainName() );
	d1.main->ApplicationVersionLineedit->setText( GlobalConfig->currentProfile->getApplicationVersion() );


	d1.main->NtDomainNameCheckbox->setChecked( GlobalConfig->currentProfile->getUseNtDomainName() );
	d1.main->NtDomainNameLineedit->setText( GlobalConfig->currentProfile->getNtDomainName() );

	if ( GlobalConfig->currentProfile->getUseAdvancedSettings() )
	{
		if (GlobalConfig->currentProfile->connectiontype == VpnAccountData::cisco)
		{
			d1.main->LocalPortCheckbox->setEnabled ( true );
			d1.main->PerfectForwardSecurityCheckbox->setEnabled ( true );
			d1.main->IkeGroupCheckbox->setEnabled( true );
			d1.main->SingleDesCheckbox->setEnabled ( true );
			d1.main->NtDomainNameCheckbox->setEnabled ( true );
			d1.main->ApplicationVersionCheckbox->setEnabled ( true );
			d1.main->UseGlobalIpsecSecretCheckbox->setEnabled ( true );
		}

		else if (GlobalConfig->currentProfile->connectiontype == VpnAccountData::racoon)
		{
			d1.main->LocalPortCheckbox->setEnabled ( true );
			d1.main->PerfectForwardSecurityCheckbox->setEnabled ( true );
			d1.main->IkeGroupCheckbox->setEnabled( true );
			//d1.main->SingleDesCheckbox->setEnabled ( true );
		}

		else if (GlobalConfig->currentProfile->connectiontype == VpnAccountData::pptp)
		{
			d1.main->NtDomainNameCheckbox->setEnabled ( true );
			d1.main->NtDomainNameCheckbox->setEnabled( true );
			//d1.main->NtDomainNameLineedit->setEnabled( true );

			d1.main->IkeGroupCheckbox->setEnabled( true );
			if (!GlobalConfig->currentProfile->getIkeGroup().isEmpty())
				d1.main->IkeGroupCombobox->setCurrentText(GlobalConfig->currentProfile->getIkeGroup());
		}


		d1.main->IkeGroupCheckbox->setChecked ( GlobalConfig->currentProfile->getUseIkeGroup() );

		d1.main->SingleDesCheckbox->setChecked( GlobalConfig->currentProfile->getUseSingleDes() );

		d1.main->IkeGroupCheckbox->setChecked ( GlobalConfig->currentProfile->getUseIkeGroup() );

		d1.main->UseGlobalIpsecSecretCheckbox->setChecked ( GlobalConfig->currentProfile->getUseGlobalIpsecSecret() );

		d1.main->PerfectForwardSecurityCheckbox->setChecked( GlobalConfig->currentProfile->getUsePerfectForwardSecrety() );

		if ( GlobalConfig->currentProfile->getUseNtDomainName() )
		{
			d1.main->NtDomainNameLineedit->setEnabled ( true );
			d1.main->NtDomainNameCheckbox->setChecked( true );
		}

		if ( GlobalConfig->currentProfile->getUseApplicationVersion() )
		{
			d1.main->ApplicationVersionLineedit->setEnabled ( true );
			d1.main->ApplicationVersionCheckbox->setChecked( true );
		}

		if ( GlobalConfig->currentProfile->getUseLocalPort() )
		{
			d1.main->LocalPortSpinbox->setEnabled ( true );
			d1.main->LocalPortCheckbox->setChecked( true );
		}

		d1.main->IkeGroupCombobox->setEnabled (  GlobalConfig->currentProfile->getUseIkeGroup() );

	}

	d1.exec();

	saveSessionClicked();

}

void ProfileWidget::pingIpToggled( bool )
{
	if ( PingCheckBox->isChecked() )
	{
		PingIPLineEdit->setEnabled( true );
	}
	else
	{
		PingIPLineEdit->setEnabled( false );
	}
}

void ProfileWidget::useSpecialRemoteIDClicked()
{
	if ( UseSpecialRemoteIDcheckBox->isChecked() )
		RemoteIDLineEdit->setEnabled( true );
	else
		RemoteIDLineEdit->setEnabled( false );
}


void ProfileWidget::renameSessionClicked()
{
	bool ok=false;
	QString oldName= GlobalConfig->currentProfile->getName();
	QString newName = KInputDialog::getText ( i18n("New name"),i18n("Enter new name for profile:"), oldName, &ok,this);

	if (ok)
	{
		GlobalConfig->currentProfile->setName(newName);
		int currIndex = ProfileComboBox->currentItem();
		ProfileComboBox->removeItem(currIndex);
		ProfileComboBox->insertItem(newName, currIndex);
		ProfileComboBox->setCurrentItem(currIndex);


		saveSessionClicked();


		GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" renamed to \"%2\"." ).arg(oldName).arg( GlobalConfig->currentProfile->getName() ),GlobalConfig->debug );
	}

}


void ProfileWidget::useVirtualIPClicked()
{
	if (UseVirtualIPCheckBox->isChecked())
		LocalVirtualIpEdit->setEnabled( TRUE );
	else
		LocalVirtualIpEdit->setEnabled( FALSE );
}

void ProfileWidget::PskInFileToggled()
{
	if (PskInFileCheckBox->isChecked())
	{
		LabelPskFile->setEnabled(TRUE);
		PSKFileURLRequester->setEnabled(TRUE);
		LabelPsk->setEnabled(FALSE);
		PSKLineEdit->setEnabled(FALSE);
	}
	else
	{
		LabelPskFile->setEnabled(FALSE);
		PSKFileURLRequester->setEnabled(FALSE);
		LabelPsk->setEnabled(TRUE);
		PSKLineEdit->setEnabled(TRUE);

	}
}

void ProfileWidget::additionalNetworkRoutesToggled(bool)
{
	if (UseExtraNetworkRoutesCheckbox->isChecked())
	{
		NetworkListView->setEnabled(TRUE);
		DeleteNetworkRoutePushButton->setEnabled(TRUE);
		AddRoutePushButton->setEnabled(TRUE);
	}
	else
	{
		NetworkListView->setEnabled(FALSE);
		DeleteNetworkRoutePushButton->setEnabled(FALSE);
		AddRoutePushButton->setEnabled(FALSE);
	}
}

void ProfileWidget::addNetworkRouteClicked()
{
	AddNetworkRouteDialog dlg(this, i18n("Add network route..."));
	if (dlg.exec())
	{
		NetworkListView->insertItem( new QListViewItem(NetworkListView, dlg.getNetwork(),dlg.getNetmask()));
	}
}


void ProfileWidget::delNetworkRouteClicked()
{
	if ( NetworkListView->childCount() > 0 && NetworkListView->currentItem()!= 0 )
	{
		QListViewItem *item = NetworkListView->currentItem();
		QString Network = item->text(0);
		QString Netmask = item->text(1);
		int result = KMessageBox::questionYesNo ( this, i18n( "Do you really want to delete the network \"%1/%2\"?" ).arg( Network ).arg(Netmask), i18n( "Delete?" ) );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3) // Yes
		{
			NetworkListView->removeItem(item);
		}
	}
}

void ProfileWidget::useSpecialServerCertificateToggled(bool)
{
	if (UseSpecialServerCertificateCheckBox->isChecked())
	{
		SpecialServerCertificateURLRequester->setEnabled(TRUE);
	}
	else
	{
		SpecialServerCertificateURLRequester->setEnabled(FALSE);
	}
}

void ProfileWidget::udpPortToggled(bool)
{
	if (UdpPortCheckbox->isChecked())
	{
		UdpPortSpinbox->setEnabled(TRUE);
	}
	else
	{
		UdpPortSpinbox->setEnabled(FALSE);
	}
}

void ProfileWidget::useUdpToggled (bool)
{
	if (UseUdpCheckbox->isChecked())
	{
		UdpPortCheckbox->setEnabled(TRUE);
		UdpPortSpinbox->setEnabled(FALSE);
	}
	else
	{
		UdpPortCheckbox->setEnabled(FALSE);
		UdpPortSpinbox->setEnabled(FALSE);
	}


}

void ProfileWidget::useDnsServerToggled(bool)
{
	if ( DnsServerCheckbox->isChecked() )
		DnsServerLineedit->setEnabled( true );
	else
		DnsServerLineedit->setEnabled( false );
}


void ProfileWidget::setDefaultRouteToggled(bool)
{
	if (SetDefaultRouteCheckbox->isChecked())
		ReplaceDefaultRouteCheckbox->setEnabled(true);
	else
		ReplaceDefaultRouteCheckbox->setEnabled(false);
}

void ProfileWidget::mtuToggled(bool)
{
	if (MtuCheckbox->isChecked())
		MtuSpinbox->setEnabled(true);
	else
		MtuSpinbox->setEnabled(false);
}

void ProfileWidget::userdefinedPortToggled(bool)
{
	if (UseUserdefinedPortCheckBox->isChecked())
		UserdefinedPortSpinBox->setEnabled(true);
	else
		UserdefinedPortSpinBox->setEnabled(false);
}

#include "profilewidget.moc"
