/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "toolinfo.h"
#include <qfile.h>
#include <iostream>
#include <klocale.h>


ToolInfo::ToolInfo(QString Name)
{
	this->Name = Name;
	/*
		if (!PathToExec.isEmpty())
			SearchPathList.append(PathToExec);*/
	// 	if (GlobalConfig->KvpncDebugLevel > 0)
	//std::cout << "Checking for: " << Name << std::endl;

	SearchPathList.append("/bin");
	SearchPathList.append("/sbin");
	SearchPathList.append("/usr/bin");
	SearchPathList.append("/usr/sbin");
	SearchPathList.append("/usr/local/bin");
	SearchPathList.append("/usr/local/sbin");
	SearchPathList.append("/root/bin");
	SearchPathList.append(QString (QString(getenv("$HOME"))+"/bin"));

	Version=i18n("No info");
}


bool ToolInfo::collectToolInfo()
{
	bool success=false;
	bool found=false;
	PathToExec="";
	for ( QStringList::Iterator it = SearchPathList.begin(); it != SearchPathList.end(); ++it )
	{
		if (!found)
		{
			// 		if (GlobalConfig.KvpncDebugLevel > 0)
			//std::cout << "looking in: " << *it << std::endl;
			QFile bin(QString(*it+"/"+Name));
			if (bin.exists())
			{
				PathToExec= QString(*it+"/"+Name);
				// 			if (GlobalConfig->KvpncDebugLevel > 0)
				//std::cout << Name << " found at "<< PathToExec << "." << std::endl;
				found=true;
				break;
			}
		}
	}
	if (!found)
	{
		// 		if (GlobalConfig->KvpncDebugLevel > 0)
		//std::cout << Name << " not found." << std::endl;
	}
	else
	{
		CollectToolInfoProcess = new QProcess(this);
		CollectToolInfoProcess->clearArguments();
		connect( CollectToolInfoProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutCollectToolInfo() ) );
		connect( CollectToolInfoProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrCollectToolInfo() ) );
		//connect( CollectToolInfoProcess, SIGNAL( processExited () ), this, SLOT(processFinished()  ) );
		bool run=true;

		//FIXME how it could be better?
		if (Name == "vpnc")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("--version");
		}
		else	if (Name == "ipsec")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("--version");
		}
		else	if (Name == "racoon")
		{

			// we need to do some stupid hack...
			// /usr/sbin/racoon -> /usr/sbin/setkey
			CollectToolInfoProcess->addArgument(QString(PathToExec.left(PathToExec.length()-6)+"setkey"));

			CollectToolInfoProcess->addArgument("-V");
		}
		else	if (Name == "setkey")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("-V");
		}
		else	if (Name == "openvpn")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("--version");
		}
		else	if (Name == "openssl")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("version");
		}
		else	if (Name == "pppd")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("--version");

		}
		else	if (Name == "iptables")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("-V");
		}
		else	if (Name == "kill")
		{
			run=false;
			success=true;
		}
		else	if (Name == "killall")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("-V");
		}
		else	if (Name == "ping")
		{
			CollectToolInfoProcess->addArgument(PathToExec);
			CollectToolInfoProcess->addArgument("-V");
		}
		else
		{
			std::cout << "Invalid tool!" << std::endl;
			run=false;
			success=false;
		}

		collectRunning=false;

		if (run )
		{

			if ( !PathToExec.isEmpty() && !CollectToolInfoProcess->start() )
			{
				//std::cerr << i18n("Unable to start collectToolInfo process (%1)!").arg(Name) << std::endl;

				//delete CollectToolInfoProcess;
				collectRunning=false;
				success=false;
			}
			else
			{
				collectRunning=true;
				while(CollectToolInfoProcess->isRunning() && collectRunning)
				{}

				//KMessageBox::information(0,QString("Name: "+Name+", Path: "+PathToExec+", Version: "+Version),"aaa");
				// 		disconnect( CollectToolInfoProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutCollectToolInfo() ) );
				// 		disconnect( CollectToolInfoProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrCollectToolInfo() ) );
				// 		delete CollectToolInfoProcess;
				success=true;
			}
		}

		disconnect( CollectToolInfoProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdOutCollectToolInfo() ) );
		disconnect( CollectToolInfoProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErrCollectToolInfo() ) );


		//std::cout << "Name: " << Name << ", Path: " << PathToExec << ", Version: " << Version << std::endl;
	}
	return success;
}


void ToolInfo::readStdOutCollectToolInfo()
{
	while (CollectToolInfoProcess->canReadLineStdout())
	{
		QString msg = QString( CollectToolInfoProcess->readLineStdout() );
		//	QString msg = QString( CollectToolInfoProcess->readStdout() );
		//	std::cout << "stdout collectToolInfo: " << msg<<std::endl;

		//FIXME how it could be better?
		if (Name == "vpnc")
		{
			if ( msg.find( "version", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "ipsec")
		{
			if ( msg.find( "version", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "racoon")
		{

			// we need to do some stupid hack...
			// /usr/sbin/racoon -> /usr/sbin/setkey
			CollectToolInfoProcess->addArgument(QString(PathToExec.left(PathToExec.length()-6)+"setkey"));
			if ( msg.find( "ipsec-tools", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',3,3);
			}
		}
		else	if (Name == "setkey")
		{
			if ( msg.find( "ipsec-tools", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',3,3);
			}
		}
		else	if (Name == "openvpn")
		{
			if ( msg.find( "built", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "openssl")
		{
			if ( msg.find( "OpenSSL", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "pppd")
		{
			if ( msg.find( "version", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "iptables")
		{
			if ( msg.find( "iptables", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "ping")
		{
			if ( msg.find( "ping", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else
		{
			;
		}
	}
	collectRunning=false;
}

void ToolInfo::readStdErrCollectToolInfo()
{
	while (CollectToolInfoProcess->canReadLineStderr())
	{
		QString msg = QString( CollectToolInfoProcess->readLineStderr() );
		//std::cout << "stderr collectToolInfo (" << Name << "): " << msg << std::endl;

		if (Name == "pppd")
		{
			if ( msg.find( "version", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "killall")
		{
			if ( msg.find( "killall", 0, FALSE ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
	}
}


void ToolInfo::processFinished()
{
	collectRunning=false;
}

void ToolInfo::addSearchPath(QString )
{
	/*
	std::cout << "Path added: " << path << std::endl;
	if (!path.isEmpty())
		SearchPathList.insert(SearchPathList.begin(), QString(path));
	else
	*/
	return;
}
