/*****************************************************************************
 * Copyright (C) 2008-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef PROFILEIPSECOPTIONS_H
#define PROFILEIPSECOPTIONS_H

#include <QtGui/QWidget>

#include "ui_profileipsecoptionsbase4.h"

class ProfileIpsecOptions  :  public QWidget, public Ui_ProfileIpsecOptionsBase
{
    Q_OBJECT

public:
    ProfileIpsecOptions(QWidget *parent);
    ~ProfileIpsecOptions();

    bool dialogModified;

public slots:
    void useRightNextHopToggled(bool);
    void useLeftNextHopToggled(bool);
    void useEspToogled(bool);
    void useIkeToggled(bool);
    void localIDTypeToggled(const QString& text);
    void ikeHelpClicked(int, int);
    void espHelpClicked(int, int);

private slots:
    void dialogChanged();

signals:
    void changed();

};

#endif
