/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilenetworkhttpproxyoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>
#include <QtGui/QSpinBox>

#include <kcombobox.h>
#include <knuminput.h>
#include <kpassworddialog.h>
#include <kurlrequester.h>

#include "widgetnotifyhelper.h"

ProfileNetworkHttpProxyOptions::ProfileNetworkHttpProxyOptions(QWidget *parent)
{
    Q_UNUSED(parent);

    setupUi(this);
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
}



ProfileNetworkHttpProxyOptions::~ProfileNetworkHttpProxyOptions()
{}


void ProfileNetworkHttpProxyOptions::useHttpProxyToggeled(bool)
{
    if (UseHttpProxyCheckBox->isChecked()) {
        HostTextLabel->setEnabled(true);
        UseHttpProxyAuthCheckBox->setEnabled(true);
        HttpProxyLineEdit->setEnabled(true);
        HttpProxyPortIntNumInput->setEnabled(true);
        HttpProxyTimeoutIntSpinBox->setEnabled(true);
        TimeoutTextLabel->setEnabled(true);
        HostTextLabel->setEnabled(true);
        PortTextextLabel->setEnabled(true);

    } else {
        HttpProxyGroupBox->setEnabled(false);
        UseHttpProxyAuthCheckBox->setEnabled(false);
        HttpProxyLineEdit->setEnabled(false);
        HttpProxyPortIntNumInput->setEnabled(false);
        HttpProxyTimeoutIntSpinBox->setEnabled(false);
        TimeoutTextLabel->setEnabled(false);
        HostTextLabel->setEnabled(false);
        PortTextextLabel->setEnabled(false);
    }
}


void ProfileNetworkHttpProxyOptions::useHttpProxyAuthToggeled(bool)
{
    if (UseHttpProxyAuthCheckBox->isChecked()) {
        HttpProxyAuthTextLabel->setEnabled(true);
        HttpProxyAuthTypeComboBox->setEnabled(true);
        HttpProxyUserTextLabel->setEnabled(true);
        HttpProxyUserLineEdit->setEnabled(true);
        HttpProxyPassTextLabel->setEnabled(true);
        HttpProxyAuthPasswordEdit->setEnabled(true);
    } else {
        HttpProxyAuthTextLabel->setEnabled(false);
        HttpProxyAuthTypeComboBox->setEnabled(false);
        HttpProxyUserTextLabel->setEnabled(false);
        HttpProxyUserLineEdit->setEnabled(false);
        HttpProxyPassTextLabel->setEnabled(false);
        HttpProxyAuthPasswordEdit->setEnabled(false);
    }
}

void ProfileNetworkHttpProxyOptions::dialogChanged()
{
    dialogModified = true;
}













