###
### $Rev: 42 $
### $Release: 0.5.1 $
### copyright(c) 2005 kuwata-lab all rights reserved.
###

unless defined?(TESTDIR)
   TESTDIR = File.dirname(__FILE__)
   libdir  = File.dirname(TESTDIR) + "/lib"
   $LOAD_PATH << libdir << TESTDIR
end

require 'test/unit'
require 'test/unit/ui/console/testrunner'
require 'kwalify'
require 'kwalify/util/assert-diff'
require 'yaml'


class RuleTest < Test::Unit::TestCase

   ## define test methods
   testdata_filename = __FILE__.sub(/\.rb$/, '.yaml')
   str = File.read(testdata_filename)
   @@docs = {}
   YAML.load_documents(str) do |doc|
      name = doc['name']
      !@@docs.key?(name) or raise "*** test name '#name}' is duplicated."
      @@docs[name] = doc
      doc.each do |key, val|
         if key =~ /\A(.*)\*\z/
            doc[$1] ||= val['ruby']
         end
      end
      doc['schema'] = YAML.load(doc['input'])
      s = <<-END
         def test_#{name}
            doc = @@docs['#{name}']
            @name    = doc['name']
            @desc    = doc['desc']
            @input   = doc['input']
            @schema  = doc['schema']
            @exception   = #{doc['exception'] == nil ? 'nil' : doc['error']}
            _test()
         end
      END
      eval s
   end

   ## execute test
   def _test()
      assert_nothing_raised do
         return if $target && $target != @name
         schema = @schema
         rule = Kwalify::Rule.new(schema)
      end
   end

end

