#############################################################################
##    Kwave                - kwave.spec
##                           -------------------
##    begin                : Sun Feb 03 2008
##    copyright            : (C) 2008 by Thomas Eschenbacher
##    email                : Thomas.Eschenbacher@gmx.de
#############################################################################
#
#############################################################################
##                                                                          #
##    This program is free software; you can redistribute it and/or modify  #
##    it under the terms of the GNU General Public License as published by  #
##    the Free Software Foundation; either version 2 of the License, or     #
##    (at your option) any later version.                                   #
##                                                                          #
#############################################################################

# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild

%define ver 0.8.12
%define release 1

Summary:        KDE, Qt, WAV, Sound, Editor, Effects, playback, recording
License:        GPL
Group:          Productivity/Multimedia/Sound/Editors and Convertors

Name:           kwave
Version:        0.8.12
Release:        1
Source0:        kwave-%{version}-1.tar.bz2
Url:            http://kwave.sourceforge.net
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
# hack for SLE
%ifarch i586
BuildArch:      i586
%endif
%ifarch x86_64
BuildArch:      x86_64
%endif

# common for all distributions
Requires:       %{name}-lang = %{version}
Requires:       audiofile >= 0.3.0
Requires:       flac
Requires:       libogg.so.0 >= 0.4.0
Requires:       libsamplerate >= 0.1.3
Requires:       libvorbis >= 1
Requires:       libvorbisenc.so.2 >= 2.0.0
BuildRequires:  ImageMagick
BuildRequires:  cmake >= 2.6.0
BuildRequires:  gettext-devel
BuildRequires:  sed

# SuSE specific:
%if %{defined suse_version}
Prefix:         /usr
Requires:       %kde4_runtime_requires
Requires:       alsa
Requires:       fftw3 >= 3.0
Requires:       libqt4 >= 4.7
Requires:       libopus
Requires:       pulseaudio >= 0.9.16
BuildRequires:  alsa-devel
BuildRequires:  audiofile-devel >= 0.3.0
BuildRequires:  awk
BuildRequires:  fdupes
BuildRequires:  fftw3-devel >= 3.0
BuildRequires:  flac-devel
BuildRequires:  kde4-l10n-devel
%if %{suse_version} >= 1301
BuildRequires:  kdemultimedia
%else
BuildRequires:  kdemultimedia4
%endif
BuildRequires:  libkde4-devel >= 4.0
BuildRequires:  libogg-devel >= 1
BuildRequires:  libopus-devel
BuildRequires:  libqt4-devel > 4.7
BuildRequires:  libsamplerate-devel
BuildRequires:  libvorbis-devel
BuildRequires:  pulseaudio-devel
BuildRequires:  rsvg-view
BuildRequires:  update-desktop-files
# BuildRequires:  librsvg
# BuildRequires:  python

%define EXTRA_OPTS ""
%define FDUPES %fdupes -s %{buildroot}
%endif

# CentOS specific:
%if %{defined centos_version}
Prefix:         /usr
Requires:       alsa-lib
Requires:       fftw3 >= 3.0
Requires:       kdelibs >= 4.0
Requires:       libopus
BuildRequires:  alsa-lib-devel
BuildRequires:  audiofile-devel >= 0.3.0
BuildRequires:  fftw3-devel >= 3.0
BuildRequires:  flac-devel
BuildRequires:  gawk
BuildRequires:  gcc-c++
BuildRequires:  kdemultimedia-devel >= 4.0
BuildRequires:  kdesdk >= 4.0
BuildRequires:  libogg-devel >= 1
BuildRequires:  libopus-devel
BuildRequires:  libsamplerate-devel
BuildRequires:  libvorbis-devel
BuildRequires:  pulseaudio-libs-devel
%define _kde4_applicationsdir /usr/share/applications/kde4/
%define _kde4_modulesdir %{_kde4_libdir}/kde4/plugins
%define _kde4_htmldir /usr/share/doc/HTML/
%endif

# Fedora specific:
%if %{defined fedora}
Prefix:         /usr
Requires:       alsa-lib
Requires:       fftw3 >= 3.0
Requires:       kdelibs >= 4.0
%if %{fedora_version} > 18
Requires:       opus
%else
Requires:       libopus
%endif
Requires:       pulseaudio >= 0.9.16
Requires:       qt4 >= 4.7
Requires:       qt4-x11 >= 4.7
BuildRequires:  alsa-lib-devel
BuildRequires:  audiofile-devel >= 0.3.0
BuildRequires:  fdupes
BuildRequires:  fftw3-devel >= 3.0
BuildRequires:  flac-devel
BuildRequires:  gawk
BuildRequires:  gcc-c++
BuildRequires:  kdelibs-devel >= 4.0
BuildRequires:  kdemultimedia-devel >= 4.0
%if %{fedora_version} > 19
BuildRequires:  poxml
%else
BuildRequires:  kdesdk-utils >= 4.0
%endif
BuildRequires:  libogg-devel >= 1
%if %{fedora_version} > 18
BuildRequires:  opus-devel
%else
BuildRequires:  libopus-devel
%endif
BuildRequires:  libsamplerate-devel
BuildRequires:  libvorbis-devel
BuildRequires:  pulseaudio-libs-devel >= 0.9.16
BuildRequires:  qt4-devel >= 4.7.0
%define EXTRA_OPTS ""
%define FDUPES fdupes -s %{buildroot}
%define _kde4_applicationsdir /usr/share/applications/kde4/
%define _kde4_modulesdir %{_kde4_libdir}/kde4/plugins
%define _kde4_htmldir /usr/share/doc/HTML/
%endif

# RedHat specific:
%if %{defined rhel_version}
Requires:       alsa-lib
Requires:       fftw3
Requires:       flac
Requires:       libogg
Requires:       libopus
Requires:       libsamplerate
Requires:       kdelibs >= 4.0
Requires:       pulseaudio >= 0.9.16
Requires:       pulseaudio-libs >= 0.9.16
Requires:       qt4 >= 4.7
Requires:       qt4-x11 >= 4.7
BuildRequires:  alsa-lib-devel
BuildRequires:  audiofile-devel >= 0.3.0
BuildRequires:  fftw3
BuildRequires:  fftw3-devel
BuildRequires:  flac
BuildRequires:  gcc-c++
BuildRequires:  kdelibs-devel >= 4.0
BuildRequires:  kdesdk-utils >= 4.0
BuildRequires:  libogg-devel >= 1
BuildRequires:  libopus-devel
BuildRequires:  libsamplerate-devel
BuildRequires:  libvorbis-devel
BuildRequires:  pulseaudio-libs-devel
BuildRequires:  qt-devel >= 4.7
%define _kde4_applicationsdir /usr/share/applications/kde4
%define _kde4_modulesdir %{_kde4_libdir}/kde4/plugins
%define _kde4_htmldir /usr/share/doc/HTML
%define EXTRA_OPTS -DWITH_FLAC=OFF
%endif

# Mandriva specific:
%if %{defined mandriva_version}
Prefix:         /usr
Requires:       alsa-lib
Requires:       fftw3 >= 3.0
Requires:       id3lib >= 3.8.1
Requires:       kdelibs4 >= 4.0
Requires:       kdemultimedia4 >= 4.0
Requires:       libopus
BuildRequires:  alsa-lib-devel
BuildRequires:  aspell-cs
BuildRequires:  aspell-de
BuildRequires:  aspell-es
BuildRequires:  aspell-fr
BuildRequires:  audiofile-devel >= 0.3.0
BuildRequires:  fftw3-devel >= 3.0
BuildRequires:  gawk
BuildRequires:  gcc-c++
BuildRequires:  id3lib-devel >= 3.8.1
BuildRequires:  kde-l10n-cs >= 4.0
BuildRequires:  kde-l10n-de >= 4.0
BuildRequires:  kde-l10n-es >= 4.0
BuildRequires:  kde-l10n-fr >= 4.0
BuildRequires:  kdelibs4-devel
BuildRequires:  kdemultimedia4-devel
BuildRequires:  kdesdk4-po2xml
BuildRequires:  libflac++-devel
BuildRequires:  libmad >= 0.14
BuildRequires:  libmad-devel >= 0.14
BuildRequires:  libogg-devel >= 1
BuildRequires:  libopus-devel
BuildRequires:  libsamplerate-devel
BuildRequires:  libvorbis-devel
BuildRequires:  pulseaudio-devel >= 0.9.16
%define _kde4_bindir /usr/bin
%define _kde4_libdir /usr/lib*
%define _kde4_appsdir /usr/share/apps
%define _kde4_iconsdir /usr/share/icons
%define _kde4_applicationsdir /usr/share/applications/kde4
%define _kde4_modulesdir %{_kde4_libdir}/kde4/plugins
%define _kde4_htmldir /usr/share/doc/HTML

# Mandriva has paid for using patented MP3 code and therefore are
# allowed to ship with MP3 support
%define MP3ENABLED "-DWITH_MP3=ON"
%define EXTRA_OPTS ""
%else
# all other distributions are not allowed to ship with MP3 support,
# at least not in the USA
%define MP3ENABLED "-DWITH_MP3=OFF"
%endif

%description
With Kwave you can record, play back, import and edit many
sorts of audio files including multi-channel files.<br>
Kwave includes some plugins to transform audio files in
several ways and presents a graphical view with a complete
zoom- and scroll capability.

%package doc
Summary:        HTML Documentation of Kwave
Group:          Documentation/HTML
BuildArch:      noarch

%description doc
This package contains the HTML documentation for Kwave

%package lang
Summary:        Languages for package Kwave
Group:          System/Localization
BuildArch:      noarch

%description lang
Provides translations to the package Kwave

%prep
%setup -q

%build
unset DESTDIR
mkdir build
cd build
CXXFLAGS="${CXXFLAGS} ${RPM_OPT_FLAGS}" CFLAGS="${CFLAGS} ${RPM_OPT_FLAGS}" \
    cmake ${CONFIGURE_OPTS} %{MP3ENABLED} %{EXTRA_OPTS} ..
cd -

make -C build %{?jobs:-j %jobs}

%install
make -C build DESTDIR="$RPM_BUILD_ROOT" SUID_ROOT="" install
%if %{defined FDUPES}
    %{FDUPES}
%endif
%find_lang kwave %{name}.lang

%files
%defattr(-,root,root)
%doc GNU-LICENSE AUTHORS LICENSES CHANGES README TODO kwave.lsm
%{_kde4_bindir}/%name
%{_kde4_applicationsdir}/%{name}.desktop
%{_kde4_libdir}/libkwave*
%{_kde4_appsdir}/%{name}
%{_kde4_modulesdir}/*
%{_kde4_iconsdir}/*
%exclude %{_kde4_htmldir}/*/%{name}

%files doc
%defattr(-,root,root,-)
%doc %{_kde4_htmldir}/*/%{name}

%files lang -f %{name}.lang
%defattr(-,root,root,-)
%exclude %{_kde4_htmldir}/*/%{name}

%clean
rm -Rf "$RPM_BUILD_ROOT"

%post
ldconfig

%postun
ldconfig

%changelog

-------------------------------------------------------------------
Sat May 31 2014 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.12
- recording via PulseAudio, by Joerg-Christan Boehme <joerg@chaosdorf.de>
- bugfix: "Close" button of the record dialog did not save settings
- bugfix: amplify free plugin: untranslated action names in progress bar
- bugfix: sonagram plugin did not honor the windowing function parameter
- bugfix: coherency problems in overview cache
- bugfix: metadata got lost after cut/undo/redo
- bugfix: save/as check against overwriting existing files failed
- bugfix: undo/redo did not work after recording
- bugfix: signal was "modified" after canceled record (empty) / done
- bugfix: wrong calculation of zoom and window geometry at startup
- bugfix: wrong scaling of overview in sonagram window
- bugfix: playback pointer did not update synchronously across tracks
- bugfix: brought back support for optimized memcpy (from xine-lib)
- updated memcpy.c + cpu detection, including AVX assembler support
- new command line option: "--logfile=<FILE>" for logging to a file
- brought back the horizontal scroll bar
- support for swap files to store undo data
- speedup: too many copy-on-write operations, use more const data
- improved robustness against out of memory situations
- memory manager: added statistics for debugging
- memory settings: only use up to 25% of process address space
- internal cleanups: renamed openSampleReader -> openReader,
  fixed signature of Signal/SignalManager::openWriter
- speedup: use stripe list instead of raw data for saving undo data
- debug plugin: added functions "labels_at_stripes", "sawtooth_verify"
  and "dump_metadata"
- automatic defragmentation of stripes
- sonagram plugin: use Qt Concurrent framework -> more than factor 40
  faster on a quad core cpu
- got rid of KDE ThreadWeaver, replaced with Qt Concurrent framework
- debug plugin: added function "fm_sweep"
- workaround for broken WAV files with zeroed fact chunk
- fixed many 32/64 bit issues
- new build target "make wrapper": creates a wrapper script to start Kwave
  for test/debug purpose
- new build target "make dep": creates a binary debian package
  (for personal use and testing purposes)
- mouse wheel + Ctrl: zoom in/out aligns signal to mouse position
- record plugin: level meter is always enabled, simplified dialog
- PulseAudio playback: fixed wrong timeout calculation
- requires at least Qt-4.7 + FLAC-1.2.0

-------------------------------------------------------------------
Sun Nov 24 2013 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.11
- added spanish translation, provided by Carlos R. <pureacetone@gmail.com>
- bugfix: file names were not properly escaped in context of file/open,
  file/openrecent and drag&drop
- bugfix: saveblocks() did not abort properly when pressing cancel
- unclean shutdown of the file progress dialog when saving
- noise plugin: add noise (mix) instead of overwrite, with adjustable
  level in percent or dB
- pause button: change tooltip to "continue" if paused
- new command line option: "--disable-splashscreen"
- new command line option: "--iconic" to start minimized
- fixed quoting errors in CMakeLists.txt (cmake-2.8.12 complained)
- bugfix: ASCII encoder: escape special characters in meta data
- implementation of ASCII import
- memory settings: raised default memory limits
- bugfix: crash in file info dialog / auto generate keywords
- MP3 plugin: use ID3 tag TSSE for software version
- ASCII codec: implemented support for labels

-------------------------------------------------------------------
Sat Feb  9 2013 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.10
- file name cleanup: removed "Kwave" prefix
- bugfix: added range checks for track selection commands
- reverted changes in sample writer due to problems in debug mode (commits
   ee54660d4380d264b7346a904eff9dd8d8d00a93 and
   6fba04db879ea7ae1fdf79141dd93d47f9c1d403)
- bugfix: unwanted termination if splash screen closed while the first
  toplevel widget still was starting up
- moved code into namespace "Kwave"
- cleanup: remove support for outdated FLAC API versions below 1.1.3
- removed unused code: libkwave/FileFormat.*
- renamed source files with "Kwave" in the name
- added subsystem prefix to inclusion of Qt header files
- using bit types from qt (e.g. u_int32_t => quint32)
- compile with DQT_NO_CAST_TO_ASCII and QT_NO_CAST_FROM_ASCII
- bugfix: recording via OSS did not handle invalid devices properly
- improved auto detect of svg-to-png conversion,
  added support for "rsvg-convert" (SF bug #38)
- removed dependency to ImageMagick if "rsvg" is available
- replaced libkwave/byteswap.h with generic Qt functions
- replaced some Qt classes with their KDE equivalent:
  KLineEdit, KComboBox, KDialogButtonBox, KPushButton, KTabWidget, KTextEdit
- using KDE standard buttons in dialogs
- simplified plugin loading mechanism, do load/unload only at start/end of
  the program
- delete plugin settings of old versions when detected
- using QLibrary instead of functions from libdl
- bugfix: shutdown sequence was incomplete
- bugfix: keyboard shortcut for first menu entry did not work
- bugfix: ambiguous keyboard shortscut for "File/New Window"
- bugfix: undo of "modify label" caused loss of other labels
- bugfix: use timeout for phonon playback, to avoid hang on unusable devices
- using klocale for formating numbers of samples
- added common base class for all codec plugins
- reduced quality level of sample rate converter from "best" to "medium",
  to improve speed
- refactored playback handling (controller vs. plugin)
- workaround for bug in Phonon: no device names available in first call to
  Phonon::BackendCapabilities::availableAudioOutputDevices()
- moved playback test into worker thread, for better GUI responsiveness
- Phonon playback: changed to own mainloop with timeout support to avoid
  application hang on broken audio devices
- bugfix: data loss in sample rate converter when processing streams
- vorbis encoder: call to deprecated API (now use OV_ECTL_RATEMANAGE2_SET)
- using estimated length for streaming file formats without length info
- made sample rate conversion (libsamplerate) mandantory
- increased default memory sizes
- added toolbar buttons for "File/SaveAs" and "File/Close"
- reordered toolbars

-------------------------------------------------------------------
Tue Nov  6 2012 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.9
- new feature: MP3 export via external program "lame", "toolame" and
  "twolame", with configurable command line options
- new feature: allow change of compression type via file info
- fix for SF #3528848, removed -Wl,--add-needed from plugin LINK_FLAGS
- speedup: improved performance of sample writer
- wav import/export: support for some more meta data tags
- bugfix: meta data lost when writing wav files that had meta data for
  product/album or subject/track at the same time
- bugfix: broken signal/slot connection in SaveBlocks plugin
- workaround for bug in id3lib, SF #3534143:
  ignore id3lib crc check result for MPEG Layer II files
- bugfix: Gentoo ebuild lacked required svg use flag for media-gfx/imagemagick
  and media-gfx/graphicsmagick
- bugfix: File/SaveAs now uses last recently used directory and extension
  together with the user defined file name
- bugfix: PluginManager::sync caused application slowdown or stale GUI

-------------------------------------------------------------------
Sun May 20 2012 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.8
- new feature: seek functionality for playback
- new feature: added toolbar with record/playback/scroll functions
- migration to GIT as source code management
- documentation update
- allowing zoom and scroll while a plugin is running
- allow "close" and "quit" while playback is running
- allow track selection change during playback
- fix for namespace collision with libaudiofile
- bugfix: mouse selection update with negative offset failed
- bugfix: wrong focus of progress dialog when repairing damaged wav files
- bugfix: missing updates of zoom selection combo box
- bugfix: when viewing with full zoom, scroll by 1 sample was possible
- bugfix: focus was wrong on program start (zoom combo box)
- bugfix: wrong view when moving slider of overview widget to negative value
- bugfix: playback pointer did not disappear after play - pause - stop
- bugfix: creating a label without text was not possible
- bugfix: saving WAV with G.711 and non-16bits/sample produced broken output
- bugfix: handling of shortened tracks in encoders

-------------------------------------------------------------------
Sun Nov 27 2011 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.7
- ebuild update for media-gfx/imagemagick <-> media-gfx/graphicsmagick
  (see gentoo bug #314325)
- new feature: "insert at", paste clipboard at given position
- fix for API change in libaudiofile v0.3.1
- speedup: loading ogg/mp3 is much faster now (up to factor 2)
- bugfix: stream name of pulse audio playback used wrong encoding
- update of the Kwave spec file (synced with OpenSuSE build service version)
- new build target "distfiles"
- updated version of the GPL v2 document (GNU-LICENSE)
- support for visualization plugins

-------------------------------------------------------------------
Mon Mar  7 2011 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.6
- bugfix: copy/paste with partial track selection failed
- bugfix: labels update after undo of copy&paste failed on multitrack signals
- string/i18n update from Panagiotis Papadopoulos
- bugfix: invocation of xgettext was wrong, left untranslated strings
- plugin API change: support for translateable short description
- about plugin: use plugin info from PluginManager
- bugfix: last directory of file dialogs sometimes got lost
- bugfix: wrong message when canceling Ogg import
- replaced sched_yield() with QThread::yieldCurrentThread()
- added cmake parameter for disabling optimized memcpy support
  -D WITH_OPTIMIZED_MEMCPY=OFF, default is ON
- integrated patch #3021795 for Qt-4.7 compatibility
- bugfix: optimized memcpy for PPC (SF bug #3068664)
- doc: upgrade to DocBook XML V4.2 / V1.1
- build fixes for qt-4.7
- no longer using QSplashScreen (has side effects, operates as modal window)
- bugfix: startup as unique application did not work correctly
- bugfix: potential crash in message loop of progress dialog
- bugfix: handling of track selection was wrong in reverse plugin
- workaround for bug in libaudiofile: some files have sampe rate zero,
  falling back to 8000 samples/sec in that case (audio/x-ircam, sun, BE)
- bugfix: reverse failed on files smaller than the internal block size
- using entities for URLs in handbook, to simplify maintenance
- bugfix in cmake files: some invocations of STREQUAL lacked quotes

-------------------------------------------------------------------
Thu Dec 24 2009 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.5
- new feature: playback via PulseAudio
- applied kwave-0.8.2-nolinguas.patch (see gentoo bug #267702)
- support for the Gentoo build system that steals .po files
- no longer default to english language for documentation and gui l10n
- fixed use count mismatch of plugins
- bugfix: playback control: continuing after pause continued from start
- bugfix: G.711 encoded wav files support only 16 bit signed format
- new assignment for mouse wheel:
  * without modifier key: scroll left/right
  * with Shift: page left/right
  * with Ctrl: zoom in/out
  * with Alt: vertical zoom in/out
- bugfix: support sysinfo.mem_unit when >= 4GB RAM are installed
- bugfix: crash in progress dialog handling (crashed when closing a plugin
  after finishing it's work)
- new ebuild for Gentoo

-------------------------------------------------------------------
Sat Sep 26 2009 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.4
- new feature: support for primitive macros (batch files), playback only
- new plugin: change sample rate
- using libsamplerate (new dependency)
- new feature: sample rate conversion on clipboard data
- new feature: abillity to set recording start time in advance
  (feature requested by John David Thompson)
- bugfix: drag&drop of files on the main window was broken
- workaround for bug in id3lib which crashed in ID3_Tag::GetSize()
  with some MP3 files (see id3lib upstream bug at SF #2821464)
- bugfix: recording via ALSA, crash on snd_pcm_close(),
  see SF bug #2816544
- bugfix: playback plugin: infinite loop when switching from OSS to ALSA
- bugfix: forcing clipboard and drag&drop data to uncompressed mode
- bugfix: deadlock in progress bar handling
- bugfix: crash when unloading plugins with queued events
- help/about dialog: hide "translators" tab if no translator available
- help/about dialog: hack to allow web addresses of translators
- bugfix: selection was not set after "paste" and undo of other operations
- bugfix: label handling in context of "delete" and "undo" was broken
- bugfix: invalidation of overview cache after delete was not correct
- bugfix: artefacts in track display in min/max overview mode
- bugfix: add/delete/modify of labels did not set the state of the
  current file to "modified"
- bugfix: record dialog caused shutdown to hang when closed while recording
- bugfix: decoding 32bit/sample was broken
- bugfix: recording level meter consumed 100% cpu
- new make target: "make apidoc" for internal doxygen documentation
- bugfix: some images and icons in non-english documentation were missing
- volume plugin: preview was not updated on first use of plugin

-------------------------------------------------------------------
Sat Jul  4 2009 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.3-2
- bugfix: re-enabled detection of optimized memcpy function
- bugfix: deadlock in recording plugin and plugin management
  (see SF bug #2816544)
- bugfix: ID3 tag import did not work
- taking ID3 tag for "album" as "product" in wav meta data
- taking ID3 tag for "track" as "subject" in wav meta data

-------------------------------------------------------------------
Sun Jun 28 2009 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.3
- integrated 05-do-not-install-so-symlinks.diff from Debian
  (thanks to Aurelien)
- cs i18n update from Pavel Fric
- new plugin: normalize
- progress bar in volume plugin did not work
- flattened "Fx" menu, no submenus for amplify and filter
- bugfix: workaround for libaudiofile bug produced wrong header
  in 24bit/sample mode
- bugfix: "fade outro" was broken
- bugfix: the dialog when playing the test sound in the playback
  setup dialog did not appear
- replaced qreal with double (fixes build problems on arm)
- show hourglass / progress bar when undo/redo is running
- flattened "Calculate" menu, no submenus for "Frequencies"
- wav encoder: auto-switch to unsigned format for <= 8bit and
  signed format for > 8 bit per sample
- volume plugin: show a little "preview" for guessing the level
- bugfix: after deleting a track, file info was not updated
- about plugin: separate tab for translators
- made plugin API version configurable per plugin
- recognize mime type "audio/x-vorbis+ogg" (found in KDE-4)
- updated czech gui translation and user manual from Pavel Fric
- bugfix: crashes when deleting objects that still have event queued
  with Qt::QueuedConnection -> now using Qt::BlockingQueuedConnection
- new plugin: reverse
- speedup: limiting the number of progress bar updates per second
- memory manager: fixed multithreading issues, improved OOM behaviour
- bugfix: received SIGBUS in SwapFile when disk was full
- improved performance of memory management
- require Qt4 v4.5.0 or newer

-------------------------------------------------------------------
Sat Apr 25 2009 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.2
- bugfix: minor off-by-one bug in buffer handling
- wav/RIFF parser: be more robust if the file has not been correctly padded
- bugfix in wav encoder: padding for info and label chunk was missing
- bugfix: if two markers were too close and displayed at the same
  pixel position they eliminated each other through XOR mode
- bugfix: numeric overflow when trying to select labels in high zoom factors
- bugfix: not all positions were selectable due to internal rounding errors
- silence plugin now supports all modes
- use "unsigned" sample format per default when creating new files
  with <= 8 bits/sample
- bugfix: playback position was shown on startup
- bugfix: show correct file size in progress dialog
- bugfix: crash when deleting label from end of signal
- bugfix: overview was wrong when deleted space after signal was visible
- bugfix: overview was not always synchronized after delete/insert
- bugfix: "modified" state got lost during undo
- use ALSA per default for playback/record if nothing has been selected yet
- fixed calculation of undo/redo sizes
- undo/redo handling for sample range and track selection
- processing updates of overview widget in a background thread
- memory management: no longer evaluate RLIMIT_RSS, gives more
  available physical memory
- portability fix: swapfile creation/destruction went wrong
- feature: memory for undo/redo can now be configured
- bugfix: handling of "continue without undo" produced wrong undo/redo states
  and asked several times
- bugfix: file progress did not do GUI updates, cancel button did not work
- bugfix: assert in record plugin if no valid sample rate available
- speedup for generation of signal overviews in min/max mode
- bugfix: MultiTrackWriter produced one extra sample (off by one error)
- workaround for bug in libaudiofile: sometimes libaudiofile produces
  broken files as it uses 'float' for internal calculations (wrong size
  of 'data' and 'RIFF' chunk) => see ubuntu bug #327018
- implemented "debug" plugin, with internal functions for test and
  verification (quality improvement)
- added czech gui translation from Pavel Fric <pavelfric@seznam.cz>
- bugfix: after creating a new empty file, "revert" was possible
- speed optimizations in buffer handling
- speedup: limiting the rate of progress updates when loading and saving files
- fixed displayed names of actions based on the "amplifyfree" plugin
- bugfix: menu entry translation did not work correctly
- bugfix: deleteLater on menu nodes did not work,
  implemented own garbage collector
- speedup: use different block sizes for interactive and non-interactive mode
- i18n fix: texts in help/about menu were untranslated
- about plugin: new tab for translators

-------------------------------------------------------------------
Tue Dec 23 2008 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.1
- replaced application icon, now using a scalable svg image
- replaced GSL with FFTW3, which is license compatible with Kwave
- use implicit sharing for Label class
- new clipboard implementation, using the clipboard of KDE (X11)
- fixed enable/disable of copy/paste functions depending on clipboard state
- re-enabled function "flush clipboard"
- re-enabled function "invert track selection"
- re-enabled function "select all tracks"
- implemented plugin for "go to position..."
- added status bar item for current cursor position
- show current playback position in status bar
- show selection in overview widget
- bugfix: mode switch in time selection widget did not work properly
- bugfix: handle situation when adding or moving a label to a
  location that is already occupied by another label
- show labels in overview widget
- show current playback position in overview widget
- overview widget: dimming parts that are out of view
- no longer needing builtin copy of libaudiofile, removed

-------------------------------------------------------------------
Sat Sep 27 2008 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.8.0
- ported to KDE4 / Qt4
- dropped support for FLAC API v1.1.1 and older
- support for ALSA lib API v1.0.16
- made MP3 decoder disabled per default due to legal issues
- fixed bug in cue list parsing of .wav files
- fixed bugs in recording plugin, recorded too much if recording time
  limit was activated or in prerecording mode
- a much nicer splash screen
- bugfix in label handling: support labels with zero-length names
- re-arranged source files for cleaner library interfaces
- re-enabled accelerator keys for 0..9
- using horizontal scrollbar instead of overview widget
- implemented vertical zoom (Ctrl + MouseWheelUp/Down)
- using more standard KDE keyboard shortcuts
- nicer icons for the menus
- using more icons from the crystal icon collection (to clearify
  the license situation)
- removed aRts support
- now also available through the openSUSE build service for
  various platforms
- respect the LINGUAS environment variable to build only needed
  languages (defaulting to all)
- removed changelog from online manual to simplify the work of
  translators
- no longer dependent from "recode"
- recording plugin: show current recording time in status bar
- fixed infinite loop on undo/redo of channel selection
- usage of GSL can be disabled through cmake parameter -DWITH_GSL=OFF
- support for OSS v4 (integrated sf feature request #1870434)

-------------------------------------------------------------------
Sun Dec  9 2007 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.11
- new internal streaming architecture, based on Qt instead of aRts
- aRts support is now disabled per default
- some minor bugfixes for x86_64 support
- band pass plugin

-------------------------------------------------------------------
Wed Aug  8 2007 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.10
- build system: using 'METASOURCES=AUTO' (which simplifies a lot)
- ported the build system to cmake
- support for newer APIs of FLAC v1.1.3 and v1.1.4
  (closes SF bugs #1713655 and #1757716 + debian bugs #427747, #426668
  and #431199)
- replaced problematic code in libaudiofile with new code under the
  LGPL, contributed by Bertrand Songis (partially fixes debian bug #419124)
- update of the online documentation to reflect the change of the make system

-------------------------------------------------------------------
Tue May  1 2007 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.9
- playback via ALSA: offer the "default" device, if no devices found
  offer the "null" device
- implemented import and export of labels, currently only for uncompressed
  wav files
- new plugin for saving blocks between labels as separate files
- new function: expand selection to labels
- new function: select next/previous range between labels
- bugfix: don't change the file name when saving only the selection
- new configure option: --enable-doc=yes/no to enable/disable the
  generation of the online documentation (default=yes)

-------------------------------------------------------------------
Sun Dec 31 2006 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.8
- bugfix: workaround for bug in ALSA, crashed when initializing
  the dsnoop plugin
- bugfix: error in swap file handling, one sample was destroyed
  when resizing. Affects cut, delete, crop and many other functions.
- fixed the incorrect usage of the word "loose" (thanks to J.T. Hundley)
- bugfix: went back to old implementation of ThreadsafeX11Guard class
  in order to fix a deadlock (closes sourceforge bug #1623357)
- documentation update: mention Subversion instead of CVS
- zero plugin: new mode, support for inserting a range filled with silence
- fixed the macro functions "Fade Leadin" and "Fade Leadout", using the
  new mode of the 'zero' plugin
- export of ASCII format files

-------------------------------------------------------------------
Sun Sep 17 2006 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.7
- new feature: implemented a small widget that shows the current
  selection position and the selection borders
- new feature: context menu for the signal widget (right mouse button)
- improved file open dialog: show "All Files" and "All Supported Files"
- bugfix: error in handling of mouse selection
- bugfix: recording only used the first channel
  (closes sourceforge bug #1551050)
- install plugins kde_moduledir/plugins/kwave instead of
  kde_datadir/kwave/plugins

-------------------------------------------------------------------
Mon Jun  5 2006 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.6
- bugfix: recording setup crashed when called for the first time
- bugfix: do no longer crash when recording device is not
  present or opening failed
- bugfix: fixed generation of rpm dependency for libmad
- bugfix: update the size of the level meter if the dialog size has changed
- record plugin: added a fancy status bar
- record plugin: added autodetect/scanning for OSS devices
- record plugin: added dsnoop plugin as ALSA source
- record plugin: fewer annoying message boxes, instead show
  a short notice in the status bar for some seconds
- record plugin: add logarithmic scale to the level meter and use 3 colors
- playback plugin: added autodetect/scanning for OSS devices
- playback plugin / ALSA: support for 18 and 20 bits/sample
- playback plugin / ALSA: support for big endian

-------------------------------------------------------------------
Sat Dec 31 2005 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.5
- draw signal in a different color set when not selected
- bugfix: solved deadlock situation when starting a plugin
  while another plugin was still running
- workaround for deadlock when trying to close the current
  file while a plugin is still running
- bugfix: delete range only in selected tracks
- thrown over board the idea of using gstreamer due to serious license
  issues, we will wait until KDEMM is out (KDE-4) instead.

-------------------------------------------------------------------
Sun Oct 16 2005 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.4
- recording via ALSA
- support for the silently changed API of libFLAC++ v1.1.2
  (closes sourceforge bug #1243707 + debian bug #289953)
- fixed support of MMX / SSE detection on X64_64 architecture
  (closes sourceforge bug #1244320 and debian bugs #288781 +
  #327501)
- decided to support gstreamer as streaming engine
  in future versions (will make v0.8 if Kwave is aRts-free)
- fixed some German translations
  (closes debian bug #313790 and bug #314000)

-------------------------------------------------------------------
Thu May 26 2005 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.3
- playback via ALSA
- completely new playback settings dialog, with support for aRts,
  ALSA and OSS
- playback plugin: play a test sound
- record plugin: detect when device is alread open, now no longer
  blocks. Show an error message.
- smoother signal display in overview mode (no gaps) and improved
  polyline mode
- replaced some of Kwave's multithreading classes with classes
  from Qt
- compiles under SuSE-9.3
- ebuild file for Gentoo Linux

-------------------------------------------------------------------
Fri Dec 31 2004 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.2
- big rework of the internal streaming/storage subsystem,
  support for multiple stripes.
  Makes a big speedup when handling large files!
  Creating an empty 512MB file before: over 350 sec,
  now: about 25 sec (on my system)
- optimized versions of memcpy() for ix86 (using MMX, MMXEXT,
  3DNOW, SSE, SSE2) and for PowerPC, copied from the xine project
- some support for X86_64
- bugfix: in memory setup plugin, set virtual memory limit only if
  the limit has been enabled (checkbox is clicked)
- bugfix: clipping in Ogg import filter was incorrect
- speedups: import of Ogg and MP3 files improved
- removed code copied from the GSL library, link against the
  shared library instead
- added target "package-messages" to the toplevel Makefile,
  for translators

-------------------------------------------------------------------
Sat Jul 10 2004 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.1
- FLAC (Free Lossness Audio Codec) import/export plugin
- speedups for loading / saving files
- removed our own copy of libmad from the source tree, now it
  should be available in all common distributions
- implemented pre-recording
- implemented recording time limit
- bugfix: minor bug in the recording state machine
- bugfix: solved some layout issues in the about- and sonagram plugins
- bugfix: cancel while saving to .ogg works now
- update of the online documentation, many screenshots
- improved Makefile dependencies of the plugins, now parallel builds
  also work and speed up the creation of plugins

-------------------------------------------------------------------
Mon Dec  1 2003 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.7.0
- first version with recording functionality (still alpha)
- removed workaround for uic invocation
- bugfix: handling of persistent and unique plugins was wrong,
  which caused playback to work only in the first main window
  instance
- added project files for kdevelop-3

-------------------------------------------------------------------
Sat Jun 28 2003 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.7
- new plugin: "pitch_shift"
- new plugin: "lowpass"
- new plugin: "notch_filter", contrinuted by Dave Flogeras
- included a bugfixed version of the synth_pitch_shift aRts plugin
- new feature: "pre-listen", first implementation in pitch_shift plugin
- ported to work with Qt-3.1 without Qt-2 compatibility,
  also compiles with -DQT_NO_COMPAT -DQT_CLEAN_NAMESPACE

-------------------------------------------------------------------
Sat Mar 29 2003 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.6
- works with KDE-3.1
- many improvements on the build system. Now compiles under Debian,
  Mandrake, RedHat, Gentoo and SuSE
- starting up with last window size
- Xt toolkit option for geometry works again, including workaround
  for bug in KDE3's geometry management.
  example: "kwave -geometry 800x600"
- bugfix: select to left selected one sample less then needed
- volume plugin: simple clipping
- volume plugin: mode for "multiply with /divide through factor"
- newsignal and selectrange plugin: got rid of KDoubleNumInput and
  it's weird display and entry behaviour
- selectrange plugin: also select start position of selection
- can use libmad and libaudiofile from the host system if usable
- show the fileinfo plugin when saving under a different mime type

-------------------------------------------------------------------
Sat Nov  9 2002 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.5
- MP3 import with ID3 tag support through id3lib and libmad
- Ogg/Vorbis import and export (only ABR mode)
- new plugin "volume"
- show selected range as time (feature requested by Christian Hollaender)
- support for saving compressed .wav files
- thrown away Qt2/KDE2 compatibility, now only supports Qt3/KDE3
- playback plugin: enabled the "select..." button for choosing
  other playback devices (feature requested by Len Ovens)
- solved problem with name mangling in plugins and different gcc versions
- works with gcc-3.2 / solved __dso_handle problem
- stricter checks for programs in configure script

-------------------------------------------------------------------
Sun Jun 30 2002 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.4
- support for different file formats / integrated libaudiofile
- drag and drop bugfix: dropping into the same signal left from
  the selection removed wrong range
- auto-repair for structurally damaged wav files
- bugfix: save selection works again
- integrated libkwavemt into libkwave
- using time instead of zoom factor, e.g. set zoom to "1 minute"
  (feature requested by Gilles Caulier)
- menu entries for playback control
- some more icons in the menues
- replaced KFileDialog with subclass KwaveFileDialog (works
  around some bugs in KDE)
- added a little chapter about digital audio basics to online help
- added "select range" plugin

-------------------------------------------------------------------
Fri Mar  1 2002 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.3
- simple drag and drop
- french translation
- handling of "signal modified"
- shows error message and aborts if loading failed

-------------------------------------------------------------------
Mon Dec 24 2001 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.2
- new plugin "amplifyfree"
- new plugin "noise"
- >>> new aRts plugin adapter framework <<<
  now Kwave is able to use existing aRts plugins in it's own plugins
  for sound processing
- changed documentation to XML / Docbook-4.1
- recovery of damaged files if non-zero file length but data length
  entry in the wav header is zero (e.g. happens when krecord crashes
  during recording)
- bugfix: freeing virtual memory fixed in MemoryManager
- bugfix: problem with TSS in TSS_Object cleanup

-------------------------------------------------------------------
Sat Sep  1 2001 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.1-1
- bugfix: class Track made duplicate entry in stripe list when inserting
  signals into an empty track
- fixed that weird layout behavior in dialogs, seems that Qt has
  problems with complex nested layouts :(

-------------------------------------------------------------------
Fri Aug 24 2001 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.1
- >>> USE OF VIRTUAL MEMORY <<<
- changed Makefiles: html docu stays in distribution due to too much
  trouble with the KDE documentation tools
- when inserting from clipboard into a signal with a different number
  of tracks, the result will be mixed (still not optimized/slow)
- fixed compile problem with gcc-2.96 / gcc-3.0
- fixed missing header file in NewSigDlg.ui
- the RPM should be relocateable again
- fixed bug in shutdown sequence, now clipboard is flushed before the
  application closes.

-------------------------------------------------------------------
Sun Jul 29 2001 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.6.0
- >>> PORTED TO QT-2 AND KDE2 <<<
- completely new internal architecture
- plugins can be located in a user directory
- libkwave is included and no longer supported (at least by me) as
  a separate package
- playback via aRts
- many more bugfixes, too many to mention here...

-------------------------------------------------------------------
Fri Feb 23 2001 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.5-1
- bugfix: selection across end of file no longer possible
- bugfix: no overflow in wav header when saving large wav
  files above 268MB
  (bug reported by Sven-Steffen Arndt, ssa29@gmx.de )

-------------------------------------------------------------------
Fri Dec  1 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.5
- new playback handling, allows pause/continue
- limited the playback buffer to be between 256 and 65536 bytes
  due to problems (system hang) with small playback buffers with
  16..64 bytes (might be a hardware problem)
- introduced a toolbar for some standard operations
- fixed some bugs concerning selection with the mouse
- rework of the overview widget (used in main window and sonagram)
- fixed menu command "zoom selection"
- sonagram: saving to file, auto-brightness adjust
- replaced QFileDialog with KFileDialog
- tested with AMD Athlon-optimized compiler (patched pegcs)
- some fixes for safer multithreading
- checking for much more header files at configure time (due to a
  problem reported by issiac@evcom.net )

-------------------------------------------------------------------
Tue Oct  3 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.4-4
- added classes Mutex and MutexGuard
- sonagram: set a transparent background for the image
- added sizeHint() and minimumSize() to ScaleWidget and OverViewWidget
- sonagram: removed (need for) SonagramContainer, using
  QGridLayout instead
- moved SignalProxy to the mt subdirectory
- fixed X11 synchronzation problem with SignalProxy
- added TSS (thread-specific-storage) support to the mt classes
- added some multithreading support classes: Thread, AsynchObject, ...
- removed the "get" prefix from all member functions. This is the
  new KDE/QT coding style.
- updated the online documentation to point to the new Kwave
  homepage on http://kwave.sourceforge.net/
- class ImageView: always repaints (maybe image data has changed)
- bugfix: selection and playpointer will not be drawn if no signal
  is loaded

-------------------------------------------------------------------
Sat Sep  9 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.4-3
- the sonagram window updates it's title if the signal's
  name changed
- found a solution for the problem of synchronizing X11
  and QT in a multithreaded environment
- fixed bug in the "Halt" function (playback)

-------------------------------------------------------------------
Sun Aug 20 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.4-2
- geometry/layout management for the MainWidget
- limited the displayed height of a signal. If not all signals fit
   onto the screen, a scrollbar appears on the right side of the
   signal.
- limited the size of the TopWidget to a reasonable
  minimum size
- automatic dependencies for the plugins work again

-------------------------------------------------------------------
Sat Jul 29 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.4-1
- fixed layout of playback dialog
- started to implement a new plugin interface
- geometry/layout management for the sonagram settings dialog
- formatting of selection and file time (KwavePlugin::ms2string)
- plugins can now consist of multiple source files

-------------------------------------------------------------------
Wed Jul 12 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.4
- some more minor changes to the Makefiles
- split the documentation output into "de" and "en" part
- made symbolic links to the english help directory from the "de"
  and "default" directory during make install and uninstall and also
  in the post and postun scripts of the specfile
  The user should at least get the english help...
- alpha version of english documentation done
- automatic update of the revision history in the docbook file if this
  file is modified (only english version)
- CVS is up on sourceforge.net
- changed some header lines in this file
- started on writing a new documentation / online help using docbook

-------------------------------------------------------------------
Mon Jun 12 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.3
- if a file with invalid size (e.g. recorded by "arecord") is loaded,
  shows a message and truncates the input at the end of the file
- found out that we need ALSA support for 24 and 32 bits/sample
- >>> playback in stereo <<<
- selected channels (x) are mixed to the output device's channels (y)
  at playback using a x:y translation matrix with linear scaling, all
  values for x and y except zero are allowed
- playback only for selected channels
- rework of the settings/playback dialog (plugin)
- heavy reword on the playback code
- fixed severe bug in SignalManager::readWavChunk(), chrashed if there
  was data after the wav chunk

-------------------------------------------------------------------
Fri Jun  2 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.2-12
- copied the AsyncSync class into libgui, should be used for threadsafe
  usage of the qt library
- moved handling of the "selected" flag from class SignalManager
  to class Signal
- fixed selection of channels if appended or deleted

-------------------------------------------------------------------
Sun May 28 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.2-11
- included config.h in each source file (except the plugins)
- export to ASCII for multi-channel signal (multi-channel import has
  still to be done, currently only mono)
- fixed many memory leaks and inconsistent delete operations (e.g. used
  "delete" instead of "delete[]")
- included support for (and tested with) the error detection and memory
  debugging tool "Insure++ Lite 4.1" (./configure --enable-insure=yes ...)
  -> thanks to ParaSoft Corporation for making this limited version of
     the tool available (http://www.parasoft.com)
- SignalWidget uses three layers for drawing, speeds up the redraws
  after mouse selection by about factor 14(!!!) on my system :-))

-------------------------------------------------------------------
Sun May 21 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.2-10
- some minor bugfixes in the Makefiles
- save the kwave.spec and include it into the source archive, this
  lets "rpm -ta kwave-x.x.x-x.tar.gz" work
- wrote a new README file, moved Martin's version to README.OLD
- RPM_OPT_FLAGS are appended to the compiler options, this lets
  pentium optimizations work :-)
- shows a message box if loading of a file failed

-------------------------------------------------------------------
Fri May 19 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.2-9
- list of recent files is synchronized across all toplevel windows
- fixed dozens of memory leaks, missing ASSERT constructions, missing
  variable initializations and possible divisions through zero
- Help menu aligned to the right side (MenuRoot now is able to process
  the special command "#separator")

-------------------------------------------------------------------
Thu May 18 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.2-8
- replaced all occurances of sprintf with snprintf, strcpy with strncpy
  (in 92 places) !
- doesn't show any zoom factor if no signal is loaded
- handling of channel add/delete: selection/speakers are shifted
- changed some variables/parameters to "unsigned" (simplifies range checks)
- beautified this file
- beautified the whole source code according to my favorite coding style.
  -> thanks to the developers of the "Artistic Style" package,
     astyle-1.11.4-1 made good work :-)
- fixed that annoying flicker in the help/about dialog
- checking for sizes of char, short and int at configure time
- globals.app will not be used (obsolete, should be removed from libkwave)
- MessagePort will not be used (obsolete, should be removed from libkwave)
- multiple toplevel windows are possible
- made X toolkit parameters work (especially "-geometry")
- bugfix concerning loading/saving 8 bit .wav-files (always unsigned !)
- >>> COMPLETE REWORK OF THE INTERNAL COMMAND STRUCTURE <<<
  * made use of a combination of signals/slots and string messages
  * hierarchical processing: commands are are forwarded "upwards"
    until they reach a TopWidget
  * the TopWidget (highest level) dispatches the comands and forwards
    them to the lower levels

-------------------------------------------------------------------
Mon Apr 24 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.2
- rpm package should now be installable without conflicts and compile
  without any previous installation of kwave
- removed the "${KDEDIR}/share/doc/HTML/default" directory from the rpm
  so that it doesn't conflict with the already existing one
- shift+Home/shift+End selects from the current left/right position
  up to the start/end of the signal
- bugfix in display of signal: signal is no longer inverted
- selectrange() works now
- the zoom factor combo box reflects the current "real" zoom factor
- some bugfixes in menu handling / cleanups
- complete rework of zoom and offset handling:
  * simple poly-lines instead of lowpass interpolation if zoom factor
    has less than 10 pixels per sample
  * lowpass interpolation if more than 10 pixels per sample
- bugfix in KWaveApp: now sets globals.app to this if it was null before,
  now doesn't crash if it loads a file specified at cmdline

-------------------------------------------------------------------
Sun Apr 16 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.1-4
- >>> now compiles and runns under RedHat 6.1 / Halloween IV <<<
  >>> as well as under SuSE 6.2                              <<<
- version info of libkwavegui.so is set to the package's version
- bugfix in plugins/template/Makefile.am: will not create .moc files on
  make distclean and other targets
- compiler flags are passed through to plugin compilation
- compiling with --no-rtti. This was necessary to compile against the
  kde libraries of RedHat that seem to contain no rtti. As a side effect
  all warnings on linking programs/libs disappeared :-)
- configure-parameter --enable-debug has effect again
- >>> ASCII import and export works now (mono only) <<<
- bugfixes in some plugins, all compile now without warnings/errors
- plugins are processed in alphabetical order
- all plugins are automatically found and compiled
- new target "make src.rpm" makes only the source rpm

-------------------------------------------------------------------
Mon Apr  3 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.1-3
- display will be scrolled left or zoomed if something from the end
  of the signal is deleted
- curve parameters of fade in / fade out work again

-------------------------------------------------------------------
Thu Mar 16 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.1-2
- converted many "klocale->translate(...)"s into "i18n(...)"
- target "make messages" works again
- converter for menus.config, creates a dummy .cpp-file that is handled
  by i18n

-------------------------------------------------------------------
Mon Mar 13 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.1-1
- new target "make rpm" creates binary and source RPM packages
- fixed the shared-library-problem in the build system

-------------------------------------------------------------------
Mon Feb 28 2000 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.1
- menu items can belong to groups
- renamed SignalWidget::info to "refresh"
- many cleanups in the header-Files in src and libgui
- the menu management has completely been rewritten:
  * Menu, NumberedMenu and MenuCommand classes are deleted
  * new classes: MenuNode, MenuItem, MenuSub, MenuToplevel and MenuRoot
- menu items can have icons
- menu nodes can have unique string ids
- special menu commands start with a "#"
- first attempts for internationalization
- list of recent files is sorted by time of last usage

-------------------------------------------------------------------
Mon Dec 27 1999 - Thomas Eschenbacher <Thomas.Eschenbacher@gmx.de>

- v0.5.0-1
- moved my modifications from the Makefiles to Makefile.am
- included targets "make release", "make patchlevel" and some scripts

-------------------------------------------------------------------
Sun Dec 19 1999 - by Thomas.Eschenbacher@gmx.de

- remade my modifications of some Makefiles and of the configure script that
  were lost during Martin's changes
- changed shortcut for mixpaste from CTRL-SHIFT-X to CTRL-SHIFT-C
- added the "crop" command to the edit menu
- made the "mixpaste" command work
- corrected the call of "delete", now really deletes instead of cutting
  and copying the selection to the clipboard (saves clipboard content)

-------------------------------------------------------------------
Sat Dec 18 1999 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- changed filenames to reflect class names
- one class per file is now the standard
- stripped leading "Kwave" in Classnames for most Classes

-------------------------------------------------------------------
Fri Dec 10 1999 - by Thomas.Eschenbacher@gmx.de

- removed -Werror compiler option (caused trouble with configure script)
- fixed a nasty bug in SignalManager::save that caused crashes on
  several positions in the program and libstdc++

-------------------------------------------------------------------
Thu Dec  9 1999 - by Thomas.Eschenbacher@gmx.de

- gave the destructor of SignalManager some code, this fixes
  a huge memory leak !
- added a TODO file
- added -Werror to the c++ compiler options when debuging enabled
- some include file cleanups in libgui

-------------------------------------------------------------------
Tue Dec  7 1999 - by Thomas.Eschenbacher@gmx.de

- SignalManager::writeWavChunk uses buffers for writing (much faster!)
- bugfix: caption of main window changes after "SaveAs"
- bugfix: selected resolution takes effect
- bugfix: caption of main window changes after "SaveAs"
- bugfix: SignalManager::writeWavChunk now doesn't destroy the signal's
  data while saving
- make distclean in the projekt root directory also removes zero-length
  files, *.orig, *.rej and *~ (just makes cleaner than before)
- symbolic links to Makefile, Makefile.in and Makefile.am in the plugins
  directory are deleted with "make distclean" and rebuilt on "make"
  (changes in the referenced Makefiles in the template directory will not
  be reflected thousand times when creating a patch with diff)
- cleanups, removed some old backup files
- improved support for debugging accessible through
- "configure --enable-debug=yes" (-g and -DDEBUG compiler flags)
- rewritten big parts of Makefile.in for the plugins
- added -O2 compiler optimization

-------------------------------------------------------------------
Fri Dec  3 1999 - by Thomas.Eschenbacher@gmx.de

- merged with Martin Wilz's version

-------------------------------------------------------------------
Fri Nov 12 1999 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- version numbering script donated by Thomas Eschenbacher
- now using KTMainwindow for top level widgets
- using timer to check message port -> alternative (threadsafe) message
  passing instead of signal/slot
- labelling code rewritten, now incompatible with old releases
- batch loading routines

-------------------------------------------------------------------
Tue Sep  7 1999 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- deleting channels works again
- fixed savelabel dialog
- corrected envelope dialog, string handling
- connected many functions via the new string-based way of invocation
- fixed some dependencies between old code and new classes
  (there's still more to do !)
- saving should now work again
- trimmed down Clipboard class
- Color class as wrapper to QColor (may become independent later)
- reworking Curve Class for creation via string, interpolation now
  uses curve objects
- moved gui functions into a new library (libkwavegui)
- new Classes: Parser DynamicLoader Filter (previously was a struct)
- moved gui-independent functions into a library (libkwave)
- rework of dialogs into single files and single plugins
- new calling scheme via string commands. This will allow scripting and macro
  definitions. Threading is made a whole lot easier, because a only a
  string has to be passed and gets expanded into the needed set of
  parameters in each thread
- io functions and playback adapted to SignalManager
- Introduction of SignalManager class for multiple channel management

-------------------------------------------------------------------
Fri Dec 25 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.29.5
- Just a fix for an annoying bug while zooming out

-------------------------------------------------------------------
Tue Dec 22 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.29.4
- removed a memory leak in playback
- triple-checked the missing Accelerators in the Menumanager. It seems to
  be a bug in qpopmenu, I'll wait for qt to be fixed, or until a workaround
  is known
- recent Files are updated again, while the program is running
- kwave now keeps track of last directory saved to; for user convenience
- reestablished selection mechanism to match versions
  before 0.29.3 and corrected some otherwise screwed-up behaviour
- _now_ all parameters to destructors should have vanished

-------------------------------------------------------------------
Fri Dec 18 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.29.3
- developement has slowed down a bit, this release is not as complete as I
  wished but since 0.29.2 has a destructor with parameters accidently left
  in, and so does not compile on all systems -> here we go again...
- reworked selection routines into a new class, code is still rather
  confusing, but seems to work
- added checkmark functionality again
- converted file-menus to new menu-scheme
- added gui to mix channels together, the needed functions for mixing
  are still missing
- Halt button by Gerhard Zintel

-------------------------------------------------------------------
Tue Dec 15 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.29.2
- moved clipboard functionality to its own class
- dynamic allocation of menu entries used by all classes but TopWidget
- import of ascii data files

-------------------------------------------------------------------
Sun Dec 13 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.29.1
- Bugfix for multichannel save. Now the saved files should work with other prgs
- local snap to peak by Gerhard Zintel

-------------------------------------------------------------------
Thu Nov 12 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.29.0
- changed version numbering and filename as suggested by
  Version 1.1 of "How To Name Things" from sunsite. The last digit will
  always mark be 0 for releases uploaded to ftp.kde.org.
- added windowing (Hamming Hanning, Blackmann) functions
- contribution from Gerhard Zintel displaying notes in fftview
- Added pitch display window
- implemented cursor and db scale for fft-view
- added reselection and cursor change
- added possibility of different display modes in Frequency representation
- fixed severe quantisation bug in saving 16Bit routine, reported by ?
- mmaping support contributed by Juhana Kouhia
- added as new Possibility to generate Signals: pulse trains
- added wrapper for systems with no posixthreads ->
  still needs handling by configure script
  (change Makefile for not linking libpthread and doing a define)
- First use of multiple threads (pthreads) in some functions
- Pitch generation now independent of additive synthesis
- added import function for ascii files
- Ascii label saving now also by frequency
- Label generation according to Period Detection (autocorellation)
- Sonagram, FFTView and Distortion-Dialog  now use ScaleWidgets
- New ScaleWidget gives the user more information
- Improved ProgressDialog and Interpolation class to allow multiple threads
- fixed some minor bugs

-------------------------------------------------------------------
Wed Jul 15 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.28
- changes in curvewidget (recent point has another pixmap).
- sorting of labels now works without overwriting of QGList::compareItems.
- bug fix for saving selection.
- save Block function added.
- signal finding function in markers.cpp: gui improved.
- some smaller bug fixes.

-------------------------------------------------------------------
Tue Jul 14 1998 - by Martin Wilz <mwilz@ernie.mi.uni-koeln.de>

- v0.27
- first release, but never uploaded, because ftp.kde.org was down.

