/***************************************************************************
                          kwcentrybar.cpp  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentrybar.h"


/*!
	\fn KWCEntryBar::KWCEntryBar(const QString & inscr, KSingleTabWidget *parent, const char *name )
*/
KWCEntryBar::KWCEntryBar(const QString & inscr, KSingleTabWidget *parent, const char *name ) : KWCEntry(inscr, parent, name)
{
	valueBar = new KProgress( 100, parent );
	valueBar->setMaximumHeight( inscriptionLabel->height() + 2 );
	
	valueLabel = new QLabel( parent );
	valueLabel->hide();

	setValueWidget( valueBar );
	setValue2Widget( valueLabel );
}


/*!
	\fn KWCEntryBar::~KWCEntryBar()
*/
KWCEntryBar::~KWCEntryBar()
{
}


/*!
	\fn KWCEntryBar::setValue( int value )
*/
void KWCEntryBar::setValue( int value )
{
	valueBar->setProgress( value );
}


/*!
	\fn KWCEntryBar::setValue( const QString & value )
*/
void KWCEntryBar::setValue( const QString & value )
{
	valueLabel->setText( value );
}


/*!
	\fn KWCEntryBar::showBar (bool ok )
*/
void KWCEntryBar::showBar (bool ok )
{
	valueBar->setShown( ok );
	valueLabel->setHidden( ok );
}
