/***************************************************************************
 *   Copyright (C) 2004 by Matthias Reif                                   *
 *   matthias.reif@informatik.tu-chemnitz.de                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qwhatsthisstrings.h"

QWhatsThisStrings::QWhatsThisStrings( QObject *parent, const char *name ) : QObject( parent, name )
{
}


QWhatsThisStrings::~QWhatsThisStrings()
{
}


/*!
	\fn QWhatsThisStrings::essid()
 */
QString QWhatsThisStrings::essid()
{
	return i18n( "<p>Set the ESSID (or Network Name - in some products it may also be called Domain ID).</p><p>The ESSID is used to identify cells which are part of the same virtual network.<br>As opposed to the AP Address or NWID which define a single cell, the ESSID defines a group of cells connected via repeaters or infrastructure, where the user may roam transparently.</p>" );
}


#include "qwhatsthisstrings.moc"


/*!
	\fn QWhatsThisStrings::channel()
 */
QString QWhatsThisStrings::channel()
{
	return i18n( "<p>Set the operating frequency or channel in the device.</p><p>When using Managed mode, most often the Access Point dictates the channel and the driver may refuse the setting of the frequency. In Ad-Hoc mode, the frequency setting may only be used at initial cell creation, and may be ignored when joining an existing cell.</p>" );
}


/*!
	\fn QWhatsThisStrings::sensitivity()
 */
QString QWhatsThisStrings::sensitivity()
{
	return i18n( "<p>Set the sensitivity threshold.</p><p>This is the lowest signal level for which the hardware will consider receive packets usable. Positive values are assumed to be the raw value used by the hardware or a percentage, negative values are assumed to be dBm. Depending on the hardware implementation, this parameter may control various functions.<br> This parameter may control the receive threshold, the lowest signal level for which the hardware attempts packet reception, signals weaker than this are ignored. This may also controls the defer threshold, the lowest signal level for which the hardware considers the channel busy. Proper setting of those threshold prevent the card to waste time receiving background noise. Modern designs seems to control those thresholds automatically.<br>On modern cards, this parameter may control handover/roaming threshold, the lowest signal level for which the hardware remains associated with the current Access Point. When the signal level goes below this threshold the card starts looking for a new/better Access Point.</p>" );
}


/*!
	\fn QWhatsThisStrings::mode()
 */
QString QWhatsThisStrings::mode()
{
	return i18n( "<p>Set the operating mode of the device, which depends on the network topology.</p><p>The mode can be <b>Ad-Hoc</b> (network composed of only one cell and without Access Point), <b>Managed</b> (node connects to a network composed of many Access Points, with roaming), <b>Master</b> (the node is the synchronisation master or acts as an Access Point), <b>Repeater</b> (the node forwards packets between other wireless nodes), <b>Secondary</b> (the node acts as a backup master/repeater), <b>Monitor</b> (the node is not associated with any cell and passively monitor all packets on the frequency) or <b>Auto</b>.</p>" );
}


/*!
	\fn QWhatsThisStrings::nickname()
 */
QString QWhatsThisStrings::nickname()
{
	return i18n( "<p>Set the nickname, or the station name.</p><p>Some 802.11 products do define it, but this is not used as far as the protocols (MAC, IP, TCP) are concerned and completely useless as far as configuration goes. Only some diagnostic tools may use it.</p>" );
}



/*!
	\fn QWhatsThisStrings::bitrate()
 */
QString QWhatsThisStrings::bitrate()
{
	return i18n( "<p>For cards supporting multiple bit rates, set the bit-rate.</p><p>The bit-rate is the speed at which bits are transmitted over the medium, the user speed of the link is lower due to medium sharing and various overhead.</p>" );
}



/*!
	\fn QWhatsThisStrings::power()
 */
QString QWhatsThisStrings::power()
{
	return i18n( "<p>Used to manipulate power management scheme parameters and mode.</p>" )/*<p>To set the period between wake ups, enter period `value'. To set the timeout before going back to sleep, enter timeout value. You can also add the min and max modifiers. By default, those values are in seconds, append the suffix m or u to specify values in milliseconds or microseconds. Sometimes, those values are without units (number of beacon periods, dwell or similar).<br>*/+i18n( "'disabled' and 'enabled' disable and reenable power management. You may set the power management mode to all (receive all packets), unicast (receive unicast packets only, discard multicast and broadcast) and multicast (receive multicast and broadcast only, discard unicast packets) (if those modes are available).</p>" );
}


/*!
	\fn QWhatsThisStrings::txPower()
 */
QString QWhatsThisStrings::txPower()
{
	return i18n( "<p>For cards supporting multiple transmit powers, sets the transmit power.</p><p>In addition, 'off' disable the radio, and auto and fixed enable and disable power control (if those features are available).</p>" );
}


/*!
	\fn QWhatsThisStrings::ap()
 */
QString QWhatsThisStrings::ap()
{
	return i18n( "<p>Access Point/Cell</p><p>An address equal to 00:00:00:00:00:00 means that the card failed to associate with an Access Point (most likely a configuration issue). The Access Point parameter will be shown as Cell in ad-hoc mode (for obvious reasons), but otherwise works the same.</p>" );
}


/*!
	\fn QWhatsThisStrings::link()
 */
QString QWhatsThisStrings::link()
{
	return i18n( "<p>Overall quality of the link.</p><p>May be based on the level of contention or interference, the bit or frame error rate, how good the received signal is, some timing synchronisation, or other hardware metric. This is an aggregate value, and depends totally on the driver and hardware.</p>" );
}


/*!
	\fn QWhatsThisStrings::signal()
 */
QString QWhatsThisStrings::signal()
{
	return i18n( "<p>Received signal strength (RSSI - how strong the received signal is).</p><p>May be arbitrary units or dBm, iwconfig uses driver meta information to interpret the raw value given by /proc/net/wireless and display the proper unit or maximum value (using 8 bit arithmetic). In Ad-Hoc mode, this may be undefined and you should use iwspy.</p>" );
}


/*!
	\fn QWhatsThisStrings::noise()
 */
QString QWhatsThisStrings::noise()
{
	return i18n( "<p>Background noise level (when no packet is transmitted).</p><p>Similar comments as for Signal level.</p>" );
}


/*!
    \fn QWhatsThisStrings::device()
 */
QString QWhatsThisStrings::device()
{
	return i18n( "<p>Set the (wireless) device that should be configured.</p><p>Select an inserted item for using this auto detected wireless device</p>" );
}


/*!
    \fn QWhatsThisStrings::ip()
 */
QString QWhatsThisStrings::ip()
{
	return i18n( "<p>Set the ip address for this device.</p><p>For example '192.168.0.2'</p>" );
}


/*!
    \fn QWhatsThisStrings::traffic()
 */
QString QWhatsThisStrings::traffic()
{
	return i18n( "<p>Shows the current activity (sent and recieved data) of the selected device.</p>" );
}


/*!
    \fn QWhatsThisStrings::polling()
 */
QString QWhatsThisStrings::polling()
{
	return i18n( "<p>Set the interval how often the information will be updated.</p>" );
}


/*!
    \fn QWhatsThisStrings::root()
 */
QString QWhatsThisStrings::root()
{
	return i18n( "<p>Restarts the application as the super user 'root'.</p><p>You may want to do this, if you don't have enough rights to manipulate the settings (i.e. you get the 'operation not permitted' error).</p>" );
}


/*!
	\fn QWhatsThisStrings::rts()
 */
QString QWhatsThisStrings::rts()
{
	return i18n( "<p>RTS/CTS adds a handshake before each packet transmission to make sure that the channel is clear. This adds overhead, but increases performance in case of hidden nodes or a large number of active nodes. This parameter sets the size of the smallest packet for which the node sends RTS; a value equal to the maximum packet size disables the mechanism.</p>" );
}


/*!
	\fn QWhatsThisStrings::frag()
 */
QString QWhatsThisStrings::frag()
{
	return i18n( "<p>Fragmentation allows to split an IP packet in a burst of smaller fragments transmitted on the medium. In most cases this adds overhead, but in a very noisy environment this reduces the error penalty and allow packets to get through interference bursts. This parameter sets the maximum fragment size; a value equal to the maximum packet size disables the mechanism.</p>" );
}


/*!
    \fn QWhatsThisStrings::sentRecv()
 */
QString QWhatsThisStrings::sentRecv()
{
	return i18n( "<p>Totaly sent and received data of the selected device.</p>" );
}


/*!
    \fn QWhatsThisStrings::trafficMaximum()
 */
QString QWhatsThisStrings::trafficMaximum()
{
	return i18n( "<p>Defines the scale of the diagram. Points at the top of the diagram have this value</p>" );
}


/*!
    \fn QWhatsThisStrings::discarded()
 */
QString QWhatsThisStrings::discarded()
{
	QString s;
	s += i18n( "<p><b>Rx invalid nwid</b><br/>Number of packets received with a different NWID or ESSID. Used to detect configuration problems or adjacent network existence (on the same frequency).</p>" );
	
	s += i18n( "<p><b>Rx invalid crypt</b><br/>Number of packets that the hardware was unable to decrypt. This can be used to detect invalid encryption settings.</p>" );
	
	s += i18n( "<p><b>Rx invalid frag</b><br/>Number of packets for which the hardware was not able to properly re-assemble the link layer fragments (most likely one was missing).</p>" );
	
	s += i18n( "<p><b>Tx retries</b><br/>Number of packets that the hardware failed to deliver. Most MAC protocols will retry the packet a number of times before giving up.</p>" );
	
	s += i18n( "<p><b>Invalid misc</b><br/>Other packets lost in relation with specific wireless operations.</p>" );
	
	s += i18n( "<p><b>Missed beacon</b><br/>Number of periodic beacons from the Cell or the Access Point we have missed. Beacons are sent at regular intervals to maintain the cell coordination, failure to receive them usually indicates that the card is out of range.</p>" );
	return s;
}


/*!
    \fn QWhatsThisStrings::gateway()
 */
QString QWhatsThisStrings::gateway()
{
	return i18n( "<p>The default gateway for this device.</p><p>A gateway is a node on a computer network that serves as an access point to another network.<br>It routes the traffic from a workstation to the outside network</p>" );
}


/*!
    \fn QWhatsThisStrings::encryption()
 */
QString QWhatsThisStrings::encryption()
{
	return i18n( "<p> Used to manipulate encryption or scrambling keys and security mode.</p><p> The security mode may be open or restricted, and its meaning depends on the card used. With most cards, in open mode no  authentication  is  used  and  the card may also accept non-encrypted sessions, whereas in restricted mode only encrypted sessions are accepted and the card will use authentication if available.<br>You can also select and edit a stored key</p>" );
}
