

#include "keventhistorydlg.h"

#include <qlistview.h>

#include <kdebug.h>

KEventHistoryDlg::KEventHistoryDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KEventHistory(parent,name, modal,fl)
{
}

KEventHistoryDlg::~KEventHistoryDlg()
{
}

/*$SPECIALIZATION$*/

void KEventHistoryDlg::addEvent( WpaMsg msg )
{
    QListViewItem *item;
    item = new QListViewItem(lvEventHistory,
                             msg.getTimestamp().toString("yyyy-MM-dd hh:mm:ss.zzz"),
                             msg.getMsg());
    if (item == NULL)
        return;
    lvEventHistory->ensureItemVisible(item);
    lvEventHistory->setSelected(item, false);}

void KEventHistoryDlg::addEvents( WpaMsgList msgs )
{
    kdDebug() << "Initiating Log window" <<endl;
    WpaMsgList::iterator it;
    for (it = msgs.begin(); it != msgs.end(); it++) {
        addEvent(*it);
    }
}



#include "keventhistorydlg.moc"


