
#ifndef KWLANMAINWIN_H
#define KWLANMAINWIN_H

#include "kwlan.h"
#include "configuration.h"
#include "wpa_ctrl.h"
#include "kwlantraywin.h"
#include "wpamsg.h"
#include <kapplication.h>
#include <qstringlist.h>
#include <qsocketnotifier.h>

class KScanDlg;
class KEventHistoryDlg;
class KUserDataRequestDlg;
class KTempFile;
class KWlanInterface;
class Configuration;

class KWlanMainWin : public Kwlan
{
  Q_OBJECT

    public:
    KWlanMainWin(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~KWlanMainWin();
    Configuration *getConfiguration()
    {
        return m_configuration;
    }
    /*$PUBLIC_FUNCTIONS$*/
    
    
    public slots:
    /*$PUBLIC_SLOTS$*/
        virtual int           init(QString interface);
        virtual void          editSettings();
        virtual void          toolsLogViewer();
        virtual void          scan();
        virtual void          fileStopWpaSupplicant();
        virtual void          fileStartWpaSupplicant();
        virtual void          updateNetworks();
        virtual void          profileDelete();
        virtual void          profileModify();
        virtual void          profileNew();
        virtual void          profileActivate();
        virtual void          helpAbout();
        virtual void          fileExit();
        virtual void          profileSelect(QString profile);
        void enableStartWpaMenu(bool enable);
    
    signals:
        void statusChanged(bool connected);
        void ipChanged(const QString &ipaddress);
        void interfaceChanged(const QString &interface);
        
    protected:
    /*$PROTECTED_FUNCTIONS$*/
    
    protected slots:
    /*$PROTECTED_SLOTS$*/
        
    private:
    
        bool getRootPassword();
        QStringList m_wlanInterfaces;
         char *m_controlInterface;
         char *m_controlInterfaceDir;
        QSocketNotifier *m_messageNotifier;
        bool m_associated;
        bool m_IpAddress;
        bool m_wpaWarned; // User has been warned in case of failure to connect to wpa_supplicant
        QString m_ssid;
//        QTimer *m_timer;
        KWlanTrayWin *m_tray;
        KScanDlg *m_scanDlg;
        KEventHistoryDlg *m_eventHistory;
        WpaMsgList m_messages;
        KUserDataRequestDlg *m_userDataRequest;
        KTempFile *resolvconf;
        KWlanInterface *m_interface;
        QString m_confFile;
        Configuration *m_configuration;
    
    private slots:
        void cleanTemporaryFiles();

};

#endif





















