

#include "kwlansettingsdlg.h"
#include "configuration.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>


KWlanSettingsDlg::KWlanSettingsDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KWlanSettings(parent,name, modal,fl)
{
    m_configuration = 0L;
}

KWlanSettingsDlg::~KWlanSettingsDlg()
{
}

/*$SPECIALIZATION$*/
void KWlanSettingsDlg::enableWpaNoQuestion(int state)
{
    cbWpaNoQuestion->setEnabled(state);
}

void KWlanSettingsDlg::Cancel()
{
    QWidget::close(true);
}

void KWlanSettingsDlg::Ok()
{
    if (!m_configuration)
    {
        QWidget::close(true);
        return;
    }
    m_configuration->m_startWpa = cbWpa->isChecked();
    m_configuration->m_startWpaNoQuestion = cbWpaNoQuestion->isChecked();
    m_configuration->m_startMinimized = cbMinimized->isChecked();
    PasswordCache().m_pwexpire = sbPasswordTime->value();
    m_configuration->writeSettings();
    PasswordCache().writePasswordExpire();
    QWidget::close(true);
}



#include "kwlansettingsdlg.moc"

