#include "kwlantraywin.h"
#include "wlanlib.h"
#include "kwlaninterface.h"


#include <kstdaction.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <qtooltip.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <klocale.h>
#include <kdebug.h>






KWlanTrayWin::KWlanTrayWin(QWidget *parent, const char *name)
    : KSystemTray(parent, name)
{
    m_interface = 0L;
    m_ifname="";
    m_interfaceUp = FALSE;
    // actionCollection()->remove( actionCollection()->action( "quit" ) );
    m_quit = KStdAction::quit( this, SIGNAL( quitSelected() ), actionCollection() );
    m_about = KStdAction::aboutApp( this, SIGNAL( aboutSelected() ), actionCollection() );
    m_interfaceEnableMenu = new KAction(this,"interfaceEnale");
    connect (m_interfaceEnableMenu,SIGNAL(activated()),this, SLOT(interfaceEnable()));

    setPixmap(loadIcon("kwlan/disconnected"));
    m_tooltip = new KWlanToolTip(this);
    m_profiles.setAutoDelete(TRUE);
    m_profileMenu = new KPopupMenu();
    connect (m_profileMenu, SIGNAL(activated(int )),SLOT(selectProfile(int )));
    m_timer = new QTimer(this);
    if (m_timer){
        connect (m_timer, SIGNAL(timeout()),SLOT(updateIcon()));
        m_timer->start(2000,FALSE);
    }

}

KWlanTrayWin::~KWlanTrayWin() {
    delete m_tooltip;
    m_tooltip = 0;
}

void KWlanTrayWin::setInterface(KWlanInterface *interface)
{
    m_interface = interface;
    updateNetworks();
    connect (m_interface, SIGNAL(interfaceUp( bool )), this, SLOT (setInterfaceEnableMenu( bool )));
    connect (this, SIGNAL(interfaceEnable( bool )), m_interface, SLOT (enableInterface(bool)));
}

 
void KWlanTrayWin::contextMenuAboutToShow( KPopupMenu *r ) {
    QString *prof, curProf;
    //updateNetworks();
    if (m_interface)
      curProf = m_interface->getCurrentProfile();
    //kdDebug() << "Current profile" << curProf << endl;
    int id;
    r->clear();
    r->insertTitle(SmallIcon ("kwlan"), "KWlan - Wireless Lan Manager");
    // Now fill int the profiles into profile menu
    id = 1;
    m_profileMenu->clear();
    if (!m_profiles.isEmpty() && m_interfaceUp){
        prof = m_profiles.first();
        while (prof){
            //kdDebug() << "Inserting profile " << *prof << endl;
            m_profileMenu->insertItem(*prof,id);
            m_profileMenu->setItemParameter(id,id);
            if (*prof == curProf)
                m_profileMenu->setItemChecked(id, TRUE);
            else 
                m_profileMenu->setItemChecked(id, FALSE);
            prof=m_profiles.next();
            id++;
        }
        r->insertItem("Select Profile",m_profileMenu);
    }
    else kdDebug() << "No profile found." << endl;
    //now set the interface enable / disable menu
    QString enableMenu;
    if (m_interfaceUp) enableMenu = i18n("Disable");
    else enableMenu = i18n("Enable");
    m_interfaceEnableMenu->setText(enableMenu);
    m_interfaceEnableMenu->plug(r);
    m_about->plug( r );
    m_quit->plug( r );
    
}

void KWlanTrayWin::clearProfiles()
{
    while (!m_profiles.isEmpty()) m_profiles.removeFirst();
}

void KWlanTrayWin::updateNetworks()
{
    QStringList networks;
    clearProfiles();
    if (!m_interface) return;
    kdDebug() << "Updating network list" << endl;
    networks= m_interface->listProfiles();
    for (QStringList::Iterator it=networks.begin();it != networks.end();it++){
        m_profiles.append(new QString(*it));
    }
}

void KWlanTrayWin::setInterfaceEnableMenu( bool up)
{
    m_interfaceUp = up;
}
            
void KWlanTrayWin::interfaceEnable()
{
    emit (interfaceEnable(!m_interfaceUp));
}
const QString & KWlanTrayWin::getInterfaceName() const {
    return m_ifname;
}
        


void KWlanTrayWin::updateIcon()
{
    //QPixmap trayIcon;
    // Do we have a wireless interface?
    interfaceData data = m_interface->getInterfaceData();
    if (data.wirelessDevice) {
        if (!data.connected )
            setPixmap(loadIcon("kwlan/disconnected"));
        else if (!m_ifname.isEmpty()){
            IwLib iw(m_ifname);
            if (iw.getQuality() >35) 
                setPixmap(loadIcon("kwlan/connected"));
            else setPixmap(loadIcon("kwlan/weakconnection"));
        }
    }
    else {
        // wired interface
        if (!data.connected)
            setPixmap(loadIcon("kwlan/wired-disconnected"));
        else setPixmap(loadIcon("kwlan/wired-connected"));
    }
}


void KWlanTrayWin::setInterfaceName(const QString &ifname)
{
    m_ifname = ifname;
}

void KWlanTrayWin::setIpAddress(const QString &ipaddress){
    m_ipaddress = ipaddress;
}


void KWlanTrayWin::selectProfile(int id)
{
    //kdDebug() <<"select Profile " <<m_profileMenu->text(id) << endl;
    emit profileChanged(m_profileMenu->text(id));
}

KWlanToolTip::KWlanToolTip(QWidget *parent): QToolTip(parent) {
}
    
KWlanToolTip::~KWlanToolTip() {
    
}
        
void KWlanToolTip::maybeTip(const QPoint &p) {
    QString tooltip;
    KWlanTrayWin *parent = (KWlanTrayWin *)parentWidget();
    const QString &ifname = parent->getInterfaceName();
        
    // We can't show tooltip if no interface was specified
    if (!parent->getInterface())
        return;
    interfaceData data = parent->getInterface()->getInterfaceData();
    if (data.connected) {
//        IwLib iw(ifname);
        tooltip  = QString("<table cellspacing=0 cellpadding=0 border=0>");
        tooltip += QString(i18n("<tr><th colspan=2 align=center>Interface %1</th></tr>")).arg(ifname);
        if (data.wirelessDevice) {
            wirelessData wData = parent->getInterface()->getWirelessData();
            tooltip += QString(i18n("<tr><td>Connected to: </td><td> <b>%1</b></td></tr>")).arg(wData.essid);
            tooltip += QString(i18n("<tr><td>Bitrate:</td><td> <b>%1 Mbit/s</b></td></tr>")).arg(wData.bitRate);    
            tooltip += QString(i18n("<tr><td>Link quality:</td><td> <b>%1</b></td></tr>")).arg(wData.linkQuality);
            tooltip += QString(i18n("<tr><td>Signal Level:</td><td> <b>%1</b></td></tr>")).arg(wData.signal);
            tooltip += QString(i18n("<tr><td>Frequency:</td><td> <b>%1</b></td></tr>")).arg(wData.frequency);
            tooltip += QString(i18n("<tr><td>Channel:</td><td> <b>%1</b></td></tr>")).arg(wData.channel);
        }
        tooltip += QString(i18n("<tr><td>IP address:</td><td> <b>%1</b></td></tr>")).arg(data.ipAddress);
        tooltip += QString(i18n("<tr><td>Netmask:</td><td> <b>%1</b></td></tr>")).arg(data.subnetMask);
        tooltip += QString(i18n("<tr><td>Broadcast address:</td><td> <b>%1</b></td></tr>")).arg(data.broadcastAddress);
        tooltip += QString(i18n("<tr><td>Bytes received:</td><td> <b>%1</b></td></tr>")).arg(data.rxString);
        tooltip += QString(i18n("<tr><td>Bytes sent:</td><td> <b>%1</b></td></tr>")).arg(data.txString);
        tooltip += QString(i18n("<tr><td>Packets received:</td><td> <b>%1</b></td></tr>")).arg(data.rxPackets);
        tooltip += QString(i18n("<tr><td>Packets sent:</td><td> <b>%1</b></td></tr>")).arg(data.txPackets);
        tooltip += QString("</table>");
    }
    else {
        tooltip  = QString(i18n("Interface : <b>%1</b><br />")).arg(ifname);
        tooltip += i18n("Disconnected");
    }
                 
    tip(parent->rect(), tooltip);
}
