#ifndef _KWLANKICKER_H_
#define _KWLANKICKER_H_


#include <sys/types.h>
#include <ksystemtray.h>
#include <qtooltip.h>
#include <qstring.h>
#include <qptrlist.h>
#include <kpopupmenu.h>
#include <qtimer.h>

class QWidget;
class KAction;
class KWlanInterface;


// Tooltip class to show extended link information - "KGet approach"

class KWlanToolTip : public QToolTip {

    public:
     	KWlanToolTip(QWidget *parent);
    virtual ~KWlanToolTip();
	
    protected:
       void maybeTip(const QPoint &);
};


// Class to show status in systray

class KWlanTrayWin : public KSystemTray
{
    Q_OBJECT
    public:
        KWlanTrayWin(QWidget *parent=0, const char *name=0);
        virtual ~KWlanTrayWin();
        void contextMenuAboutToShow ( KPopupMenu * );
        bool isConnected() const;
        const QString & getInterfaceName() const;
        void clearProfiles();
        void setInterface(KWlanInterface *interface);
        KWlanInterface* getInterface()
        {
            return m_interface;
        }
        void setInterfaceName(const QString &ifname);

    signals:
        void clicked();
        void aboutSelected();
        void profileChanged(QString profile);
        void interfaceEnable(bool enable);
        
    public slots:
        void updateIcon();
        void setIpAddress(const QString &ipaddress);
        void updateNetworks();
        void setInterfaceEnableMenu(bool up);
        void interfaceEnable();

    protected:
        //void mouseReleaseEvent( QMouseEvent * );
        QString m_ifname;
        QString m_ipaddress;
        KAction *m_quit, *m_about,  *m_interfaceEnableMenu;
        KWlanToolTip *m_tooltip;
        QTimer *m_timer;
    private slots:
        void selectProfile(int id);
    private:
        QPtrList<QString> m_profiles;
        bool m_interfaceUp;
        KPopupMenu *m_profileMenu;
        KWlanInterface *m_interface;
};


#endif
