

#include "kwlanmainwin.h"
#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <qsocketnotifier.h>
#include <kmessagebox.h>

#include "wlanlib.h"
#include "kwlanapplication.h"

static const char description[] =
    I18N_NOOP("Wireless connection manager for KDE");

static const char version[] = "0.4.7";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kwlan", I18N_NOOP("KWlan"), version, description, KAboutData::License_GPL_V2, "(C) 2006 Thomas Michel", 0, 0, "tom.michel@arcor.de");
    about.addAuthor( "Thomas Michel", 0, "tom.michel@arcor.de" );
    about.addAuthor( "Jouni Malinen", I18N_NOOP("Original wpa_gui version"), "jkmaline@cc.hut.fi", 0 );
    about.addAuthor( "Valentine Sinitsyn", I18N_NOOP("Misc patches and improvements"), "e_val@inbox.ru", 0 );
    about.addCredit( "Andrew Barr", I18N_NOOP("KWlan icons"), "andrew.james.barr@gmail.com", 0 );
    about.addCredit("Percy Leonhard",I18N_NOOP("Source code for interface statistics from knemo"),"<percy@eris23.de>",0);
    about.setOtherText( I18N_NOOP("This product uses wpa_supplcant to configure wireless networks\n"
                        "wpa_supplicant includes software developed\n"
                        "by the OpenSSL Project for use in the\n"
                        "OpenSSL Toolkit (http://www.openssl.org/)\n" ));
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
  
    if (!KWlanApplication::start()) {
        fprintf(stderr, "KWlan is already running!\n");
	KMessageBox::error(0,i18n("KWlan is already running!\n"));
        exit(-1);
    }

    KWlanApplication app;
    app.init();
    return app.exec();
}
