/// All functions to set wlan parameters and query wlan interfaces

#ifndef _WLANLIB_
#define _WLANLIB_

#include <qstring.h>
#include <qstringlist.h>
#include <qwidget.h>


#define PROC_NET_WIRELESS	"/proc/net/wireless"
#define PROC_NET_WIRED	"/proc/net/dev"
#define MAX_SSID_SIZE 100

struct interfaceData
{
    interfaceData()
    : existing( false ),
    available( false ),
    connected( false),
    wirelessDevice( false ),
    incomingBytes( 0L ),
    outgoingBytes( 0L ),
    rxBytes( 0L ),
    txBytes( 0L ),
    prevRxBytes( 0L ),
    prevTxBytes( 0L )
    {}

    bool existing;
    bool available;
    bool connected;
    bool up;
    bool wirelessDevice;
    unsigned long rxPackets;
    unsigned long txPackets;
    unsigned long prevRxBytes;
    unsigned long prevTxBytes;
    unsigned long incomingBytes;
    unsigned long outgoingBytes;
    QString ipAddress;
    QString subnetMask;
    QString hwAddress;
    QString ptpAddress;
    QString broadcastAddress;
    QString defaultGateway;
    QString rxString;
    QString txString;
    Q_UINT64 rxBytes;
    Q_UINT64 txBytes;
};

struct wirelessData
{
    QString essid;
    QString mode;
    QString frequency;
    QString channel;
    QString bitRate;
    QString signal;
    QString noise;
    QString linkQuality;
};


///not wireless related, but needed from several classes: executes program using kdesud
bool executeSuCommand(QString command);
/// lists all wireless interfaces
QStringList getInterfaces();
/// return full path for a file "file"
QString getPath(QString file);
/// Returns true is there is a nameserver entry in /etc/resolv.conf
bool hasNameserver();
/// Returns true if there is default gateway on an active interface
bool hasGateway();

/// class to request information about wireless status
class IwLib {
    public:
        IwLib(const QString &ifname);
        virtual ~IwLib();
	
        int getQuality();
        QString getBitrate();
        QString getESSID();
        bool setWepAuth(int authMode);
    private:
        int m_socket;
        QString m_ifname;
};


static int str_match(const char *a, const char *b)
{
    return strncmp(a, b, strlen(b)) == 0;
}


// Non Member function
static void kwlan_msg_cb(char *msg, size_t)
{
    /* This should not happen anymore since two control connections are used. */
    printf("missed message: %s\n", msg);
}

#endif
