/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/
#ifndef KPROFILECONFIGDLG_H
#define KPROFILECONFIGDLG_H

#include "kprofileconfig.h"
#include "kwlanmainwin.h"
#include "kwlnetworklist.h"

class KwlanInterface;

class KProfileConfigDlg : public KProfileConfig
{
  Q_OBJECT

public:
  KProfileConfigDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KProfileConfigDlg();
  /*$PUBLIC_FUNCTIONS$*/
  virtual void          setInterface( KwlanInterface * interface );
  virtual void          getEapCapa();
  virtual void          wepEnabled( bool enabled );
  virtual void          newNetwork();
  virtual void          paramsFromConfig( KwlanInterface *interface, QString ssid );
  virtual int           setNetworkParam( int id, const char * field, const char * value, bool quote );
  virtual void          paramsFromScanResults( kwlNetwork p );

public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          dnsRemoveDomain();
  virtual void          dnsAddDomain();
  virtual void          setMainWin( KwlanMainWin * mainWin );
  virtual void          dhcpState(int state);
  virtual void          browseForServerCertificate();
  virtual void          browseForPrivateKey();
  virtual void          browseForCertificate();
  virtual void          writeWepKey( int network_id, QLineEdit * edit, int id );
  virtual void          encrChanged( const QString & sel );
  virtual void          addNetwork();
  virtual void          authChanged( int sel );

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
    
signals:
        void                  profileAdded();

private:
  KwlanInterface *m_interface;
  int m_editNetworkID;
  bool m_newNetwork;
};

#endif









