/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kscandlg.h"

#include "kprofileconfigdlg.h"
#include "kwlaninterface.h"
#include "kwlnetworklist.h"

#include <qlistview.h>
#include <kmessagebox.h>
#include <kprocess.h>
#include <qregexp.h>
#include <kdebug.h>
#include <qtimer.h>

KScanDlg::KScanDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KScan(parent,name, modal,fl)
{
    m_interface = 0L;
    m_timer = new QTimer(this);
    int timerInterval;
    timerInterval = 100;
    if (m_timer){
        connect (m_timer, SIGNAL(timeout()),SLOT(updateResults()));
        m_timer->start(timerInterval,FALSE);
    }
}

KScanDlg::~KScanDlg()
{
}

void KScanDlg::closeScanWindow()
{
    if (m_timer) delete m_timer;
    m_timer = 0L;
    close();
}

/*$SPECIALIZATION$*/
void KScanDlg::addSelected()
{
    QListViewItem *sel = scanResultsView->selectedItem();
    if (!sel) {
        KMessageBox::sorry(this,"kwlan","No Network selected!");
        return;
    }
    bssSelected( sel);
}

void KScanDlg::bssSelected( QListViewItem * sel )
{
    if (!m_interface) return;
    QString ssid = sel->text(0);
    kwlNetworkList prof = m_interface->getAvailableProfiles();
    for (kwlNetworkList::iterator it = prof.begin();it != prof.end();it++)
    {
        if ((*it).m_ssid == ssid)
        {
            KProfileConfigDlg *nc = new KProfileConfigDlg();
            if (nc == NULL)
                return;
            nc->setInterface(m_interface);
            nc->paramsFromScanResults(*it);
            nc->show();
            nc->exec();
            return;
        }
    }
    // Could happen if network is nat available any more
    kwlNetwork p(ssid);
    KProfileConfigDlg *nc = new KProfileConfigDlg();
    if (nc == NULL)
        return;
    nc->setInterface(m_interface);
    nc->paramsFromScanResults(p);
    nc->show();
    nc->exec();
}


void KScanDlg::scanRequest()
{
    if (m_interface == NULL)
        return;
    m_interface->slotScanAvailableNetworks();
}

void KScanDlg::updateResults()
{
    if (!m_interface) return;
    scanResultsView->clear();
    
    kwlNetworkList prof = m_interface->getAvailableProfiles();
    for (kwlNetworkList::Iterator it = prof.begin(); it != prof.end(); it++) {
        QString ssid, bssid, channel, signal, flags;
        bssid = (*it).m_bssid;
        channel = (*it).m_channel;
        signal = (*it).m_signal;
        flags = (*it).m_flags;
        ssid = (*it).m_ssid;
        //work around signal bug (it's about twice as what iwscan gives)
        signal = QString("%1").arg(signal.toInt()/2);
        new QListViewItem(scanResultsView, ssid, bssid, channel, signal, flags);
    }
}

void KScanDlg::setInterface( KwlanInterface *interface )
{
    m_interface  = interface;
    if (!m_interface) return; 
    scanRequest();
    m_timer = new QTimer(this);
    if (!m_timer) return;
    connect(m_timer, SIGNAL(timeout()), SLOT(updateResults()));
    m_timer->start(2000, FALSE);
}



#include "kscandlg.moc"


