/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xematrixpanther.h"
#include "xeconfiguration.h"
#include "xeobject.h"
#include "kdebug.h"

extern "C" QObject *xeplugin_register(QObject *parent)
{
	const char NOME[]="xMatrix";
	kdWarning() << "xeplugin_register(" <<NOME<<")\n";
	return (new XEMatrixPanther(parent,NOME));
}



XEMatrixPanther::XEMatrixPanther(QObject *parent, const char *name)
 : XEMatrix(parent, name)
{
	// Registration is done by XEMatrix
}


XEMatrixPanther::~XEMatrixPanther()
{
	xStop();
	XEObject::xPluginDel(this);
}


#include "xematrixpanther.moc"


/*!
    \fn XEMatrixPanther::xParse(const QString &, int, void *)
 */
void XEMatrixPanther::xParse(const QString &sAction, int, void *)
{
	if(sAction=="xMakePanther")xMakePanther();
	if(sAction=="xMakeUp")xMakePanther();
}


/*!
    \fn XEMatrixPanther::xMakePanther()
 */
inline void XEMatrixPanther::xMakePanther()
{
#ifndef ENABLE_FINAL
	qWarning("void XEMatrix::MakePanther()");
#endif
	double ratio=0;
	double ratioy=0;
	QPoint p1,p2;
	
	if(ActiveConfiguration->Window.Align=="bottom")
	{
		ActiveConfiguration->Icons.Raise=-int((double(ActiveConfiguration->Icons.SizeBig/2)-double(ActiveConfiguration->Icons.Size/2)));
	}
	else
	{
		ActiveConfiguration->Icons.Raise=-(-int((double(ActiveConfiguration->Icons.SizeBig/2)-double(ActiveConfiguration->Icons.Size/2))));
	}
	ActiveConfiguration->Icons.Horiz=0;
	
	
	
		ActiveConfiguration->Matrix.sizeMatrix=(
			ActiveConfiguration->Icons.Size + ActiveConfiguration->Icons.Separation
			)*2;
		
	ratio=double(ActiveConfiguration->Icons.SizeBig-ActiveConfiguration->Icons.Size)
				/
				double(ActiveConfiguration->Matrix.sizeMatrix*2);

		// This function will align the icons
		// now we have to get the Y displacement
		xMakeCenter(0,&p1);
		xMakeCenter(0,&p2);
		
		
		
		// quantum icon must raise
		// double
		ratioy=(-double(ActiveConfiguration->Icons.Raise)/double(ActiveConfiguration->Matrix.sizeMatrix*2));
		// horizontal displacement
		
		// TODO: garbage on reloadig matrix
		// Allocate arrays
		ActiveConfiguration->Matrix.XMatrix=
			new int[ActiveConfiguration->Matrix.sizeMatrix*2];
		ActiveConfiguration->Matrix.YMatrix=
			new int[ActiveConfiguration->Matrix.sizeMatrix*2];
		ActiveConfiguration->Matrix.ZMatrix=
			new int[ActiveConfiguration->Matrix.sizeMatrix*2];
/*
	timespec rem;
	timespec FewTime;
	FewTime.tv_sec=0;
	FewTime.tv_nsec=1;
*/

		// loadin static matrix
		// simulating the mouse movement from - infite to + infinite relative to 1 icon
		for (int mouseinx=0;mouseinx<ActiveConfiguration->Matrix.sizeMatrix*2;mouseinx++)
		{
			// 14052004
			// precision variables
			// int -> double <-
			double ZMatrixDouble=double(ActiveConfiguration->Icons.SizeBig)-double(ratio*mouseinx);
			
			ActiveConfiguration->Matrix.ZMatrix[mouseinx]=(int)ZMatrixDouble;
				
			ActiveConfiguration->Matrix.YMatrix[mouseinx]=(int)
				double(
				ZMatrixDouble/2
				+double(ActiveConfiguration->Matrix.sizeMatrix*2 -mouseinx) * ratioy
				-double(ActiveConfiguration->Icons.Size/2));
			ActiveConfiguration->Matrix.XMatrix[mouseinx]=(int)
				double(ZMatrixDouble/2
				-double(ActiveConfiguration->Icons.Size/2));
		}
		
		// dynamic horizontal displacement
		ActiveConfiguration->Matrix.DMatrix=
			new int*[ActiveConfiguration->Matrix.sizeMatrix*2];
			
			
		int contaIcone=(ActiveConfiguration->Matrix.sizeMatrix*2)/(ActiveConfiguration->Icons.Size+ActiveConfiguration->Icons.Separation);
		
		double dMax=(double(ActiveConfiguration->Icons.SizeBig)-double(ratio*0))/2;
		double dMin=dMax;
		int XIcona=ActiveConfiguration->Matrix.sizeMatrix*2;
		dMin+=(double(ActiveConfiguration->Icons.SizeBig)-double(ratio*XIcona))/2;
		for(int contaIcona=0;contaIcona<contaIcone;contaIcona++)
		{
			XIcona=(ActiveConfiguration->Matrix.sizeMatrix*2)-contaIcona*(ActiveConfiguration->Icons.Size + ActiveConfiguration->Icons.Separation);
			dMin+=(double(ActiveConfiguration->Icons.SizeBig)-double(ratio*XIcona));
			
		}
		for (int mouseinx=0;mouseinx<ActiveConfiguration->Matrix.sizeMatrix*2;mouseinx++)
		{
	//nanosleep(&FewTime,&rem);
			int *vett=new int[ActiveConfiguration->Matrix.sizeMatrix*2];
			for(int mouseiny=0;mouseiny<ActiveConfiguration->Matrix.sizeMatrix*2;mouseiny++)
			{
					//double pinco=ActiveConfiguration->Matrix.ZMatrix[mouseinx-1]+ActiveConfiguration->Matrix.ZMatrix[mouseinx];
					//pinco=pinco+ActiveConfiguration->Icons.SizeBig;
					
					double pinco=(double(ActiveConfiguration->Icons.SizeBig)-double(ratio*double(mouseinx+mouseiny)/2));
					pinco=pinco-(double(ActiveConfiguration->Icons.Size));
					
					pinco=pinco*3;
					
					//pinco=pinco+(ActiveConfiguration->Icons.SizeBig-ActiveConfiguration->Icons.Size);
					/*
					pinco=pinco+(
					(double(ActiveConfiguration->Icons.SizeBig)-double(ratio*double(mouseinx+mouseiny)/2))
					-ActiveConfiguration->Icons.Size
					+ActiveConfiguration->Icons.Size
					);
					*/
					
					pinco=pinco+(ActiveConfiguration->Icons.SizeBig-ActiveConfiguration->Icons.Size)*
					(double(ActiveConfiguration->Icons.SizeBig)-double(ratio*double(mouseinx+mouseiny)/2))/ActiveConfiguration->Icons.SizeBig;
					
					
					
					
					//pinco=pinco*(ActiveConfiguration->Icons.SizeBig/ActiveConfiguration->Icons.Size);
					
					double pincoRatio=
						double(mouseinx)
						/
						double(ActiveConfiguration->Matrix.sizeMatrix*2)
						;
					pinco=pinco*pincoRatio;
					
					vett[mouseiny]=int(pinco);
					/*
				if(mouseiny==0)qWarning(QString("[%1][%1]=%1 ").arg(mouseinx).arg(mouseiny).arg(vett[mouseiny]));
					*/

			}
			ActiveConfiguration->Matrix.DMatrix[mouseinx]=vett;
		}
		
		
		ActiveConfiguration->Matrix.KMatrix=new int[ActiveConfiguration->Matrix.sizeMatrix*2];

		double ratiok=
			double(ActiveConfiguration->Matrix.DMatrix[ActiveConfiguration->Matrix.sizeMatrix*2-1][0])
			/double(ActiveConfiguration->Matrix.sizeMatrix*2);
		for (int mouseinx=0;mouseinx<ActiveConfiguration->Matrix.sizeMatrix*2;mouseinx++)
		{
	//nanosleep(&FewTime,&rem);

			ActiveConfiguration->Matrix.KMatrix[mouseinx]=int(
				ratiok*
				double(ActiveConfiguration->Matrix.sizeMatrix*2-mouseinx));
		}
		/*
		qWarning(QString("KMatrix=%1").arg(ActiveConfiguration->Matrix.DMatrix[ActiveConfiguration->Matrix.sizeMatrix*2-1][0]));
		*/
		//exit(0);

}


/*!
    \fn XEMatrixPanther::xMakeCenter(int, QPoint *)
 */
inline void XEMatrixPanther::xMakeCenter(int iconIndex, QPoint *xy)
{
	xMakeSpace(iconIndex,xy);
	xy->setX(xy->x()+ActiveConfiguration->Icons.Size/2);
	xy->setY(xy->y()+ActiveConfiguration->Icons.Size/2+ActiveConfiguration->Icons.Raise);
}


/*!
    \fn XEMatrixPanther::xMakeSpace(int, QPoint *)
 */
void XEMatrixPanther::xMakeSpace(int iconIndex, QPoint *xy)
{
	xy->setX(
			ActiveConfiguration->Window.borderLeft
			+
			(iconIndex*
				(ActiveConfiguration->Icons.Separation+ActiveConfiguration->Icons.Size)
				));
	xy->setY(
			ActiveConfiguration->Window.borderTop);
}


/*!
    \fn XEMatrixPanther::xUpdateMatrix()
 */
void XEMatrixPanther::xUpdateMatrix()
{
#ifndef ENABLE_FINAL
	kdWarning() << ("XEMatrixPanther::xUpdateMatrix()\n");
#endif
	xMakePanther();
}
