/***************************************************************************
 *   Copyright (C) 2005 by Stefano Zingarini   *
 *   stefano@xiaprojects.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xgfloater.h"

#include <kdebug.h>
#include <xeobject.h>
#include <qwidget.h>
#include <qtimer.h>
#include <kwin.h>
#include <xgfloater.h>
#include <time.h>
#include <kxdocker_setup_sources.h>
#include <xgicon.h>
#include <xgdocker.h>
#include <xeconfiguration.h>


#include "xgfloater.moc"


void xGFloater::setPixmap(const QImage &pi)
{
	sourcePixmap=pi;
	paintBuffer=sourcePixmap;
}
xGFloater::xGFloater():QWidget()
{
	setBackgroundMode(Qt::NoBackground,Qt::NoBackground);
	KWin::setType(winId(), NET::Dock);
	//KWin::setType(winId(), NET::Override);
	KWin::setState( winId(), NET::StaysOnTop );
	setFocusPolicy(QWidget::StrongFocus);
	setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
	MaxY=0;
	Direction=1;
}
xGFloater::~xGFloater()
{

}
void xGFloater::resize(int x1,int y1)
{
	// TODO: workaround until we can use Slots!
	QWidget::move(x(),y()+(MaxY-y())/2);
	//QWidget::move(x(),0);

	paintBuffer=sourcePixmap.smoothScale(x1,y1);

	QBitmap msk;
	msk.convertFromImage(paintBuffer.createAlphaMask());
	setMask(msk);

	QWidget::resize(x1,y1);
	repaint(false);
}
void xGFloater::move(int x,int yd,int force)
{
	if(force)QWidget::move(x,yd);
	else QWidget::move(x,y());
}
void xGFloater::move(int x1,int y1)
{
	MaxY=y1;
	QWidget::move(x1,y());
}
void xGFloater::paintEvent( QPaintEvent *e)
{
	QRect rect = e->rect();
	int l=rect.left();
	int t=rect.top();
	int w=rect.width();
	int h=rect.height();
	bitBlt(this,
		l,
		t,
		&paintBuffer,
		l,t,w,h,
		Qt::CopyROP);
}
