/***************************************************************************
 *   Copyright (C) 2006 by Tomasz Sałaciński   *
 *   distortion@vp.pl   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//KDE Includes
#include <kinputdialog.h>

//QT Includes
#include <qstringlist.h>

//kX Generator Includes
#include "GlobalFunctions.h"


QString GlobalFunctions :: GetPointer(Xorg *Xorg)
{
X = Xorg;

QStringList PointerList;
PointerList.clear();
for (int a = 1; a <= X->CountSections(Xorg::InputDevice); a++)
   {
    if (!X->isKeyboard(a)) { PointerList << X->GetValue(Xorg::InputDevice, a, "Identifier", 1); }
   }

return KInputDialog :: getItem(Locale(0), Locale(1), PointerList);
}

QString GlobalFunctions :: GetKeyboard(Xorg *Xorg)
{
X = Xorg;

QStringList KeyboardList;
KeyboardList.clear();
for (int a = 1; a <= X->CountSections(Xorg::InputDevice); a++)
   {
    if (X->isKeyboard(a)) { KeyboardList << X->GetValue(Xorg::InputDevice, a, "Identifier", 1); }
   }

return KInputDialog :: getItem(Locale(2), Locale(3), KeyboardList);
}

QString GlobalFunctions :: GetScreen(Xorg *Xorg)
{
X = Xorg;

QStringList ScreenList;
ScreenList.clear();
for (int a = 1; a <= X->CountSections(Xorg::Screen); a++)
   {
    ScreenList << X->GetValue(Xorg::Screen, a, "Identifier", 1);
   }

return KInputDialog :: getItem(Locale(4), Locale(5), ScreenList);
}

QString GlobalFunctions :: GetServerLayout(Xorg *Xorg)
{
X = Xorg;

QStringList ServerLayoutList;
ServerLayoutList.clear();
for (int a = 1; a <= X->CountSections(Xorg::ServerLayout); a++)
   {
    ServerLayoutList << X->GetValue(Xorg::ServerLayout, a, "Identifier", 1);
   }

return KInputDialog :: getItem(Locale(6), Locale(7), ServerLayoutList);
}







QString GlobalFunctions :: GetInputDescription (QString DriverName)
{
if (DriverName.lower() == "mouse") { return Locale(200); }


return Locale(1000);
}

QString GlobalFunctions :: GetVideoDescription(QString DriverName)
{
if (DriverName.lower() == "nvidia") { return Locale(300); }
if (DriverName.lower() == "vesa") { return Locale(301); }

return Locale(1000);
}
