/***************************************************************************
                          commands_file  -  description
                             -------------------
    begin                : Wed Nov 26 2003
    copyright           : (C) 2003 by The KXMLEditor Team
    email                : a_charytoniuk@user.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "commands_file.h"
#include <qstring.h>
#include <kurl.h>
#include "kxmleditorpart.h"
#include <kmessagebox.h>
//////////////////////////////////////////////////////////////////////////////////////////
///////////		Setting Version & Encoding			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXEVersionEncodingCommand::KXEVersionEncodingCommand(KXMLEditorPart* pPart, const QString& oldData, const QString &newData)
 : KXECommand(pPart)
{
	m_strOldData = oldData;
	m_strNewData = newData;
}

KXEVersionEncodingCommand::~KXEVersionEncodingCommand()
{
}

void KXEVersionEncodingCommand::execute()
{
	m_pPart->setSpecProcInstr("xml",m_strNewData);
}

void KXEVersionEncodingCommand::unexecute()
{
	m_pPart->setSpecProcInstr("xml",m_strOldData);
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Attaching stylesheet			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXEStylesheetAttachCommand::KXEStylesheetAttachCommand(KXMLEditorPart* pPart,const QString& prevStylesheet,const QString& newStylesheet)
 : KXECommand(pPart)
{
	m_strNewStylesheet = newStylesheet;
	m_strPrevStylesheet = prevStylesheet;
}

KXEStylesheetAttachCommand::~KXEStylesheetAttachCommand()
{
}

void KXEStylesheetAttachCommand::execute()
{
	m_pPart->detachStylesheet();
	m_pPart->attachStylesheet(KURL(m_strNewStylesheet));
}

void KXEStylesheetAttachCommand::unexecute()
{
	m_pPart->detachStylesheet();
	if(!m_strPrevStylesheet.isEmpty())
		m_pPart->attachStylesheet(KURL(m_strPrevStylesheet));
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Detaching Stylesheet			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXEStylesheetDetachCommand::KXEStylesheetDetachCommand(KXMLEditorPart* pPart,const QString& prevStylesheet)
 : KXECommand(pPart)
{
	m_strPrevStylesheet = prevStylesheet;
}

KXEStylesheetDetachCommand::~KXEStylesheetDetachCommand()
{
}

void KXEStylesheetDetachCommand::execute()
{
	m_pPart->detachStylesheet();
}

void KXEStylesheetDetachCommand::unexecute()
{
  if (!m_strPrevStylesheet.isEmpty())
		m_pPart->attachStylesheet(KURL(m_strPrevStylesheet));
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Attaching Schema			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXESchemaAttachCommand::KXESchemaAttachCommand(KXMLEditorPart *pPart,const QString& newSchema)
 : KXECommand(pPart)
{
	m_pPart = pPart;
	m_strNewSchema = newSchema;
	m_strPrevSchema = "";
}
KXESchemaAttachCommand::KXESchemaAttachCommand(KXMLEditorPart *pPart,const QString& newSchema,const QString& prevSchema)
 : KXECommand(pPart)
{
	m_strNewSchema = newSchema;
	m_strPrevSchema = prevSchema;
}

KXESchemaAttachCommand::~KXESchemaAttachCommand()
{
}

void KXESchemaAttachCommand::execute()
{
	m_pPart->detachSchema();						// old schema is removed
	m_pPart->attachSchema(KURL(m_strNewSchema));		// new schema is applited
}

void KXESchemaAttachCommand::unexecute()
{
	m_pPart->detachSchema();						// new schema is removed
	if (!m_strPrevSchema.isEmpty())
		m_pPart->attachSchema(KURL(m_strPrevSchema));		// old schema is applied
}

//////////////////////////////////////////////////////////////////////////////////////////
///////////			Detaching schema			//////////
//////////////////////////////////////////////////////////////////////////////////////////

KXESchemaDetachCommand::KXESchemaDetachCommand(KXMLEditorPart* pPart, const QString& schema)
 : KXECommand(pPart)
{
		m_schema = schema;
}

KXESchemaDetachCommand::~KXESchemaDetachCommand()
{
}

void KXESchemaDetachCommand::execute()
{
	m_pPart->detachSchema();
}

void KXESchemaDetachCommand::unexecute()
{
	if (!m_schema.isEmpty())
		m_pPart->attachSchema(KURL(m_schema));
}

