/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qlabel.h>
#include <qpushbutton.h>
#include <kapplication.h>
#include <klocale.h>
#include "deletecolordialog.h"

DeleteColorDialog::DeleteColorDialog(QWidget *parent)
  : AddColorDlg(parent,"DeleteColorDialog",true)
{
  setCaption(i18n("Delete Colors"));
  SchemeName->setText(QString(i18n("Delete colors from scheme")));
  NewColorButton->hide();
  connect(HelpButton,SIGNAL(clicked()),this,SLOT(slotContextHelp()));
}

DeleteColorDialog::~DeleteColorDialog()
{
  // nothing to do here
}

void DeleteColorDialog::slotContextHelp()
{
  kapp->invokeHelp("DeleteColorDialog");
}
