/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef SCHEMEPARSER_H
#define SCHEMEPARSER_H

#include <qxml.h>
#include <qstring.h>
#include <qmap.h>
#include <qptrstack.h>

class FlossScheme;

/** Parse an XML scheme file and create a FlossScheme from it.
    @author Stephen P. Allewell
  */
class SchemeParser : public QXmlDefaultHandler
{
public:
  SchemeParser();
  virtual ~SchemeParser();
/** Get a pointer to the scheme parsed from the file.
    @return Pointer to the scheme, NULL if an error occured.
  */
  FlossScheme* flossScheme();
/** Overloaded from base class, initialises a new FlossScheme.
    @return TRUE if successful, FALSE otherwise.
  */
  virtual bool startDocument();
/** Overloaded from base class, starts a new element.
    @return Always returns TRUE.
    @param namespaceURI Unused.
    @param localName Unused.
    @param qName Name of the element.
    @param qxmlAttributes Unused.
  */
  virtual bool startElement(const QString& namespaceURI, const QString& localName, const QString&, const QXmlAttributes& qxmlAttributes);
/** Overloaded from base class, set the value of the currently open
    tag to the contents of the supplied data.
    @return Always returns true.
    @param data The data related to the tag
  */
  virtual bool characters(const QString& d);
/** Overloaded from base class, ends an element.
    @return TRUE if the element is valid, FALSE otherwise.
    @param namespaceURI Unused.
    @param localName Unused.
    @param qName Name of the element.
  */
  virtual bool endElement(const QString& namespaceURI, const QString& localName, const QString& qName);
/** Get the error string that caused the failure.
    @return The error string.
  */
  virtual QString errorString();

private:
  int                   m_errorCode;
  FlossScheme*          m_scheme;
  QMap<QString,QString> m_flossMap;
  QPtrStack<QString>    m_elements;
};

#endif
