/***************************************************************************
 *   Copyright (C) 2006 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CHARSELECTORDIALOG_H
#define CHARSELECTORDIALOG_H

#include "charselectordlg.h"

class CharSelectorDialog : public CharSelectorDlg
{
  Q_OBJECT
public:
  CharSelectorDialog(QWidget* parent, QMap<int,QChar>* usedSymbols, QValueList<int>* usedFlosses);
  ~CharSelectorDialog();

  void setSelectedChar(QChar);
  QChar selectedChar();

signals:
  void charSelected();

protected slots:
  void characterSelected(const QChar&);

private:

  QMap<int,QChar>*  m_usedSymbols;
  QValueList<int>*  m_usedFlosses;
  QChar             m_currentChar;
};

#endif
