/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "flossscheme.h"

FlossScheme::FlossScheme()
  : m_map(0)
{
  m_flosses.setAutoDelete(true);
}

FlossScheme::~FlossScheme()
{
  delete m_map;
}

QString FlossScheme::schemeName()
{
  return m_name;
}

void FlossScheme::setSchemeName(QString name)
{
  m_name = name;
}

void FlossScheme::addFloss(Floss *floss)
{
  m_flosses.append(floss);
  delete m_map;
  m_map = 0;
}

Floss *FlossScheme::find(QString name)
{
  for (Floss* floss = m_flosses.first() ; floss ; floss = m_flosses.next())
  {
    if (floss->name == name)
      return floss;
  }
  return 0;
}

Magick::Image* FlossScheme::createImageMap()
{
  if (m_map == 0)
  {
    QPtrListIterator<Floss> it = flossIterator();
    char *pixels = new char[it.count()*3];
    char *pixel = pixels;
    Floss *f;
    for ( ; (f = it.current()) ; ++it)
    {
      *pixel++ = (char)(f->color.red());
      *pixel++ = (char)(f->color.green());
      *pixel++ = (char)(f->color.blue());
    }
    m_map = new Magick::Image(it.count(), 1, "RGB", MagickLib::CharPixel, pixels);
    delete pixels;
  }
  return m_map;
}

Floss *FlossScheme::convert(QColor color)
{
  createImageMap();
  char c[3];
  c[0] = (char)color.red();
  c[1] = (char)color.green();
  c[2] = (char)color.blue();
  Magick::Image image = Magick::Image(1, 1, "RGB", MagickLib::CharPixel, c);
  image.map(*m_map);
  Magick::Pixels cache(image);
  const Magick::PixelPacket *pixels = cache.get(0,0,1,1);
  Magick::PixelPacket packet = *pixels;
  QColor newColor(packet.red/257, packet.green/257, packet.blue/257);
  for (Floss* floss = m_flosses.first() ; floss ; floss = m_flosses.next())
  {
    if (floss->color == newColor)
      return floss;
  }
  return 0; // should never happen
}

QPtrListIterator<Floss> FlossScheme::flossIterator()
{
  return QPtrListIterator<Floss>(m_flosses);
}

void FlossScheme::clearScheme()
{
  m_flosses.clear();
}

