/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "freedbinterface.h"

extern rcdatei *settingsfile;

freedbconnect::freedbconnect()
{
  url=new QHttp();
  url->setHost("uk.freedb.org",80);
}

freedbconnect::~freedbconnect()
{
  delete url;
}

void freedbconnect::getservers()
{
  transactionid=url->get
                ("/~cddb/cddb.cgi/?cmd=sites&hello=anonymous+localhost+kyamo+0.2a&proto=6");
  connect(url,SIGNAL(requestFinished (int, bool)),SLOT(getfinished(int,bool)));
  notfinished=TRUE;
  while (notfinished)
    {
      kapp->processEvents();
    }
  if (queryOk)
    {
      //Got response from freedb,parse the result
    }
}

void freedbconnect::getcdinfo(QString cddbquery,QString discid)
{
  //first get the right style for our cd,so we get the right results later
  QString querystring=QString("/~cddb/cddb.cgi/?cmd=%1&hello=anonymous+localhost+kyamo+%2&proto=6").arg(cddbquery,"0.2a");
  querystring.replace(' ','+');
  transactionid=url->get
                (querystring);
  connect(url,SIGNAL(requestFinished (int, bool)),SLOT(getfinished(int,bool)));
  notfinished=TRUE;
  while (notfinished)
    {
      kapp->processEvents();
    }
  //Answer should start with 200 ,followed by th right style
  parselastquery();
  QString answer=lastquery->first();
  //check if one cd was found (answer starts with 200)
  if (answer.startsWith("200"))
    {
      answer.remove("200");
      int position=answer.find(discid);
      answer=answer.left(position);
      //remove all spaces from the answerstring
      answer.remove(" ");
    }
  //check if more cds where found (answer starts with 210)
  else if (answer.startsWith("210"))
    {
      //more results, let user choose wich one he wants
      //use the next Strings in list to make a user choice
      QStringList::Iterator index=lastquery->begin();
      index++;
      bool last=FALSE;
      QStringList choices;
      while(!last&&index!=lastquery->end())
        {
          QString buffer=*index;
          if(buffer.startsWith("."))
            {
              //we already have every good entry, an dneed to make dialog now
              last=TRUE;
            }
          else
            choices.append(buffer);
          index++;
        }
      //Ask User for the right disc
      choicebox *userchoice=new choicebox(&choices);
      while(userchoice->selected==QString::null)
        {
          kapp->processEvents();
        }
      answer=userchoice->selected;
      answer=answer.left(answer.find(discid)-1);
      delete userchoice;
    }
  else
    {
      queryOk=FALSE;
      return;
    }
  querystring=QString("/~cddb/cddb.cgi/?cmd=cddb+read+%1+%2&hello=anonymous+localhost+kyamo+%3&proto=6").arg(answer,discid,"0.2a");
  transactionid=url->get
                (querystring);
  connect(url,SIGNAL(requestFinished (int, bool)),SLOT(getfinished(int,bool)));
  notfinished=TRUE;
  while (notfinished)
    {
      kapp->processEvents();
    }
  if (queryOk)
    {
      //Got response from freedb,parse the result
      parselastquery();
    }
}

void freedbconnect::getfinished(int id, bool error )
{
  queryOk=FALSE;
  if (transactionid==id)
    {
      if (!error)
        {
          queryOk=TRUE;
        }
      else
        cerr<<url->errorString()<<endl;
      notfinished=FALSE;
    }
}

void freedbconnect::parselastquery()
{
  lastquery=new QStringList;
  QByteArray receiveddata=url->readAll();
  QString buffer;
  for ( uint i = 0; i < receiveddata.count(); i++ )
    {
      char character=receiveddata[(int)i];
      if (character!='\n')
        {
          buffer.append(character);
        }
      else
        {
          if (!buffer.startsWith("#"))//throw away everything starting with #
            buffer=QString::fromUtf8(buffer);
          lastquery->append(buffer);
          buffer="";
        }
    }
  QStringList::Iterator index=lastquery->begin();
  if (QString(*index).startsWith("2"))
    {
      tracklist=new QStringList;
      //got a result from freedb
      while(index!=lastquery->end())
        {
          QString line=QString(*index);
          //search for keywords
          if (line.contains("DTITLE="))
            {
              //get artist and albumname out of line
              line=line.remove("DTITLE=");
              int position=line.find('/');
              artist=QString::fromLocal8Bit(line.left(position));
              album=line.right(line.length()-(position+2));
              //cut off last space
              album=album.left(album.length()-1);
            }
          else if(line.contains("TITLE"))
            {
              int position=line.find("=");
              QString trackname=line.right(line.length()-(position+1));
              //cut off last space
              trackname=trackname.left(trackname.length()-1);
              tracklist->append(trackname);
            }
          else if(line.contains("DYEAR="))
            {
              line=line.remove("DYEAR=");
              bool ok;
              releaseyear=line.toLong(&ok,10);
            }
          else if(line.contains("DGENRE="))
            {
              line=line.remove("DGENRE=");
              genre=line.left(line.length()-1);
            }
          index++;
        }
    }
  else
    {
      queryOk=FALSE;
      //nothing found by freedb
    }
}
