/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
using namespace std;

#ifndef _FREEDBINTERFACE_H_
#define _FREEDBINTERFACE_H_

#include <iostream>

#include <qstring.h>
#include <qstringlist.h>
#include <klocale.h>
#include <kapp.h>
#include <qhttp.h>

#include "id3tag.h"
#include "rcdatei.h"
#include "choicebox.h"

class freedbconnect: public QObject
  {
    Q_OBJECT
  public:
    freedbconnect();
    ~freedbconnect();
    void getservers();
    void getcdinfo(QString,QString);
    bool queryOk;
    QString artist;
    QString album;
    QString genre;
    long releaseyear;
    QStringList *tracklist;
  private:
    QHttp *url;
    int transactionid;
    bool notfinished;
    void parselastquery();
    QStringList *lastquery;
  private slots:
    void getfinished(int, bool);
  };

#endif //_FREEDBINTERFACE_H_
