/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "progress.h"

progressmainwindow::progressmainwindow(bool multimode)
{
  this->setModal(TRUE);
  runningprogresses=0;
  isChancelled=FALSE;
  QBoxLayout *progresslayout = new QVBoxLayout( this, 5 );
  progresslayout->setDirection(QBoxLayout::TopToBottom);
  taskslayout=new QGroupBox(1,Qt::Horizontal,this);
  progresslayout->addWidget(taskslayout);
  if (multimode)
    {
      chancelallbutton=new QPushButton(i18n("Chancel all Processes"),this);
      progresslayout->addWidget(chancelallbutton);
      connect (chancelallbutton,SIGNAL(clicked()),SLOT(chancelAll()));
    }
}

//Startfunctions for the progresswidgets
progresswithbar * progressmainwindow::startProgress(QString text,long max,KProcess *proc)
{
  runningprogresses++;
  if (runningprogresses>1)
    this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
  if (runningprogresses==1)
    this->setCaption(i18n("1 Process is running"));
  progresswithbar *object=new progresswithbar(text,max,taskslayout,proc);
  object->barbox->show();
  connect(this,SIGNAL(chancelprogresses()),object,SLOT(chancelProcess()));
  return object;
}

progresswithbar * progressmainwindow::startProgress(QString text,long max)
{
  runningprogresses++;
  if (runningprogresses>1)
    this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
  if (runningprogresses==1)
    this->setCaption(i18n("1 Process is running"));
  progresswithbar *object=new progresswithbar(text,max,taskslayout);
  object->barbox->show();
  connect(this,SIGNAL(chancelprogresses()),object,SLOT(chancelProcess()));
  return object;
}

progressinfo * progressmainwindow::startInfo(QString text)
{
  runningprogresses++;
  if (runningprogresses>1)
    this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
  if (runningprogresses==1)
    this->setCaption(i18n("1 Process is running"));
  progressinfo *object=new progressinfo(text,taskslayout);
  object->infobox->show();
  connect(this,SIGNAL(chancelprogresses()),object,SLOT(chancelProcess()));
  return object;
}

progressinfoonly * progressmainwindow::startInfoOnly(QString text)
{
  runningprogresses++;
  if (runningprogresses>1)
    this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
  if (runningprogresses==1)
    this->setCaption(i18n("1 Process is running"));
  progressinfoonly *object=new progressinfoonly(text,taskslayout);
  object->infobox->show();
  return object;
}

//deletefunctions for the progresswidgets
void progressmainwindow::killProgress(progresswithbar *object)
{
  this->runningprogresses--;
  if (this->runningprogresses>1)
    this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
  if (this->runningprogresses==1)
    this->setCaption(i18n("1 Process is running"));
  delete object;
  if (runningprogresses)
    {
      this->taskslayout->adjustSize();
      this->updateGeometry();
    }
}

void progressmainwindow::killProgress(progressinfo *object)
{
  runningprogresses--;
  delete object;
  if (runningprogresses>1)
    this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
  if (runningprogresses==1)
    this->setCaption(i18n("1 Process is running"));
  if (runningprogresses)
    {
      this->taskslayout->adjustSize();
      this->updateGeometry();
    }
}

void progressmainwindow::killProgress(progressinfoonly *object)
{
  runningprogresses--;
  delete object;
  if (runningprogresses>1)
    this->setCaption(i18n("%1 Processes are running").arg(QString::number(runningprogresses)));
  if (runningprogresses==1)
    this->setCaption(i18n("1 Process is running"));
  if (runningprogresses)
    {
      this->taskslayout->adjustSize();
      this->updateGeometry();
    }
}

void progressmainwindow::chancelAll()
{
  isChancelled=TRUE;
  emit chancelprogresses();
}

//Different Progresswidgets

//Progressbar-Class
progresswithbar::progresswithbar(QString text,long max,QWidget *parent,KProcess *proc)
{
  isChancelled=FALSE;
  progressedProcess=proc;
  barbox=new QGroupBox(1,Qt::Horizontal,parent);
  line1box=new QGroupBox(2,Qt::Horizontal,barbox);
  barlabel=new QLabel(text,line1box);
  chancelbutton=new QPushButton(i18n("Chancel"),line1box);
  bar=new QProgressBar(max,barbox,"progress");
  bar->setProgress(0);
  connect(chancelbutton,SIGNAL(clicked()),SLOT(chancelProcess()));
}

progresswithbar::progresswithbar(QString text,long max,QWidget *parent)
{
  progressedProcess=NULL;
  isChancelled=FALSE;
  barbox=new QGroupBox(1,Qt::Horizontal,parent);
  line1box=new QGroupBox(2,Qt::Horizontal,barbox);
  barlabel=new QLabel(text,line1box);
  chancelbutton=new QPushButton(i18n("Chancel"),line1box);
  bar=new QProgressBar(max,barbox,"progress");
  bar->setProgress(0);
  connect(chancelbutton,SIGNAL(clicked()),SLOT(chancelProcess()));
}
progresswithbar::~ progresswithbar()
{
  delete chancelbutton;
  delete bar;
  delete barlabel;
  delete line1box;
  delete barbox;
}

void progresswithbar::setProgress(long value)
{
  bar->setProgress(value);
  kapp->processEvents();
}

void progresswithbar::chancelProcess()
{
  if(progressedProcess)
    this->progressedProcess->kill();
  isChancelled=TRUE;
  emit chancelled();
}


//Infobox-Class

progressinfo::progressinfo(QString text,QWidget *parent)
{
  infobox=new QGroupBox(2,Qt::Horizontal,parent);
  infolabel=new QLabel(text,infobox);
  chancelbutton=new QPushButton(i18n("Chancel"),infobox);
  connect(chancelbutton,SIGNAL(clicked()),SLOT(chancelProcess()));
}

progressinfo::~ progressinfo()
{
  delete chancelbutton;
  delete infolabel;
  delete infobox;
}

void progressinfo::setText(QString text)
{
  infolabel->setText(text);
  kapp->processEvents();
}

void progressinfo::chancelProcess()
{
  emit chancelled();
  //this->progressedProcess->kill();
}

//Infobox without chancel class

progressinfoonly::progressinfoonly(QString text,QWidget *parent)
{
  infobox=new QGroupBox(2,Qt::Horizontal,parent);
  infolabel=new QLabel(text,infobox);
}

progressinfoonly::~ progressinfoonly()
{
  delete infolabel;
  delete infobox;
}

void progressinfoonly::setText(QString text)
{
  infolabel->setText(text);
  kapp->processEvents();
}
