/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "rcdatei.h"


void rcdatei::laden()
{
  QString puffer;
  QFile *settingsdatei=new QFile(QString("%1/.k-yamo.rc").arg(QDir::homeDirPath()));
  //Falls Settingsdatei existiert, Werte auslesen und in Variablen schieben
  if(settingsdatei->open(IO_ReadOnly))
  {
    QTextStream lesen(settingsdatei);
    lesen.setEncoding(QTextStream::UnicodeUTF8);
    while(!lesen.atEnd())
    {
      bool ok;
      puffer=lesen.readLine();
      if (puffer.contains("mysql="))
      {
        puffer=puffer.remove("mysql=");
        mysql=puffer.toInt(&ok,2);
      }
      if (puffer.contains("autocompletion="))
      {
        puffer=puffer.remove("autocompletion=");
        vervollstaendigen=puffer.toInt(&ok,2);
      }
      if (puffer.contains("recursive="))
      {
        puffer=puffer.remove("recursive=");
        rekursiv=puffer.toInt(&ok,2);
      }
      if (puffer.contains("delete="))
      {
        puffer=puffer.remove("delete=");
        loeschen=puffer.toInt(&ok,2);
      }
      if (puffer.contains("overwrite="))
      {
        puffer=puffer.remove("overwrite=");
        ueberschreiben=puffer.toInt(&ok,2);
      }
      if (puffer.contains("better="))
      {
        puffer=puffer.remove("better=");
        besser=puffer.toInt(&ok,2);
      }
      if (puffer.contains("working_dir="))
        working_dir=puffer.remove("working_dir=");
      if (puffer.contains("filter="))
        filter=(puffer.remove("filter="));
      if (puffer.contains("start_dir="))
        reading_dir=(puffer.remove("start_dir="));
      if (puffer.contains("destination_dir="))
        destination_dir=(puffer.remove("destination_dir="));
      if (puffer.contains("reject_dir="))
        reject_dir=(puffer.remove("reject_dir="));
      if (puffer.contains("mp3_dir="))
        mp3_dir=puffer.remove("mp3_dir=");
      if (puffer.contains("bitrate="))
      {
        puffer=puffer.remove("bitrate=");
bitrate=puffer.toInt();
      }
    };
  }
  else
  {
    working_dir=QString(QDir::homeDirPath()+"/");
    reading_dir=QString(QDir::homeDirPath()+"/");
    destination_dir=QString(QDir::homeDirPath()+"/");
    reject_dir=QString(QDir::homeDirPath()+"/");
    mp3_dir=QString(QDir::homeDirPath()+"/");
    filter="#GENRE#/#BAND#/#ALBUM#/#TRACK#-#SONG#";
    vervollstaendigen=TRUE;
    rekursiv=FALSE;
    loeschen=FALSE;
    ueberschreiben=FALSE;
    besser=FALSE;
    mysql=FALSE;
    bitrate=128;
    speichern();
  }
  delete settingsdatei;
}

void rcdatei::speichern()
{
  QFile *settingsdatei=new QFile(QString("%1/.k-yamo.rc").arg(QDir::homeDirPath()));
  //Falls Settingsdatei existiert, Werte auslesen und in Variablen schieben
  if(settingsdatei->open(IO_WriteOnly))
  {
    QTextStream schreiben(settingsdatei);
    schreiben.setEncoding(QTextStream::UnicodeUTF8);
    schreiben<<"working_dir="<<working_dir<<"\n";
    schreiben<<"start_dir="<<reading_dir<<"\n";
    schreiben<<"destination_dir="<<destination_dir<<"\n";
    schreiben<<"reject_dir="<<reject_dir<<"\n";
    schreiben<<"mp3_dir="<<mp3_dir<<"\n";
    schreiben<<"filter="<<filter<<"\n";
    schreiben<<"autocompletion="<<QString::number(vervollstaendigen)<<"\n";
    schreiben<<"recursive="<<QString::number(rekursiv)<<"\n";
    schreiben<<"delete="<<QString::number(loeschen)<<"\n";
    schreiben<<"overwrite="<<QString::number(ueberschreiben)<<"\n";
    schreiben<<"better="<<QString::number(besser)<<"\n";
    schreiben<<"mysql="<<QString::number(mysql)<<"\n";
    schreiben<<"bitrate="<<QString::number(bitrate)<<"\n";
    settingsdatei->close();
  }
  delete settingsdatei;
}
