/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

using namespace std;

#ifndef _RIPPER_H_
#define _RIPPER_H_

#include <iostream>

#include <qgroupbox.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qfiledialog.h>
#include <qsize.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <klocale.h>
#include <kiconloader.h>
#include <qprocess.h>

#include "mysqlinterface.h"
#include "taglibschnittstelle.h"
#include "id3tag.h"
#include "rcdatei.h"
#include "albumdialog.h"
#include "cdparanoia-interface.h"
#include "encoder-interface.h"
#include "freedbinterface.h"
#include "progress.h"
#include "cleanup.h"

class encoder;

class ripperdialog : public QWidget
{
  Q_OBJECT
public:
  ripperdialog(QWidget *);
  ~ripperdialog();
private:
  bool selectall;
  QString artist;
  QString album;
  QString year;
  QString genre;
  QString path;
  compactdisc *cd;
  QLabel *pathlabel;
  QLabel *artistlabel;
  QLabel *albumlabel;
  QLabel *yearlabel;
  QLabel *genrelabel;
  QComboBox *artistbox;
  QComboBox *albumbox;
  QComboBox *genrebox;
  QSpinBox *yearbox;
  QGroupBox *ripperlayout;
  QGroupBox *multitagbox;
  QGroupBox *songbox;
  QGroupBox *buttonbox;
  QGroupBox *pathbox;
  QGroupBox *actionbox;
  QButtonGroup *bitrate;
  QPushButton *startbutton;
  QPushButton *refreshbutton;
  QPushButton *selectallbutton;
  QRadioButton *bitrate128;
  QRadioButton *bitrate160;
  QRadioButton *bitrate192;
  QRadioButton *bitrate256;
  QRadioButton *bitrate320;
  QRadioButton *bitratevbr;
  albumdialog *songs;
  QScrollView *scrollarea;
  encoder *encodeCd;
public slots:
  void refreshcdinfoSlot();
  void readinDiscSlot();
  void selectallslot();
  void artistChanged();
  void albumChanged();
  void genreChanged();
  void setAutocomplete(bool);
signals:
  void encodeSong(QString,QString,int,int,progressmainwindow *);
};

#endif //_RIPPER_H_
