/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#define APPNAME  "K-YAMO"


#include "tableiste.h"

extern aufraeumendialog *aufraeumenmaske;

tableiste::tableiste()
{
  loader=new KIconLoader("KYamo");
  QPixmap pixmap;
  QString bildname="edit.png";
  this->setCaption(APPNAME);
  tagger=new QVBox(this);
  tagmaske=new tagdialog(tagger);
  tagger->setMargin(5);
  bildname="edit.png";
  pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
  if (!pixmap.isNull())
  {
    QIconSet taggerset(pixmap);
    addTab(tagger,taggerset,i18n("tagger"));
  }
  else
    addTab(tagger,i18n("tagger"));

  ripper=new QVBox(this);
  rippermask=new ripperdialog(ripper);
  bildname="cdaudio_unmount.png";
  pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
  if (!pixmap.isNull())
  {
    QIconSet ripperset(pixmap);
    addTab(ripper,ripperset,i18n("ripper"));
  }
  else
    addTab(ripper,i18n("ripper"));

  settings=new QVBox(this);
  settingsmaske=new settingsdialog(settings);
  settings->setMargin(5);
  settings->setSpacing(5);
  bildname="configure.png";
  pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
  if (!pixmap.isNull())
  {
    QIconSet settingsset(pixmap);
    addTab(settings,settingsset,i18n("settings"));
  }
  else
    addTab(settings,i18n("settings"));

  about=new QVBox(this);
  bildname="kyamo.png";
  pixmap=loader->loadIcon(bildname,KIcon::NoGroup);
  aboutmaske=new aboutdialog(about);
  about->setMargin(5);
  about->setSpacing(5);
  if (!pixmap.isNull())
  {
    QIconSet aboutset(pixmap);
    addTab(about,aboutset,i18n("about"));
  }
  else
    addTab(about,i18n("about"));

  this->setOkButton(QString::null);
  this->showPage(tagger);
  connect (settingsmaske,SIGNAL(verzeichniswechsel()),tagmaske,SLOT(listboxholen()));
  connect (settingsmaske,SIGNAL(vervollstaendigensignal(bool)), tagmaske,SLOT(setvervollstaendigen(bool)));
  connect (settingsmaske,SIGNAL(vervollstaendigensignal(bool )),rippermask,SLOT(setAutocomplete(bool)));
  connect (settingsmaske,SIGNAL(mysqlsignal()),tagmaske,SLOT(boxenholen()));
  settingsmaske->start();
  delete loader;
}

tableiste::~tableiste()
{
  delete tagger;
  delete rippermask;
  delete settings;
  delete about;
  delete tagmaske;
  delete settingsmaske;
  delete aboutmaske;
}


#include "tableiste.moc"
