/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*This is the master-class,that handles all the encoding engines.
 *This class only hands over the parameters to the right encoding-class*/
 
using namespace std;

#ifndef _ENCODING_INTERFACE_H_
#define _ENCODING_INTERFACE_H_

//all the encoders (Lame=gogo, cause we can set the right encoder-binary in the future)
#define LAME     0  
#define GOGO     1
#define BLADEENC 2
#define OGGENC   3
 

#include <qstring.h>
#include <qfile.h>

#include <iostream>

#include "progress.h"
#include "tagenginewrapper.h"
#include "rcdatei.h"

#include "lame-encoder.h"
#include "gogo-encoder.h"
#include "bladeenc-encoder.h"
#include "oggenc-encoder.h"

extern rcdatei settingsfile;

class encoder : public QObject
  {
    Q_OBJECT
  public:
    progresswithbar *progress;
    progressmainwindow *progresswindow;
    encoder(QString,QString,mediatag,progressmainwindow *);
    ~encoder()
    {};
  private:
  QString wavfile;
  QString mp3file;
  mediatag Songtags;
  };

#endif //_ENCODING_INTERFACE_H_
