/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _OGGINTERFACE_H_
#define _OGGINTERFACE_H_

//QT-Libs used
#include <qstring.h>
#include <qpixmap.h>
#include <qfileinfo.h>
#include <qbuffer.h>

//taglib-library-includes
#include <taglib/audioproperties.h>
#include <taglib/mpegfile.h>
#include <taglib/id3v2tag.h>
#include <taglib/id3v1tag.h>
#include <taglib/attachedpictureframe.h>
#include <taglib/id3v2frame.h>
#include <taglib/textidentificationframe.h>
#include <taglib/fileref.h>

//own includes from kyamo
#include "mediatag.h"
#include "genrehelper.h"

//We need the Prototype of mediatag here, cause we need it for oggfile
class mediatag;

//Our motherclass for id3tags is the oggfile

/*Class for handling ogg-files
 *No internal functions needed,cause taglib does tagging this the easy way.
 *The API is almost the same, as in both other classes. But now pictures, and no v2tags supported.*/
 
class oggfile
{
public:
  oggfile(QString);
  ~oggfile();
  bool saveFile();
  void setTags(mediatag);
  void readTags();
  bool containsTag;
  bool readsuccess;
  int bitrate;
  long songlenth;
  mediatag v1tag;
private:
  TagLib::FileRef *workingfile;
  QString filename;
};

#endif //_OGGINTERFACE_H_
