/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert   *
 *   roweigert@t-online.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

//Masterdialog for all the settingsdialogs
#ifndef _SETTINGSMAINDIALOG_H_
#define _SETTINGSMAINDIALOG_H_

using namespace std;

#include <iostream>


#include <qpushbutton.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qiconset.h>
#include <qpixmap.h>
#include <qlistview.h>
#include <qsize.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qsplitter.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qspinbox.h>
#include <qtooltip.h>
#include <qradiobutton.h>

#include <klocale.h>
#include <kiconloader.h>

#include "rcdatei.h"
#include "progress.h"
#include "freedbinterface.h"

extern rcdatei settingsfile;

class settingsmaindialog : public QWidget
{
    Q_OBJECT
public:
    settingsmaindialog(QWidget *);
    ~settingsmaindialog();
private:
    QSplitter *splitfield;
    QHBoxLayout *mainsettingslayout;
    QHBox *settingslayout;
    QListView *settingslist;
    QListViewItem *filesavingbutton;
    QListViewItem *ripperbutton;
    QListViewItem *directoriesbutton;
    QListViewItem *databasebutton;
    QListViewItem *internetbutton;
    QListViewItem *playerbutton;
    QWidget *shownpage;
public slots:
    void opensubmenu(QListViewItem *);
signals:
    void directorychange();
    void autocompletesignal(bool);
    void databasechangesignal();
};

// Classes for all the submenus, including the empty page at the beginning

class settingsempty : public QWidget
{
public:
    settingsempty(QHBox *);
    ~settingsempty();
private:
    QLabel *infotext;
};

class settingsdirectories : public QWidget
{
    Q_OBJECT
public:
    settingsdirectories(QHBox *);
    ~settingsdirectories();
private:
    QLineEdit *readingpathledit;
    QPushButton *readingpathbutton;
    QLineEdit *destinationpathledit;
    QPushButton *destinationpathbutton;
    QLineEdit *rejectpathledit;
    QPushButton *rejectpathbutton;
    QLineEdit *temppathledit;
    QPushButton *temppathbutton;
    QGroupBox *pathgroupbox;
private slots:
    void getreadingpath();
    void setreadingpath();
    void getdestinationpath();
    void setdestinationpath();
    void getrejectpath();
    void setrejectpath();
    void gettemppath();
    void settemppath();
signals:
    void directorychange();
};

class settingsdatabase : public QWidget
{
    Q_OBJECT
public:
    settingsdatabase(QHBox *);
    ~settingsdatabase();
private:
    QGroupBox *databasegroupbox;
    QComboBox *databasetypecombo;
    QCheckBox *autocompletebox;
    QPushButton *editdatabasebutton;
public slots:
    void autocompleteslot();
    void databasechange(int);
    void editdatabaseslot();
signals:
    void autocompletesignal(bool);
    void databasechangesignal();
};

class settingsripper : public QWidget
{
    Q_OBJECT
public:
    settingsripper(QHBox *);
    ~settingsripper();
private:
    QGroupBox *rippergroupbox;
    QGroupBox *encodergroupbox;
    QComboBox *encodertypecombo;
    QGroupBox *encoderpathgroupbox;
    QPushButton *encoderpathbutton;
    QLineEdit *encoderpathledit;
    QButtonGroup *bitrategroupbox;
    QRadioButton *bitrate128;
    QRadioButton *bitrate160;
    QRadioButton *bitrate192;
    QRadioButton *bitrate256;
    QRadioButton *bitrate320;
    QCheckBox *bitratevbr;
    QGroupBox *commandlinegroupbox;
    QLineEdit *commandlineledit;
private slots:
    void encoderchange(int);
    void executableleditslot(const QString &);
    void executableselect();
    void bitrateslot(int);
    void commandlineleditslot(const QString &);
};

class settingsplayer :public QWidget
{
    Q_OBJECT
public:
    settingsplayer(QHBox *);
    ~settingsplayer();
private:
    QGroupBox *playergroupbox;
    QGroupBox *playerbox;
    QGroupBox *executablebox;
    QComboBox *playertypecombo;
    QPushButton *playerpathbutton;
    QLineEdit *playerpathledit;
private slots:
    void playerchange(int);
    void executableselect();
    void executableleditslot(const QString &);
};

class settingsinternet : public QWidget
{
    Q_OBJECT
public:
    settingsinternet(QHBox *);
    ~settingsinternet();
private:
    QGroupBox *internetgroupbox;
    QGroupBox *freedbgroupbox;
    QGroupBox *musicbrainzgroupbox;
    QCheckBox *freedbcheckbox;
    QPushButton *getserverlistbutton;
    QLineEdit *freedbserverledit;
    QCheckBox *musicbrainzcheckbox;
    QLineEdit *loginnameledit;
    QLineEdit *freedbloginledit;
    QLabel *loginlabel;
    freedbconnect *freedbc;
    progressmainwindow *progresswindow;
    progressinfoonly *progress;
private slots:
    void serverlistslot();
    void serverselected(QString);
    void servercancelled();
    void errorreceived(QString);
    void freedbserverslot(const QString &);
    void freedbloginslot(const QString &);
    void freedbcheckboxslot();
    void musicbrainzcheckboxslot();
};

class settingssaving : public QWidget
{
    Q_OBJECT
public:
    settingssaving(QHBox *);
    ~settingssaving();
private:
    QGroupBox *filesavinggroupbox;
    QButtonGroup *tagtypegroupbox;
    QGroupBox *filtergroupbox;
    QGroupBox *filterbuttonsgroupbox;
    QGroupBox *picturegroupbox;
    QGroupBox *overwritegroupbox;
    QGroupBox *verbosegroupbox;
    //Tagtype
    QCheckBox *v1tagbox;
    QCheckBox *v23tagbox;
    QCheckBox *v24tagbox;
    //filter
    QLineEdit *filterledit;
    QPushButton *directorybutton;
    QPushButton *yearbutton;
    QPushButton *artistbutton;
    QPushButton *songbutton;
    QPushButton *trackbutton;
    QPushButton *albumbutton;
    QPushButton *genrebutton;
    //picture
    QCheckBox *picturecheckbox;
    QLineEdit *pictureledit;
    QSpinBox *picturesizebox;
    QComboBox *pictureformatcombo;
    //overwrite
    QCheckBox *overwritecheckbox;
    QCheckBox *bettercheckbox;
    QCheckBox *deletecheckbox;
    //verbosity
    QCheckBox *verbosecheckbox;

private slots:
    //filter
    void dirslashslot();
    void yearslot();
    void artistslot();
    void songslot();
    void trackslot();
    void albumslot();
    void genreslot();
    void savefilter(const QString &);
    //tagtype
    void tagtypeslot(int);
    //covers in dir-slots
    void covernamechanged(const QString &);
    void coversizechanged(int);
    void coverformatchanged(const QString &);
    void coversavecheckboxslot();
    //overwrite
    void deleteslot();
    void overwriteslot();
    void betterslot();
    void verboseslot();
};

#endif //_SETTINGSMAINDIALOG_H_
