(* Copyright (C) 2000-2003, Luca Padovani <luca.padovani@cs.unibo.it>,
 *                          Claudio Sacerdoti Coen <sacerdot@cs.unibo.it>.
 *
 * This file is part of lablgtkmathview, the Ocaml binding
 * for the GtkMathView widget.
 * 
 * lablgtkmathview is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * lablgtkmathview is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with lablgtkmathview; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * For details, send a mail to the author.
 *)

open Gtk_mathview
open Gaux
open Gobject
open Gtk
open Tags
open GtkMathViewProps
open GtkBase

external _gtkmathview_init : unit -> unit = "ml_gtk_mathview_init"
let () = _gtkmathview_init ()

module MathView = struct
  include MathView
  external freeze : [>`mathview] obj -> unit =
   "ml_gtk_math_view_freeze"
  external thaw : [>`mathview] obj -> unit =
   "ml_gtk_math_view_thaw"
  external load_uri : [>`mathview] obj -> filename:string -> bool =
   "ml_gtk_math_view_load_uri"
  external load_doc : [>`mathview] obj -> dom:[> `Document] GdomeT.t -> bool =
   "ml_gtk_math_view_load_doc"
  external unload : [>`mathview] obj -> unit =
   "ml_gtk_math_view_unload"
  external select :
   [>`mathview] obj -> [> `Element] GdomeT.t -> unit =
   "ml_gtk_math_view_select"
  external unselect :
   [>`mathview] obj -> [> `Element] GdomeT.t -> unit =
   "ml_gtk_math_view_unselect"
  external is_selected :
   [>`mathview] obj -> [> `Element] GdomeT.t -> bool =
   "ml_gtk_math_view_is_selected"
  external get_element_at :
   [> `mathview] obj -> int -> int -> TElement.t option =
   "ml_gtk_math_view_get_element_at"
   (* beginning of prop-like methods *)
  external get_width : [>`mathview] obj -> int =
   "ml_gtk_math_view_get_width"
  external get_height : [>`mathview] obj -> int =
   "ml_gtk_math_view_get_height"
  external get_top : [>`mathview] obj -> (int * int) =
   "ml_gtk_math_view_get_top"
  external set_top : [>`mathview] obj -> int -> int -> unit =
   "ml_gtk_math_view_set_top"
  external set_adjustments : [>`mathview] obj -> Gtk.adjustment obj -> Gtk.adjustment obj -> unit =
   "ml_gtk_math_view_set_adjustments"
  external get_hadjustment : [>`mathview] obj -> Gtk.adjustment obj =
   "ml_gtk_math_view_get_hadjustment"
  external get_vadjustment : [>`mathview] obj -> Gtk.adjustment obj =
   "ml_gtk_math_view_get_vadjustment"
  external get_buffer : [>`mathview] obj -> Gdk.pixmap =
   "ml_gtk_math_view_get_buffer"
  external get_drawing_area : [>`mathview] obj -> Gtk.drawing_area obj =
   "ml_gtk_math_view_get_drawing_area"
  external set_font_size : [>`mathview] obj -> int -> unit =
   "ml_gtk_math_view_set_font_size"
  external get_font_size : [>`mathview] obj -> int =
   "ml_gtk_math_view_get_font_size"
  external set_log_verbosity : [>`mathview] obj -> int -> unit =
   "ml_gtk_math_view_set_log_verbosity"
  external get_log_verbosity : [>`mathview] obj -> int =
   "ml_gtk_math_view_get_log_verbosity"
end
