/*=========================================================================

  Program:   VtkQt
  Module:    $RCSfile: vtkQtImageViewer.cxx,v $
  Language:  C++
  Date:      $Date: 2002/11/12 10:52:38 $
  Version:   $Revision: 1.1.1.1 $

  Copyright (c) 2002 Denis Shamonin
  Section Computational Science
  University of Amsterdam
  Kruislaan 403, 1098 SJ Amsterdam
  the Netherlands

  E-mail        : dshamoni@science.uva.nl
  URL           : http://www.science.uva.nl/~dshamoni/
  
  All rights reserved.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
#include "vtkQtImageViewer.h"

vtkQtImageViewer::vtkQtImageViewer(QWidget *parent, const char *name ):QGLWidget(parent, name)
{
  if (!parent) InitializeResize = FALSE;
  else InitializeResize = TRUE;
    
  vtkQtImageViewer::SetDisplayId(qt_xdisplay());
  vtkQtImageViewer::SetWindowId((void *)this->winId());
}

vtkQtImageViewer::~vtkQtImageViewer()
{
}

void vtkQtImageViewer::paintGL()
{ 
  this->GetRenderWindow()->Render();
}

void vtkQtImageViewer::SetWindowName(const char * cname)
{ 
  this->GetRenderWindow()->SetWindowName(cname);
  QString name(cname);
  QGLWidget::setCaption(name);
}

void vtkQtImageViewer::SetPosition(int x,int y)
{
  this->GetRenderWindow()->SetPosition(x,y);
  QGLWidget::move(x,y);
}

void vtkQtImageViewer::resizeGL(int w, int h)
{
 if (this->InitializeResize) 
   this->SetSize(w,h);
}
